/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.visuals.NewFlowDialog;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;

public class NewFlowAction
extends AbstractAction {
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(NewFlowAction.class);
    private static final long serialVersionUID = 1L;
    private Frame m_frame = null;
    private ScheduleManager m_plugin;
    private String m_lastSchedulingServer;
    private String m_location;

    public NewFlowAction(ScheduleManager plugin, UserContextInterface userContext) {
        this.m_frame = plugin.getMainFrame();
        this.m_plugin = plugin;
        String nameText = m_bundle.getString("NewFlowAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_NewFlow));
        this.putValue("ShortDescription", m_bundle.getString("NewFlowAction.ShortDescription.txt"));
        this.m_lastSchedulingServer = this.m_plugin.getLastSchedulingServer();
        this.m_location = this.m_plugin.getLastFlowFolderLocation();
    }

    public void dispose() {
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            FlowInfo flow;
            NewFlowDialog dlg = new NewFlowDialog(this.m_plugin);
            if (this.m_lastSchedulingServer != null) {
                dlg.setDefaultScheduler(this.m_lastSchedulingServer);
            }
            if (this.m_location != null) {
                dlg.setDefaultFolder(this.m_location);
            }
            dlg.makeVisible();
            if (dlg.getReturnValue() == 1 && (flow = dlg.getNewFlow()) != null) {
                this.m_location = flow.getLocation();
                SchedulerServerInfo ssi = flow.getScheduler();
                this.m_lastSchedulingServer = ssi != null ? ssi.getId() : null;
            }
            if (this.m_lastSchedulingServer != null) {
                this.m_plugin.setLastSchedulingServer(this.m_lastSchedulingServer);
            }
            if (this.m_location != null) {
                this.m_plugin.setLastFlowFolderLocation(this.m_location);
            }
            this.m_plugin.saveUserOptions();
        }
        catch (RemoteException ex) {
            if (ScheduleManager.isDebug()) {
                ex.printStackTrace();
            }
            MessageUtil.displayMessage((Frame)this.m_frame, (String)ex.getLocalizedMessage(), (String)m_bundle.getString("NewFlowAction.Title.txt"), (int)0, (int)-1);
        }
        catch (Exception e) {
            if (ScheduleManager.isDebug()) {
                e.printStackTrace();
            }
            MessageUtil.displayMessage((Frame)this.m_frame, (String)e.getLocalizedMessage(), (String)m_bundle.getString("NewFlowAction.Title.txt"), (int)0, (int)-1);
        }
    }
}

