/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.net.crypto.SealedString;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerResultSet;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.UserOptions;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.visuals.swing.LoginDialog;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class FlowSubmitter {
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(FlowSubmitter.class);
    private ServerFlowInfo m_flow;
    private boolean m_flowModified;

    public FlowSubmitter(ServerFlowInfo flow) {
        this(flow, false);
    }

    public FlowSubmitter(ServerFlowInfo flow, boolean flowModified) {
        this.m_flow = flow;
        this.m_flowModified = flowModified;
    }

    public boolean interactiveAutoSubmit(ScheduleManager schmgr) throws SchedulerException {
        return schmgr.interactiveAutoSubmit(this.m_flow);
    }

    public boolean interactiveSubmit(ScheduleManager schmgr) throws SchedulerException {
        return schmgr.interactiveSubmit(this.m_flow, this.m_flowModified);
    }

    public static List<ArrayList<FlowInfo>> batchReschedule(ScheduleManager schmgr) throws RemoteException, SchedulerException {
        ArrayList<ArrayList<FlowInfo>> list = new ArrayList<ArrayList<FlowInfo>>(3);
        ArrayList<FlowInfo> successfulFlows = new ArrayList<FlowInfo>();
        ArrayList<FlowInfo> failedFlows = new ArrayList<FlowInfo>();
        ArrayList<FlowInfo> notScheduledFlows = new ArrayList<FlowInfo>();
        FlowSubmitter.batchReschedule(schmgr, true, successfulFlows, failedFlows, notScheduledFlows);
        list.add(0, successfulFlows);
        list.add(1, failedFlows);
        list.add(2, notScheduledFlows);
        return list;
    }

    public static int batchResubmit(ScheduleManager schmgr) throws RemoteException, SchedulerException {
        return FlowSubmitter.batchReschedule(schmgr, false, null, null, null);
    }

    private static int batchReschedule(ScheduleManager schmgr, boolean confirm, List<FlowInfo> successful, List<FlowInfo> failed, List<FlowInfo> notscheduled) throws RemoteException, SchedulerException {
        Frame owner = schmgr.getMainFrame();
        int nSuccessfulSchedules = 0;
        boolean prompt = true;
        String userid = "";
        SealedString password = new SealedString("");
        String str1 = m_bundle.getString("RescheduleAllFlowsAction.BuildMetadataProgressIndicator.Message.txt");
        String str2 = m_bundle.getString("RescheduleAllFlowsAction.BuildMetadataProgressIndicator.Title.txt");
        List<FlowInfo> flows = schmgr.getSubmittedFlows(str1, str2, notscheduled);
        if (confirm) {
            if (flows.size() == 0) {
                MessageUtil.displayMessage((Frame)owner, (String)m_bundle.getString("FlowSubmitter.RescheduleError.txt"), (String)m_bundle.getString("FlowSubmitter.Reschedule.Title.txt"), (int)0);
                return 0;
            }
            int response = JOptionPane.showConfirmDialog(owner, m_bundle.messageString("FlowSubmitter.RescheduleFlowsMessage.fmt", (Object)new Integer(flows.size())), m_bundle.getString("FlowSubmitter.Reschedule.Title.txt"), 0);
            if (1 == response) {
                return 0;
            }
        }
        boolean showWarnings = new UserOptions().showWarnings();
        for (FlowInfo flow : flows) {
            SchedulerServerInfo scheduler = flow.getScheduler();
            if (scheduler == null) {
                MessageUtil.displayMessage((Frame)owner, (String)m_bundle.messageString("FlowSubmitter.NoSchedulerAssigned.fmt", (Object)flow.getName()), (String)m_bundle.getString("FlowSubmitter.Reschedule.Title.txt"), (int)0);
                if (failed == null) continue;
                failed.add(flow);
                continue;
            }
            if (prompt) {
                String loginTitle = m_bundle.messageString("FlowSubmitter.Logon.title.fmt", (Object)flow.getName(), (Object)scheduler.getName());
                LoginDialog dialog = new LoginDialog(owner, loginTitle, m_bundle.getString("FlowSubmitter.Login.Checkbox.txt"));
                dialog.setUserName(userid);
                dialog.setPasswordSealedString(password);
                dialog.makeVisible();
                boolean bl = prompt = !dialog.checkboxSelected();
                if (dialog.getReturnValue() == 1) {
                    userid = dialog.getUserName();
                    password = dialog.getPasswordSealedString();
                }
            }
            if (schmgr.connectToSchedulingServer(scheduler, userid, password)) {
                SchedulerResultSet results = schmgr.batchResubmit(flow);
                switch (results.getReturnValue()) {
                    case 2: {
                        ++nSuccessfulSchedules;
                        if (successful != null) {
                            successful.add(flow);
                        }
                        if (!showWarnings) break;
                        String message = m_bundle.messageString("FlowSubmitter.Confirmation.Warning.msg.fmt", (Object)flow.getName(), (Object)scheduler.getName(), (Object)results.getMessage());
                        MessageUtil.displayMessage((Frame)owner, (String)message, (String)m_bundle.getString("FlowSubmitter.Reschedule.Title.txt"), (int)2);
                        ScheduleManager.setStatusText(message);
                        break;
                    }
                    case 1: {
                        ++nSuccessfulSchedules;
                        if (successful == null) break;
                        successful.add(flow);
                        break;
                    }
                    case 0: {
                        if (failed == null) break;
                        failed.add(flow);
                    }
                }
                continue;
            }
            if (failed == null) continue;
            failed.add(flow);
        }
        ScheduleManager.setStatusText(m_bundle.getString("FlowSubmitter.RescheduleFlowsResultsMessage.txt"));
        return nSuccessfulSchedules;
    }

    public static boolean confirmScheduleAllFlows(ScheduleManager schmgr) throws RemoteException, SchedulerException {
        String str2;
        Frame frame = schmgr.getMainFrame();
        String str1 = m_bundle.getString("RescheduleAllFlowsAction.BuildMetadataProgressIndicator.Message.txt");
        List<FlowInfo> flows = schmgr.getSubmittedFlows(str1, str2 = m_bundle.getString("RescheduleAllFlowsAction.BuildMetadataProgressIndicator.Title.txt"), null);
        if (flows.size() == 0) {
            MessageUtil.displayMessage((Frame)frame, (String)m_bundle.getString("FlowSubmitter.RescheduleError.txt"), (String)m_bundle.getString("FlowSubmitter.Reschedule.Title.txt"), (int)0);
            return false;
        }
        int response = JOptionPane.showConfirmDialog(frame, m_bundle.messageString("FlowSubmitter.RescheduleFlowsMessage.fmt", (Object)new Integer(flows.size())), m_bundle.getString("FlowSubmitter.Reschedule.Title.txt"), 0);
        if (0 == response) {
            return true;
        }
        if (1 == response) {
            return false;
        }
        return false;
    }

    public static void displayScheduleAllFlowsResults(ScheduleManager schmgr, int num) {
        MessageUtil.displayMessage((Frame)schmgr.getMainFrame(), (String)m_bundle.messageString("FlowSubmitter.RescheduleFlowsResults.fmt", (Object)new Integer(num)), (String)m_bundle.getString("FlowSubmitter.Reschedule.Title.txt"), (int)1);
        ScheduleManager.setStatusText("");
    }

    public static void displayScheduleAllFlowsResults(ScheduleManager schmgr, List<?> listOfLists) {
        List successList = (List)listOfLists.get(0);
        List failList = (List)listOfLists.get(1);
        List notList = (List)listOfLists.get(2);
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(m_bundle.getString("FlowSubmitter.TreeTopName.txt"));
        DefaultMutableTreeNode success = new DefaultMutableTreeNode(m_bundle.messageString("FlowSubmitter.TreeSuccess.fmt", (Object)String.valueOf(successList.size())));
        DefaultMutableTreeNode fail = new DefaultMutableTreeNode(m_bundle.messageString("FlowSubmitter.TreeFail.fmt", (Object)String.valueOf(failList.size())));
        DefaultMutableTreeNode not = new DefaultMutableTreeNode(m_bundle.messageString("FlowSubmitter.TreeNotScheduled.fmt", (Object)String.valueOf(notList.size())));
        top.add(success);
        top.add(fail);
        top.add(not);
        Iterator i = successList.iterator();
        while (i.hasNext()) {
            success.add(new DefaultMutableTreeNode(i.next()));
        }
        i = failList.iterator();
        while (i.hasNext()) {
            fail.add(new DefaultMutableTreeNode(i.next()));
        }
        i = notList.iterator();
        while (i.hasNext()) {
            not.add(new DefaultMutableTreeNode(i.next()));
        }
        JTree tree = new JTree(top, false);
        tree.setEditable(false);
        tree.setFocusable(false);
        tree.setScrollsOnExpand(true);
        JScrollPane scrollpane = new JScrollPane(tree, 20, 30);
        scrollpane.setPreferredSize(new Dimension(300, 150));
        StandardPanel mainPanel = new StandardPanel();
        mainPanel.setLayout((LayoutManager)new GridBagLayout());
        mainPanel.add((Component)scrollpane, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        StandardDialog dia = new StandardDialog(schmgr.getMainFrame(), m_bundle.getString("FlowSubmitter.Reschedule.Title.txt"), true, mainPanel);
        dia.setCancelButtonVisible(false);
        dia.setHelpProduct("scheduler");
        dia.setHelpTopic("window_reschedule_all_flows");
        dia.makeVisible();
        ScheduleManager.setStatusText("");
    }
}

