/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.PluginChangeEvent;
import com.sas.graphics.components.pfd.PFDCompositeNode;
import com.sas.graphics.components.pfd.PFDScrollView;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobEventInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.pfd.AddItemActionListener;
import com.sas.scheduler.pfd.File;
import com.sas.scheduler.pfd.FlowEventActionListener;
import com.sas.scheduler.pfd.FlowPFDView;
import com.sas.scheduler.pfd.Job;
import com.sas.scheduler.pfd.Subflow;
import com.sas.scheduler.pfd.Time;
import com.sas.scheduler.schmgr.DeleteFlowAction;
import com.sas.scheduler.schmgr.FlowNode;
import com.sas.scheduler.schmgr.PropertyAction;
import com.sas.scheduler.schmgr.ScheduleFlowAction;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.visuals.AddItemByFolderPanel;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.visuals.swing.JobPropertiesPanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

public class FlowPFDScrollView
implements CustomViewInterface {
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(FlowPFDScrollView.class);
    private transient FlowNode m_node;
    private ServerFlowInfo m_flow;
    private FlowPFDView m_pfdPanel;
    private PFDScrollView m_view;
    private ScheduleManager m_schmgr;
    private boolean m_stupidUserOption = false;
    private static Object critsect = new Object();

    public FlowPFDScrollView(ServerFlowInfo flow, ScheduleManager plugin, FlowNode node) {
        this.m_flow = flow;
        this.m_node = node;
        this.m_schmgr = plugin;
        String idiot = System.getProperty("sas.schedule.nocirculardependencycheck");
        if (idiot != null && idiot.equals("true")) {
            this.m_stupidUserOption = true;
        }
    }

    public void refresh() {
        try {
            this.m_pfdPanel.refresh(this.m_flow.getInfo());
            if (!this.m_stupidUserOption) {
                this.updateFlowList();
            }
        }
        catch (SchedulerException e) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)e.getLocalizedMessage(), (String)m_bundle.getString("FlowPFDScrollView.Title.txt"), (int)2);
        }
    }

    public void saveSettingsAndCleanUp() {
        this.m_node = null;
        this.m_flow = null;
        this.m_pfdPanel.saveSettingsAndCleanUp();
        this.m_pfdPanel = null;
        this.m_view = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getToolBarActions() {
        if (this.m_pfdPanel == null) {
            Object object = critsect;
            synchronized (object) {
                this.getComponent();
            }
        }
        return this.m_pfdPanel.getToolBarActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getContextMenuActions() {
        if (this.m_pfdPanel == null) {
            Object object = critsect;
            synchronized (object) {
                this.getComponent();
            }
        }
        return this.m_pfdPanel.getContextMenuActions();
    }

    public NodeInterface getNode() {
        return this.m_node;
    }

    public void setNode(FlowNode node) {
        this.m_node = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetPFDKeyboard() {
        if (this.m_pfdPanel == null) {
            Object object = critsect;
            synchronized (object) {
                this.getComponent();
            }
        }
        this.m_pfdPanel.setKeyboardEnabled(false);
        this.m_pfdPanel.setKeyboardEnabled(true);
    }

    public void resetView() {
        List flowjoblist = this.m_flow.getJobNames();
        List nodes = this.m_pfdPanel.getJobs();
        for (Object obj : nodes) {
            Subflow sflow;
            if (obj instanceof Job) {
                Job job = (Job)obj;
                if (flowjoblist.contains(job.getInfo().getName())) continue;
                this.m_pfdPanel.removeJob((PFDCompositeNode)job);
                continue;
            }
            if (!(obj instanceof Subflow) || flowjoblist.contains((sflow = (Subflow)obj).getInfo().getName())) continue;
            this.m_pfdPanel.removeJob((PFDCompositeNode)sflow);
        }
    }

    public void updateFlowList() {
        this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        List flowjoblist = this.m_flow.getJobNames();
        List<List<DisplayInfo>> list = this.m_schmgr.getJobAndSubflowLists(this.m_flow.getId(), flowjoblist, false);
        List<DisplayInfo> jobs = list.get(0);
        List<DisplayInfo> subflows = list.get(1);
        this.m_pfdPanel.updateLists(jobs, subflows);
        this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent() {
        if (this.m_view == null) {
            if (this.m_pfdPanel == null) {
                Object object = critsect;
                synchronized (object) {
                    if (!this.m_stupidUserOption) {
                        List flowjoblist = this.m_flow.getJobNames();
                        List<List<DisplayInfo>> list = this.m_schmgr.getJobAndSubflowLists(this.m_flow.getId(), flowjoblist, false);
                        List<DisplayInfo> joblist = list.get(0);
                        List<DisplayInfo> flowlist = list.get(1);
                        this.m_pfdPanel = this.m_flow.hasScheduler() ? new FlowPFDView(this.m_schmgr.getMainFrame(), this.m_flow.getInfo(), joblist, flowlist, (ActionListener)new myScheduleListener(), (ActionListener)new mySaveListener(), (ActionListener)new myCloseListener(), (ActionListener)new myDeleteListener(), (ActionListener)new myJobPropertiesListener(), (FlowEventActionListener)new myTimeEventListener(), (ActionListener)new myTimePropertiesListener(), (FlowEventActionListener)new myFileEventListener(), (ActionListener)new myFilePropertiesListener()) : new FlowPFDView(this.m_schmgr.getMainFrame(), this.m_flow.getInfo(), joblist, flowlist, (ActionListener)new myScheduleListener(), (ActionListener)new mySaveListener(), (ActionListener)new myCloseListener(), (ActionListener)new myDeleteListener());
                        this.m_pfdPanel.setFlowPropertyListener((ActionListener)new myFlowPropertiesListener());
                        this.m_pfdPanel.setCircularListener((ActionListener)new myCircularcheckListener());
                    } else {
                        List flowjoblist = this.m_flow.getJobNames();
                        this.m_pfdPanel = this.m_flow.hasScheduler() ? new FlowPFDView(this.m_schmgr.getMainFrame(), this.m_flow.getInfo(), (AddItemActionListener)new myAddItemListener(), (ActionListener)new myScheduleListener(), (ActionListener)new mySaveListener(), (ActionListener)new myCloseListener(), (ActionListener)new myDeleteListener(), (ActionListener)new myJobPropertiesListener(), (FlowEventActionListener)new myTimeEventListener(), (ActionListener)new myTimePropertiesListener(), (FlowEventActionListener)new myFileEventListener(), (ActionListener)new myFilePropertiesListener()) : new FlowPFDView(this.m_schmgr.getMainFrame(), this.m_flow.getInfo(), (AddItemActionListener)new myAddItemListener(), (ActionListener)new myScheduleListener(), (ActionListener)new mySaveListener(), (ActionListener)new myCloseListener(), (ActionListener)new myDeleteListener());
                        this.m_pfdPanel.setFlowPropertyListener((ActionListener)new myFlowPropertiesListener());
                        this.m_pfdPanel.setCircularListener((ActionListener)new myCircularcheckListener());
                    }
                }
            }
            this.m_view = new PFDScrollView((PFDView)this.m_pfdPanel);
        }
        return this.m_view;
    }

    public void pluginChange(PluginChangeEvent evt) {
    }

    private class myCircularcheckListener
    implements ActionListener {
        private myCircularcheckListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            FlowInfo flow = (FlowInfo)ae.getSource();
            String id = ae.getActionCommand();
            try {
                FlowPFDScrollView.this.m_schmgr.checkCircularDependencies(flow, id);
            }
            catch (SchedulerException schedulerException) {
                // empty catch block
            }
        }
    }

    private class myAddItemListener
    implements AddItemActionListener {
        private List<JobInfo> addedJobs;
        private ActionListener actL = null;

        private myAddItemListener() {
        }

        public List<JobInfo> getReturnValue() {
            return this.addedJobs;
        }

        public void setPropertiesListener(ActionListener al) {
            this.actL = al;
        }

        public void actionPerformed(ActionEvent ae) {
            FlowInfo flow = (FlowInfo)ae.getSource();
            AddItemByFolderPanel panel = new AddItemByFolderPanel(FlowPFDScrollView.this.m_schmgr, flow);
            if (this.actL != null) {
                panel.setPropertiesListener(this.actL);
            }
            StandardDialog dlg = new StandardDialog(FlowPFDScrollView.this.m_schmgr.getMainFrame(), m_bundle.getString("ActionAddItemByFolder.Title.txt"), true);
            dlg.setMainPanel((StandardPanel)panel);
            dlg.setHelpProduct("scheduler");
            dlg.setHelpTopic("window_additem");
            dlg.makeVisible();
            this.addedJobs = panel.getAddedItems();
        }
    }

    private class myFlowPropertiesListener
    implements ActionListener {
        private myFlowPropertiesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            PropertyAction prop = new PropertyAction(FlowPFDScrollView.this.m_node, FlowPFDScrollView.this.m_schmgr, false);
            prop.actionPerformed(new ActionEvent(FlowPFDScrollView.this.m_flow, 1001, null));
            if (FlowPFDScrollView.this.m_pfdPanel != null && prop.isDirty()) {
                FlowPFDScrollView.this.m_pfdPanel.markDirty();
            }
            FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private class myFilePropertiesListener
    implements ActionListener {
        private myFilePropertiesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            File node = (File)ae.getSource();
            FileEventInfo info = node.getInfo();
            String title = m_bundle.getString("FlowPFDScrollView.EditFileEvent.Title.txt");
            SchedulerServerInfo scheduler = FlowPFDScrollView.this.m_flow.getInfo().getScheduler();
            if (scheduler != null) {
                if (FlowPFDScrollView.this.m_schmgr.checkSchedulerConnectionForFlowEvents(FlowPFDScrollView.this.m_flow)) {
                    try {
                        if (FlowPFDScrollView.this.m_schmgr.showFileEvent(title, info) == 1 && node != null) {
                            node.updateInfo(info);
                        }
                    }
                    catch (SchedulerException se) {
                        MessageUtil.displayMessage((Frame)FlowPFDScrollView.this.m_schmgr.getMainFrame(), (String)se.getLocalizedMessage(), (String)m_bundle.getString("FlowPFDScrollView.Title.txt"), (int)0, (int)-1);
                    }
                } else {
                    MessageUtil.displayMessage((Frame)FlowPFDScrollView.this.m_schmgr.getMainFrame(), (String)m_bundle.getString("FlowPFDScrollView.CannotConnectToScheduler.txt"), (String)m_bundle.getString("FlowPFDScrollView.Title.txt"), (int)0, (int)-1);
                }
            }
            FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private class myFileEventListener
    implements FlowEventActionListener {
        private int returnValue;

        private myFileEventListener() {
        }

        public int getReturnValue() {
            return this.returnValue;
        }

        public void actionPerformed(ActionEvent ae) {
            FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            File node = (File)ae.getSource();
            FileEventInfo info = node.getInfo();
            String title = m_bundle.getString("FlowPFDScrollView.NewFileEvent.Title.txt");
            SchedulerServerInfo scheduler = FlowPFDScrollView.this.m_flow.getInfo().getScheduler();
            if (scheduler != null) {
                if (FlowPFDScrollView.this.m_schmgr.checkSchedulerConnectionForFlowEvents(FlowPFDScrollView.this.m_flow)) {
                    try {
                        this.returnValue = FlowPFDScrollView.this.m_schmgr.showFileEvent(title, info);
                        if (this.returnValue == 1 && node != null) {
                            node.setInfo(info);
                        }
                    }
                    catch (SchedulerException se) {
                        MessageUtil.displayMessage((Frame)FlowPFDScrollView.this.m_schmgr.getMainFrame(), (String)se.getLocalizedMessage(), (String)m_bundle.getString("FlowPFDScrollView.Title.txt"), (int)0, (int)-1);
                    }
                }
            } else {
                MessageUtil.displayMessage((Frame)FlowPFDScrollView.this.m_schmgr.getMainFrame(), (String)m_bundle.getString("FlowPFDScrollView.CannotConnectToScheduler.txt"), (String)m_bundle.getString("FlowPFDScrollView.Title.txt"), (int)0, (int)-1);
            }
            FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private class myTimePropertiesListener
    implements ActionListener {
        private myTimePropertiesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            Time node = (Time)ae.getSource();
            TimeEventInfo info = node.getInfo();
            String title = m_bundle.getString("FlowPFDScrollView.EditTimeEvent.Title.txt");
            SchedulerServerInfo scheduler = FlowPFDScrollView.this.m_flow.getInfo().getScheduler();
            if (scheduler != null) {
                if (FlowPFDScrollView.this.m_schmgr.checkSchedulerConnectionForFlowEvents(FlowPFDScrollView.this.m_flow)) {
                    try {
                        if (FlowPFDScrollView.this.m_schmgr.showTimeEvent(title, info, scheduler) == 1 && node != null) {
                            node.updateInfo(info);
                        }
                    }
                    catch (SchedulerException se) {
                        MessageUtil.displayMessage((Frame)FlowPFDScrollView.this.m_schmgr.getMainFrame(), (String)se.getLocalizedMessage(), (String)m_bundle.getString("FlowPFDScrollView.Title.txt"), (int)0, (int)-1);
                    }
                } else {
                    MessageUtil.displayMessage((Frame)FlowPFDScrollView.this.m_schmgr.getMainFrame(), (String)m_bundle.getString("FlowPFDScrollView.CannotConnectToScheduler.txt"), (String)m_bundle.getString("FlowPFDScrollView.Title.txt"), (int)0, (int)-1);
                }
            }
            FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private class myTimeEventListener
    implements FlowEventActionListener {
        private int returnValue;

        private myTimeEventListener() {
        }

        public int getReturnValue() {
            return this.returnValue;
        }

        public void actionPerformed(ActionEvent ae) {
            FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            Time node = (Time)ae.getSource();
            TimeEventInfo info = node.getInfo();
            String title = m_bundle.getString("FlowPFDScrollView.NewTimeEvent.Title.txt");
            SchedulerServerInfo scheduler = FlowPFDScrollView.this.m_flow.getInfo().getScheduler();
            if (scheduler != null) {
                if (FlowPFDScrollView.this.m_schmgr.checkSchedulerConnectionForFlowEvents(FlowPFDScrollView.this.m_flow)) {
                    try {
                        info.setScheduler(scheduler);
                        this.returnValue = FlowPFDScrollView.this.m_schmgr.showTimeEvent(title, info, scheduler);
                        if (this.returnValue == 1 && node != null) {
                            node.setInfo(info);
                        }
                    }
                    catch (SchedulerException se) {
                        MessageUtil.displayMessage((Frame)FlowPFDScrollView.this.m_schmgr.getMainFrame(), (String)se.getLocalizedMessage(), (String)m_bundle.getString("FlowPFDScrollView.Title.txt"), (int)0, (int)-1);
                    }
                } else {
                    MessageUtil.displayMessage((Frame)FlowPFDScrollView.this.m_schmgr.getMainFrame(), (String)m_bundle.getString("FlowPFDScrollView.CannotConnectToScheduler.txt"), (String)m_bundle.getString("FlowPFDScrollView.Title.txt"), (int)0, (int)-1);
                }
            }
            FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private class myJobPropertiesListener
    implements ActionListener {
        private myJobPropertiesListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            try {
                Job node = null;
                JobInfo info = null;
                String title = "";
                Object obj = ae.getSource();
                if (obj instanceof Job) {
                    node = (Job)obj;
                    info = node.getInfo();
                    title = info.getName();
                } else if (obj instanceof JobInfo) {
                    info = (JobInfo)obj;
                    title = info.getName();
                }
                if (info.isSubflow()) {
                    FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
                    PropertyAction prop = new PropertyAction(FlowPFDScrollView.this.m_node, FlowPFDScrollView.this.m_schmgr, false);
                    prop.actionPerformed(new ActionEvent(FlowPFDScrollView.this.m_flow, 1001, null));
                    if (FlowPFDScrollView.this.m_pfdPanel != null && prop.isDirty()) {
                        FlowPFDScrollView.this.m_pfdPanel.markDirty();
                    }
                    FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                } else if (FlowPFDScrollView.this.m_flow.getInfo().getScheduler() != null) {
                    if (FlowPFDScrollView.this.m_schmgr.checkSchedulerConnectionForProperties(FlowPFDScrollView.this.m_flow)) {
                        String namestr;
                        SchedulerServerInfo scheduler = FlowPFDScrollView.this.m_flow.getInfo().getScheduler();
                        int rc = FlowPFDScrollView.this.m_schmgr.showJobAdvanceProperties(title, info, FlowPFDScrollView.this.m_flow, scheduler);
                        if (rc == 1 && node != null && !(namestr = node.getTitleText()).equals(JobEventInfo.genName((DisplayInfo)info))) {
                            node.setTitleText(JobEventInfo.genName((DisplayInfo)info));
                        }
                    } else {
                        MessageUtil.displayMessage((Frame)FlowPFDScrollView.this.m_schmgr.getMainFrame(), (String)m_bundle.getString("FlowPFDScrollView.CannotConnectToScheduler.txt"), (String)m_bundle.getString("FlowPFDScrollView.Title.txt"), (int)2);
                        if (node != null) {
                            node.setPropertiesListener(null);
                            node.customize((PFDView)FlowPFDScrollView.this.m_pfdPanel);
                            node.setPropertiesListener((ActionListener)this);
                        } else if (info != null) {
                            String cmd = FlowPFDScrollView.this.m_schmgr.getJobCommandline(info);
                            if (cmd != null) {
                                info.setCommandLine(cmd);
                            }
                            JobPropertiesPanel panel = new JobPropertiesPanel(info);
                            StandardDialog dlg = new StandardDialog(FlowPFDScrollView.this.m_schmgr.getMainFrame(), title, true);
                            dlg.setMainPanel((StandardPanel)panel);
                            dlg.setHelpProduct("scheduler");
                            dlg.setHelpTopic("window_job_properties");
                            dlg.makeVisible();
                        }
                    }
                } else if (node != null) {
                    node.setPropertiesListener(null);
                    node.customize((PFDView)FlowPFDScrollView.this.m_pfdPanel);
                    node.setPropertiesListener((ActionListener)this);
                } else if (info != null) {
                    String cmd = FlowPFDScrollView.this.m_schmgr.getJobCommandline(info);
                    if (cmd != null) {
                        info.setCommandLine(cmd);
                    }
                    JobPropertiesPanel panel = new JobPropertiesPanel(info);
                    StandardDialog dlg = new StandardDialog(FlowPFDScrollView.this.m_schmgr.getMainFrame(), title, true);
                    dlg.setMainPanel((StandardPanel)panel);
                    dlg.setHelpProduct("scheduler");
                    dlg.setHelpTopic("window_job_properties");
                    dlg.makeVisible();
                }
            }
            finally {
                FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class myCloseListener
    implements ActionListener {
        private myCloseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            try {
                FlowPFDView panel = (FlowPFDView)ae.getSource();
                if (FlowPFDScrollView.this.m_pfdPanel.equals(panel)) {
                    FlowPFDScrollView.this.m_node.setCustomView(null);
                    FlowPFDScrollView.this.m_node.refreshUI();
                    FlowPFDScrollView.this.saveSettingsAndCleanUp();
                }
            }
            finally {
                FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class mySaveListener
    implements ActionListener {
        private mySaveListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            block12: {
                FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    FlowInfo info = (FlowInfo)ae.getSource();
                    try {
                        boolean ok = FlowPFDScrollView.this.m_flow.resetInfo(info);
                        if (ok) {
                            FlowPFDScrollView.this.m_schmgr.refreshNodeFromInfo(FlowPFDScrollView.this.m_node, (DisplayInfo)info);
                            FlowPFDScrollView.this.m_pfdPanel.clearDirty();
                            MessageUtil.displayMessage((Frame)FlowPFDScrollView.this.m_schmgr.getMainFrame(), (String)m_bundle.getString("FlowPFDScrollView.FlowSavedToMetadata.fmt"), (String)m_bundle.getString("FlowPFDScrollView.Title.txt"), (int)1);
                            break block12;
                        }
                        if (System.getProperty("sas.sch.RecoverOnMetadataWriteFailure") != null) {
                            if (ScheduleManager.isDebug()) {
                                System.err.println("INFO: attempting to recover from metadata write failure.");
                            }
                            if (ok = FlowPFDScrollView.this.m_flow.resetInfo(info)) {
                                FlowPFDScrollView.this.m_schmgr.refreshNodeFromInfo(FlowPFDScrollView.this.m_node, (DisplayInfo)info);
                            }
                        }
                        if (ok) {
                            FlowPFDScrollView.this.m_pfdPanel.clearDirty();
                            MessageUtil.displayMessage((Frame)FlowPFDScrollView.this.m_schmgr.getMainFrame(), (String)m_bundle.getString("FlowPFDScrollView.FlowSavedToMetadata.fmt"), (String)m_bundle.getString("FlowPFDScrollView.Title.txt"), (int)1);
                            break block12;
                        }
                        if (ScheduleManager.isDebug()) {
                            System.err.println("ERROR: metadata write failed.");
                        }
                        MessageUtil.displayMessage((Frame)FlowPFDScrollView.this.m_schmgr.getMainFrame(), (String)m_bundle.messageString("FlowPFDScrollView.CannotSaveFlowToMetadata.fmt", (Object)new SecurityException()), (String)m_bundle.getString("FlowPFDScrollView.Title.txt"), (int)0);
                        FlowPFDScrollView.this.m_pfdPanel.markDirty();
                    }
                    catch (SchedulerException ex) {
                        if (ScheduleManager.isDebug()) {
                            ex.printStackTrace();
                        }
                        MessageUtil.displayMessage((Frame)FlowPFDScrollView.this.m_schmgr.getMainFrame(), (String)m_bundle.messageString("FlowPFDScrollView.CannotSaveFlowToMetadata.fmt", (Object)ex), (String)m_bundle.getString("FlowPFDScrollView.Title.txt"), (int)0);
                    }
                }
                finally {
                    FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    private class myDeleteListener
    implements ActionListener {
        private myDeleteListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            try {
                FlowPFDScrollView.this.m_node.setCustomView(null);
                FlowInfo finfo = (FlowInfo)ae.getSource();
                ServerFlowInfo info = new ServerFlowInfo(finfo, FlowPFDScrollView.this.m_schmgr.getServerUtilities(), (PromptCallbackInterface)FlowPFDScrollView.this.m_schmgr);
                DeleteFlowAction action = new DeleteFlowAction(info, FlowPFDScrollView.this.m_schmgr, FlowPFDScrollView.this.m_node);
                action.actionPerformed(null);
                FlowPFDScrollView.this.saveSettingsAndCleanUp();
            }
            finally {
                FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class myScheduleListener
    implements ActionListener {
        private myScheduleListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
            try {
                FlowInfo finfo = (FlowInfo)ae.getSource();
                ServerFlowInfo info = new ServerFlowInfo(finfo, FlowPFDScrollView.this.m_schmgr.getServerUtilities(), (PromptCallbackInterface)FlowPFDScrollView.this.m_schmgr);
                ScheduleFlowAction action = new ScheduleFlowAction(info, FlowPFDScrollView.this.m_schmgr, FlowPFDScrollView.this.m_node);
                action.actionPerformed(null);
            }
            finally {
                FlowPFDScrollView.this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }
}

