/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.console.filter.visuals.FilterTableView;
import com.sas.console.filter.visuals.NeoTableModelInterface;
import com.sas.console.plugins.AbstractNode;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.ElementInterface;
import com.sas.console.plugins.IntObjPair;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.PluginChangeListener;
import com.sas.console.plugins.PluginNavigationInterface;
import com.sas.console.plugins.TableModelInterface;
import com.sas.console.visuals.ConsoleTree;
import com.sas.console.visuals.MainConsole;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdObjectListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobColumnSelectorModel;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.AddJobAction;
import com.sas.scheduler.schmgr.DeleteFlowAction;
import com.sas.scheduler.schmgr.EditFlowDiagramAction;
import com.sas.scheduler.schmgr.FlowPFDScrollView;
import com.sas.scheduler.schmgr.JobNode;
import com.sas.scheduler.schmgr.ReportFlowAction;
import com.sas.scheduler.schmgr.ScheduleFlowAction;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.SetSchedulerAction;
import com.sas.scheduler.schmgr.UnScheduleFlowAction;
import com.sas.scheduler.schmgr.model.JobsTableModel;
import com.sas.scheduler.schmgr.visuals.FlowPropertiesAttributesTab;
import com.sas.scheduler.schmgr.visuals.FlowPropertiesDefaultJobAttributesTab;
import com.sas.scheduler.schmgr.visuals.FlowPropertiesDependenciesTab;
import com.sas.scheduler.schmgr.visuals.FlowPropertiesGeneralTab;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerInfoInterface;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.server.ServerUtilities;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.ProgressIndicator;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FlowNode
extends AbstractNode
implements ElementInterface,
ServerInfoInterface {
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(FlowNode.class);
    private ScheduleManager m_schmgr;
    private Vector<JobNode> m_jobNodeList;
    private Vector<ServerInfoInterface> m_schMgrInfoList;
    private JobsTableModel m_tableModel = null;
    private ServerFlowInfo m_info = null;
    private FlowNode m_node;
    private int m_jobGrouping = 0;
    private CustomViewInterface m_pane = null;
    private ScheduleFlowAction m_sfa = null;
    private UnScheduleFlowAction m_usfa = null;
    private ArrayList<AbstractAction> m_actionList = null;
    private String m_oldname = null;

    public FlowNode(PluginNavigationInterface pInterface, String name, ServerFlowInfo flow) {
        super(pInterface, name);
        this.m_schmgr = (ScheduleManager)pInterface;
        this.m_info = flow;
        this.m_jobNodeList = null;
        this.m_schMgrInfoList = null;
        this.m_node = this;
        this.m_sfa = new ScheduleFlowAction(flow, this.m_schmgr, this);
        this.m_usfa = new UnScheduleFlowAction(flow, this.m_schmgr, this);
        this.m_actionList = FlowNode.buildContextMenuActions(flow, this.m_schmgr, this, this.m_sfa, this.m_usfa);
    }

    public CustomViewInterface getCustomView() {
        if (this.m_pane == null) {
            this.getListViewData();
            this.m_pane = new FilterTableView(this.m_schmgr.getWorkspaceFile(), (NodeInterface)this, (NeoTableModelInterface)this.m_tableModel, this.m_schmgr.getDefaultJobsRule());
        }
        return this.m_pane;
    }

    public void setCustomView(CustomViewInterface pane) {
        if (this.m_pane != null) {
            this.m_schmgr.removePluginChangeListener((PluginChangeListener)this.m_tableModel);
            this.m_schmgr.removePluginChangeListener((PluginChangeListener)this.m_pane);
        }
        this.m_pane = pane;
        ConsoleTree tree = ((MainConsole)this.m_schmgr.getConsole()).getTree();
        TreePath mypath = tree.getSelectionPath();
        tree.setSelectionPath(tree.getPathForRow(0));
        tree.setSelectionPath(mypath);
    }

    public static ArrayList<AbstractAction> buildContextMenuActions(ServerFlowInfo flow, ScheduleManager schmgr, FlowNode node, ScheduleFlowAction sfa, UnScheduleFlowAction usfa) {
        ArrayList<AbstractAction> actionList = new ArrayList<AbstractAction>();
        actionList.add(new EditFlowDiagramAction(flow, schmgr, node));
        actionList.add(new AddJobAction(flow, schmgr, node));
        actionList.add(new ReportFlowAction(flow, schmgr, node));
        if (sfa != null) {
            actionList.add(sfa);
        }
        actionList.add(new SetSchedulerAction(flow, schmgr, node));
        if (usfa != null) {
            actionList.add(usfa);
        }
        actionList.add(new DeleteFlowAction(flow, schmgr, node));
        return actionList;
    }

    public List<AbstractAction> getContextMenuActions() {
        if (this.m_pane instanceof FlowPFDScrollView) {
            return this.m_pane.getContextMenuActions();
        }
        FlowNode.SetScheduleAction(this.m_info, this.m_sfa);
        FlowNode.SetUnScheduleAction(this.m_info, this.m_usfa);
        return this.m_actionList;
    }

    public static void SetScheduleAction(ServerFlowInfo info, ScheduleFlowAction sfa) {
        try {
            if (info.hasCriticalErrors()) {
                sfa.setEnabled(false);
            } else {
                sfa.setEnabled(true);
            }
        }
        catch (RuntimeException e) {
            sfa.setEnabled(false);
        }
    }

    public static void SetUnScheduleAction(ServerFlowInfo info, UnScheduleFlowAction sfa) {
        try {
            sfa.setEnabled(info.isFlowSubmitted());
        }
        catch (RuntimeException e) {
            sfa.setEnabled(false);
        }
    }

    public TableModelInterface getListViewData() {
        if (this.m_schMgrInfoList == null) {
            this.populateJobNodes(false);
        }
        if (this.m_tableModel == null) {
            this.m_tableModel = new JobsTableModel((NodeInterface)this, this.m_schMgrInfoList, this.m_schmgr.getDefaultJobsRule(), new JobColumnSelectorModel(0));
        }
        return this.m_tableModel;
    }

    public List<?> getToolBarActions() {
        this.m_schmgr.clearChallengeCallbackHandler();
        if (this.m_pane instanceof FlowPFDScrollView) {
            return this.m_pane.getToolBarActions();
        }
        return this.getContextMenuActions();
    }

    public boolean hasInitialized() {
        return this.m_jobNodeList != null;
    }

    public void refresh() {
        if (!this.m_schmgr.getConsole().isConnected()) {
            return;
        }
        if (this.getChildCount() > 0) {
            this.removeAll();
            this.m_tableModel = null;
        }
        try {
            this.m_info.refresh();
            if (this.m_pane != null && this.m_pane instanceof FlowPFDScrollView) {
                ((FlowPFDScrollView)this.m_pane).refresh();
            }
        }
        catch (Exception e) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)e.getLocalizedMessage(), (String)m_bundle.getString("FlowNode.Title.txt"), (int)0);
        }
        for (Object obj : this.m_info.getJobs()) {
            ServerJobInfo job;
            if (obj instanceof JobInfo) {
                job = new ServerJobInfo((DisplayInfo)((JobInfo)obj), this.m_info, this.m_schmgr.getServerUtilities());
                this.m_node.addJobNode(job);
                continue;
            }
            if (obj instanceof FlowInfo) {
                ServerFlowInfo sflow = new ServerFlowInfo((FlowInfo)obj, this.m_schmgr.getServerUtilities(), (PromptCallbackInterface)this.m_schmgr);
                this.m_node.addJobNode(sflow);
                continue;
            }
            if (obj instanceof ServerJobInfo) {
                job = (ServerJobInfo)obj;
                this.m_node.addJobNode(job);
                continue;
            }
            if (!(obj instanceof ServerFlowInfo)) continue;
            ServerFlowInfo flow = (ServerFlowInfo)obj;
            this.m_node.addJobNode(flow);
        }
        FlowNode.SetScheduleAction(this.m_info, this.m_sfa);
        FlowNode.SetUnScheduleAction(this.m_info, this.m_usfa);
    }

    public void refreshUI() {
        if (!this.m_schmgr.getConsole().isConnected()) {
            return;
        }
        if (this.getChildCount() > 0) {
            this.removeAll();
            this.m_tableModel = null;
        }
        try {
            if (this.m_pane instanceof FlowPFDScrollView) {
                ((FlowPFDScrollView)this.m_pane).refresh();
            }
        }
        catch (Exception e) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)e.getLocalizedMessage(), (String)m_bundle.getString("FlowNode.Title.txt"), (int)0);
        }
        for (Object obj : this.m_info.getJobs()) {
            ServerJobInfo job;
            if (obj instanceof JobInfo) {
                job = new ServerJobInfo((DisplayInfo)((JobInfo)obj), this.m_info, this.m_schmgr.getServerUtilities());
                this.m_node.addJobNode(job);
                continue;
            }
            if (obj instanceof FlowInfo) {
                ServerFlowInfo sflow = new ServerFlowInfo((FlowInfo)obj, this.m_schmgr.getServerUtilities(), (PromptCallbackInterface)this.m_schmgr);
                this.m_node.addJobNode(sflow);
                continue;
            }
            if (obj instanceof ServerJobInfo) {
                job = (ServerJobInfo)obj;
                this.m_node.addJobNode(job);
                continue;
            }
            if (!(obj instanceof ServerFlowInfo)) continue;
            ServerFlowInfo flow = (ServerFlowInfo)obj;
            this.m_node.addJobNode(flow);
        }
        FlowNode.SetScheduleAction(this.m_info, this.m_sfa);
        FlowNode.SetUnScheduleAction(this.m_info, this.m_usfa);
        this.refreshIcons();
    }

    public void refreshOnUpdate() {
        if (this.m_info != null && System.getProperty("sas.sch.RecoverOnMetadataWriteFailure") != null) {
            RuntimeException rte = new RuntimeException();
            StackTraceElement[] st = rte.getStackTrace();
            for (int i = 0; i < st.length; ++i) {
                StackTraceElement e = st[i];
                if (!e.getClassName().equals("com.sas.metadata.promotion.ImportHandler") || !e.getMethodName().equals("runImport")) continue;
                try {
                    Root root = this.getMetadataObject(this.m_schmgr.getServerUtilities());
                    if (root == null) continue;
                    MdObjectStore store = (MdObjectStore)root.getObjectStore();
                    store.clearChangeList();
                    break;
                }
                catch (Exception ex) {
                    if (!ScheduleManager.isDebug()) continue;
                    ex.printStackTrace();
                }
            }
        }
        this.refreshIcons();
    }

    public boolean isLeaf() {
        if (this.m_jobNodeList == null) {
            this.populateJobNodes(false);
        }
        return this.m_jobNodeList.size() <= 0;
    }

    public boolean getAllowsChildren() {
        return this.m_info.areJobs();
    }

    public void refreshIcons() {
        this.m_info.refreshIcon();
        if (this.m_jobNodeList != null) {
            for (JobNode node : this.m_jobNodeList) {
                node.refreshIcon();
            }
        }
    }

    public Icon getIcon(int size) {
        return this.getIcon();
    }

    public Icon getIcon() {
        return this.m_info.getIcon();
    }

    public Enumeration<JobNode> children() {
        return this.m_jobNodeList.elements();
    }

    public int getChildCount() {
        return this.getChildCount(false);
    }

    public int getCurrentChildCount() {
        return this.m_jobNodeList != null ? this.m_jobNodeList.size() : 0;
    }

    public int getChildCount(boolean silently) {
        if (this.getPlugin().getConsole().getDefaultRepository() == null) {
            return 0;
        }
        if (this.m_jobNodeList == null) {
            this.populateJobNodes(silently);
        }
        return this.m_jobNodeList.size();
    }

    public JobNode addJobNode(ServerJobInfo job) {
        int index = this.getChildCount();
        JobNode node = new JobNode((PluginNavigationInterface)this.m_schmgr, job.getName(), job);
        node.setParent((MutableTreeNode)((Object)this));
        this.m_jobNodeList.add(index, node);
        this.m_schMgrInfoList.add(index, (ServerInfoInterface)job);
        this.insert((MutableTreeNode)((Object)node), index);
        IntObjPair ioPair = new IntObjPair(index, (Object)node);
        Vector<IntObjPair> childList = new Vector<IntObjPair>(0);
        childList.add(ioPair);
        this.m_schmgr.firePluginChange(1, (NodeInterface)this, childList);
        return node;
    }

    public JobNode addJobNode(ServerFlowInfo subflow) {
        int index = this.getChildCount();
        JobNode node = new JobNode((PluginNavigationInterface)this.m_schmgr, subflow.getName(), subflow);
        node.setParent((MutableTreeNode)((Object)this));
        this.m_jobNodeList.add(index, node);
        this.m_schMgrInfoList.add(index, (ServerInfoInterface)subflow);
        this.insert((MutableTreeNode)((Object)node), index);
        IntObjPair ioPair = new IntObjPair(index, (Object)node);
        Vector<IntObjPair> childList = new Vector<IntObjPair>(0);
        childList.add(ioPair);
        this.m_schmgr.firePluginChange(1, (NodeInterface)this, childList);
        return node;
    }

    public void remove(int index) {
        JobNode jobNode = this.m_jobNodeList.get(index);
        this.m_jobNodeList.remove(index);
        this.m_schMgrInfoList.remove(index);
        IntObjPair ioPair = new IntObjPair(index, (Object)jobNode);
        Vector<IntObjPair> childList = new Vector<IntObjPair>();
        childList.add(ioPair);
        this.m_schmgr.firePluginChange(0, (NodeInterface)this, childList);
    }

    public void removeAll() {
        int count = this.getChildCount();
        for (int index = count - 1; index >= 0; --index) {
            this.remove(index);
        }
    }

    public TreeNode getChildAt(int index) {
        return this.m_jobNodeList.get(index);
    }

    public List<WAPropertyTab> getPropertyTabs() {
        if (this.m_jobNodeList == null) {
            this.populateJobNodes(false);
        }
        ArrayList<WAPropertyTab> tabList = new ArrayList<WAPropertyTab>();
        try {
            FlowPropertiesGeneralTab tab1 = new FlowPropertiesGeneralTab(this.m_schmgr, this.m_info);
            tab1.setName(m_bundle.getString("FlowNode.GeneralTab.Name.txt"));
            tabList.add((WAPropertyTab)tab1);
            FlowPropertiesAttributesTab tab2 = null;
            try {
                tab2 = new FlowPropertiesAttributesTab(this.m_schmgr, this.m_info);
                tab2.setName(m_bundle.getString("FlowNode.FlowPropertiesAttributesTab.Name.txt"));
                tabList.add(tab2);
            }
            catch (SchedulerException se) {
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)se.getLocalizedMessage(), (String)m_bundle.getString("FlowNode.Title.txt"), (int)2, (int)-1);
            }
            FlowPropertiesDefaultJobAttributesTab tab3 = null;
            try {
                tab3 = new FlowPropertiesDefaultJobAttributesTab(this.m_schmgr, this.m_info);
                tab3.setName(m_bundle.getString("FlowNode.FlowPropertiesDefaultJobAttributesTab.Name.txt"));
                tabList.add(tab3);
                if (tab2 != null) {
                    tab2.setDependentTab(tab3);
                }
            }
            catch (SchedulerException se) {
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)se.getLocalizedMessage(), (String)m_bundle.getString("FlowNode.Title.txt"), (int)2, (int)-1);
            }
            FlowPropertiesDependenciesTab tab4 = null;
            try {
                tab4 = new FlowPropertiesDependenciesTab(this.m_schmgr, this.m_info);
                tab4.setName(m_bundle.getString("FlowNode.FlowPropertiesDependenciesTab.Name.txt"));
                tabList.add(tab4);
                if (tab3 != null) {
                    tab3.setDependentTab(tab4);
                }
            }
            catch (SchedulerException se) {
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)se.getLocalizedMessage(), (String)m_bundle.getString("FlowNode.Title.txt"), (int)2, (int)-1);
            }
            tabList.trimToSize();
        }
        catch (RemoteException ex) {
            tabList = null;
        }
        try {
            this.m_info.addMetaDataListener(new MdObjectListener(){

                public void MdObjectModified(MdEvent e) {
                    block20: {
                        Object obj;
                        if (e.getSource().equals("NAME")) {
                            try {
                                Root root = FlowNode.this.getMetadataObject(FlowNode.this.m_schmgr.getServerUtilities());
                                String newname = root.getName();
                                if (FlowNode.this.m_info.isFlowSubmitted()) {
                                    String oldname = FlowNode.this.getName();
                                    Frame frame = FlowNode.this.m_schmgr.getMainFrame();
                                    int response = JOptionPane.showConfirmDialog(frame, m_bundle.getString("FlowNode.FlowSubmitted.Remove.txt"), m_bundle.getString("FlowNode.Title.txt"), 0);
                                    if (0 == response) {
                                        root.setName(oldname);
                                        FlowNode.this.m_info.setName(oldname);
                                        try {
                                            String runnowname;
                                            String flowname;
                                            Scheduler scheduler = FlowNode.this.m_info.getServerUtil().getSchedulingServer(FlowNode.this.m_info.getInfo().getScheduler());
                                            if (!FlowNode.this.m_schmgr.connectToSchedulingServer(FlowNode.this.m_info) || !scheduler.removeFlow(FlowNode.this.m_info.getInfo())) {
                                                MessageUtil.displayMessage((Frame)frame, (String)m_bundle.getString("FlowNode.UnableToRemoveFromScheduler.txt"), (String)m_bundle.getString("FlowNode.Title.txt"), (int)2);
                                            }
                                            if ((flowname = scheduler.genFlowName(FlowNode.this.m_info.getInfo())).compareTo(runnowname = scheduler.runNowName(flowname)) != 0) {
                                                try {
                                                    scheduler.removeFlow(runnowname);
                                                }
                                                catch (SchedulerException se) {
                                                    Workspace.getDefaultLogger().debug((Object)se.getMessage());
                                                }
                                            }
                                        }
                                        catch (UnsupportedOperationException ex) {
                                            MessageUtil.displayMessage((Frame)frame, (String)m_bundle.getString("FlowNode.UnableToRemoveFromScheduler.txt"), (String)m_bundle.getString("FlowNode.Title.txt"), (int)2);
                                        }
                                        catch (SchedulerException ex) {
                                            MessageUtil.displayMessage((Frame)frame, (String)m_bundle.getString("FlowNode.UnableToRemoveFromScheduler.txt"), (String)m_bundle.getString("FlowNode.Title.txt"), (int)2);
                                        }
                                        root.setName(newname);
                                        FlowNode.this.m_info.setName(newname);
                                        FlowNode.this.setName(newname);
                                        FlowNode.this.m_oldname = null;
                                        break block20;
                                    }
                                    root.setName(oldname);
                                    FlowNode.this.m_info.setName(oldname);
                                    FlowNode.this.setName(oldname);
                                    FlowNode.this.m_oldname = oldname;
                                    break block20;
                                }
                                FlowNode.this.setName(newname);
                            }
                            catch (RemoteException ex) {
                                String errorMessage = m_bundle.messageString("FlowNode.UnexpectedError.Message.fmt", (Object)ex.getLocalizedMessage());
                                MessageUtil.displayMessage((Frame)FlowNode.this.m_schmgr.getMainFrame(), (String)errorMessage, (String)m_bundle.getString("FlowNode.Title.txt"), (int)0);
                            }
                            catch (RuntimeException ex) {
                                String errorMessage = m_bundle.messageString("FlowNode.UnexpectedError.Message.fmt", (Object)ex.getLocalizedMessage());
                                MessageUtil.displayMessage((Frame)FlowNode.this.m_schmgr.getMainFrame(), (String)errorMessage, (String)m_bundle.getString("FlowNode.Title.txt"), (int)0);
                            }
                        } else if (e.getSource().equals("WRITECHANGE")) {
                            FlowNode.this.refresh();
                        } else if (FlowNode.this.m_oldname != null && (obj = e.getSource()) instanceof JFJob) {
                            try {
                                JFJob jfjob = (JFJob)obj;
                                if (jfjob.getName().compareTo(FlowNode.this.m_oldname) != 0) {
                                    jfjob.setName(FlowNode.this.m_oldname);
                                    jfjob.updateMetadataAll();
                                }
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }
            });
        }
        catch (RemoteException ex) {
            String errorMessage = m_bundle.messageString("FlowNode.UnexpectedError.Message.fmt", (Object)ex.getLocalizedMessage());
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)errorMessage, (String)m_bundle.getString("FlowNode.Title.txt"), (int)0);
        }
        return tabList;
    }

    public NodeInterface getNode() {
        return this;
    }

    public void delete() {
        this.removeAll();
    }

    public void persist() {
    }

    public Root getMetadataObject(ServerUtilities serverUtil) {
        return this.m_info.getMetadataObject(serverUtil);
    }

    public ServerFlowInfo getFlowInfo() {
        return this.m_info;
    }

    public Vector<JobNode> getNodeList() {
        return this.m_jobNodeList;
    }

    private void populateJobNodes(boolean quietly) {
        try {
            if (quietly) {
                this.cRunnable_run();
            } else {
                String str1 = m_bundle.messageString("FlowNode.BuildMetadataProgressIndicator.Message.fmt", (Object)this.m_info.getName());
                String str2 = m_bundle.getString("FlowNode.BuildMetadataProgressIndicator.Title.txt");
                ProgressIndicator request = new ProgressIndicator(this.m_schmgr.getMainFrame(), str1, str2);
                request.setDelayBeforeProgressCancelDialog(200);
                request.execute((Runnable)new cRunnable());
            }
        }
        catch (RuntimeException ex) {
            String message = ex.toString();
            String lmessage = ex.getLocalizedMessage();
            if (lmessage != null && lmessage.length() > 0) {
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)lmessage, (String)m_bundle.getString("FlowNode.Title.txt"), (int)0, (int)-1);
            }
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("FlowNode.Title.txt"), (int)0, (int)-1);
        }
    }

    private void cRunnable_run() {
        if (this.m_jobNodeList == null) {
            this.m_jobNodeList = new Vector();
        } else {
            this.m_jobNodeList.clear();
        }
        if (this.m_schMgrInfoList == null) {
            this.m_schMgrInfoList = new Vector();
        } else {
            this.m_schMgrInfoList.clear();
        }
        try {
            SortedSet list = this.m_info.getListOfJobs(this.m_jobGrouping);
            for (Object obj : list) {
                if (obj instanceof ServerJobInfo) {
                    ServerJobInfo job = (ServerJobInfo)obj;
                    this.m_node.addJobNode(job);
                    continue;
                }
                if (!(obj instanceof ServerFlowInfo)) continue;
                ServerFlowInfo flow = (ServerFlowInfo)obj;
                this.m_node.addJobNode(flow);
            }
        }
        catch (RemoteException ex) {
            String errorMessage = m_bundle.messageString("FlowNode.UnexpectedError.Message.fmt", (Object)ex.getLocalizedMessage());
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)errorMessage, (String)m_bundle.getString("FlowNode.Title.txt"), (int)0);
        }
        catch (SchedulerException ex) {
            String errorMessage = m_bundle.messageString("FlowNode.UnexpectedError.Message.fmt", (Object)ex.getLocalizedMessage());
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)errorMessage, (String)m_bundle.getString("FlowNode.Title.txt"), (int)0);
        }
    }

    private class cRunnable
    implements Runnable {
        cRunnable() {
        }

        @Override
        public void run() {
            FlowNode.this.cRunnable_run();
        }
    }
}

