/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.console.ConsoleInterface;
import com.sas.console.visuals.MainConsole;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.schmgr.FlowNode;
import com.sas.scheduler.schmgr.FlowPFDScrollView;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.swing.visuals.util.Util;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class EditFlowDiagramAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(EditFlowDiagramAction.class);
    private ServerFlowInfo m_flow;
    private ScheduleManager m_schmgr;
    private FlowNode m_node;

    public EditFlowDiagramAction(ServerFlowInfo flow, ScheduleManager plugin, FlowNode node) {
        this.m_flow = flow;
        this.m_schmgr = plugin;
        this.m_node = node;
        String nameText = m_bundle.getString("EditFlowDiagramAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_EditFlowDiagram));
        this.putValue("ShortDescription", m_bundle.getString("EditFlowDiagramAction.ShortDescription.txt"));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        FlowPFDScrollView view = new FlowPFDScrollView(this.m_flow, this.m_schmgr, this.m_node);
        this.m_node.setCustomView(view);
        view.resetPFDKeyboard();
        try {
            ConsoleInterface console = this.m_node.getPlugin().getConsole();
            if (console instanceof MainConsole) {
                ((MainConsole)console).getTree().setSelectionPath(this.m_node.getTreePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_schmgr.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
    }
}

