/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.utils;

import com.sas.apps.content.migration.utils.Lib;
import com.sas.apps.content.migration.utils.LogParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMLWriter {
    public File writeXML(Map<String, Lib> mapLib, File parent) throws IOException, ParserConfigurationException, TransformerException {
        File xmlFile = new File(parent, "cmu_report.xml");
        if (!xmlFile.exists()) {
            xmlFile.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(xmlFile);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        DOMImplementation impl = builder.getDOMImplementation();
        Element libElement = null;
        Element migratedFilesElement = null;
        Element notMigratedFilesElement = null;
        Element notesElement = null;
        Document xmldoc = impl.createDocument(null, "LIBS", null);
        Element root = xmldoc.getDocumentElement();
        for (Lib lib : mapLib.values()) {
            libElement = xmldoc.createElementNS(null, "Lib");
            libElement.setAttributeNS(null, "Target", lib.getTarget());
            libElement.setAttributeNS(null, "TotalMigratedFiles", Long.toString(lib.getCountOfMigratedFiles()));
            libElement.setAttributeNS(null, "TotalNotMigratedFiles", Long.toString(lib.getCountOfNotMigratedFiles()));
            libElement.setAttributeNS(null, "TotalFailureNotes", Long.toString(lib.getCountOfErrors()));
            migratedFilesElement = xmldoc.createElementNS(null, "MigratedFiles");
            this.constructFilesElement(lib.getMapMigratedFiles(), migratedFilesElement, xmldoc);
            libElement.appendChild(migratedFilesElement);
            notMigratedFilesElement = xmldoc.createElementNS(null, "NotMigratedFiles");
            this.constructFilesElement(lib.getMapNotMigratedFiles(), notMigratedFilesElement, xmldoc);
            libElement.appendChild(notMigratedFilesElement);
            notesElement = xmldoc.createElementNS(null, "Notes");
            this.constructNotesElement(lib.getMapNotes(), notesElement, xmldoc);
            libElement.appendChild(notesElement);
            root.appendChild(libElement);
        }
        DOMSource domSource = new DOMSource(xmldoc);
        StreamResult streamResult = new StreamResult(out);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        serializer.setOutputProperty("encoding", "ISO-8859-1");
        serializer.setOutputProperty("indent", "yes");
        serializer.transform(domSource, streamResult);
        File htmlFile = new File(parent, "cmu_report.html");
        StreamSource xsltSource = new StreamSource(new FileInputStream(new File(parent, "cmu_report.xsl")));
        StreamSource xmlSource = new StreamSource(xmlFile);
        StreamResult result = new StreamResult(htmlFile);
        Transformer transformer = tf.newTransformer(xsltSource);
        transformer.transform(xmlSource, result);
        return htmlFile;
    }

    private Element createFileTypeElement(String fileExtension, Document xmldoc) {
        Element fileTypeElement = null;
        for (LogParser.FileTypes ft : LogParser.FileTypes.values()) {
            if (!fileExtension.equalsIgnoreCase(ft.getFileType())) continue;
            switch (ft) {
                case CATALOG: {
                    fileTypeElement = xmldoc.createElementNS(null, "Catalog");
                    break;
                }
                case DATA: {
                    fileTypeElement = xmldoc.createElementNS(null, "DataSet");
                    break;
                }
                case INDEX: {
                    fileTypeElement = xmldoc.createElementNS(null, "Index");
                    break;
                }
                case ITEMSTOR: {
                    fileTypeElement = xmldoc.createElementNS(null, "ItemStore");
                    break;
                }
                case MDDB: {
                    fileTypeElement = xmldoc.createElementNS(null, "Mddb");
                    break;
                }
                case VIEW: {
                    fileTypeElement = xmldoc.createElementNS(null, "View");
                }
            }
            break;
        }
        return fileTypeElement;
    }

    private void constructFilesElement(Map<String, List<String>> mapObj, Element filesElement, Document xmldoc) {
        String fileExtension = null;
        Element fileTypeElement = null;
        Element fileElement = null;
        Text fileNode = null;
        Element catalogElement = xmldoc.createElementNS(null, "Catalog");
        Element datasetElement = xmldoc.createElementNS(null, "DataSet");
        Element indexElement = xmldoc.createElementNS(null, "Index");
        Element itemStoreElement = xmldoc.createElementNS(null, "ItemStore");
        Element mddbElement = xmldoc.createElementNS(null, "Mddb");
        Element viewElement = xmldoc.createElementNS(null, "View");
        catalogElement.setAttributeNS(null, "TotalFiles", "0");
        datasetElement.setAttributeNS(null, "TotalFiles", "0");
        indexElement.setAttributeNS(null, "TotalFiles", "0");
        itemStoreElement.setAttributeNS(null, "TotalFiles", "0");
        mddbElement.setAttributeNS(null, "TotalFiles", "0");
        viewElement.setAttributeNS(null, "TotalFiles", "0");
        filesElement.appendChild(catalogElement);
        filesElement.appendChild(datasetElement);
        filesElement.appendChild(indexElement);
        filesElement.appendChild(itemStoreElement);
        filesElement.appendChild(mddbElement);
        filesElement.appendChild(viewElement);
        for (Map.Entry<String, List<String>> entry : mapObj.entrySet()) {
            fileExtension = entry.getKey();
            for (LogParser.FileTypes ft : LogParser.FileTypes.values()) {
                if (!fileExtension.equalsIgnoreCase(ft.getFileType())) continue;
                switch (ft) {
                    case CATALOG: {
                        fileTypeElement = catalogElement;
                        break;
                    }
                    case DATA: {
                        fileTypeElement = datasetElement;
                        break;
                    }
                    case INDEX: {
                        fileTypeElement = indexElement;
                        break;
                    }
                    case ITEMSTOR: {
                        fileTypeElement = itemStoreElement;
                        break;
                    }
                    case MDDB: {
                        fileTypeElement = mddbElement;
                        break;
                    }
                    case VIEW: {
                        fileTypeElement = viewElement;
                    }
                }
                break;
            }
            fileTypeElement.setAttributeNS(null, "TotalFiles", Integer.toString(entry.getValue().size()));
            for (String fileName : entry.getValue()) {
                fileElement = xmldoc.createElementNS(null, "File");
                fileNode = xmldoc.createTextNode(fileName);
                fileElement.appendChild(fileNode);
                fileTypeElement.appendChild(fileElement);
            }
        }
    }

    private void constructNotesElement(Map<String, List<String>> mapObj, Element notesElement, Document xmldoc) {
        String noteType = null;
        Element noteTypeElement = null;
        Element noteElement = null;
        Text noteNode = null;
        Element errorElement = xmldoc.createElementNS(null, "Error");
        errorElement.setAttributeNS(null, "TotalNotes", "0");
        notesElement.appendChild(errorElement);
        for (Map.Entry<String, List<String>> entry : mapObj.entrySet()) {
            noteType = entry.getKey();
            noteTypeElement = errorElement;
            noteTypeElement.setAttributeNS(null, "TotalNotes", Integer.toString(entry.getValue().size()));
            for (String note : entry.getValue()) {
                noteElement = xmldoc.createElementNS(null, "note");
                noteNode = xmldoc.createTextNode(note);
                noteElement.appendChild(noteNode);
                noteTypeElement.appendChild(noteElement);
            }
        }
    }

    private Element createNoteTypeElement(String noteType, Document xmldoc) {
        Element noteTypeElement = null;
        for (LogParser.NoteTypes nt : LogParser.NoteTypes.values()) {
            if (!noteType.equalsIgnoreCase(nt.toString())) continue;
            switch (nt) {
                case ERROR: {
                    noteTypeElement = xmldoc.createElementNS(null, "Error");
                    break;
                }
                case WARNING: {
                    noteTypeElement = xmldoc.createElementNS(null, "Warning");
                }
            }
            break;
        }
        return noteTypeElement;
    }
}

