/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.utils;

import com.sas.apps.content.migration.core.ContentMigrationException;
import com.sas.apps.content.migration.utils.RB;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.text.Message;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class Utils {
    public static final boolean DEBUG = false;
    public static final int OS_UNDEFINED = 0;
    public static final int OS_WINDOWS = 1;
    public static final int OS_LINUX = 2;
    public static final int OS_SOLARIS = 3;
    public static final int OS_HPUX = 4;
    public static final int OS_AIX = 5;
    public static final int OS_OPENVMS = 6;
    public static final int OS_ALX = 7;
    public static final int OS_MVS = 8;
    public static final int OS_MAC = 9;
    public static final int OS_ZOS = 10;
    public static final String OS_SUFFIX_SAX = "sax";
    public static final String OS_SUFFIX_S64 = "s64";
    public static final String OS_SUFFIX_LIX = "lix";
    public static final String OS_SUFFIX_LAX = "lax";
    public static final String OS_SUFFIX_LNX = "lnx";
    public static final String OS_SUFFIX_H6I = "h6i";
    public static final String OS_SUFFIX_H64 = "h64";
    public static final String OS_SUFFIX_R64 = "r64";
    public static final String OS_SUFFIX_ALX = "alx";
    public static final String OS_SUFFIX_W64 = "w64";
    public static final String OS_SUFFIX_WX6 = "wx6";
    public static final String OS_SUFFIX_WIN = "win";
    public static final String OS_SUFFIX_MVS = "mvs";
    public static final String OS_SUFFIX_MAC = "mac";
    public static final String OS_SUFFIX_VMI = "vmi";
    public static final String OS_SUFFIX_ZOS = "zos";
    public static final String OS_FAMILY_UNDEFINED = "Undefined";
    public static final String OS_FAMILY_UNIX = "Unix";
    public static final String OS_FAMILY_WINDOWS = "Windows";
    public static final String OS_FAMILY_MAC = "Macintosh";
    public static final String OS_FAMILY_MVS = "MVS";
    public static final String OS_FAMILY_ZOS = "ZOS";
    public static final String OS_FAMILY_VMS = "VMS";
    public static final String OS_3_UNIX = "unx";
    public static final String OS_3_WINDOWS = "win";
    public static final String OS_3_MAC = "mac";
    public static final String OS_3_ZOS = "zos";
    public static final String OS_3_UND = "und";
    private static final int MAX_BUNDLES_SEARCHED = 7;
    static int gc_count = 0;
    static int m_os = 0;
    static String m_osSuffix = null;

    public static String getOS_Family() {
        switch (Utils.getOS()) {
            case 0: {
                return OS_FAMILY_UNDEFINED;
            }
            case 1: {
                return OS_FAMILY_WINDOWS;
            }
            case 2: {
                return OS_FAMILY_UNIX;
            }
            case 3: {
                return OS_FAMILY_UNIX;
            }
            case 4: {
                return OS_FAMILY_UNIX;
            }
            case 5: {
                return OS_FAMILY_UNIX;
            }
            case 6: {
                return OS_FAMILY_VMS;
            }
            case 7: {
                return OS_FAMILY_UNIX;
            }
            case 8: {
                return OS_FAMILY_MVS;
            }
            case 9: {
                return OS_FAMILY_MAC;
            }
            case 10: {
                return OS_FAMILY_ZOS;
            }
        }
        return OS_FAMILY_UNDEFINED;
    }

    public static String getOS_3byte() {
        switch (Utils.getOS()) {
            case 0: {
                return OS_3_UND;
            }
            case 1: {
                return "win";
            }
            case 2: {
                return OS_3_UNIX;
            }
            case 3: {
                return OS_3_UNIX;
            }
            case 4: {
                return OS_3_UNIX;
            }
            case 5: {
                return OS_3_UNIX;
            }
            case 6: {
                return OS_3_UNIX;
            }
            case 7: {
                return OS_3_UNIX;
            }
            case 8: {
                return "zos";
            }
            case 9: {
                return "mac";
            }
            case 10: {
                return "zos";
            }
        }
        return OS_3_UND;
    }

    public static int getOS() {
        int rc = 0;
        String osName = System.getProperty("os.name");
        if (osName.startsWith(OS_FAMILY_WINDOWS)) {
            rc = 1;
        } else if (osName.equalsIgnoreCase("Linux")) {
            rc = 2;
        } else if (osName.equalsIgnoreCase("Solaris") || osName.equalsIgnoreCase("SunOS")) {
            rc = 3;
        } else if (osName.equalsIgnoreCase("HP-UX")) {
            rc = 4;
        } else if (osName.equalsIgnoreCase("AIX")) {
            rc = 5;
        } else if (osName.equalsIgnoreCase("OpenVMS")) {
            rc = 6;
        } else if (osName.equalsIgnoreCase("Compaq's Digital UNIX") || osName.equalsIgnoreCase("OSF1")) {
            rc = 7;
        } else if (osName.equalsIgnoreCase(OS_FAMILY_MVS)) {
            rc = 8;
        } else if (osName.equalsIgnoreCase("z/os")) {
            rc = 10;
        } else if (osName.startsWith("Mac")) {
            rc = 9;
        } else if (osName.startsWith("OpenVMS")) {
            rc = 6;
        }
        return rc;
    }

    public static String getOS_Suffix() {
        String suffix = "";
        if (m_osSuffix != null) {
            suffix = m_osSuffix;
        } else {
            String osArch = System.getProperty("os.arch");
            boolean itanium = osArch.length() >= 4 && osArch.substring(0, 4).equalsIgnoreCase("ia64");
            boolean x86 = osArch.length() >= 3 && osArch.substring(0, 3).equalsIgnoreCase("x86");
            boolean x86_64 = osArch.length() >= 5 && osArch.substring(0, 5).equalsIgnoreCase("amd64");
            switch (Utils.getOS()) {
                case 3: {
                    if (x86) {
                        suffix = OS_SUFFIX_SAX;
                        break;
                    }
                    suffix = OS_SUFFIX_S64;
                    break;
                }
                case 2: {
                    if (!x86_64) {
                        try {
                            String sascmd = "sh -c 'if [ `uname -m` = \"x86_64\" ] ; then exit 1 ; else exit 0 ; fi'";
                            Runtime runtime = Runtime.getRuntime();
                            Process process = runtime.exec(sascmd);
                            int rc = process.waitFor();
                            x86_64 = rc == 1;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (itanium) {
                        suffix = OS_SUFFIX_LIX;
                        break;
                    }
                    if (x86_64) {
                        suffix = OS_SUFFIX_LAX;
                        break;
                    }
                    suffix = OS_SUFFIX_LNX;
                    break;
                }
                case 4: {
                    if (itanium) {
                        suffix = OS_SUFFIX_H6I;
                        break;
                    }
                    suffix = OS_SUFFIX_H64;
                    break;
                }
                case 5: {
                    suffix = OS_SUFFIX_R64;
                    break;
                }
                case 6: {
                    suffix = OS_SUFFIX_VMI;
                    break;
                }
                case 7: {
                    suffix = OS_SUFFIX_ALX;
                    break;
                }
                case 1: {
                    if (itanium) {
                        suffix = OS_SUFFIX_W64;
                        break;
                    }
                    suffix = "win";
                    break;
                }
                case 8: {
                    suffix = OS_SUFFIX_MVS;
                    break;
                }
                case 9: {
                    suffix = "mac";
                    break;
                }
                case 10: {
                    suffix = "zos";
                }
            }
            m_osSuffix = suffix;
        }
        return suffix;
    }

    public static String getOSCode4Byte(String osSuffix) {
        String code4Byte = null;
        code4Byte = osSuffix.equalsIgnoreCase(OS_SUFFIX_SAX) ? "slx6" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_S64) ? "sl64" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_LIX) ? "lini" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_LAX) ? "lina" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_LNX) ? "linx" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_H6I) ? "hp6i" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_H64) ? "hp64" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_R64) ? "ar64" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_ALX) ? "aosf" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_W64) ? OS_SUFFIX_W64 : (osSuffix.equalsIgnoreCase(OS_SUFFIX_WX6) ? OS_SUFFIX_WX6 : (osSuffix.equalsIgnoreCase("win") ? "wndw" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_MVS) ? "os" : (osSuffix.equalsIgnoreCase("mac") ? "mac" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_VMI) ? "ivms" : ""))))))))))))));
        return code4Byte;
    }

    public static String escapeHTMLString(String inString) {
        StringBuffer stringBuffer = new StringBuffer();
        int i = inString.length();
        char[] inChar = new char[i];
        inString.getChars(0, i, inChar, 0);
        for (i = 0; i < inChar.length; ++i) {
            String outChar;
            switch (inChar[i]) {
                case '<': {
                    outChar = "&lt;";
                    break;
                }
                case '>': {
                    outChar = "&gt;";
                    break;
                }
                case '&': {
                    outChar = "&amp;";
                    break;
                }
                case '\"': {
                    outChar = "&quot;";
                    break;
                }
                case '\u00a0': {
                    outChar = "*&nbsp;";
                    break;
                }
                case '\u00a1': {
                    outChar = "&iexcl;";
                    break;
                }
                case '\u00a2': {
                    outChar = "&cent;";
                    break;
                }
                case '\u00a3': {
                    outChar = "&pound;";
                    break;
                }
                case '\u00a4': {
                    outChar = "&curren;";
                    break;
                }
                case '\u00a5': {
                    outChar = "&yen;";
                    break;
                }
                case '\u00a6': {
                    outChar = "&brvbar;";
                    break;
                }
                case '\u00a7': {
                    outChar = "&sect;";
                    break;
                }
                case '\u00a8': {
                    outChar = "&uml;";
                    break;
                }
                case '\u00a9': {
                    outChar = "*&copy;";
                    break;
                }
                case '\u00aa': {
                    outChar = "&ordf;";
                    break;
                }
                case '\u00ab': {
                    outChar = "&laquo;";
                    break;
                }
                case '\u00ac': {
                    outChar = "&not;";
                    break;
                }
                case '\u00ad': {
                    outChar = "&shy;";
                    break;
                }
                case '\u00ae': {
                    outChar = "&reg;";
                    break;
                }
                case '\u00af': {
                    outChar = "&macr;";
                    break;
                }
                case '\u00b0': {
                    outChar = "&deg;";
                    break;
                }
                case '\u00b1': {
                    outChar = "&plusmn;";
                    break;
                }
                case '\u00b2': {
                    outChar = "&sup2;";
                    break;
                }
                case '\u00b3': {
                    outChar = "&sup3;";
                    break;
                }
                case '\u00b4': {
                    outChar = "&acute;";
                    break;
                }
                case '\u00b5': {
                    outChar = "&micro;";
                    break;
                }
                case '\u00b6': {
                    outChar = "&para;";
                    break;
                }
                case '\u00b7': {
                    outChar = "&middot;";
                    break;
                }
                case '\u00b8': {
                    outChar = "&cedil;";
                    break;
                }
                case '\u00b9': {
                    outChar = "&sup1;";
                    break;
                }
                case '\u00ba': {
                    outChar = "&ordm;";
                    break;
                }
                case '\u00bb': {
                    outChar = "*&raquo;";
                    break;
                }
                case '\u00bc': {
                    outChar = "&frac14;";
                    break;
                }
                case '\u00bd': {
                    outChar = "&frac12;";
                    break;
                }
                case '\u00be': {
                    outChar = "&frac34;";
                    break;
                }
                case '\u00bf': {
                    outChar = "&iquest;";
                    break;
                }
                case '\u00c0': {
                    outChar = "&Agrave;";
                    break;
                }
                case '\u00c1': {
                    outChar = "&Aacute;";
                    break;
                }
                case '\u00c2': {
                    outChar = "&Acirc;";
                    break;
                }
                case '\u00c3': {
                    outChar = "&Atilde;";
                    break;
                }
                case '\u00c4': {
                    outChar = "&Auml;";
                    break;
                }
                case '\u00c5': {
                    outChar = "&Aring;";
                    break;
                }
                case '\u00c6': {
                    outChar = "&AElig;";
                    break;
                }
                case '\u00c7': {
                    outChar = "&Ccedil;";
                    break;
                }
                case '\u00c8': {
                    outChar = "&Egrave;";
                    break;
                }
                case '\u00c9': {
                    outChar = "&Eacute;";
                    break;
                }
                case '\u00ca': {
                    outChar = "&Ecirc;";
                    break;
                }
                case '\u00cb': {
                    outChar = "&Euml;";
                    break;
                }
                case '\u00cc': {
                    outChar = "&Igrave;";
                    break;
                }
                case '\u00cd': {
                    outChar = "&Iacute;";
                    break;
                }
                case '\u00ce': {
                    outChar = "&Icirc;";
                    break;
                }
                case '\u00cf': {
                    outChar = "&Iuml;";
                    break;
                }
                case '\u00d0': {
                    outChar = "&ETH;";
                    break;
                }
                case '\u00d1': {
                    outChar = "&Ntilde;";
                    break;
                }
                case '\u00d2': {
                    outChar = "&Ograve;";
                    break;
                }
                case '\u00d3': {
                    outChar = "&Oacute;";
                    break;
                }
                case '\u00d4': {
                    outChar = "&Ocirc;";
                    break;
                }
                case '\u00d5': {
                    outChar = "&Otilde;";
                    break;
                }
                case '\u00d6': {
                    outChar = "&Ouml;";
                    break;
                }
                case '\u00d7': {
                    outChar = "&times;";
                    break;
                }
                case '\u00d8': {
                    outChar = "&Oslash;";
                    break;
                }
                case '\u00d9': {
                    outChar = "&Ugrave;";
                    break;
                }
                case '\u00da': {
                    outChar = "&Uacute;";
                    break;
                }
                case '\u00db': {
                    outChar = "&Ucirc;";
                    break;
                }
                case '\u00dc': {
                    outChar = "&Uuml;";
                    break;
                }
                case '\u00dd': {
                    outChar = "&Yacute;";
                    break;
                }
                case '\u00de': {
                    outChar = "&THORN;";
                    break;
                }
                case '\u00df': {
                    outChar = "&szlig;";
                    break;
                }
                case '\u00e0': {
                    outChar = "&agrave;";
                    break;
                }
                case '\u00e1': {
                    outChar = "&aacute;";
                    break;
                }
                case '\u00e2': {
                    outChar = "&acirc;";
                    break;
                }
                case '\u00e3': {
                    outChar = "&atilde;";
                    break;
                }
                case '\u00e4': {
                    outChar = "&auml;";
                    break;
                }
                case '\u00e5': {
                    outChar = "&aring;";
                    break;
                }
                case '\u00e6': {
                    outChar = "&aelig;";
                    break;
                }
                case '\u00e7': {
                    outChar = "&ccedil;";
                    break;
                }
                case '\u00e8': {
                    outChar = "&egrave;";
                    break;
                }
                case '\u00e9': {
                    outChar = "&eacute;";
                    break;
                }
                case '\u00ea': {
                    outChar = "&ecirc;";
                    break;
                }
                case '\u00eb': {
                    outChar = "&euml;";
                    break;
                }
                case '\u00ec': {
                    outChar = "&igrave;";
                    break;
                }
                case '\u00ed': {
                    outChar = "&iacute;";
                    break;
                }
                case '\u00ee': {
                    outChar = "&icirc;";
                    break;
                }
                case '\u00ef': {
                    outChar = "&iuml;";
                    break;
                }
                case '\u00f0': {
                    outChar = "&eth;";
                    break;
                }
                case '\u00f1': {
                    outChar = "&ntilde;";
                    break;
                }
                case '\u00f2': {
                    outChar = "&ograve;";
                    break;
                }
                case '\u00f3': {
                    outChar = "&oacute;";
                    break;
                }
                case '\u00f4': {
                    outChar = "&ocirc;";
                    break;
                }
                case '\u00f5': {
                    outChar = "&otilde;";
                    break;
                }
                case '\u00f6': {
                    outChar = "&ouml;";
                    break;
                }
                case '\u00f7': {
                    outChar = "&divide;";
                    break;
                }
                case '\u00f8': {
                    outChar = "&oslash;";
                    break;
                }
                case '\u00f9': {
                    outChar = "&ugrave;";
                    break;
                }
                case '\u00fa': {
                    outChar = "&uacute;";
                    break;
                }
                case '\u00fb': {
                    outChar = "&ucirc;";
                    break;
                }
                case '\u00fc': {
                    outChar = "&uuml;";
                    break;
                }
                case '\u00fd': {
                    outChar = "&yacute;";
                    break;
                }
                case '\u00fe': {
                    outChar = "&thorn;";
                    break;
                }
                case '\u00ff': {
                    outChar = "&yuml;";
                    break;
                }
                default: {
                    outChar = String.valueOf(inChar[i]);
                }
            }
            stringBuffer.append(outChar);
        }
        return stringBuffer.toString();
    }

    public static boolean isValidPortNumber(String port) {
        boolean valid = true;
        if (port.indexOf(".") > -1) {
            valid = false;
        } else {
            try {
                int portNum;
                valid = !Integer.valueOf(port).toString().equals(port) ? false : (portNum = Integer.parseInt(port)) >= 0 && portNum <= 65535;
            }
            catch (Exception e) {
                valid = false;
            }
        }
        return valid;
    }

    public static String normalize(String s) {
        String lineSeparator = System.getProperty("line.separator");
        int strlen = s != null ? s.length() : 0;
        StringBuffer str = new StringBuffer(strlen + strlen / 10);
        block7: for (int i = 0; i < strlen; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    if (i > 0) {
                        char lastChar = str.charAt(str.length() - 1);
                        if (lastChar != '\r') {
                            str.append(lineSeparator);
                            continue block7;
                        }
                        str.append('\n');
                        continue block7;
                    }
                    str.append(lineSeparator);
                    continue block7;
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public static List calculateBundleNames(String baseName, Locale locale) {
        ArrayList<String> result = new ArrayList<String>(7);
        String language = null;
        String country = null;
        String variant = null;
        Locale defaultLocale = Locale.getDefault();
        if (!locale.equals(defaultLocale)) {
            language = locale.getLanguage();
            country = locale.getCountry();
            variant = locale.getVariant();
            if (language.length() > 0) {
                if (country.length() > 0) {
                    if (variant.length() > 0) {
                        result.add(baseName + "_" + language + "_" + country + "_" + variant);
                    }
                    result.add(baseName + "_" + language + "_" + country);
                }
                result.add(baseName + "_" + language);
            }
        }
        language = defaultLocale.getLanguage();
        country = defaultLocale.getCountry();
        variant = defaultLocale.getVariant();
        if (language.length() > 0) {
            if (country.length() > 0) {
                if (variant.length() > 0) {
                    result.add(baseName + "_" + language + "_" + country + "_" + variant);
                }
                result.add(baseName + "_" + language + "_" + country);
            }
            result.add(baseName + "_" + language);
        }
        result.add(baseName);
        return result;
    }

    public static boolean compareHosts(String host1, String host2) throws ContentMigrationException {
        InetAddress address2;
        InetAddress address1;
        try {
            address1 = InetAddress.getByName(host1);
        }
        catch (UnknownHostException ex) {
            throw new ContentMigrationException(Message.format((ResourceBundle)RB.getResources(), (String)"Framework.badmdhost.ex.fmt.txt", (Object)host1));
        }
        try {
            address2 = InetAddress.getByName(host2);
        }
        catch (UnknownHostException ex) {
            throw new ContentMigrationException(Message.format((ResourceBundle)RB.getResources(), (String)"Framework.badmdhost.ex.fmt.txt", (Object)host2));
        }
        return address1.equals(address2);
    }

    public static String getLocale() {
        return "" + Locale.getDefault();
    }

    public static String getEncoding() {
        return "" + System.getProperty("file.encoding");
    }

    public static String getArch() {
        return "" + System.getProperty("os.arch");
    }

    public static String getRepositoryName(String host, String port, String user, String password) {
        String reposName = null;
        try {
            MdFactoryImpl mdFactory = new MdFactoryImpl(false);
            if (mdFactory != null) {
                MdOMRConnection connection = mdFactory.getConnection();
                connection.makeOMRConnection(host, port, user, password);
                reposName = mdFactory.getOMIUtil().getFoundationRepository().getName();
                connection.closeOMRConnection();
                connection.dispose();
                mdFactory.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reposName;
    }
}

