/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.utils;

import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.utils.Lib;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class LogParser {
    public static final String PROC_MIGRATE_START = "Input Params to Proc Migrate";
    public static final String PROC_MIGRATE_END = "PROCEDURE MIGRATE used";
    public static final String LIB1 = "lib1 =";
    public static final String LIB2 = "lib2 =";
    public static final String ERROR = "ERROR:";
    public static final String WARNING = "WARNING:";
    public static final String NOTE = "NOTE:";
    public static final String MEM_TYPE = "memtype=";
    public static final String TO_LIB2 = "to LIB2";
    public static final String DOT = ".";
    public static final String REGEX_DOT = "\\.";
    public static final String PROC_CIMPORT_START = "Input Params to Proc CImport";
    public static final String PROC_CIMPORT_END = "PROCEDURE CIMPORT used";
    public static final String INFILE = "infile =";
    public static final String CIMPORT_BEGINS_TO = "PROC CIMPORT begins to";
    public static final String LIB1_DOT = "LIB1.";
    private Map<String, Lib> mapLib = new TreeMap<String, Lib>();

    public static void main(String[] args) {
        try {
            LogParser fp = new LogParser();
            fp.parseFile(new File("C:\\Users\\sinswp\\eclipseWS\\CMU\\src\\logs\\logCrossPlatformOutput.log"));
        }
        catch (Exception e) {
            AnalyzerHelper.log(e);
        }
    }

    public Map<String, Lib> parseFile(File inputFile) throws IOException {
        Lib lib = null;
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        String inputLine = null;
        while ((inputLine = br.readLine()) != null) {
            if (inputLine.startsWith(PROC_MIGRATE_START)) {
                lib = this.parseProcMigrateLib(br);
                this.mapLib.put(lib.getTarget(), lib);
                continue;
            }
            if (!inputLine.startsWith(PROC_CIMPORT_START)) continue;
            lib = this.parseCImportLib(br);
            this.mapLib.put(lib.getTarget(), lib);
        }
        return this.mapLib;
    }

    private Lib parseProcMigrateLib(BufferedReader br) throws IOException {
        Lib procMigrateLib = new Lib();
        String inputLine = "";
        String lastMigratedFileName = null;
        String errorFileName = null;
        String fileExtension = null;
        String noteType = null;
        String fileType = null;
        String fileName = null;
        Map<String, List<String>> mapNotMigratedFiles = null;
        Map<String, List<String>> mapMigratedFiles = null;
        Map<String, List<String>> mapNotes = null;
        List<String> listFiles = null;
        List<String> listNotes = null;
        while (inputLine.indexOf(PROC_MIGRATE_END) == -1) {
            inputLine = br.readLine().trim();
            if (inputLine.startsWith(LIB1)) {
                procMigrateLib.setSource(inputLine.split("=")[1].trim());
                continue;
            }
            if (inputLine.startsWith(LIB2)) {
                procMigrateLib.setTarget(inputLine.split("=")[1].trim());
                continue;
            }
            if (inputLine.endsWith(FileTypes.DATA.getFileType()) || inputLine.endsWith(FileTypes.VIEW.getFileType()) || inputLine.endsWith(FileTypes.MDDB.getFileType()) || inputLine.endsWith(FileTypes.ITEMSTOR.getFileType()) || inputLine.endsWith(FileTypes.CATALOG.getFileType()) || inputLine.endsWith(FileTypes.INDEX.getFileType())) {
                fileExtension = inputLine.split(REGEX_DOT)[1].trim();
                mapNotMigratedFiles = procMigrateLib.getMapNotMigratedFiles();
                listFiles = mapNotMigratedFiles.get(fileExtension);
                if (null == listFiles) {
                    listFiles = new ArrayList<String>();
                    mapNotMigratedFiles.put(fileExtension, listFiles);
                }
                listFiles.add(inputLine);
                continue;
            }
            if (inputLine.startsWith(ERROR) && !inputLine.contains("Library LIB1 does not exist")) {
                noteType = inputLine.split(":")[0].trim();
                mapNotes = procMigrateLib.getMapNotes();
                listNotes = mapNotes.get(noteType);
                if (null == listNotes) {
                    listNotes = new ArrayList<String>();
                    mapNotes.put(noteType, listNotes);
                }
                listNotes.add(inputLine);
                if (inputLine.split(LIB1_DOT).length <= 1 || (errorFileName = inputLine.split(LIB1_DOT)[1].split(REGEX_DOT)[0]) == null || lastMigratedFileName == null || !errorFileName.equalsIgnoreCase(lastMigratedFileName.split(REGEX_DOT)[0])) continue;
                fileExtension = lastMigratedFileName.split(REGEX_DOT)[1];
                mapNotMigratedFiles = procMigrateLib.getMapNotMigratedFiles();
                listFiles = mapNotMigratedFiles.get(fileExtension);
                if (null == listFiles) {
                    listFiles = new ArrayList<String>();
                    mapNotMigratedFiles.put(fileExtension, listFiles);
                }
                listFiles.add(lastMigratedFileName);
                mapMigratedFiles = procMigrateLib.getMapMigratedFiles();
                listFiles = mapMigratedFiles.get(fileExtension);
                listFiles.remove(lastMigratedFileName);
                continue;
            }
            if (inputLine.indexOf(MEM_TYPE) == -1) continue;
            int toLibIndex = inputLine.indexOf("to LIB2.");
            fileType = inputLine.split(MEM_TYPE)[1].split("\\)")[0].trim();
            fileExtension = FileTypes.valueOf(fileType).getFileType();
            if (toLibIndex == -1) continue;
            lastMigratedFileName = fileName = inputLine.split("to LIB2\\.")[1].split(".memtype=")[0].trim() + DOT + fileExtension;
            mapMigratedFiles = procMigrateLib.getMapMigratedFiles();
            listFiles = mapMigratedFiles.get(fileExtension);
            if (null == listFiles) {
                listFiles = new ArrayList<String>();
                mapMigratedFiles.put(fileExtension, listFiles);
            }
            listFiles.add(fileName);
        }
        return procMigrateLib;
    }

    private Lib parseCImportLib(BufferedReader br) throws IOException {
        Lib cImportLib = new Lib();
        String inputLine = "";
        String targetPath = "";
        String catalogName = "";
        String catalogExtension = FileTypes.CATALOG.getFileType();
        while (inputLine.indexOf(PROC_CIMPORT_END) == -1) {
            inputLine = br.readLine();
            if (inputLine.startsWith(INFILE)) {
                cImportLib.setSource(inputLine.split("=")[1].trim());
                continue;
            }
            if (inputLine.startsWith(LIB1)) {
                targetPath = inputLine.split("=")[1].trim();
                if (targetPath.endsWith(File.separator)) {
                    targetPath = targetPath.substring(0, targetPath.length() - 1);
                }
                if (null == this.mapLib.get(targetPath)) {
                    cImportLib.setTarget(targetPath);
                    continue;
                }
                cImportLib = this.mapLib.get(targetPath);
                continue;
            }
            if (inputLine.startsWith(ERROR)) {
                String noteType = inputLine.split(":")[0].trim();
                Map<String, List<String>> mapNotes = cImportLib.getMapNotes();
                List<String> listNotes = mapNotes.get(noteType);
                if (null == listNotes) {
                    listNotes = new ArrayList<String>();
                    mapNotes.put(noteType, listNotes);
                }
                listNotes.add(inputLine.trim());
                continue;
            }
            if (inputLine.indexOf(CIMPORT_BEGINS_TO) == -1) continue;
            while (inputLine.indexOf(LIB1_DOT) == -1) {
                inputLine = br.readLine();
            }
            catalogName = inputLine.split(LIB1_DOT)[1].trim() + DOT + catalogExtension;
            Map<String, List<String>> mapMigratedFiles = cImportLib.getMapMigratedFiles();
            List<String> listFiles = mapMigratedFiles.get(catalogExtension);
            if (null == listFiles) {
                listFiles = new ArrayList<String>();
                mapMigratedFiles.put(catalogExtension, listFiles);
            }
            listFiles.add(catalogName);
        }
        return cImportLib;
    }

    public static enum NoteTypes {
        ERROR,
        WARNING,
        NOTE;

    }

    public static enum FileTypes {
        DATA("sas7bdat"),
        VIEW("sas7bvew"),
        MDDB("sas7bmdb"),
        ITEMSTOR("sas7bitm"),
        CATALOG("sas7bcat"),
        INDEX("sas7bndx");

        private String fileType;

        private FileTypes(String fileType) {
            this.fileType = fileType;
        }

        public String getFileType() {
            return this.fileType;
        }
    }
}

