/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.invokers;

import com.sas.apps.content.migration.core.ContentMigrationAdapter;
import com.sas.apps.content.migration.core.ContentMigrationException;
import com.sas.apps.content.migration.core.ContentMigrationFramework;
import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.invokers.RB;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationBuilder;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class ContentMigrationTask
extends Task {
    File propertyFile;
    private final Properties properties = new Properties();
    private static boolean debug = false;
    ContentMigrationFramework framework = null;
    private int returnCode = 0;

    public File getPropertyFile() {
        return this.propertyFile;
    }

    public void setPropertyFile(File propertyFile) {
        this.propertyFile = propertyFile;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean debug) {
        ContentMigrationTask.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Logger logger = LogManager.getLogger((String)"");
        try {
            this.framework = new ContentMigrationFramework();
            this.initialize();
            this.doMigration();
        }
        catch (ContentMigrationException ex) {
            this.returnCode = 8;
            logger = LogManager.getLogger((String)"CMU");
            logger.error("The migration utility had an error:");
            logger.error(ex.getMessage());
            if (debug || ex.getMessage() == null || ex.getMessage().length() <= 0) {
                AnalyzerHelper.log(ex);
            }
            logger = LogManager.getLogger((String)"CMULOG");
            Throwable cause = ex;
            if (cause.getCause() != null && cause.getCause() != cause) {
                cause = cause.getCause();
            }
            logger.error("The migration utility exited with error:", cause);
            if (cause.getMessage().length() <= 0) {
                logger.error(cause.getStackTrace().toString());
            }
        }
        catch (Throwable t) {
            this.returnCode = 8;
            logger = LogManager.getLogger((String)"CMU");
            logger.error("The migration utility had an error:");
            logger.error(t.getMessage());
            if (debug || t.getMessage() == null || t.getMessage().length() <= 0) {
                AnalyzerHelper.log(t);
            }
            logger = LogManager.getLogger((String)"CMULOG");
            Throwable cause = t;
            if (cause.getCause() != null && cause.getCause() != cause) {
                cause = cause.getCause();
            }
            logger.error("The migration utility exited with error:", cause);
            if (cause.getMessage().length() <= 0) {
                logger.error(cause.getStackTrace().toString());
            }
        }
        finally {
            System.exit(this.returnCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        this.configureLog4j(null, null);
        Logger logger = LogManager.getLogger((String)"CMU");
        Project project = this.getProject();
        String propName = "cmu.properties";
        if (this.propertyFile == null) {
            this.propertyFile = new File(project.getBaseDir(), propName);
        } else {
            propName = this.propertyFile.getName();
        }
        if (this.propertyFile.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.propertyFile);
                this.properties.load(fis);
            }
            catch (IOException iOException) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            for (String string : this.properties.keySet()) {
                String value = this.properties.getProperty(string);
                if (value.equals(value.trim())) continue;
                this.properties.put(string, value.trim());
            }
        } else {
            AnalyzerHelper.log(Message.format((String)RB.getStringResource("Main.missingprop.ex.fmt.txt"), (Object)propName), 0);
            this.returnCode = 8;
        }
        File packageDir = null;
        String dirString = this.properties.getProperty("cmu.package.dir");
        if (dirString == null) {
            logger.error(RB.getStringResource("Main.outdirreq.ex.txt"));
            this.returnCode = 8;
        }
        if (!(packageDir = new File(dirString)).isAbsolute()) {
            logger.error(RB.getStringResource("Main.absoutput.ex.txt"));
            this.returnCode = 8;
        }
        if (!packageDir.exists() && !packageDir.mkdirs()) {
            logger.error(Message.format((String)RB.getStringResource("Framework.nooutputdir.ex.fmt.txt"), (Object)packageDir.getAbsolutePath()));
            this.returnCode = 8;
        }
        this.properties.setProperty("cmu.package.dir", packageDir.getAbsolutePath());
        String string = this.properties.getProperty("cmu.migration.mode");
        if (string == null) {
            logger.error(RB.getStringResource("Main.modereq.ex.txt"));
            this.returnCode = 8;
        }
        if (!string.equalsIgnoreCase("IMPORT") && !string.equalsIgnoreCase("EXPORT")) {
            logger.error(RB.getStringResource("Main.modereq.ex.txt"));
            this.returnCode = 8;
        } else if ("IMPORT".equalsIgnoreCase(string)) {
            File targetDir;
            String targetString = this.properties.getProperty("cmu.target.dir");
            if (targetString == null) {
                logger.error(RB.getStringResource("Main.targetdirreq.ex.txt"));
                this.returnCode = 8;
            }
            if (!(targetDir = new File(targetString)).isAbsolute()) {
                logger.error(RB.getStringResource("Main.abstarget.ex.txt"));
                this.returnCode = 8;
            }
            if (!targetDir.exists() && !targetDir.mkdirs()) {
                logger.error(Message.format((String)RB.getStringResource("Framework.nooutputdir.ex.fmt.txt"), (Object)targetDir.getAbsolutePath()));
                this.returnCode = 8;
            }
            this.framework.setOutputDirectory(targetDir);
        } else if ("EXPORT".equalsIgnoreCase(string)) {
            this.framework.setOutputDirectory(packageDir);
        }
        this.properties.setProperty("cmu.migration.mode", string);
    }

    private void doMigration() throws ContentMigrationException {
        Properties logProp = this.framework.makeLog4jProperties();
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        PropertiesConfiguration newConfiguration = new PropertiesConfigurationBuilder().setRootProperties(logProp).setLoggerContext(ctx).build();
        Configuration oldConfiguration = ctx.getConfiguration();
        ArrayList composites = new ArrayList((Configuration)newConfiguration, oldConfiguration){
            final /* synthetic */ Configuration val$newConfiguration;
            final /* synthetic */ Configuration val$oldConfiguration;
            {
                this.val$newConfiguration = configuration;
                this.val$oldConfiguration = configuration2;
                this.add(this.val$newConfiguration);
                this.add(this.val$oldConfiguration);
            }
        };
        CompositeConfiguration composite = new CompositeConfiguration((List)composites);
        composite.reconfigure();
        ctx.start((Configuration)composite);
        Logger logger = LogManager.getLogger((String)"CMU");
        logger.info("Content Migration Utility version 9.3-1.0");
        ContentMigrationAdapter adapter = new ContentMigrationAdapter();
        adapter.migrateContents(this.properties);
    }

    public void configureLog4j(String propPath, String outputPath) {
        Properties results = new Properties();
        Object migrateLog = null;
        if (propPath != null) {
            File propFile = new File(propPath);
            if (propFile.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(propFile);
                    results.load(fis);
                    fis.close();
                }
                catch (IOException fis) {}
            } else {
                AnalyzerHelper.log("The log4j properties file you specified does not exist.", 2);
                this.loadDefaultLog4JProperties(results);
            }
        } else {
            this.loadDefaultLog4JProperties(results);
        }
        if (migrateLog != null) {
            results.put("log4j.appender.logfile.File", (Object)migrateLog);
            results.put("log4j.logger.CMULOG", "debug, logfile");
        }
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        PropertiesConfiguration newConfiguration = new PropertiesConfigurationBuilder().setRootProperties(results).setLoggerContext(ctx).build();
        Configuration oldConfiguration = ctx.getConfiguration();
        ArrayList composites = new ArrayList((Configuration)newConfiguration, oldConfiguration){
            final /* synthetic */ Configuration val$newConfiguration;
            final /* synthetic */ Configuration val$oldConfiguration;
            {
                this.val$newConfiguration = configuration;
                this.val$oldConfiguration = configuration2;
                this.add(this.val$newConfiguration);
                this.add(this.val$oldConfiguration);
            }
        };
        CompositeConfiguration composite = new CompositeConfiguration((List)composites);
        composite.reconfigure();
        ctx.start((Configuration)composite);
        if (this.framework != null) {
            this.framework.setLogProperties(results);
        }
    }

    private void loadDefaultLog4JProperties(Properties prop) {
        prop.put("appender.SAS_CONSOLE.type", "Console");
        prop.put("appender.SAS_CONSOLE.name", "STDOUT");
        prop.put("appender.SAS_CONSOLE.layout.type", "PatternLayout");
        prop.put("appender.SAS_CONSOLE.layout.pattern", "%d{ABSOLUTE} [%-6.6p] %c  %m%n");
        prop.put("appender.SAS_FILE.type", "NullAppender");
        prop.put("appender.SAS_FILE.name", "File");
        prop.put("appender.SAS_FILE.append", "true");
        prop.put("appender.SAS_FILE.layout.type", "PatternLayout");
        prop.put("appender.SAS_FILE.layout.pattern", "%d{ISO8601} [%-6.6p] %m%n");
        prop.put("rootLogger.level", "ERROR");
        prop.put("rootLogger.appenderRefs", "SAS_CONSOLE");
        prop.put("rootLogger.appenderRef.console.ref", "STDOUT");
        prop.put("logger.CMU.name", "CMU");
        prop.put("logger.CMU.level", "DEBUG");
        prop.put("logger.CMU.appenderRefs", "SAS_CONSOLE");
        prop.put("logger.CMU.appenderRef.SAS_CONSOLE.ref", "STDOUT");
        prop.put("logger.comsasssn.name", "com.sas.ssn");
        prop.put("logger.comsasssn.level", "TRACE");
        prop.put("logger.comsasssn.appenderRefs", "SAS_CONSOLE");
        prop.put("logger.comsasssn.appenderRef.SAS_CONSOLE.ref", "STDOUT");
        prop.put("logger.CMULOG.name", "CMULOG");
        prop.put("logger.CMULOG.additivity", "false");
        prop.put("logger.CMULOG.level", "DEBUG");
        prop.put("logger.CMULOG.appenderRefs", "SAS_FILE");
        prop.put("logger.CMULOG.appenderRef.SAS_FILE.ref", "File");
    }
}

