/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.permissions;

import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.export.permissions.OSFilePermission;
import com.sas.apps.content.migration.export.permissions.OSFilePermissionExtractor;
import com.sas.apps.content.migration.export.permissions.OSPermissionCollection;
import com.sas.apps.content.migration.export.permissions.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

class WindowsFilePermission
implements OSFilePermissionExtractor {
    private String filePath = null;
    private static final String EXEC_ACTIONS_CMD = "cmd /c cacls ";
    private static final String DOMAIN_NOT_FOUND = "not found>";
    private static final String AT_THE_RATE = "@";
    private String actions = null;
    private String owner = null;
    private File file = null;
    private List includeFilterList = null;
    private List globalExcludeList = null;
    OSPermissionCollection collection;

    WindowsFilePermission(String filePath) {
        this.setPath(filePath);
    }

    private WindowsFilePermission(OSPermissionCollection collection) {
        this.collection = collection;
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public OSFilePermission getFilePermission() {
        OSFilePermission filePermission = new OSFilePermission(){

            @Override
            public String getActions() {
                return WindowsFilePermission.this.actions;
            }

            @Override
            public String getOwner() {
                return WindowsFilePermission.this.owner;
            }

            @Override
            public String getOwnerGroup() {
                return null;
            }

            @Override
            public String getPath() {
                return WindowsFilePermission.this.filePath;
            }
        };
        return filePermission;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public String getOwnerGroup() {
        return null;
    }

    @Override
    public String getPath() {
        return this.filePath;
    }

    private void performActions(String dirPath, OSPermissionCollection collection, boolean isSingle) {
        String command = "cmd /c cacls \"" + dirPath + (isSingle ? "" : "\\*\"");
        Process cacls = Tools.perform(command);
        if (cacls != null) {
            this.parseDirActions(cacls.getInputStream(), collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDirActions(InputStream result, OSPermissionCollection collection) {
        ArrayList<String> oneFileActions = new ArrayList<String>();
        String line = null;
        String fileName = null;
        String prevName = null;
        String actions = null;
        int index = 0;
        BufferedReader br = null;
        try {
            if (result != null) {
                br = new BufferedReader(new InputStreamReader(result));
                while ((line = br.readLine()) != null) {
                    fileName = this.getFileName(line);
                    if (index != 0 && fileName != null) {
                        actions = this.parseActionResult(oneFileActions, prevName);
                        if (actions != null) {
                            if (this.includeFilterList != null) {
                                if (this.includeFilterList.contains(prevName) && this.globalExcludeList != null && !this.globalExcludeList.contains(prevName)) {
                                    collection.add(prevName, actions);
                                }
                            } else {
                                collection.add(prevName, actions);
                            }
                        }
                        oneFileActions.clear();
                        prevName = fileName;
                        fileName = null;
                    } else if (index == 0) {
                        prevName = fileName;
                    }
                    ++index;
                    oneFileActions.add(line);
                }
                if (!Tools.isEmpty(oneFileActions) && (actions = this.parseActionResult(oneFileActions, prevName)) != null) {
                    if (this.includeFilterList != null) {
                        if (this.includeFilterList.contains(prevName) && this.globalExcludeList != null && !this.globalExcludeList.contains(prevName)) {
                            collection.add(prevName, actions);
                        }
                    } else {
                        collection.add(prevName, actions);
                    }
                }
            }
        }
        catch (IOException exception) {
            AnalyzerHelper.log(exception);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getFileName(String line) {
        String[] actionsSplit;
        String fileName = "";
        File file = null;
        boolean isFile = false;
        if (!Tools.isEmpty(line) && (actionsSplit = line.split("\\s+")) != null && actionsSplit.length > 1) {
            for (int index = 0; index < actionsSplit.length; ++index) {
                file = new File(fileName = fileName + (index != 0 ? " " : "") + actionsSplit[index]);
                if (!file.exists()) continue;
                isFile = true;
                break;
            }
        }
        return isFile ? fileName : null;
    }

    private String parseActionResult(List result, String fileName) {
        StringBuffer actions = null;
        boolean userDeleted = false;
        if (!Tools.isEmpty(result) && !Tools.isEmpty(fileName)) {
            String line0 = (String)result.get(0);
            int fileIndex = line0.toLowerCase().indexOf(fileName.toLowerCase());
            String line = fileIndex != -1 ? line0.substring(fileName.length()) : "";
            actions = new StringBuffer();
            if (!(userDeleted = this.userDeletedForACE(line, userDeleted))) {
                actions.append(line.trim());
            }
            for (int index = 1; index < result.size(); ++index) {
                line = (String)result.get(index);
                userDeleted = this.userDeletedForACE(line, userDeleted);
                if (userDeleted) continue;
                if (line.indexOf(":") != -1) {
                    actions.append(AT_THE_RATE);
                }
                actions.append(line.trim());
            }
        }
        return actions != null ? actions.toString() : null;
    }

    private boolean userDeletedForACE(String line, boolean deleted) {
        return Tools.isEmpty(line) || line.indexOf(DOMAIN_NOT_FOUND) != -1 || deleted && line.indexOf(":") == -1;
    }

    public static OSFilePermissionExtractor getInstance(OSPermissionCollection collection) {
        return new WindowsFilePermission(collection);
    }

    @Override
    public void extract() {
        String dirPath = this.file.isDirectory() ? this.file.getPath() : this.file.getParent();
        this.performActions(dirPath, this.collection, true);
        this.performActions(dirPath, this.collection, false);
    }

    @Override
    public OSPermissionCollection getPermissionsCollection() {
        return this.collection;
    }

    private void clear() {
        this.owner = "";
        this.actions = "";
    }

    @Override
    public void setPath(String path) {
        this.clear();
        this.filePath = path;
        this.file = new File(this.filePath);
    }

    @Override
    public void setIncludeList(List includeFiles) {
        this.includeFilterList = includeFiles;
    }

    @Override
    public void setGlobalExcludeList(List globalExcludeList) {
        this.globalExcludeList = globalExcludeList;
    }
}

