/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.permissions;

import com.sas.apps.content.migration.export.permissions.OSFilePermission;
import com.sas.apps.content.migration.export.permissions.OSFilePermissionExtractor;
import com.sas.apps.content.migration.export.permissions.OSPermissionCollection;
import com.sas.apps.content.migration.export.permissions.UNIXFilePermission;
import com.sas.apps.content.migration.export.permissions.WindowsFilePermission;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class OSPermissionFactory {
    private static String[] supportedOS = new String[]{"Windows", "Unix", "ZOS"};
    private static String osType;
    private OSFilePermissionExtractor filePermission;
    private static OSPermissionFactory factory;
    private static File permissionsDump;
    private static final String OS_TYPE_WIN = "Windows";
    private static final String OS_TYPE_UNIX = "Unix";

    private OSPermissionFactory(String osType) {
        OSPermissionCollection collection = new OSPermissionCollection(permissionsDump);
        this.filePermission = osType.equals(OS_TYPE_WIN) ? WindowsFilePermission.getInstance(collection) : UNIXFilePermission.getInstance(collection);
    }

    public static OSPermissionFactory getPermissionFactory(String os) {
        try {
            try {
                permissionsDump = File.createTempFile("permissions", "");
            }
            catch (Exception e) {
                File tempFolder = new File(".", "Temp" + File.separator + "CMUTemp");
                tempFolder.mkdirs();
                permissionsDump = File.createTempFile("permissions", "", tempFolder);
            }
            permissionsDump.deleteOnExit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        factory = new OSPermissionFactory(os);
        return factory;
    }

    public void extractFilePermissions(String subDirPath, List includedChildFiles, List globalExcludeList) {
        if (includedChildFiles != null) {
            this.filePermission.setIncludeList(includedChildFiles);
        }
        if (globalExcludeList != null) {
            this.filePermission.setGlobalExcludeList(globalExcludeList);
        }
        this.filePermission.setPath(subDirPath);
        this.filePermission.extract();
    }

    public OSPermissionCollection getPermissionsCollection() {
        return this.filePermission.getPermissionsCollection();
    }

    public OSFilePermission getFilePermission(String filePath) {
        this.filePermission.setPath(filePath);
        this.filePermission.extract();
        return this.filePermission.getFilePermission();
    }

    public static boolean isOSSupported(String osFamily) {
        return Arrays.asList(supportedOS).contains(osFamily);
    }
}

