/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.permissions;

import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.export.permissions.Tools;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class OSPermissionCollection {
    private static final int DEFAULT_CACHE_SIZE = 8192;
    private static int CACHE_SIZE = 8192;
    private Map permissions = new LinkedHashMap();
    private int capacity = 0;
    private File dumpFile;
    private boolean isInCache = false;

    public OSPermissionCollection(File dumpFile) {
        this.dumpFile = dumpFile;
    }

    public OSPermissionCollection(int inmemoryQuota) {
        CACHE_SIZE = inmemoryQuota;
    }

    public void add(String filePath, String permissionString) {
        if (this.cacheFull()) {
            this.dump(true);
        }
        this.permissions.put(filePath, permissionString);
    }

    public String getPermission(String filePath) {
        String permission = null;
        this.ensurePresence(filePath);
        if (this.permissions.containsKey(filePath)) {
            permission = filePath + (String)this.permissions.get(filePath);
        }
        return permission;
    }

    private void ensurePresence(String filePath) {
        if (!this.permissions.containsKey(filePath)) {
            this.pull(filePath);
        }
    }

    private boolean cacheFull() {
        return this.permissions.size() >= CACHE_SIZE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(boolean clear) {
        BufferedWriter writer = null;
        String fileName2 = null;
        String value = null;
        String dumpString = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.dumpFile, true));
            if (!Tools.isEmpty(this.permissions)) {
                this.capacity += this.permissions.size();
                for (String fileName2 : this.permissions.keySet()) {
                    value = (String)this.permissions.get(fileName2);
                    dumpString = fileName2 + "|" + value;
                    writer.write(dumpString);
                    writer.newLine();
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            if (clear) {
                this.permissions.clear();
            }
        }
    }

    public static String getPermissionsString(String permissions) {
        int fileNameIndex;
        String perms = null;
        if (!Tools.isEmpty(permissions) && (fileNameIndex = permissions.indexOf("|")) != -1 && permissions.length() > fileNameIndex) {
            perms = permissions.substring(fileNameIndex + 1);
        }
        return perms;
    }

    public static String getFileName(String permissions) {
        int fileNameIndex;
        String fileName = null;
        if (!Tools.isEmpty(permissions) && (fileNameIndex = permissions.indexOf("|")) != -1) {
            fileName = permissions.substring(0, fileNameIndex);
        }
        return fileName;
    }

    public boolean contains(String filePath) {
        boolean contains = true;
        if (!this.permissions.containsKey(filePath)) {
            contains = this.checkDump(filePath);
        }
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDump(String filePath) {
        BufferedReader reader = null;
        String line = null;
        boolean extract = false;
        try {
            reader = new BufferedReader(new FileReader(this.dumpFile));
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(filePath) == -1) continue;
                extract = true;
                break;
            }
        }
        catch (IOException exception) {
            AnalyzerHelper.log(exception);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return extract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pull(String filePath) {
        BufferedReader reader = null;
        String line = null;
        boolean extract = false;
        int extracatedCount = 0;
        try {
            reader = new BufferedReader(new FileReader(this.dumpFile));
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(filePath) != -1) {
                    this.permissions.put(filePath, OSPermissionCollection.getPermissionsString(line));
                    extract = true;
                    continue;
                }
                if (!extract) continue;
                if (extracatedCount < CACHE_SIZE) {
                    this.permissions.put(OSPermissionCollection.getFileName(line), OSPermissionCollection.getPermissionsString(line));
                    continue;
                }
                break;
            }
        }
        catch (IOException exception) {
            AnalyzerHelper.log(exception);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.isInCache = extract;
        return extract;
    }

    public Iterator iterator() {
        if (!this.isInCache) {
            this.dump(false);
        }
        return new Iterator(){
            private BufferedReader streamReader;
            private String nextLine = null;
            {
                try {
                    this.streamReader = new BufferedReader(new FileReader(OSPermissionCollection.this.dumpFile));
                    this.nextLine = this.streamReader.readLine();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public boolean hasNext() {
                return this.nextLine != null;
            }

            public Object next() {
                String nextObject = this.nextLine;
                try {
                    this.nextLine = this.streamReader.readLine();
                    if (this.nextLine == null) {
                        this.closeStream();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return nextObject;
            }

            @Override
            public void remove() {
            }

            private void closeStream() {
                if (this.streamReader != null) {
                    try {
                        this.streamReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
    }
}

