/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.common;

import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.export.common.MetadataServerUtil;
import com.sas.metadata.Machine;
import com.sas.metadata.MdException;
import com.sas.metadata.ServerComponent;
import com.sas.metadata.Tree;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MetadataServerUtil92
extends MetadataServerUtil {
    @Override
    public boolean isOnSpecifiedHost(ServerComponent server, String hostName, boolean isMdTier) {
        boolean isLocalMachine;
        block1: {
            isLocalMachine = false;
            Set machines = this.getAssociatedMachines(server);
            if (AnalyzerHelper.isEmpty(machines)) break block1;
            Iterator macIt = machines.iterator();
            Machine machine = null;
            while (macIt.hasNext() && !(isLocalMachine = this.isLocalMachine(machine = (Machine)macIt.next(), hostName, isMdTier))) {
            }
        }
        return isLocalMachine;
    }

    protected Set getAssociatedMachines(ServerComponent server) {
        HashSet<Machine> machineList = null;
        if (!AnalyzerHelper.isEmpty(server)) {
            try {
                List machines;
                machineList = new HashSet<Machine>();
                Machine machine = server.getAssociatedMachine();
                if (!AnalyzerHelper.isEmpty(machine)) {
                    machineList.add(machine);
                }
                if (!AnalyzerHelper.isEmpty(machines = this.getMachines((List)server.getSoftwareTrees()))) {
                    machineList.addAll(machines);
                }
            }
            catch (MdException mdException) {
                // empty catch block
            }
        }
        return machineList;
    }

    private List getMachines(List softwareTrees) throws MdException {
        if (!AnalyzerHelper.isEmpty(softwareTrees)) {
            for (int index = 0; index < softwareTrees.size(); ++index) {
                Tree tree = (Tree)softwareTrees.get(index);
                if (!tree.getTreeType().equals("MachineGroup")) continue;
                return tree.getAssociatedObjects("Members");
            }
        }
        return null;
    }

    @Override
    public Machine getServerClusterMachine(ServerComponent server, String hostName, boolean isMdTier) {
        List machines = null;
        boolean isClusterMachine = false;
        try {
            machines = this.getMachines((List)server.getSoftwareTrees());
            if (machines != null) {
                Machine machine = null;
                for (int index = 0; index < machines.size(); ++index) {
                    machine = (Machine)machines.get(index);
                    isClusterMachine = this.isLocalMachine(machine, hostName, isMdTier);
                    if (!isClusterMachine) continue;
                    return machine;
                }
            }
        }
        catch (MdException mdException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public List getServerClusterGroup(ServerComponent server) {
        List machines = null;
        try {
            machines = this.getMachines((List)server.getSoftwareTrees());
        }
        catch (MdException mdException) {
            // empty catch block
        }
        return !AnalyzerHelper.isEmpty(machines) ? machines : null;
    }

    static {
        templates.put("ServerContext", "<Templates><ServerContext Id=\"\" Name=\"\" ><UsingComponents/></ServerContext><LogicalServer><UsingComponents/></LogicalServer><ServerComponent><AssociatedMachine/><SoftwareTrees/></ServerComponent><Tree><Members/></Tree><Tree Name=\"\" Id=\"\"/><Machine Name=\"\" Id=\"\"/><ServerComponent Name=\"\" Id=\"\"/></Templates>");
        templates.put("ServerComponent", "<Templates><ServerComponent Id=\"\" Name=\"\" MetadataUpdated=\"\" MetadataCreated=\"\" ProductName=\"\" ClassIdentifier=\"\" SoftwareVersion=\"\"><AssociatedMachine></AssociatedMachine><Tree Name=\"\"></Tree><Properties PropertyName=\"\" ></Properties><SourceConnections></SourceConnections><UsedByComponents></UsedByComponents></ServerComponent><Property Id=\"\" Name=\"\" DefaultValue=\"\" PropertyName=\"\"></Property><TCPIPConnection Id=\"\" ApplicationProtocol=\"\" Port=\"\" HostName=\"\" Name=\"\"><Domain></Domain></TCPIPConnection><AuthenticationDomain Id=\"\" Name=\"\"></AuthenticationDomain><SASClientConnection Id=\"\" ApplicationProtocol=\"\" Port=\"\" RemoteAddress=\"\" Name=\"\"><Domain></Domain></SASClientConnection><LogicalServer Id=\"\" Name=\"\"><ServerContext></ServerContext></LogicalServer><Transformation Name=\"\"><TransformationSources></TransformationSources></Transformation><Login Id=\"\" Name=\"\" UserID=\"\"><AssociatedIdentity></AssociatedIdentity></Login><Person Name=\"\"></Person><IdentityGroup Name=\"\"></IdentityGroup></Templates>");
    }
}

