/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.common;

import com.sas.apps.content.migration.core.ContentExporter;
import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.export.common.ConfigItemFilterData;
import com.sas.apps.content.migration.export.common.ConfigItems;
import com.sas.apps.content.migration.export.common.DataFilterProperties;
import com.sas.apps.content.migration.export.common.DataMigrator;
import com.sas.apps.content.migration.export.common.Directory;
import com.sas.apps.content.migration.export.common.FileCollection;
import com.sas.apps.content.migration.export.common.MetadataAccess;
import com.sas.apps.content.migration.export.common.ReadableSelector;
import com.sas.apps.content.migration.export.common.SASRunner;
import com.sas.apps.content.migration.export.permissions.OSPermissionCollection;
import com.sas.apps.content.migration.export.permissions.PermissionMigrator;
import com.sas.apps.content.migration.utils.Utils;
import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.FileSelector;

public class DataMigratorHelper {
    private static final String DATA_FOLDER_NAME = "Data";
    private static final String SASENV_FOLDER_NAME = "SASEnvironment";
    private static final String PATTERN_DOTSAS_FILES = ".*\\.sas$";
    private static final String PATTERN_NON_DOTSAS_FILES = "[^\\.]*\\.(?!sas$)";
    private static final String PATTERN_CATALOG_FILES = ".*\\.sas7bcat$";
    private static final String PATTERN_CUBE_FILES = "*\\.spds9$";
    private static final String PATTERN_ITEMSTORE_FILES = ".*\\.sas7bitm$";
    private String PATTERN_USEREXCLUDE_FILES = null;
    private String PATTERN_USERINCLUDE_FILES = null;
    private static boolean MIGRATION_PERMISSION;
    private static boolean MIGRATE_CATALOG;
    private static boolean RUN_CPOREPORT;
    private static final String FILTER_PROCESS_CUBES = "Cubes";
    private static final String FILTER_PROCESS_SASFILES = "SASFiles";
    private static final String FILTER_PROCESS_CATALOGS = "Catalogs";
    private static DataMigratorHelper dataMigratorHelper;
    private ConfigItems configs = null;
    private long zipThreshold;
    private boolean itemStorePresent = false;
    private Map excludeItems = new HashMap();
    private Map coprtLogs = new HashMap();
    private List migrationResultData;
    private long totalMigratedData = 0L;
    private MetadataAccess metaAccess = null;
    private DirectoryScanner directoryScanner;
    private String configDir = null;
    private static int OUTSIDE_CONFIG_DIR;
    private static int INSIDE_CONFIG_DIR;
    private static int INSIDE_CONTEXT_DIR;
    private static int ALREADY_MIGRATED;

    private DataMigratorHelper(long zipThreshold) {
        this.zipThreshold = zipThreshold;
    }

    public void setConfigDirectory(String configDir) {
        this.configDir = configDir;
    }

    public void setSASRoot(String sasRoot) {
    }

    public void setMetadataAccess(MetadataAccess metaAccess) {
        this.metaAccess = metaAccess;
    }

    public void setConfigItems(ConfigItems configItems) {
        this.configs = configItems;
    }

    private ConfigItemFilterData createFilterData(String processName, int processType, boolean realExclude, String description) {
        ConfigItemFilterData filterData = new ConfigItemFilterData();
        filterData.setDescription(description);
        filterData.setExluded(realExclude);
        filterData.setProcessName(processName);
        filterData.setFilterType(processType);
        return filterData;
    }

    private List<ConfigItemFilterData> createGlobalFilterData(String contextDir) {
        ArrayList<ConfigItemFilterData> filters = new ArrayList<ConfigItemFilterData>();
        ConfigItemFilterData cubeFilter = this.createFilterData(FILTER_PROCESS_CUBES, "");
        filters.add(cubeFilter);
        ConfigItemFilterData _12ByteExclude = this.createFilterData("Custom12Byte", "");
        filters.add(_12ByteExclude);
        cubeFilter.setPattern(contextDir);
        return filters;
    }

    public Map getExcludedLogEntries() {
        return this.excludeItems;
    }

    private ConfigItemFilterData createFilterData(String processName, String description) {
        return this.createFilterData(processName, 0, true, description);
    }

    private ConfigItemFilterData createFilterData(String processName, boolean realExclude, String description) {
        return this.createFilterData(processName, 0, realExclude, description);
    }

    public static DataMigratorHelper getInstance(long zipThreshold) {
        dataMigratorHelper = new DataMigratorHelper(zipThreshold);
        return dataMigratorHelper;
    }

    private List getFilterDataList(String contextName) {
        ArrayList<ConfigItemFilterData> filterData = new ArrayList<ConfigItemFilterData>();
        filterData.addAll(this.createGlobalFilterData(contextName));
        if (RUN_CPOREPORT) {
            ConfigItemFilterData catalogFilter = this.createFilterData(FILTER_PROCESS_CATALOGS, false, null);
            catalogFilter.setPattern(PATTERN_CATALOG_FILES);
            filterData.add(catalogFilter);
        }
        ConfigItemFilterData itemStore = this.createFilterData(FILTER_PROCESS_SASFILES, 2, false, "");
        itemStore.setPattern(PATTERN_ITEMSTORE_FILES);
        filterData.add(itemStore);
        ConfigItemFilterData userExclude = this.createFilterData("UserExcludeFiles", 3, true, "");
        userExclude.setPattern(this.PATTERN_USEREXCLUDE_FILES);
        filterData.add(userExclude);
        if (this.PATTERN_USERINCLUDE_FILES != null && !this.PATTERN_USERINCLUDE_FILES.equals("")) {
            ConfigItemFilterData userInclude = this.createFilterData("UserIncludeFiles", 1, false, "");
            userInclude.setPattern(this.PATTERN_USERINCLUDE_FILES);
            filterData.add(userInclude);
        }
        return filterData;
    }

    public void migrateDataFolder(String configItem, String configItemName, String contextName) {
        Directory dataDir = null;
        ArrayList<ConfigItemFilterData> cubeFilter = new ArrayList<ConfigItemFilterData>();
        cubeFilter.addAll(this.createGlobalFilterData(contextName));
        if (this.PATTERN_USERINCLUDE_FILES != null && !this.PATTERN_USERINCLUDE_FILES.equals("") || this.PATTERN_USEREXCLUDE_FILES != null && !this.PATTERN_USEREXCLUDE_FILES.equals("")) {
            File dir = new File(configItem);
            this.directoryScanner = this.getDirectoryScanner(dir, this.PATTERN_USERINCLUDE_FILES, this.PATTERN_USEREXCLUDE_FILES);
            Set<File> includeFileList = this.processUserInclude(dir);
            if (includeFileList != null && includeFileList.size() >= 1) {
                dataDir = Directory.getDirectoryFilterInstance(configItem, includeFileList);
            }
        } else {
            File dir = new File(configItem);
            this.directoryScanner = this.getDirectoryScanner(dir, null, null);
            dataDir = Directory.getDirectoryInstance(configItem);
        }
        if (dataDir != null) {
            this.migrateDataFolder(dataDir, configItemName, contextName, this.getFilterDataList(contextName), cubeFilter, true);
        } else {
            AnalyzerHelper.log("Not able to package :" + configItem, 0);
        }
    }

    private Set<File> processUserInclude(File directory) {
        String[] files = null;
        String[] dirs = null;
        HashSet<File> userIncludeFiles = new HashSet<File>();
        if (this.directoryScanner != null) {
            String includeFile;
            dirs = this.directoryScanner.getIncludedDirectories();
            files = this.directoryScanner.getIncludedFiles();
            if (dirs != null && dirs.length >= 1) {
                for (int index = 0; index < dirs.length; ++index) {
                    includeFile = dirs[index];
                    if (includeFile.equals("")) continue;
                    includeFile = directory.getAbsolutePath() + File.separator + includeFile;
                    File parentDir = new File(includeFile);
                    userIncludeFiles.add(parentDir);
                }
            }
            if (files != null && files.length >= 1) {
                for (int j = 0; j < files.length; ++j) {
                    includeFile = files[j];
                    if (includeFile.equals("")) continue;
                    File file = new File(includeFile);
                    String dirName = file.getParent();
                    if (dirName != null && !dirName.equals("")) {
                        String dirPath = directory.getAbsolutePath() + File.separator + dirName;
                        File parentDir = new File(dirPath);
                        userIncludeFiles.add(parentDir);
                        continue;
                    }
                    String filePath = directory.getAbsolutePath() + File.separator + includeFile;
                    File file1 = new File(filePath);
                    userIncludeFiles.add(file1);
                }
            }
        }
        return userIncludeFiles;
    }

    private void migrateDataFolder(Directory configItem, String configItemName, String contextName, List filterdataList, List permissionsFilter, boolean emptyZip) {
        DataMigrator.DataResult dataResult = null;
        DataMigrator.DataResult catalogResult = null;
        Directory dir = configItem;
        dataResult = this.migrateData(dir, configItemName, filterdataList, emptyZip);
        this.reportDataMigrationResult(dataResult);
        File prFile = this.createDataLibRef(dataResult.getMigratedSubDirs());
        String prFilePath = null;
        if (prFile != null) {
            prFilePath = DataMigratorHelper.getMostAccurateFilePath(prFile);
            if (configItemName != null) {
                this.configs.addConfigItem(configItemName, prFilePath);
            } else {
                this.configs.addConfigItem(prFilePath);
            }
        }
        this.configs.addRelativeDestination(configItemName, prFilePath, dir.getName());
        File xmlFile = this.writePackagedFileList(dir, dataResult);
        AnalyzerHelper.log("Writing packaged files details in " + xmlFile.getPath(), 4);
        if (RUN_CPOREPORT) {
            if (MIGRATE_CATALOG) {
                catalogResult = this.migrateCatalogs(dir, configItemName);
            } else {
                AnalyzerHelper.log("Catalogs not migrated by user", 2);
            }
        }
        if (dataResult != null && dataResult.dataFound()) {
            if (RUN_CPOREPORT) {
                if (MIGRATE_CATALOG) {
                    ConfigItemFilterData filter = this.createFilterData(FILTER_PROCESS_CATALOGS, 1, false, null);
                    filter.setPattern(PATTERN_CATALOG_FILES);
                    permissionsFilter.add(filter);
                } else {
                    ConfigItemFilterData catalogFilter = this.createFilterData(FILTER_PROCESS_CATALOGS, false, null);
                    catalogFilter.setPattern(PATTERN_CATALOG_FILES);
                    permissionsFilter.add(catalogFilter);
                }
            }
            if (this.PATTERN_USERINCLUDE_FILES != null && !this.PATTERN_USERINCLUDE_FILES.equals("")) {
                ConfigItemFilterData userInclude = this.createFilterData("UserIncludeFiles", 1, false, "");
                userInclude.setPattern(this.PATTERN_USERINCLUDE_FILES);
                permissionsFilter.add(userInclude);
            }
            if (MIGRATION_PERMISSION) {
                Directory permDir = Directory.getDirectoryInstance(dir.getFileInstance().getAbsolutePath());
                this.migratePermissions(permDir, permissionsFilter, configItemName);
            } else {
                AnalyzerHelper.log("File permission not migrated by user.", 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writePackagedFileList(Directory dir, DataMigrator.DataResult result) {
        FileCollection packagedFiles = result.getPackagedFiles();
        Properties props = ContentExporter.getProperties();
        File outDir = new File(props.getProperty("cmu.package.dir"));
        File packagedDetailsFileLoc = new File(outDir, "packagedFiles");
        boolean fileCreated = false;
        if (!packagedDetailsFileLoc.exists() && !packagedDetailsFileLoc.isDirectory()) {
            fileCreated = packagedDetailsFileLoc.mkdirs();
        }
        File xmlFile = null;
        Iterator itr = packagedFiles.iterator();
        XMLStreamWriter xsw = null;
        OutputStream outputStream = null;
        try {
            xmlFile = File.createTempFile("PackagedFiles", ".xml", packagedDetailsFileLoc);
            if (!xmlFile.exists()) {
                xmlFile.createNewFile();
            }
            outputStream = new FileOutputStream(xmlFile);
            xsw = new IndentingXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(new OutputStreamWriter(outputStream, "utf-8")));
            xsw.writeStartDocument();
            xsw.writeStartElement("Directory");
            xsw.writeAttribute("Path", dir.getFileInstance().getAbsolutePath());
            xsw.writeAttribute("Size", Long.valueOf(result.getMigratedDataSize()).toString());
            while (itr.hasNext()) {
                String line = (String)itr.next();
                String subdirName = FileCollection.getDirectoryPath(line);
                List<String> files = FileCollection.getFileList(line);
                AnalyzerHelper.log("Migrated files in Dir: " + subdirName, 4);
                xsw.writeStartElement("SubDirectory");
                xsw.writeAttribute("RelativePath", subdirName);
                xsw.writeStartElement("PackagedFiles");
                StringBuffer list = new StringBuffer();
                for (String file : files) {
                    if (AnalyzerHelper.isEmpty(file)) continue;
                    if (list.length() != 0) {
                        list.append(", ");
                    }
                    String fileName = new File(file).getName();
                    list.append(fileName);
                }
                xsw.writeAttribute("List", list.toString());
                xsw.writeEndElement();
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.writeEndDocument();
        }
        catch (XMLStreamException e) {
            AnalyzerHelper.log(e);
        }
        catch (FactoryConfigurationError e) {
            AnalyzerHelper.log(e);
        }
        catch (UnsupportedEncodingException e) {
            AnalyzerHelper.log(e);
        }
        catch (FileNotFoundException e) {
            AnalyzerHelper.log(e);
        }
        catch (IOException e) {
            AnalyzerHelper.log(e);
        }
        finally {
            try {
                if (xsw != null) {
                    xsw.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (XMLStreamException e) {
                AnalyzerHelper.log("Error while trying to close xml stream", 1);
            }
            catch (IOException e) {
                AnalyzerHelper.log("Error while trying to close IO stram", 1);
            }
        }
        return xmlFile;
    }

    public static void generateXML(OutputStream stream) throws Exception {
        XMLEventFactory xmlEventFactory = XMLEventFactory.newInstance();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLEventWriter writer = outputFactory.createXMLEventWriter(stream);
        StartDocument startDocument = xmlEventFactory.createStartDocument("UTF-8", "1.0");
        writer.add(startDocument);
        StartElement startElement = xmlEventFactory.createStartElement("", "", "University");
        writer.add(startElement);
        Attribute name = xmlEventFactory.createAttribute("Name", "Computer Science");
        Attribute campus = xmlEventFactory.createAttribute("Campus", "North Campus");
        List<Attribute> attributeList = Arrays.asList(name, campus);
        List<Object> nsList = Arrays.asList(new Object[0]);
        StartElement departStartElement = xmlEventFactory.createStartElement("", "", "Department", attributeList.iterator(), nsList.iterator());
        writer.add(departStartElement);
        StartElement studentStarElement = xmlEventFactory.createStartElement("", "", "Student");
        writer.add(studentStarElement);
        StartElement studentNameStartElement = xmlEventFactory.createStartElement("", "", "Name");
        writer.add(studentNameStartElement);
        Characters studentNameChars = xmlEventFactory.createCharacters("John Doe");
        writer.add(studentNameChars);
        EndElement studentNameEndElement = xmlEventFactory.createEndElement("", "", "Name");
        writer.add(studentNameEndElement);
        StartElement rollStartElement = xmlEventFactory.createStartElement("", "", "Roll");
        writer.add(rollStartElement);
        Characters rollChars = xmlEventFactory.createCharacters("2134");
        writer.add(rollChars);
        EndElement rollEndElement = xmlEventFactory.createEndElement("", "", "Roll");
        writer.add(rollEndElement);
        EndElement studentEndElement = xmlEventFactory.createEndElement("", "", "Student");
        writer.add(studentEndElement);
        EndDocument endDocument = xmlEventFactory.createEndDocument();
        writer.add(endDocument);
        writer.flush();
        writer.close();
        stream.close();
    }

    private File createDataLibRef(List migratedsubDirs) {
        File prFile = null;
        if (!AnalyzerHelper.isEmpty(migratedsubDirs)) {
            Properties pr = new Properties();
            pr.setProperty("migrated.data.libref.list", AnalyzerHelper.listAsString(migratedsubDirs, "|"));
            prFile = AnalyzerHelper.dumpProperties(pr);
        }
        return prFile;
    }

    public void migrateSASEnvironment(String sasEnvpath, String configItemName, String contextName) {
        DataMigrator.DataResult dataResult = null;
        DataMigrator.DataResult catalogResult = null;
        Directory dir = Directory.getDirectoryInstance(sasEnvpath);
        dataResult = this.migrateData(dir, configItemName, this.getFilterDataList(contextName), true);
        this.reportDataMigrationResult(dataResult);
        File prFile = this.createDataLibRef(dataResult.getMigratedSubDirs());
        String prFilePath = null;
        if (prFile != null) {
            prFilePath = DataMigratorHelper.getMostAccurateFilePath(prFile);
            if (configItemName != null) {
                this.configs.addConfigItem(configItemName, prFilePath);
            } else {
                this.configs.addConfigItem(prFilePath);
            }
            this.configs.addRelativeDestination(configItemName, prFilePath, dir.getName());
        }
        catalogResult = this.migrateCatalogs(dir, configItemName);
        this.reportDataMigrationResult(catalogResult);
        if (dataResult.dataFound() || catalogResult.dataFound()) {
            ArrayList<ConfigItemFilterData> cubeFilter = new ArrayList<ConfigItemFilterData>();
            cubeFilter.addAll(this.createGlobalFilterData(contextName));
            this.migratePermissions(dir, cubeFilter, configItemName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataMigrator.DataResult migrateCatalogs(Directory dir, String configItemName) {
        Set<File> includeFileList;
        ArrayList<ConfigItemFilterData> filterData = new ArrayList<ConfigItemFilterData>();
        DataMigrator.DataResult result = null;
        boolean catalogWitoutPattern = true;
        if (this.PATTERN_USERINCLUDE_FILES != null && !this.PATTERN_USERINCLUDE_FILES.equals("") && (includeFileList = this.processCatalogUserInclude(this.PATTERN_USERINCLUDE_FILES, dir.getFileInstance())).size() >= 1) {
            try {
                Directory dataDir = Directory.getDirectoryFilterInstance(dir.getFileInstance().getAbsolutePath(), includeFileList);
                ConfigItemFilterData filter = this.createFilterData("UserCatalogs", 1, false, null);
                String pattern_usercatalog_files = ".*\\.sas7bcat$," + this.PATTERN_USERINCLUDE_FILES;
                filter.setPattern(pattern_usercatalog_files);
                filterData.add(filter);
                filterData.addAll(this.createGlobalFilterData(configItemName));
                result = this.migrateData(dataDir, configItemName, filterData, FILTER_PROCESS_CATALOGS, false);
                if (result != null) {
                    catalogWitoutPattern = false;
                }
            }
            catch (Exception e) {
                AnalyzerHelper.log(e);
            }
        }
        if (catalogWitoutPattern) {
            Directory dataDir = Directory.getDirectoryInstance(dir.getFileInstance().getAbsolutePath());
            ConfigItemFilterData filter = this.createFilterData(FILTER_PROCESS_CATALOGS, 1, false, null);
            filter.setPattern(PATTERN_CATALOG_FILES);
            filterData.add(filter);
            filterData.addAll(this.createGlobalFilterData(configItemName));
            result = this.migrateData(dir, configItemName, filterData, FILTER_PROCESS_CATALOGS, false);
        }
        Properties catalogLibrefs = this.processCatalogs(result.getZippedItems(), dir);
        FileOutputStream outPut = null;
        if (!AnalyzerHelper.isEmpty(catalogLibrefs)) {
            try {
                File catalogMetadata = null;
                try {
                    catalogMetadata = File.createTempFile("catlog_librefs", ".properties");
                }
                catch (Exception e) {
                    File tempFolder = new File(".", "Temp" + File.separator + "CMUTemp");
                    tempFolder.mkdirs();
                    catalogMetadata = File.createTempFile("catlog_librefs", ".properties", tempFolder);
                }
                catalogMetadata.deleteOnExit();
                outPut = new FileOutputStream(catalogMetadata);
                catalogLibrefs.store(outPut, "");
                String filePath = DataMigratorHelper.getMostAccurateFilePath(catalogMetadata);
                if (configItemName != null) {
                    this.configs.addConfigItem(configItemName, filePath);
                } else {
                    this.configs.addConfigItem(filePath);
                }
                this.configs.addRelativeDestination(configItemName, filePath, dir.getName() + "/Catalogs");
                String tmpDirectory = System.getProperty("java.io.tmpdir");
                if (catalogLibrefs != null) {
                    Iterator<Object> trnFiles = catalogLibrefs.keySet().iterator();
                    File trnFile = null;
                    while (trnFiles.hasNext()) {
                        trnFile = new File(tmpDirectory, (String)trnFiles.next());
                        if (!trnFile.exists()) continue;
                        if (configItemName != null) {
                            this.configs.addConfigItem(configItemName, trnFile.getPath());
                        } else {
                            this.configs.addConfigItem(trnFile.getPath());
                        }
                        this.configs.addRelativeDestination(configItemName, trnFile.getPath(), dir.getName() + "/Catalogs");
                    }
                }
            }
            catch (IOException exception) {
                AnalyzerHelper.log(exception);
            }
            finally {
                if (outPut != null) {
                    try {
                        outPut.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }

    private Set<File> processCatalogUserInclude(String pattern, File directory) {
        String[] files = null;
        HashSet<File> userIncludeFiles = new HashSet<File>();
        boolean dirLevelFilter = false;
        if (pattern != null) {
            String[] userIncludes = pattern.split(",");
            for (int i = 0; i < userIncludes.length; ++i) {
                String includeFile;
                String userDirPath = userIncludes[i];
                if (this.directoryScanner != null) {
                    files = this.directoryScanner.getIncludedFiles();
                }
                if (files == null || files.length < 1) continue;
                for (int j = 0; j < files.length; ++j) {
                    includeFile = files[j];
                    if (!includeFile.endsWith(".sas7bcat")) continue;
                    dirLevelFilter = true;
                    break;
                }
                if (!dirLevelFilter) continue;
                for (int index = 0; index < files.length; ++index) {
                    includeFile = files[index];
                    File file = new File(includeFile);
                    String dirName = file.getParent();
                    includeFile = directory.getAbsolutePath() + File.separator + dirName;
                    File parentDir = new File(includeFile);
                    userIncludeFiles.add(parentDir);
                }
            }
        }
        return userIncludeFiles;
    }

    private String[] find(File file, String pattern) {
        String[] all = null;
        try {
            ReadableSelector readableSelector = new ReadableSelector();
            pattern = pattern.replaceAll(" ", "?");
            FileSet fileSet = new FileSet();
            Project antProject = new Project();
            fileSet.setProject(antProject);
            fileSet.setDir(file);
            fileSet.setIncludes(pattern);
            fileSet.add((FileSelector)readableSelector);
            all = fileSet.getDirectoryScanner(antProject).getIncludedFiles();
        }
        catch (BuildException exception) {
            AnalyzerHelper.log("Error while creating DirectoryScanner :" + exception.getMessage(), 0);
        }
        catch (Exception exception) {
            AnalyzerHelper.log("Error while creating DirectoryScanner :" + exception.getMessage(), 0);
        }
        return all;
    }

    private Properties processCatalogs(List migrationItems, Directory dir) {
        Set catlogLibs = this.getCatalogLibRefs(migrationItems, dir);
        Properties catLibrefs = new Properties();
        this.runCPORT(catlogLibs, catLibrefs, dir);
        return catLibrefs;
    }

    private Set getCatalogLibRefs(List migrationItems, Directory baseDir) {
        HashSet<String> catalogLibs = new HashSet<String>();
        if (!AnalyzerHelper.isEmpty(migrationItems)) {
            DataMigrator.MigrationItem migrationItem = null;
            List includedItems = null;
            File catalogFile = null;
            File catalogLib = null;
            for (int index = 0; index < migrationItems.size(); ++index) {
                migrationItem = (DataMigrator.MigrationItem)migrationItems.get(index);
                includedItems = migrationItem.getIncludedItems();
                if (AnalyzerHelper.isEmpty(includedItems)) continue;
                for (int includeIndex = 0; includeIndex < includedItems.size(); ++includeIndex) {
                    String inputFile = (String)includedItems.get(includeIndex);
                    if (!inputFile.endsWith(".sas7bcat") || !(catalogFile = new File(migrationItem.getMigrationItem(), inputFile)).isFile() || this.isParentExcluded(catalogFile)) continue;
                    catalogLib = catalogFile.getParentFile();
                    catalogLibs.add(catalogLib.getPath());
                }
            }
        }
        return catalogLibs.size() > 0 ? catalogLibs : null;
    }

    private boolean isParentExcluded(File catalogFile) {
        DataFilterProperties dataProps = DataFilterProperties.getInstance();
        boolean isExcluded = false;
        for (File parent = catalogFile; parent != null; parent = parent.getParentFile()) {
            if (!dataProps.isExcluded(parent.getAbsolutePath())) continue;
            isExcluded = true;
            break;
        }
        return isExcluded;
    }

    private boolean runCPORT(Set catalogLibs, Properties catLibRefs, Directory dir) {
        boolean ranSuccessfully;
        block5: {
            File cportScrpit = this.createCPORTScript(catalogLibs, catLibRefs, dir);
            SASRunner sasRunner = ContentExporter.cSasRunner;
            ranSuccessfully = false;
            try {
                if (cportScrpit == null) break block5;
                File cportLogFile = null;
                try {
                    cportLogFile = File.createTempFile(cportScrpit.getName() + "log", ".log");
                }
                catch (Exception e) {
                    File tempFolder = new File(".", "Temp" + File.separator + "CMUTemp");
                    tempFolder.mkdirs();
                    cportLogFile = File.createTempFile(cportScrpit.getName() + "log", ".log", tempFolder);
                }
                cportLogFile.deleteOnExit();
                if (cportScrpit != null && sasRunner != null && !(ranSuccessfully = sasRunner.run(cportScrpit, null, cportLogFile))) {
                    this.coprtLogs.put(dir.getFileInstance().getPath(), DataMigratorHelper.getMostAccurateFilePath(cportLogFile));
                }
            }
            catch (IOException exception) {
                AnalyzerHelper.log("Unable to create the CPORT script file, Catalogs may not be migrated correctly if machine architecture is changed ", 0);
            }
        }
        return ranSuccessfully;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createCPORTScript(Set catalogLibs, Properties catalogLibrefs, Directory dir) {
        File scriptFile = null;
        File transportFile = null;
        BufferedWriter scriptWriter = null;
        String relativePath = null;
        if (!AnalyzerHelper.isEmpty(catalogLibs)) {
            Iterator libRefs = catalogLibs.iterator();
            String libRef = null;
            try {
                File tempFolder;
                try {
                    scriptFile = File.createTempFile("catalogCPORT", ".sas");
                }
                catch (Exception e) {
                    tempFolder = new File(".", "Temp" + File.separator + "CMUTemp");
                    tempFolder.mkdirs();
                    scriptFile = File.createTempFile("catalogCPORT", ".sas", tempFolder);
                }
                scriptFile.deleteOnExit();
                scriptWriter = new BufferedWriter(new FileWriter(scriptFile));
                while (libRefs.hasNext()) {
                    libRef = (String)libRefs.next();
                    relativePath = dir.getRelativePath(libRef);
                    relativePath = relativePath == null ? "" : relativePath;
                    try {
                        transportFile = File.createTempFile(String.valueOf(Math.abs(libRef.hashCode())), ".trn");
                    }
                    catch (Exception e) {
                        tempFolder = new File(".", "CMUTemp");
                        tempFolder.mkdirs();
                        transportFile = File.createTempFile(String.valueOf(Math.abs(libRef.hashCode())), ".trn", tempFolder);
                    }
                    transportFile.deleteOnExit();
                    catalogLibrefs.setProperty(transportFile.getName(), dir.getName() + File.separator + relativePath);
                    scriptWriter.write("libname source \"" + libRef + "\";");
                    scriptWriter.newLine();
                    scriptWriter.write("filename trf '" + transportFile.getPath() + "';");
                    scriptWriter.newLine();
                    scriptWriter.write("proc cport library=source file=trf memtype=catalog;");
                    scriptWriter.newLine();
                    scriptWriter.write("run;");
                    scriptWriter.newLine();
                }
            }
            catch (IOException exception) {
                AnalyzerHelper.log("Error createing the CPORT Script file : " + exception.getMessage(), 0);
            }
            finally {
                if (scriptWriter != null) {
                    try {
                        scriptWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return scriptFile;
    }

    public void migrateDataPackages(Map dataPackages, List serverContexts) {
        if (!AnalyzerHelper.isEmpty(dataPackages)) {
            Iterator dirIds = dataPackages.keySet().iterator();
            HashSet<String> migratedDtPkgs = new HashSet<String>();
            String dirId = null;
            String dirPath = null;
            int locateResult = -1;
            File dir = null;
            List filterDataList = null;
            ArrayList<ConfigItemFilterData> permFilterList = new ArrayList<ConfigItemFilterData>();
            while (dirIds.hasNext()) {
                dirId = (String)dirIds.next();
                dirPath = (String)dataPackages.get(dirId);
                if (dirPath.indexOf("@SAS_CONFIG_DIR@") != -1) {
                    dirPath = this.configDir + dirPath.substring("@SAS_CONFIG_DIR@".length());
                }
                dir = new File(dirPath);
                DataFilterProperties filterProps = DataFilterProperties.getInstance();
                if (!this.isParentExcluded(dir)) {
                    if (Directory.isAccessible(dir)) {
                        locateResult = this.locateDirectory(dirPath, serverContexts, migratedDtPkgs);
                        if (locateResult != ALREADY_MIGRATED) {
                            if (locateResult == OUTSIDE_CONFIG_DIR) {
                                filterDataList = this.getFilterDataList(null);
                                ConfigItemFilterData filterData = this.createFilterData(FILTER_PROCESS_SASFILES, 1, false, null);
                                filterData.setPattern(PATTERN_DOTSAS_FILES);
                                filterDataList.add(filterData);
                                ConfigItemFilterData sasFiles = this.createFilterData(FILTER_PROCESS_SASFILES, "");
                                sasFiles.setPattern(PATTERN_NON_DOTSAS_FILES);
                                permFilterList.add(sasFiles);
                            } else if (locateResult == INSIDE_CONFIG_DIR) {
                                String contextDir = AnalyzerHelper.insideDirectory(serverContexts, dirPath);
                                filterDataList = this.getFilterDataList(contextDir);
                                ConfigItemFilterData filesOnly = this.createFilterData("FilesOnly", 1, false, "");
                                filterDataList.add(filesOnly);
                                permFilterList.add(this.createFilterData("DirectoryOnly", ""));
                            }
                            Directory dataPackage = Directory.getRootDiretctoryInstance(dirPath);
                            this.migrateDataFolder(dataPackage, dirId, null, filterDataList, permFilterList, true);
                            migratedDtPkgs.add(dirPath);
                            continue;
                        }
                        AnalyzerHelper.log("Data Package is already migrated : " + dirPath, 2);
                        continue;
                    }
                    AnalyzerHelper.log("Data Package NOT Accessible : " + dirPath, 2);
                    continue;
                }
                AnalyzerHelper.log("Data Package excluded : " + dirPath, 2);
            }
        } else {
            AnalyzerHelper.log("No Data Package found to Migrate", 2);
        }
    }

    public void migrateUserDirectories(List dirList, String configItemName, String configDir, String userExcludePattern, String userIncludePattern) {
        if (dirList != null) {
            String value;
            String key;
            String userDirPath;
            int i;
            AnalyzerHelper.log("Found : " + dirList.size() + " user directories to migrate", 2);
            String dir = null;
            HashMap<String, String> excludefilterData = new HashMap<String, String>();
            HashMap<String, String> includefilterData = new HashMap<String, String>();
            if (userExcludePattern != null && !userExcludePattern.equals("")) {
                String[] userExcludes = userExcludePattern.split(",");
                for (i = 0; i < userExcludes.length; ++i) {
                    userDirPath = userExcludes[i];
                    if (!userDirPath.contains("|")) continue;
                    key = userDirPath.substring(0, userDirPath.indexOf("|"));
                    value = userDirPath.substring(userDirPath.indexOf("|") + 1, userDirPath.length());
                    value = value.replaceAll(":", ",");
                    excludefilterData.put(key, value);
                }
            }
            if (userIncludePattern != null && !userIncludePattern.equals("")) {
                String[] userIncludes = userIncludePattern.split(",");
                for (i = 0; i < userIncludes.length; ++i) {
                    userDirPath = userIncludes[i];
                    if (!userDirPath.contains("|")) continue;
                    key = userDirPath.substring(0, userDirPath.indexOf("|"));
                    value = userDirPath.substring(userDirPath.indexOf("|") + 1, userDirPath.length());
                    value = value.replaceAll(":", ",");
                    includefilterData.put(key, value);
                }
            }
            for (int index = 0; index < dirList.size(); ++index) {
                this.PATTERN_USERINCLUDE_FILES = null;
                this.PATTERN_USEREXCLUDE_FILES = null;
                dir = (String)dirList.get(index);
                String userExclPattern = (String)excludefilterData.get(dir);
                if (userExclPattern != null && !userExclPattern.equals("")) {
                    this.setUserExcludePattern(userExclPattern);
                } else if (userExcludePattern != null && !userExcludePattern.contains("|")) {
                    this.setUserExcludePattern(userExcludePattern);
                }
                String userInclPattern = (String)includefilterData.get(dir);
                if (userInclPattern != null && !userInclPattern.equals("")) {
                    this.setUserIncludePattern(userInclPattern);
                } else if (userIncludePattern != null && !userIncludePattern.contains("|")) {
                    this.setUserIncludePattern(userIncludePattern);
                }
                this.migrateDataFolder(dir, configItemName + (index + 1), configDir);
            }
        }
    }

    private int locateDirectory(String dirPath, List serverContexts, Set alreadyMigrated) {
        int locateResult = OUTSIDE_CONFIG_DIR;
        if (!AnalyzerHelper.isEmpty(serverContexts)) {
            File contextDir = null;
            File configDir = null;
            String levDataPath = null;
            String actualFileName = null;
            String dataPath = null;
            String sasEnvPath = null;
            for (int index = 0; index < serverContexts.size(); ++index) {
                contextDir = (File)serverContexts.get(index);
                actualFileName = AnalyzerHelper.getConfigItemAsFileName(contextDir.getPath(), DATA_FOLDER_NAME);
                dataPath = contextDir.getPath() + File.separator + actualFileName;
                actualFileName = AnalyzerHelper.getConfigItemAsFileName(contextDir.getPath(), SASENV_FOLDER_NAME);
                sasEnvPath = contextDir.getPath() + File.separator + actualFileName;
                if (configDir == null) {
                    configDir = contextDir.getParentFile();
                }
                if (!Directory.dirEquals(dataPath, dirPath) && !Directory.isChild(dataPath, dirPath) && !Directory.isChild(sasEnvPath, dirPath) && !Directory.dirEquals(sasEnvPath, dirPath)) continue;
                return ALREADY_MIGRATED;
            }
            actualFileName = AnalyzerHelper.getConfigItemAsFileName(configDir.getPath(), DATA_FOLDER_NAME);
            levDataPath = configDir.getPath() + File.separator + actualFileName;
            if (Directory.isChild(levDataPath, dirPath) || Directory.dirEquals(levDataPath, dirPath)) {
                return ALREADY_MIGRATED;
            }
            if (alreadyMigrated.contains(dirPath)) {
                return ALREADY_MIGRATED;
            }
            if (Directory.isChild(configDir.getPath(), dirPath)) {
                return INSIDE_CONFIG_DIR;
            }
        }
        return locateResult;
    }

    private DataMigrator.DataResult migrateData(Directory configItemValue, String configItemName, List excludeFilters, boolean emptyZip) {
        return this.migrateData(configItemValue, configItemName, excludeFilters, null, emptyZip);
    }

    private DataMigrator.DataResult migrateData(Directory configItemValue, String configItemName, List excludeFilters, String outDestination, boolean emptyZip) {
        long threshold = this.zipThreshold;
        AnalyzerHelper.log("Scanning directory " + configItemValue.getFileInstance().getPath(), 2);
        DataMigrator dataMigrator = null;
        dataMigrator = threshold > 0L ? new DataMigrator(configItemValue, threshold, this.metaAccess) : new DataMigrator(configItemValue, this.metaAccess);
        dataMigrator.setCreateEmptyZip(emptyZip);
        if (outDestination != null) {
            dataMigrator.setRelativeDestination(outDestination);
        }
        AnalyzerHelper.log("Directory Scanning completed ", 2);
        dataMigrator.migrateData(this.configs, configItemName, excludeFilters);
        return dataMigrator.getDataMigrationResult();
    }

    private void reportDataMigrationResult(DataMigrator.DataResult result) {
        if (result.excludeItemPresent()) {
            List excludeItemTypes = result.getExcludeTypes();
            this.itemStorePresent = this.itemStorePresent || result.itemStorePresent();
            List items = null;
            HashSet exculedFiles = null;
            String excludeType = null;
            Object message = null;
            for (int index = 0; index < excludeItemTypes.size(); ++index) {
                excludeType = (String)excludeItemTypes.get(index);
                items = result.getExcludeItem(excludeType);
                if (items == null) continue;
                exculedFiles = new HashSet(items);
                if (this.excludeItems.containsKey(excludeType)) {
                    Set excludeList = (Set)this.excludeItems.get(excludeType);
                    excludeList.addAll(items);
                    continue;
                }
                this.excludeItems.put(excludeType, exculedFiles);
            }
        }
        this.totalMigratedData += result.getMigratedDataSize();
    }

    public long getMigratedDataSize() {
        return this.totalMigratedData;
    }

    private DirectoryScanner getDirectoryScanner(File dir, String includePattern, String excludePattern) {
        DirectoryScanner directoryScanner = null;
        try {
            ReadableSelector readableSelector = new ReadableSelector();
            Project antProject = new Project();
            FileSet fileSet = new FileSet();
            fileSet.setProject(antProject);
            fileSet.setDir(dir);
            if (includePattern != null) {
                includePattern = includePattern.replaceAll(" ", "?");
                fileSet.setIncludes(includePattern);
            }
            if (excludePattern != null) {
                excludePattern = excludePattern.replaceAll(" ", "?");
                fileSet.setExcludes(excludePattern);
            }
            fileSet.add((FileSelector)readableSelector);
            directoryScanner = fileSet.getDirectoryScanner(antProject);
        }
        catch (BuildException readableSelector) {
        }
        catch (Exception exception) {
            AnalyzerHelper.log("Error while creating DirectoryScanner :" + exception.getMessage(), 0);
        }
        return directoryScanner;
    }

    private void migratePermissions(Directory dir, List filterData, String configItemName) {
        DataMigrator dataMigrator = new DataMigrator(dir, this.metaAccess);
        String osFamily = Utils.getOS_Family();
        File permissionsFile = null;
        PermissionMigrator permMigrator = null;
        if (this.directoryScanner != null) {
            try {
                permMigrator = dataMigrator.getPermissionMigrator(osFamily, filterData, this.directoryScanner);
            }
            catch (IllegalArgumentException exception) {
                AnalyzerHelper.log(osFamily + " Not yet supported for file system permissions migration", 1);
            }
        } else {
            AnalyzerHelper.log(osFamily + " Not able to create directory scanner for :" + dir.getName(), 1);
        }
        try {
            OSPermissionCollection permCollection = permMigrator.reterivePermission();
            permissionsFile = permMigrator.storePermissions(permCollection);
        }
        catch (Exception exception) {
            AnalyzerHelper.log("unable to retrive file permissions : " + exception.getMessage(), 1);
        }
        if (permissionsFile != null) {
            if (configItemName != null) {
                this.configs.addConfigItem(configItemName, DataMigratorHelper.getMostAccurateFilePath(permissionsFile));
            } else {
                this.configs.addConfigItem(DataMigratorHelper.getMostAccurateFilePath(permissionsFile));
            }
        } else {
            AnalyzerHelper.log("Unable to retrive permissions for (Directory) : " + dir.getName(), 1);
        }
    }

    public CPORTExecutionResult getCOPRTExecutionResult() {
        return new CPORTExecutionResult();
    }

    public boolean itemStorePresent() {
        return this.itemStorePresent;
    }

    public void setUserExcludePattern(String filterData) {
        this.PATTERN_USEREXCLUDE_FILES = filterData;
    }

    public void setUserIncludePattern(String userIncludePattern) {
        this.PATTERN_USERINCLUDE_FILES = userIncludePattern;
    }

    public void setMigrationPermission(boolean migrationPermission) {
        MIGRATION_PERMISSION = migrationPermission;
    }

    public void setMigrationCatalog(boolean migrateCatalog) {
        MIGRATE_CATALOG = migrateCatalog;
    }

    public void setRunCPORepot(boolean runCPOR) {
        RUN_CPOREPORT = runCPOR;
    }

    public static String getMostAccurateFilePath(File file) {
        String filePath = null;
        try {
            if (file != null) {
                filePath = file.getCanonicalPath();
            }
        }
        catch (Exception e) {
            filePath = file.getAbsolutePath();
        }
        return filePath;
    }

    static {
        OUTSIDE_CONFIG_DIR = 0;
        INSIDE_CONFIG_DIR = 1;
        INSIDE_CONTEXT_DIR = 3;
        ALREADY_MIGRATED = 2;
    }

    public class CPORTExecutionResult {
        public boolean errorsOccured() {
            return !AnalyzerHelper.isEmpty(DataMigratorHelper.this.coprtLogs);
        }

        public List getErrorDirectories() {
            return !AnalyzerHelper.isEmpty(DataMigratorHelper.this.coprtLogs) ? new ArrayList(DataMigratorHelper.this.coprtLogs.keySet()) : null;
        }

        public String getLogFileName(String directory) {
            String path = (String)DataMigratorHelper.this.coprtLogs.get(directory);
            String fileName = null;
            if (path != null) {
                File nFile = new File(path);
                fileName = nFile.getName();
            }
            return fileName;
        }

        public String getLogFilePath(String directory) {
            return (String)DataMigratorHelper.this.coprtLogs.get(directory);
        }
    }
}

