/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.common;

import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.export.common.ConfigItemFilter;
import com.sas.apps.content.migration.export.common.ConfigItemFilterData;
import com.sas.apps.content.migration.export.common.ConfigItems;
import com.sas.apps.content.migration.export.common.Directory;
import com.sas.apps.content.migration.export.common.FileCollection;
import com.sas.apps.content.migration.export.common.MetadataAccess;
import com.sas.apps.content.migration.export.permissions.PermissionMigrator;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;

public class DataMigrator {
    private String configItemRoot;
    private String relOutDestination;
    private Directory configDirectory;
    private boolean compress;
    private List globalExcludeList;
    private List<String> golbalUserExcludeList;
    private List globalPackageExcludes;
    private List globalPackageUserExcludes;
    private List globalIncludeList;
    private List zippedItems;
    private List bigFiles;
    private List globalLogList;
    private ConfigItemFilterData filterData = null;
    private boolean includeProcess;
    private long dataMigratedSize = 0L;
    private static long ZIP_THRESHOLD = 0x140000000L;
    private long zipThreshold = 0L;
    private static final String EXCLUDE_TYPE_TEMP = "tempfolder";
    private static final String EXCLUDE_TYPE_SOFTLINK = "softlink";
    private static final String EXCLUDE_TYPE_UNACCESSIBLE = "unaccessible";
    private static final String EXCLUDE_TYPE_ITEMSTORE = "itemstore";
    private static final String EXCLUDE_TYPE_USEREXCLUDE = "userexclude";
    private List configFilterData;
    private boolean createEmptyZip = false;
    private MetadataAccess metaAccess;

    public DataMigrator(Directory configDirectory, MetadataAccess metaAccess) {
        this.configDirectory = configDirectory;
        this.configItemRoot = configDirectory.getFileInstance().getPath();
        this.zippedItems = new ArrayList();
        this.globalExcludeList = new ArrayList();
        this.golbalUserExcludeList = new ArrayList<String>();
        this.globalIncludeList = new ArrayList();
        this.globalPackageExcludes = new ArrayList();
        this.globalPackageUserExcludes = new ArrayList();
        this.bigFiles = new ArrayList();
        this.zipThreshold = ZIP_THRESHOLD;
        this.configFilterData = new ArrayList();
        this.includeProcess = false;
        this.globalLogList = new ArrayList();
        this.metaAccess = metaAccess;
    }

    public void addConfigFilterData(ConfigItemFilterData filterData) {
        this.configFilterData.add(filterData);
    }

    public DataMigrator(Directory dataFolderRoot, long zipThreshold, MetadataAccess metaAccess) {
        this(dataFolderRoot, metaAccess);
        this.zipThreshold = zipThreshold;
    }

    public void setCreateEmptyZip(boolean emptyZip) {
        this.createEmptyZip = emptyZip;
    }

    public void setRelativeDestination(String relDest) {
        this.relOutDestination = relDest;
    }

    public boolean migrateData(ConfigItems configItems, String componentName, List excludeProcesses) {
        boolean dataFound = true;
        if (configItems != null) {
            if (this.shouldCompress()) {
                this.compress = true;
            }
            this.processGlobalFilterList(excludeProcesses);
            this.createSplittedZip(this.configDirectory.getFileInstance());
            String relativeDestination = null;
            dataFound = !AnalyzerHelper.isEmpty(this.zippedItems) || !AnalyzerHelper.isEmpty(this.bigFiles);
            for (int index = 0; index < this.zippedItems.size(); ++index) {
                MigrationItem item = (MigrationItem)this.zippedItems.get(index);
                relativeDestination = this.relOutDestination != null ? this.relOutDestination : (!Directory.dirEquals(item.getMigrationItem(), this.configDirectory.getFileInstance().getAbsolutePath()) ? this.configDirectory.getName() : null);
                configItems.addZippedConfigItem(componentName, item.getMigrationItem(), item.getPrefix(), item.getIncludedItems(), item.getExcludedItems(), relativeDestination);
            }
            String relDirectory = null;
            for (int index = 0; index < this.bigFiles.size(); ++index) {
                MigrationItem item = (MigrationItem)this.bigFiles.get(index);
                String migrationItem = item.getMigrationItem();
                if (componentName != null) {
                    configItems.addConfigItem(componentName, migrationItem);
                } else {
                    configItems.addConfigItem(migrationItem);
                }
                String relativePath = this.getPrefix(migrationItem);
                if (relativePath != null) {
                    File bigFile = new File(relativePath);
                    relDirectory = bigFile.getParent();
                }
                configItems.addRelativeDestination(componentName, migrationItem, relDirectory);
            }
        }
        return dataFound;
    }

    private void processGlobalFilterList(List excludeProcesses) {
        if (!AnalyzerHelper.isEmpty(excludeProcesses)) {
            List filterList = null;
            File configItemFile = this.configDirectory.getFileInstance();
            ConfigItemFilterData filterData = null;
            ConfigItemFilter filter = ConfigItemFilter.getConfigItemsFilter(this.configDirectory);
            filter.setMetaAccess(this.metaAccess);
            for (int index = 0; index < excludeProcesses.size(); ++index) {
                filterData = (ConfigItemFilterData)excludeProcesses.get(index);
                if (filterData.getFilterType() == 1) {
                    this.includeProcess = true;
                }
                if (AnalyzerHelper.isEmpty(filterList = filter.doFilter(filterData))) continue;
                if (filterData.getFilterType() == 0) {
                    this.globalExcludeList.addAll(filterList);
                    if (!filterData.isExluded()) continue;
                    this.globalPackageExcludes.addAll(filterList);
                    continue;
                }
                if (filterData.getFilterType() == 3) {
                    this.golbalUserExcludeList.addAll(filterList);
                    if (!filterData.isExluded()) continue;
                    this.globalPackageUserExcludes.addAll(filterList);
                    continue;
                }
                if (filterData.getFilterType() == 1) {
                    this.globalIncludeList.addAll(filterList);
                    continue;
                }
                if (filterData.getFilterType() != 2) continue;
                this.globalLogList.addAll(filterList);
            }
        }
    }

    public void migrateData(ConfigItems configItems, String componentName) {
        this.migrateData(configItems, componentName, null);
    }

    private void createSplittedZip(File root) {
        List children = this.configDirectory.listFiles(root.getPath());
        File child = null;
        String childPath = null;
        String childRelPath = null;
        List globalExcludes = this.getGlobalExcludeList(root.getPath());
        ArrayList<String> excludeItems = new ArrayList<String>();
        ArrayList<String> includeItems = new ArrayList<String>();
        ArrayList<String> allFiles = new ArrayList<String>();
        long size = 0L;
        long totalSize = 0L;
        boolean copyAdded = false;
        if (children != null) {
            if (globalExcludes != null) {
                excludeItems.addAll(globalExcludes);
            }
            for (int index = 0; index < children.size(); ++index) {
                child = (File)children.get(index);
                childPath = child.getPath();
                copyAdded = false;
                childRelPath = Directory.getRelativePath(root, child);
                if (!this.shouldProcess(childPath)) continue;
                size = this.configDirectory.size(child.getPath());
                if (this.shouldExcludeContains(child, size)) {
                    excludeItems.add(childRelPath);
                    if (this.thresholdReached(size) && child.isDirectory()) {
                        this.createSplittedZip(child);
                        copyAdded = true;
                    } else if (child.isFile() && child.length() > this.zipThreshold) {
                        copyAdded = true;
                        this.addCopyEntry(root, child.getName());
                    }
                }
                if (copyAdded) continue;
                if (this.thresholdReached(totalSize + size)) {
                    if (this.includeProcess && (!this.includeProcess || AnalyzerHelper.isEmpty(includeItems))) continue;
                    this.processGlobalIncludeList(childPath, child.isDirectory(), root, includeItems);
                    this.addZipEntry(root, includeItems, excludeItems);
                    allFiles.addAll(includeItems);
                    includeItems.clear();
                    totalSize = 0L;
                    continue;
                }
                if (!this.shouldInclude(child.getPath())) continue;
                if (this.includeProcess) {
                    size = this.processGlobalIncludeList(childPath, child.isDirectory(), root, includeItems);
                    totalSize += size;
                    this.dataMigratedSize += size;
                    continue;
                }
                totalSize += size;
                this.dataMigratedSize += size;
                includeItems.add(childRelPath);
            }
            if (!this.includeProcess) {
                ArrayList remainingList = new ArrayList();
                boolean isExcludeList = this.getRemainingList(allFiles, excludeItems, root, remainingList);
                if (isExcludeList) {
                    this.addZipEntry(root, null, remainingList);
                } else {
                    this.addZipEntry(root, remainingList, excludeItems);
                }
            } else if (!AnalyzerHelper.isEmpty(includeItems)) {
                this.addZipEntry(root, includeItems, excludeItems);
            }
        }
    }

    private boolean shouldProcess(String childPath) {
        File childpathFile;
        boolean shouldProces;
        boolean bl = shouldProces = !this.includeProcess;
        if (this.includeProcess && !(shouldProces = this.globalIncludeList.contains(childPath)) && (childpathFile = new File(childPath)).isDirectory()) {
            shouldProces = this.contains(childPath, this.globalIncludeList);
        }
        return shouldProces;
    }

    private boolean contains(String parentPath, List includeList) {
        if (!AnalyzerHelper.isEmpty(includeList)) {
            String relativePath = null;
            for (int index = 0; index < includeList.size(); ++index) {
                relativePath = Directory.getRelativePath(parentPath, (String)includeList.get(index));
                if (relativePath == null) continue;
                return true;
            }
        }
        return false;
    }

    private long processGlobalIncludeList(String rootPath, boolean isDir, File root, List includeList) {
        long size = 0L;
        if (isDir) {
            if (this.globalIncludeList.contains(rootPath)) {
                includeList.add(Directory.getRelativePath(root.getPath(), rootPath));
                File included = new File(rootPath);
                size = included.length();
            } else {
                Directory dir = Directory.getDirectoryInstance(rootPath);
                File included = null;
                for (int index = 0; index < this.globalIncludeList.size(); ++index) {
                    included = new File((String)this.globalIncludeList.get(index));
                    if (!dir.isChild(included.getPath())) continue;
                    includeList.add(Directory.getRelativePath(root.getPath(), included.getPath()));
                    size += included.length();
                }
            }
        } else if (this.globalIncludeList.contains(rootPath)) {
            includeList.add(Directory.getRelativePath(root.getPath(), rootPath));
            File included = new File(rootPath);
            size = included.length();
        }
        return size;
    }

    private boolean getRemainingList(List allIncludes, List excludes, File baseDir, List remainingList) {
        ArrayList allExcludes = new ArrayList(allIncludes);
        allExcludes.addAll(excludes);
        File[] dirFiles = baseDir.listFiles();
        ArrayList allFiles = !AnalyzerHelper.isEmpty(dirFiles) ? Arrays.asList(dirFiles) : new ArrayList();
        int allFilesSize = allFiles.size();
        int allExcludeFilesSize = allExcludes.size();
        String relativePath = null;
        boolean isExclude = true;
        File child = null;
        if (allExcludeFilesSize > allFilesSize - allExcludeFilesSize) {
            isExclude = false;
            for (int index = 0; index < allFiles.size(); ++index) {
                child = (File)allFiles.get(index);
                relativePath = Directory.getRelativePath(baseDir, child);
                if (allExcludes.contains(relativePath)) continue;
                remainingList.add(relativePath);
            }
        } else {
            remainingList.clear();
            remainingList.addAll(allExcludes);
        }
        return isExclude;
    }

    private void addZipEntry(File root, List includeItems, List excludeItems) {
        MigrationItem item = new MigrationItem();
        item.setMigrationItem(root.getPath());
        AnalyzerHelper.log(" Adding zip entry for : " + root.getPath(), 2);
        if (this.golbalUserExcludeList != null && this.golbalUserExcludeList.size() >= 1) {
            for (int i = 0; i < this.golbalUserExcludeList.size(); ++i) {
                String userExcludePattern = this.golbalUserExcludeList.get(i);
                excludeItems.add(userExcludePattern);
            }
        }
        String relativePath = this.configDirectory.getRelativePath(root);
        String prefix = this.getPrefix(root.getPath());
        item.setPrefix(prefix);
        item.setIncludedItems(includeItems);
        item.setExcludedItems(excludeItems);
        this.zippedItems.add(item);
    }

    private String getPrefix(String filePath) {
        String relativePath = this.configDirectory.getRelativePath(filePath);
        String prefix = this.configDirectory.getName();
        if (relativePath != null) {
            prefix = prefix + File.separator + relativePath;
        }
        return prefix;
    }

    private void addCopyEntry(File root, String fileName) {
        MigrationItem item = new MigrationItem();
        File bigFile = new File(root, fileName);
        item.setMigrationItem(bigFile.getPath());
        this.bigFiles.add(item);
    }

    private boolean shouldCompress() {
        return true;
    }

    private boolean shouldExcludeContains(File path, long size) {
        boolean shouldExclude = this.thresholdReached(size);
        boolean included = false;
        if (!shouldExclude && this.includeProcess) {
            if (path.isDirectory()) {
                File childpathFile;
                included = this.globalIncludeList.contains(path.getPath());
                if (!included && (childpathFile = new File(path.getPath())).isDirectory()) {
                    included = this.contains(path.getPath(), this.globalIncludeList);
                }
                if (included) {
                    shouldExclude = false;
                }
            } else {
                shouldExclude = !this.globalIncludeList.contains(path.getPath());
            }
        }
        return shouldExclude;
    }

    private List getGlobalExcludeList(String parentPath) {
        ArrayList<String> unaccessible = this.configDirectory.getUnaccessibleFiles(parentPath);
        if (unaccessible == null) {
            unaccessible = new ArrayList<String>();
        }
        if (this.configDirectory.rootOnlyInstance()) {
            unaccessible.add("./**/");
        }
        if (!AnalyzerHelper.isEmpty(this.globalExcludeList)) {
            String unaccessiblePath = null;
            String relPath = null;
            for (int index = 0; index < this.globalExcludeList.size(); ++index) {
                unaccessiblePath = (String)this.globalExcludeList.get(index);
                relPath = Directory.getRelativePath(parentPath, unaccessiblePath);
                if (relPath == null) continue;
                unaccessible.add(relPath);
            }
        }
        return unaccessible != null ? unaccessible : null;
    }

    private boolean shouldInclude(String path) {
        boolean shouldInclude = false;
        shouldInclude = this.configDirectory.canAccess(path) && !this.globalExcludeList.contains(path);
        return shouldInclude;
    }

    private boolean thresholdReached(long size) {
        return this.zipThreshold < size;
    }

    public List migrateData() {
        return null;
    }

    public DataResult getDataMigrationResult() {
        return new DataResult();
    }

    public PermissionMigrator getPermissionMigrator(String osFamily, List filterList, DirectoryScanner directoryScanner) throws IllegalArgumentException {
        PermissionMigrator pMigrator = PermissionMigrator.getInstance(osFamily, this.configDirectory);
        this.processGlobalFilterList(filterList);
        ArrayList<String> permissionIncludeList = new ArrayList<String>();
        if (directoryScanner != null) {
            int i;
            String[] includeFiles = directoryScanner.getIncludedFiles();
            String[] includedDirs = directoryScanner.getIncludedDirectories();
            if (includeFiles != null) {
                for (i = 0; i < includeFiles.length; ++i) {
                    permissionIncludeList.add(includeFiles[i]);
                }
            }
            if (includedDirs != null) {
                for (i = 0; i < includedDirs.length; ++i) {
                    permissionIncludeList.add(includedDirs[i]);
                }
            }
            if (permissionIncludeList != null) {
                pMigrator.setIncludeList(permissionIncludeList);
            }
            pMigrator.setDirectoryScanner(directoryScanner);
            pMigrator.setFilterList(this.globalExcludeList);
        }
        return pMigrator;
    }

    public static boolean isAbsolute(String relPath) {
        if (relPath == null) {
            throw new NullPointerException();
        }
        return relPath.startsWith("/");
    }

    public class DataResult {
        public List getZippedItems() {
            return new ArrayList(DataMigrator.this.zippedItems);
        }

        public boolean dataFound() {
            return !AnalyzerHelper.isEmpty(DataMigrator.this.zippedItems) || !AnalyzerHelper.isEmpty(DataMigrator.this.bigFiles);
        }

        public long getMigratedDataSize() {
            return DataMigrator.this.dataMigratedSize;
        }

        public boolean itemStorePresent() {
            return DataMigrator.this.globalLogList.size() > 0;
        }

        public List getExcludeItem(String excludeType) {
            ArrayList excludes = null;
            if (excludeType.equals(DataMigrator.EXCLUDE_TYPE_SOFTLINK)) {
                excludes = DataMigrator.this.configDirectory.getSoftLinks();
            }
            if (excludeType.endsWith(DataMigrator.EXCLUDE_TYPE_UNACCESSIBLE)) {
                excludes = DataMigrator.this.configDirectory.getUnaccessibleFileList();
            }
            if (excludeType.equals(DataMigrator.EXCLUDE_TYPE_TEMP) && DataMigrator.this.globalPackageExcludes.size() > 0) {
                excludes = new ArrayList(DataMigrator.this.globalPackageExcludes);
            }
            if (excludeType.equals(DataMigrator.EXCLUDE_TYPE_USEREXCLUDE) && DataMigrator.this.globalPackageUserExcludes.size() > 0) {
                excludes = new ArrayList(DataMigrator.this.globalPackageUserExcludes);
            }
            if (excludeType.equals(DataMigrator.EXCLUDE_TYPE_ITEMSTORE) && DataMigrator.this.globalLogList.size() > 0) {
                excludes = new ArrayList(DataMigrator.this.globalLogList);
            }
            return excludes;
        }

        public List getExcludeTypes() {
            ArrayList<String> excludeTypes = null;
            if (this.excludeItemPresent()) {
                excludeTypes = new ArrayList<String>();
                if (DataMigrator.this.configDirectory.unaccessibleFilesPresent()) {
                    excludeTypes.add(DataMigrator.EXCLUDE_TYPE_UNACCESSIBLE);
                }
                if (DataMigrator.this.configDirectory.softLinksPresent()) {
                    excludeTypes.add(DataMigrator.EXCLUDE_TYPE_SOFTLINK);
                }
                if (DataMigrator.this.globalPackageExcludes.size() > 0) {
                    excludeTypes.add(DataMigrator.EXCLUDE_TYPE_TEMP);
                }
                if (DataMigrator.this.globalPackageUserExcludes.size() > 0) {
                    excludeTypes.add(DataMigrator.EXCLUDE_TYPE_USEREXCLUDE);
                }
                if (DataMigrator.this.globalLogList.size() > 0) {
                    excludeTypes.add(DataMigrator.EXCLUDE_TYPE_ITEMSTORE);
                }
            }
            return excludeTypes;
        }

        public boolean excludeItemPresent() {
            return DataMigrator.this.configDirectory.unaccessibleFilesPresent() || DataMigrator.this.configDirectory.softLinksPresent() || DataMigrator.this.globalPackageExcludes.size() > 0 || DataMigrator.this.globalLogList.size() > 0 || DataMigrator.this.globalPackageUserExcludes.size() > 0;
        }

        public List getMigratedSubDirs() {
            ArrayList migratedsubDirs = null;
            HashSet<String> migratedDirs = new HashSet<String>();
            List accessible = null;
            accessible = !AnalyzerHelper.isEmpty(DataMigrator.this.globalIncludeList) ? DataMigrator.this.globalIncludeList : DataMigrator.this.configDirectory.getAccessibleDirs();
            String subDir = null;
            File subDirFile = null;
            File valFile = null;
            String relPath = null;
            boolean skip = false;
            String val = null;
            String tempSubDir = null;
            if (accessible != null) {
                for (int index = 0; index < accessible.size(); ++index) {
                    subDir = (String)accessible.get(index);
                    subDirFile = new File(subDir);
                    if (!subDirFile.isDirectory()) {
                        subDir = subDirFile.getParentFile().getPath();
                    }
                    skip = false;
                    if (DataMigrator.this.globalExcludeList.contains(subDir)) continue;
                    for (int i = 0; i < DataMigrator.this.globalExcludeList.size(); ++i) {
                        val = (String)DataMigrator.this.globalExcludeList.get(i);
                        valFile = new File(val);
                        subDirFile = new File(subDir);
                        try {
                            tempSubDir = subDir;
                            subDir = subDirFile.getCanonicalPath();
                            val = valFile.getCanonicalPath();
                        }
                        catch (IOException e) {
                            subDir = tempSubDir;
                            val = (String)DataMigrator.this.globalExcludeList.get(i);
                        }
                        if (!subDir.equals(val) && !Directory.isChild(val, subDir)) continue;
                        AnalyzerHelper.log("Excluding " + subDir + " because it is subdir of " + val + ". " + val + " was already marked to be excluded", 2);
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                    relPath = DataMigrator.this.configDirectory.getRelativePath(subDir);
                    migratedDirs.add(DataMigrator.this.configDirectory.getName() + (relPath != null ? File.separator + relPath : ""));
                }
            }
            if (!AnalyzerHelper.isEmpty(migratedDirs)) {
                migratedsubDirs = new ArrayList(migratedDirs);
            }
            return migratedsubDirs;
        }

        public FileCollection getPackagedFiles() {
            FileCollection packagedFiles;
            block8: {
                packagedFiles = null;
                try {
                    if (!DataMigrator.this.configDirectory.isPackagedFileListCreated()) {
                        File tempFile = null;
                        try {
                            tempFile = File.createTempFile(DataMigrator.this.configDirectory.getName() + "_PackagedFiles", "");
                        }
                        catch (Exception e) {
                            File tempFolder = new File(".", "Temp" + File.separator + "CMUTemp");
                            tempFolder.mkdirs();
                            tempFile = File.createTempFile(DataMigrator.this.configDirectory.getName() + "_PackagedFiles", "", tempFolder);
                        }
                        tempFile.deleteOnExit();
                        packagedFiles = new FileCollection(tempFile);
                        HashMap lMigratedItems = new HashMap();
                        List migratedsubDirs = this.getMigratedSubDirs();
                        for (int i = 0; i < migratedsubDirs.size(); ++i) {
                            String subDirectory = (String)migratedsubDirs.get(i);
                            File subDirFile = new File(DataMigrator.this.configDirectory.getFileInstance().getParentFile(), subDirectory);
                            File[] files = subDirFile.listFiles(new FileFilter(){

                                @Override
                                public boolean accept(File child) {
                                    return child.isFile();
                                }
                            });
                            ArrayList<String> fileList = new ArrayList<String>();
                            if (files != null) {
                                for (int j = 0; j < files.length; ++j) {
                                    File file = files[j];
                                    if (!Directory.isAccessible(file)) continue;
                                    fileList.add(file.getPath());
                                }
                            }
                            packagedFiles.put(subDirectory, fileList);
                        }
                        DataMigrator.this.configDirectory.setPackagedFiles(packagedFiles);
                        break block8;
                    }
                    packagedFiles = DataMigrator.this.configDirectory.getPackagedFiles();
                }
                catch (IOException e) {
                    AnalyzerHelper.log(e);
                }
            }
            return packagedFiles;
        }
    }

    public class MigrationItem {
        private List includedItems;
        private List excludedItems;
        private String prefix;
        private String migrationItem;

        public boolean compress() {
            return DataMigrator.this.compress;
        }

        public String getBaseDir() {
            return DataMigrator.this.configItemRoot;
        }

        public void setMigrationItem(String migrationItem) {
            this.migrationItem = migrationItem;
        }

        public String getMigrationItem() {
            return this.migrationItem;
        }

        public List getExcludedItems() {
            return this.excludedItems;
        }

        void setExcludedItems(List excludedItems) {
            if (excludedItems != null) {
                this.excludedItems = new ArrayList(excludedItems);
            }
        }

        public List getIncludedItems() {
            return this.includedItems;
        }

        void setIncludedItems(List includedItems) {
            if (includedItems != null) {
                this.includedItems = new ArrayList(includedItems);
            }
        }

        public String getPrefix() {
            return this.prefix;
        }

        void setPrefix(String prefix) {
            this.prefix = prefix;
        }
    }
}

