/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.common;

import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigItems {
    private static final String ROOT_KEY = "rootkey";
    private Map configItems = new HashMap(100);
    private static Map zippedConfigItems = new HashMap();

    public void addConfigItem(String componentName, String configItemPath) {
        List configItem = this.createConfigItemsList(componentName);
        configItem.add(new ConfigItem(configItemPath));
    }

    public void addConfigItem(String componentName, List configItemPaths) {
        List configItem = this.createConfigItemsList(componentName);
        configItem.addAll(this.getConfigItems(configItemPaths));
    }

    private List getConfigItems(List configItemsPath) {
        ArrayList<ConfigItem> configItems = null;
        if (configItemsPath != null) {
            configItems = new ArrayList<ConfigItem>();
            for (int index = 0; index < configItemsPath.size(); ++index) {
                configItems.add(new ConfigItem((String)configItemsPath.get(index)));
            }
        }
        return configItems;
    }

    public void addConfigItem(String configItemPath) {
        this.addConfigItem(ROOT_KEY, configItemPath);
    }

    private List createConfigItemsList(String componentName) {
        if (this.configItems.get(componentName) == null) {
            this.configItems.put(componentName, new ArrayList());
        }
        return (List)this.configItems.get(componentName);
    }

    public List getConfigItems(String componentName) {
        List compList = (List)this.configItems.get(componentName);
        ArrayList<String> configPaths = null;
        if (!AnalyzerHelper.isEmpty(compList)) {
            configPaths = new ArrayList<String>(compList.size());
            ConfigItem configItem = null;
            for (int index = 0; index < compList.size(); ++index) {
                configItem = (ConfigItem)compList.get(index);
                if (configPaths.contains(configItem.getPath())) continue;
                configPaths.add(configItem.getPath());
            }
        }
        return configPaths;
    }

    public List getConfigItems() {
        return this.getConfigItems(ROOT_KEY);
    }

    public void addRelativeDestination(String componentName, String configItemPath, String relativeDestination) {
        ConfigItem configItem = null;
        configItem = componentName == null ? this.getConfigItem(ROOT_KEY, configItemPath) : this.getConfigItem(componentName, configItemPath);
        if (configItem != null) {
            configItem.setRelativeDestination(relativeDestination);
        }
    }

    public String getRelativeDestination(String componentName, String configItemPath) {
        ConfigItem configItem = null;
        String relDestination = null;
        configItem = componentName == null ? this.getConfigItem(ROOT_KEY, configItemPath) : this.getConfigItem(componentName, configItemPath);
        if (configItem != null) {
            relDestination = configItem.getRelativeDestination();
        }
        return relDestination;
    }

    public void addExcludeConfigItem(String componentName, String configItem, String excludeItemPath) {
        ConfigItem config = this.getConfigItem(componentName, configItem);
        if (config != null) {
            config.setExcludeItem(excludeItemPath);
        }
    }

    private ConfigItem getConfigItem(String componentName, String configItem) {
        if (componentName != null) {
            List configs = (List)this.configItems.get(componentName);
            ConfigItem config = null;
            if (!AnalyzerHelper.isEmpty(configs)) {
                for (int index = 0; index < configs.size(); ++index) {
                    config = (ConfigItem)configs.get(index);
                    if (!config.getItemName().equalsIgnoreCase(configItem) && !config.getPath().equalsIgnoreCase(configItem)) continue;
                    return config;
                }
            }
        }
        return null;
    }

    public void addZippedConfigItem(String componentName, String configItem, String prefix, List includeList, List excludeList, String relDestination) {
        List configItems = this.createConfigItemsList(componentName == null ? ROOT_KEY : componentName);
        configItems.add(new ZippedConfigItem(configItem, prefix, includeList, excludeList, relDestination));
    }

    public List getZippedConfigItems(String componentName, String configItem) {
        List zippedList = (List)this.configItems.get(componentName == null ? ROOT_KEY : componentName);
        List zippedItems = null;
        ConfigItem configItemObject = null;
        ZippedConfigItem zippedItem = null;
        if (!AnalyzerHelper.isEmpty(zippedList)) {
            for (int index = 0; index < zippedList.size(); ++index) {
                configItemObject = (ConfigItem)zippedList.get(index);
                if (!configItemObject.compress()) continue;
                zippedItem = (ZippedConfigItem)configItemObject;
                zippedItems = zippedItem.getZippedConfigItems(configItem);
                break;
            }
        }
        return zippedItems;
    }

    public void setCompress(String componentName, String configItem, boolean compress) {
        ConfigItem config = this.getConfigItem(componentName, configItem);
        if (configItem != null) {
            config.setCompress(compress);
        }
    }

    public boolean compress(String componentName, String configItem) {
        boolean compress = false;
        ConfigItem config = this.getConfigItem(componentName == null ? ROOT_KEY : componentName, configItem);
        if (config != null) {
            compress = config.compress();
        }
        return compress;
    }

    public void addIncludeConfigItem(String componentName, String configItem, String includeItemPath) {
        ConfigItem config = this.getConfigItem(componentName, configItem);
        if (config != null) {
            config.setIncludeItem(includeItemPath);
        }
    }

    public void addPrefixToConfigItem(String componentName, String configItem, String prefixPath) {
        ConfigItem config = this.getConfigItem(componentName, configItem);
        if (config != null) {
            config.setPrefix(prefixPath);
        }
    }

    public String getPrefixToConfigItem(String componentName, String configItem) {
        ConfigItem config = this.getConfigItem(componentName, configItem);
        String prefix = null;
        if (config != null) {
            prefix = config.getPrefix();
        }
        return prefix;
    }

    public List getExcludeConfigItem(String componentName, String configItem) {
        List excludePaths = null;
        ConfigItem config = this.getConfigItem(componentName, configItem);
        if (config != null) {
            excludePaths = config.getExcludeList();
        }
        return excludePaths;
    }

    public List getIncludeConfigItem(String componentName, String configItem) {
        List includePaths = null;
        ConfigItem config = this.getConfigItem(componentName, configItem);
        if (config != null) {
            includePaths = config.getIncludeList();
        }
        return includePaths;
    }

    public List getRootExcludeConfigItem(String configItem) {
        return this.getExcludeConfigItem(ROOT_KEY, configItem);
    }

    public void addRootExcludeConfigItem(String configItem, String excludeItemPath) {
        this.addExcludeConfigItem(ROOT_KEY, configItem, excludeItemPath);
    }

    public class ZippedConfigItem
    extends ConfigItem {
        public ZippedConfigItem(String configItem, String prefix, List includeList, List excludeList, String relDestination) {
            super(configItem);
            this.setPrefix(prefix);
            this.setIncludeList(includeList);
            this.setExcludeList(excludeList);
            this.setRelativeDestination(relDestination);
            this.setCompress(true);
            List zippedItems = this.createZippedItemsList(configItem);
            zippedItems.add(this);
        }

        private List createZippedItemsList(String configItem) {
            if (zippedConfigItems.get(configItem) == null) {
                zippedConfigItems.put(configItem, new ArrayList());
            }
            return (List)zippedConfigItems.get(configItem);
        }

        public List getZippedConfigItems(String configItem) {
            return (List)zippedConfigItems.get(configItem);
        }
    }

    private class ConfigItem {
        String itemName;
        String path;
        List excludeList;
        List includeList;
        String prefix;
        String relDestination;
        boolean compress = false;

        public void setCompress(boolean comp) {
            this.compress = comp;
        }

        public void setRelativeDestination(String destination) {
            this.relDestination = destination;
        }

        public String getRelativeDestination() {
            return this.relDestination;
        }

        public boolean compress() {
            return this.compress;
        }

        public ConfigItem() {
        }

        void setIncludeList(List include) {
            if (include != null) {
                this.includeList = new ArrayList(include);
            }
        }

        void setExcludeList(List exclude) {
            if (exclude != null) {
                this.excludeList = new ArrayList(exclude);
            }
        }

        public ConfigItem(String configPath) {
            this.path = configPath;
            File configItem = new File(this.path);
            this.itemName = configItem.getName();
        }

        public List getExcludeList() {
            return this.excludeList;
        }

        public void setPrefix(String configPrefix) {
            this.prefix = configPrefix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public List getIncludeList() {
            return this.includeList;
        }

        public void setExcludeItem(String excludeItem) {
            if (this.excludeList == null) {
                this.excludeList = new ArrayList();
            }
            this.excludeList.add(excludeItem);
        }

        public void setIncludeItem(String includeItem) {
            if (this.includeList == null) {
                this.includeList = new ArrayList();
            }
            this.includeList.add(includeItem);
        }

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String configItemName) {
            this.itemName = configItemName;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String configPath) {
            this.path = configPath;
        }

        public boolean isDirectory() {
            File configItem = new File(this.path);
            return configItem != null && configItem.exists() && configItem.isDirectory();
        }
    }
}

