/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.export.common;

import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.export.common.ConfigFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ConfigFileImpl
implements ConfigFile {
    private File configDir = null;
    private static final String CONFIG_OPTION_PREFIX = "-";
    private static final String VARIABLE_SET_OPTION = "set ";
    private static final String COMMENT_SUFFIX = "#";
    private static final int OPTION_TYPE_VARIABLE = 1;
    private static final int OPTION_TYPE_CONFIG = 0;
    private static final int NUM_CONSTANT_TWO = 2;
    private static final String SPACE = " ";
    private Map configOptions = null;
    private Map varOptions = null;

    @Override
    public String getConfigurationOption(String option) {
        String configValue = null;
        configValue = (String)this.configOptions.get(option);
        return configValue;
    }

    @Override
    public Map getConfigurationOptions() {
        return new HashMap(this.configOptions);
    }

    @Override
    public String getVariable(String varName) {
        String varValue = null;
        varValue = (String)this.varOptions.get(varName);
        return varValue;
    }

    @Override
    public Map getVariables() {
        return new HashMap(this.varOptions);
    }

    @Override
    public void init(String context, String configFile) {
    }

    @Override
    public boolean isConfigOptionSet(String optionName) {
        return this.configOptions.containsKey(optionName);
    }

    @Override
    public boolean isVariableSet(String varName) {
        return this.varOptions.containsKey(varName);
    }

    public ConfigFileImpl(File config) {
        this.configDir = config;
        this.configOptions = new HashMap();
        this.varOptions = new HashMap();
        try {
            this.parseConfigFile(null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public ConfigFileImpl(File configDir, String fileName) {
        this.configDir = configDir;
        this.configOptions = new HashMap();
        this.varOptions = new HashMap();
        try {
            this.parseConfigFile(null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public ConfigFileImpl(File configDir, String fileName, String emptyStr) throws FileNotFoundException {
        this.configDir = configDir;
        this.configOptions = new HashMap();
        this.varOptions = new HashMap();
        this.parseConfigFile(fileName);
    }

    public ConfigFile getConfigurationFile() {
        return this;
    }

    private File searchConfigFile(final String fileFileterName) {
        File configFile = null;
        File[] configFiles = this.configDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return fileFileterName != null ? name.equalsIgnoreCase(fileFileterName) : name.endsWith(".bat") || name.endsWith(".sh") || name.endsWith(".cfg") || name.endsWith(".ini");
            }
        });
        if (!AnalyzerHelper.isEmpty(configFiles)) {
            configFile = configFiles[0];
        }
        return configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseConfigFile(String fileName) throws FileNotFoundException {
        block15: {
            File configFile = this.searchConfigFile(fileName);
            BufferedReader reader = null;
            try {
                if (configFile != null) {
                    reader = new BufferedReader(new FileReader(configFile));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        this.parseConfigLine(line);
                    }
                    break block15;
                }
                AnalyzerHelper.log(" NO CONFIG FILE FOUND ", 0);
                throw new FileNotFoundException("File Not Found " + fileName);
            }
            catch (FileNotFoundException exception) {
                throw exception;
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parseConfigLine(String line) {
        if (this.hasToProcess(line)) {
            if (this.isConfigOption(line)) {
                this.parseConfigurationOption(line);
            } else if (this.isVariableOption(line)) {
                this.parseVariableOption(line);
            }
        }
    }

    private boolean hasToProcess(String line) {
        String tempLine = null;
        boolean isToProcess = false;
        if (line != null) {
            tempLine = line.trim();
            isToProcess = !this.isCommentLine(line) && (tempLine.startsWith(CONFIG_OPTION_PREFIX) || this.isVarOption(tempLine));
        }
        return isToProcess;
    }

    private boolean isCommentLine(String line) {
        String tempLine = null;
        boolean isCommentLine = false;
        if (line != null) {
            tempLine = line.trim();
            isCommentLine = tempLine.startsWith(COMMENT_SUFFIX);
        }
        return isCommentLine;
    }

    private int getOptionType(String line) {
        String tempLine = null;
        int optionType = -1;
        if (line != null) {
            tempLine = line.trim();
            if (tempLine.startsWith(CONFIG_OPTION_PREFIX)) {
                optionType = 0;
            } else if (this.isVarOption(tempLine)) {
                optionType = 1;
            }
        }
        return optionType;
    }

    private boolean isVarOption(String line) {
        String tempLine = null;
        boolean isVar = false;
        String[] values = null;
        if (line != null) {
            tempLine = line.trim();
            isVar = line.startsWith(VARIABLE_SET_OPTION);
            isVar = isVar || (values = tempLine.split("=")) != null && values.length == 2;
        }
        return isVar;
    }

    private boolean isConfigOption(String line) {
        return this.getOptionType(line) == 0;
    }

    private boolean isVariableOption(String line) {
        return this.getOptionType(line) == 1;
    }

    private void parseLine(String line) {
    }

    private void parseConfigurationOption(String line) {
        String tempLine = line.trim();
        int configValueStart = tempLine.indexOf(SPACE);
        String configOption = "";
        String configValue = "";
        if (configValueStart != -1) {
            configOption = tempLine.substring(1, configValueStart);
            configValue = tempLine.substring(configValueStart);
        } else {
            configOption = tempLine.substring(1);
        }
        this.configOptions.put(configOption, AnalyzerHelper.trimQuotes(configValue));
    }

    private void parseVariableOption(String line) {
        String tempLine;
        boolean isSetUsed = (tempLine = line.trim().toLowerCase()).indexOf(VARIABLE_SET_OPTION) != -1;
        int varStringStart = isSetUsed ? tempLine.indexOf(VARIABLE_SET_OPTION) + VARIABLE_SET_OPTION.length() : 0;
        String[] variables = (tempLine = tempLine.substring(varStringStart)).split("=");
        if (variables != null) {
            this.varOptions.put(variables[0], AnalyzerHelper.trimQuotes(variables[1]));
        }
    }
}

