/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.core;

import com.sas.apps.content.migration.core.ContentMigrationException;
import com.sas.apps.content.migration.core.ContentMigratorInterface;
import com.sas.apps.content.migration.core.RB;
import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.utils.Constants;
import com.sas.apps.content.migration.utils.Lib;
import com.sas.apps.content.migration.utils.LogParser;
import com.sas.apps.content.migration.utils.Utils;
import com.sas.apps.content.migration.utils.XMLWriter;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.listener.CommonsLoggingListener;

public class ContentImporter
implements ContentMigratorInterface {
    private static final String cBuildFileName = "cmu_import_config.xml";
    private String cConfigXmlPath = null;
    private String cDeploywizGroovyPath = null;
    private Properties cProperties = null;
    private String hostname = null;
    private String osfamily = null;
    private String os = null;
    private String osmachine = null;
    private String osarch = null;
    private File cPropFile = null;
    private XMLWriter xmlWriter = new XMLWriter();

    @Override
    public String getMode() {
        return "IMPORT";
    }

    @Override
    public void process(Properties props) throws ContentMigrationException {
        this.cProperties = props;
        this.updateProperties();
        this.executeBuild();
        try {
            LogParser logParser;
            Map<String, Lib> mapLib;
            File logCrossPlatformFile = new File((String)this.cProperties.get("cmu.target.dir") + File.separator + "Logs" + File.separator + "CMU" + File.separator + "logCrossPlatformOutput.log");
            if (logCrossPlatformFile.exists() && !AnalyzerHelper.isEmpty(mapLib = (logParser = new LogParser()).parseFile(logCrossPlatformFile))) {
                File docs = new File((String)this.cProperties.get("cmu.target.dir") + File.separator + "Documents");
                if (!docs.exists()) {
                    docs.mkdir();
                }
                this.xmlWriter.writeXML(mapLib, docs);
            }
        }
        catch (IOException e) {
            throw new ContentMigrationException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ContentMigrationException(e);
        }
        catch (TransformerException e) {
            throw new ContentMigrationException(e);
        }
    }

    private void updateProperties() throws ContentMigrationException {
        FileOutputStream fos = null;
        try {
            File tempDir = this.createTempDir();
            this.cPropFile = new File(tempDir.getAbsolutePath(), "cmuimport.properties");
            fos = new FileOutputStream(this.cPropFile);
            File cmuCommonPropFile = new File((String)this.cProperties.get("cmu.package.dir"), "cmu_common.properties");
            this.cProperties.put("temp.dir", tempDir.getAbsolutePath());
            Constants.logger.debug("cmu_common.properties file path: " + cmuCommonPropFile.getAbsolutePath());
            if (cmuCommonPropFile.exists()) {
                Properties cmuCommonProps = new Properties();
                cmuCommonProps.load(new FileInputStream(cmuCommonPropFile));
                this.cProperties.putAll((Map<?, ?>)cmuCommonProps);
            }
            this.addOsProperties();
            if (!AnalyzerHelper.isEmpty(this.cProperties.get("config.xml.dir.path"))) {
                this.cConfigXmlPath = (String)this.cProperties.get("config.xml.dir.path");
                this.cConfigXmlPath = this.cConfigXmlPath.concat("\\Utilities");
            }
            if (!AnalyzerHelper.isEmpty(this.cProperties.get("deploywizard.groovy.path"))) {
                this.cDeploywizGroovyPath = (String)this.cProperties.get("deploywizard.groovy.path");
            }
            this.cProperties.store(fos, null);
        }
        catch (IOException e) {
            throw new ContentMigrationException(e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                Constants.logger.error("ERROR: while closing output stream");
            }
        }
    }

    private File createTempDir() throws IOException {
        String baseTempPath = System.getProperty("java.io.tmpdir");
        Random random = new Random();
        int randomInt = 1 + random.nextInt();
        File tempDir = new File(baseTempPath, "CmuTemp" + randomInt);
        try {
            if (tempDir.exists() && !tempDir.delete()) {
                throw new IOException("Could not delete temp folder: " + tempDir.getAbsolutePath());
            }
            File.createTempFile("test", "properties", tempDir).deleteOnExit();
        }
        catch (Exception e) {
            tempDir = new File(".", "Temp" + File.separator + "CMUTemp" + randomInt);
        }
        tempDir.mkdirs();
        Constants.logger.debug(tempDir.getAbsolutePath());
        tempDir.deleteOnExit();
        return tempDir;
    }

    private void addOsProperties() {
        InetAddress addr = null;
        String localCanonicalName = null;
        try {
            addr = InetAddress.getLocalHost();
            localCanonicalName = addr.getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            Constants.logger.error(RB.getStringResource("Framework.lclhostunkn.ex.txt"));
        }
        this.hostname = localCanonicalName;
        this.osfamily = Utils.getOS_Family();
        this.os = Utils.getOS_3byte();
        this.osmachine = Utils.getOS_Suffix();
        this.osarch = Utils.getArch();
        this.cProperties.put("target.host.name", this.hostname);
        if (!ContentImporter.isHostsEqual(this.cProperties.getProperty("source.host.name"), this.hostname)) {
            this.cProperties.put("change.host", "true");
        }
        this.cProperties.put("target.os.host.type", this.os);
        this.cProperties.put("target.os.host.machine.type", this.osmachine);
        this.cProperties.put("target.os.host.arch", this.osarch);
        this.cProperties.put("target.os.jvm.locale", Utils.getLocale());
        this.cProperties.put("target.os.jvm.encoding", Utils.getEncoding());
        if (this.osfamily.equalsIgnoreCase("Windows")) {
            this.cProperties.put("onWindowsHosts", "true");
        } else if (this.osfamily.equalsIgnoreCase("Unix")) {
            this.cProperties.put("onUnixHosts", "true");
        } else if (this.osfamily.equalsIgnoreCase("ZOS") || this.osfamily.equalsIgnoreCase("MVS")) {
            this.cProperties.put("onZosHosts", "true");
        }
    }

    private static boolean isHostsEqual(String host1, String host2) {
        InetAddress hostAddress1 = ContentImporter.convertToInetAddress(host1);
        InetAddress hostAddress2 = ContentImporter.convertToInetAddress(host2);
        if (hostAddress1 == null || hostAddress2 == null) {
            return host1 != null && host1.equalsIgnoreCase(host2);
        }
        return hostAddress1 != null && hostAddress1.equals(hostAddress2);
    }

    public static InetAddress convertToInetAddress(String host) {
        InetAddress address = null;
        try {
            if (host != null) {
                address = InetAddress.getByName(host);
            }
        }
        catch (UnknownHostException unknownHost) {
            Constants.logger.warn(Message.format((String)RB.getStringResource("ContentImporter.unknown.host.fmt.log"), (Object[])new Object[]{host}));
        }
        return address;
    }

    private void executeBuild() throws ContentMigrationException {
        Project p = new Project();
        try {
            File fLogDir;
            File buildFile = null;
            buildFile = !AnalyzerHelper.isEmpty(this.cConfigXmlPath) ? new File(this.cConfigXmlPath, cBuildFileName) : new File(cBuildFileName);
            Constants.logger.debug("Temp property file which is passed to ant script: " + this.cPropFile.getAbsolutePath());
            CommonsLoggingListener logListener = new CommonsLoggingListener();
            p.addBuildListener((BuildListener)logListener);
            p.fireBuildStarted();
            p.init();
            p.setUserProperty("ant.file", buildFile.getAbsolutePath());
            String logDir = this.cProperties.getProperty("cmu.logs.dir");
            if (logDir != null && (fLogDir = new File(logDir)).exists()) {
                p.setProperty("config.lev.logs.configure.dir", logDir);
            }
            p.setProperty("properties.file.path", this.cPropFile.getAbsolutePath());
            Constants.logger.info("setting ant properties.");
            Constants.logger.info("cConfigXmlPath =" + this.cConfigXmlPath);
            p.setProperty("12byte.groovy.path", this.cDeploywizGroovyPath);
            p.setProperty("default.groovy.path", this.cDeploywizGroovyPath);
            p.setProperty("install.cfgwizard.utilities.dir", this.cConfigXmlPath);
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            p.addReference("ant.projectHelper", (Object)helper);
            helper.parse(p, (Object)buildFile);
            p.executeTarget(p.getDefaultTarget());
            p.fireBuildFinished(null);
        }
        catch (BuildException e) {
            p.fireBuildFinished((Throwable)e);
            throw new AssertionError((Object)e);
        }
    }
}

