/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.core;

import com.sas.apps.content.migration.core.ContentExportScriptBuilder;
import com.sas.apps.content.migration.core.ContentMigrationException;
import com.sas.apps.content.migration.core.ContentMigratorInterface;
import com.sas.apps.content.migration.core.RB;
import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.export.common.ConfigItems;
import com.sas.apps.content.migration.export.common.DataMigrator;
import com.sas.apps.content.migration.export.common.DataMigratorHelper;
import com.sas.apps.content.migration.export.common.Directory;
import com.sas.apps.content.migration.export.common.SASRunner;
import com.sas.apps.content.migration.export.permissions.OSPermissionCollection;
import com.sas.apps.content.migration.export.permissions.PermissionMigrator;
import com.sas.apps.content.migration.utils.Constants;
import com.sas.apps.content.migration.utils.Utils;
import com.sas.text.Message;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class ContentExporter
implements ContentMigratorInterface {
    private static Properties cProperties = null;
    private static final String productName = "cmuproduct";
    private String hostname = null;
    private String osfamily = null;
    private String os = null;
    private String osmachine = null;
    private String osarch = null;
    private List<String> cSrcDirs = null;
    private Map<String, String> componentNames = null;
    private static final String ZIP_THRESHOLD_PROP = "data.split.threshold";
    private DataMigratorHelper cDataMigHelper = null;
    public static SASRunner cSasRunner = null;
    private Map excludeItems = new HashMap();
    private Map<String, List<String>> migratedItems;

    public static Properties getProperties() {
        return cProperties;
    }

    public void setCProperties(Properties properties) {
        cProperties = properties;
    }

    @Override
    public String getMode() {
        return "EXPORT";
    }

    @Override
    public void process(Properties props) throws ContentMigrationException {
        try {
            cProperties = props;
            this.initialize();
            this.analyzeSrcDirectories();
            ContentExportScriptBuilder executor = ContentExportScriptBuilder.getContentExportExecutorInstance(this);
            executor.runExport();
            this.reportDataMigrationResult();
        }
        catch (Exception e) {
            throw new ContentMigrationException(e);
        }
    }

    private void analyzeSrcDirectories() throws IOException {
        String srcDirs = cProperties.getProperty("cmu.source.dirs");
        String userIncludePattern = cProperties.getProperty("cmu.include.filter");
        if (!AnalyzerHelper.isEmpty(srcDirs)) {
            String[] srcDirPaths = srcDirs.split(",,");
            this.cSrcDirs = new ArrayList<String>(srcDirPaths.length);
            HashSet<String> sourceDirsSet = new HashSet<String>();
            String srcDirPath = null;
            String baseDir = cProperties.getProperty("cmu.base.dir");
            Constants.logger.debug("basedir: " + baseDir);
            File srcDir = null;
            for (int index = 0; index < srcDirPaths.length; ++index) {
                boolean added;
                srcDirPath = srcDirPaths[index];
                srcDir = new File(srcDirPath);
                if (!srcDir.isAbsolute()) {
                    srcDir = new File(baseDir, srcDirPath);
                }
                if (!srcDir.exists()) {
                    Constants.logger.warn(Message.format((String)RB.getStringResource("report.warning.srcdir.notfound.fmt"), (Object)srcDirPath));
                    continue;
                }
                if (Directory.isChild(baseDir, srcDir.getPath())) {
                    added = sourceDirsSet.add(srcDir.getCanonicalPath());
                    if (added) continue;
                    Constants.logger.warn(srcDir.getCanonicalPath() + " already included");
                    continue;
                }
                if (baseDir.equalsIgnoreCase(srcDir.getPath())) {
                    if (userIncludePattern != null && !userIncludePattern.equals("")) {
                        added = sourceDirsSet.add(srcDir.getCanonicalPath());
                        if (added) continue;
                        Constants.logger.warn(srcDir.getCanonicalPath() + " already included");
                        continue;
                    }
                    Constants.logger.warn("Required include filter to migrate base directory:" + srcDir.getCanonicalPath());
                    continue;
                }
                Constants.logger.warn(Message.format((String)RB.getStringResource("report.warning.srcdir.notfound.fmt"), (Object)srcDirPath));
            }
            this.cSrcDirs.addAll(sourceDirsSet);
            int i = 1;
            for (String src : this.cSrcDirs) {
                Constants.logger.debug("Source Dir" + i++ + ": " + src);
            }
        }
    }

    private void initialize() throws ContentMigrationException {
        if (this.isValidProps()) {
            try {
                String sasRoot = cProperties.getProperty("cmu.sasroot");
                String osFamily = Utils.getOS_Family();
                cSasRunner = SASRunner.getSASRunner(sasRoot, osFamily);
                this.cDataMigHelper = DataMigratorHelper.getInstance(this.getZIPThreshold());
                this.cDataMigHelper.setConfigDirectory(cProperties.getProperty("cmu.base.dir"));
            }
            catch (Exception e) {
                Constants.logger.error("Exporter initialization failed.");
                throw new ContentMigrationException("Exporter initialization failed.");
            }
        }
    }

    private boolean isValidProps() throws ContentMigrationException {
        boolean isValid = true;
        String missingProps = "";
        if (!(cProperties.containsKey("cmu.source.dirs") && cProperties.containsKey("cmu.base.dir") && cProperties.containsKey("cmu.package.dir") && cProperties.containsKey("cmu.sasroot"))) {
            isValid = false;
            if (!cProperties.containsKey("cmu.source.dirs")) {
                missingProps = "cmu.source.dirs";
            }
            if (!cProperties.containsKey("cmu.base.dir")) {
                missingProps = missingProps + " " + "cmu.base.dir";
            }
            if (!cProperties.containsKey("cmu.package.dir")) {
                missingProps = missingProps + " " + "cmu.package.dir";
            }
            if (!cProperties.containsKey("cmu.sasroot")) {
                missingProps = missingProps + " " + "cmu.sasroot";
            }
        }
        if (!isValid) {
            Constants.logger.error("Required properties are not present: " + missingProps);
            throw new ContentMigrationException("Required properties are not present: " + missingProps);
        }
        return isValid;
    }

    public Map<String, String> getComponentNames() {
        if (this.componentNames == null && !AnalyzerHelper.isEmpty(this.cSrcDirs)) {
            this.componentNames = new HashMap<String, String>();
            for (int index = 1; index <= this.cSrcDirs.size(); ++index) {
                this.componentNames.put("cmudata" + index, "cmudata" + index);
            }
        }
        return this.componentNames;
    }

    public Map<String, Map<String, String>> getComponentProperties() {
        HashMap<String, Map<String, String>> properties = new HashMap<String, Map<String, String>>();
        String relPath = null;
        HashMap<String, String> userDirProps = null;
        String baseDir = cProperties.getProperty("cmu.base.dir");
        int index = 1;
        for (String srcDir : this.cSrcDirs) {
            relPath = Directory.getChildPath(baseDir, srcDir);
            userDirProps = new HashMap<String, String>(1);
            if (relPath != null) {
                userDirProps.put("source.code.repository.path", "@SAS_CONFIG_DIR@" + File.separator + relPath);
            } else {
                userDirProps.put("source.code.repository.path", "@SAS_CONFIG_DIR@");
            }
            properties.put("cmudata" + index++, userDirProps);
        }
        return AnalyzerHelper.isEmpty(properties) ? null : properties;
    }

    public Map<String, String> getCommonProperties() {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        InetAddress addr = null;
        String localCanonicalName = null;
        try {
            addr = InetAddress.getLocalHost();
            localCanonicalName = addr.getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            Constants.logger.error(RB.getStringResource("Framework.lclhostunkn.ex.txt"));
        }
        this.hostname = localCanonicalName;
        this.osfamily = Utils.getOS_Family();
        this.os = Utils.getOS_3byte();
        this.osmachine = Utils.getOS_Suffix();
        this.osarch = Utils.getArch();
        propertyMap.put("source.host.name", this.hostname);
        propertyMap.put("source.os.host.type", this.os);
        propertyMap.put("source.os.host.machine.type", this.osmachine);
        propertyMap.put("source.os.host.arch", this.osarch);
        propertyMap.put("source.os.jvm.locale", Utils.getLocale());
        propertyMap.put("source.os.jvm.encoding", Utils.getEncoding());
        if (!this.osfamily.equalsIgnoreCase("Windows")) {
            Iterator collectionIterator;
            String permissionLine;
            String permission;
            Directory configDirectory = Directory.getRootDiretctoryInstance(cProperties.getProperty("cmu.base.dir"));
            PermissionMigrator pMigrator = PermissionMigrator.getInstance(Utils.getOS_Family(), configDirectory);
            OSPermissionCollection permCollection = pMigrator.reterivePermission(false);
            if (!AnalyzerHelper.isEmpty(permCollection) && !AnalyzerHelper.isEmpty(permission = OSPermissionCollection.getPermissionsString(permissionLine = (String)(collectionIterator = permCollection.iterator()).next()))) {
                String[] tokens = permission.split("\\|");
                String owner = !AnalyzerHelper.isEmpty(tokens) && tokens.length > 1 ? tokens[1] : "";
                AnalyzerHelper.log("Source Installer: " + owner, 2);
                if (!AnalyzerHelper.isEmpty(owner)) {
                    propertyMap.put("source.installer.login.userid", owner);
                }
            }
        }
        return propertyMap;
    }

    private long getZIPThreshold() {
        String threshold = cProperties.getProperty(ZIP_THRESHOLD_PROP);
        long thr = 0L;
        if (!AnalyzerHelper.isEmpty(threshold)) {
            try {
                thr = Long.parseLong(threshold);
            }
            catch (NumberFormatException exception) {
                Constants.logger.warn("Unable to Parse ZIP threshold Default thresold of 5 GB will be used instead");
            }
        }
        return thr;
    }

    public ConfigItems getConfigItems() {
        ConfigItems configItems = new ConfigItems();
        String baseDir = cProperties.getProperty("cmu.base.dir");
        String userExcludePattern = cProperties.getProperty("cmu.exclude.filter");
        String userIncludePattern = cProperties.getProperty("cmu.include.filter");
        String migrationPermission = cProperties.getProperty("source.dir.permission.migration");
        String migrateCatalog = cProperties.getProperty("source.dir.catalog.migration");
        String runCPOReport = cProperties.getProperty("source.dir.run.cporeport");
        this.cDataMigHelper.setConfigItems(configItems);
        if (migrationPermission != null) {
            this.cDataMigHelper.setMigrationPermission(Boolean.parseBoolean(migrationPermission));
        }
        if (migrateCatalog != null) {
            this.cDataMigHelper.setMigrationCatalog(Boolean.parseBoolean(migrateCatalog));
        }
        if (runCPOReport != null) {
            this.cDataMigHelper.setRunCPORepot(Boolean.parseBoolean(runCPOReport));
        } else {
            this.cDataMigHelper.setRunCPORepot(true);
        }
        if (!AnalyzerHelper.isEmpty(this.cDataMigHelper)) {
            this.cDataMigHelper.migrateUserDirectories(this.cSrcDirs, "cmudata", baseDir, userExcludePattern, userIncludePattern);
        }
        this.excludeItems = this.cDataMigHelper.getExcludedLogEntries();
        return configItems;
    }

    public String getProductName() {
        return productName;
    }

    private void reportDataMigrationResult(DataMigrator.DataResult result) {
        if (result.excludeItemPresent()) {
            List excludeItemTypes = result.getExcludeTypes();
            List items = null;
            String excludeType = null;
            Object message = null;
            for (int index = 0; index < excludeItemTypes.size(); ++index) {
                excludeType = (String)excludeItemTypes.get(index);
                items = result.getExcludeItem(excludeType);
                if (items == null) continue;
                if (this.excludeItems.containsKey(excludeType)) {
                    List excludeList = (List)this.excludeItems.get(excludeType);
                    excludeList.addAll(items);
                    continue;
                }
                this.excludeItems.put(excludeType, items);
            }
        }
    }

    public String getOutputDirectory() {
        return (String)cProperties.get("cmu.package.dir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportDataMigrationResult() {
        String fileName = this.getOutputDirectory() + File.separator + "excludedfiles.log";
        BufferedWriter writer = null;
        String exclude = null;
        if (!AnalyzerHelper.isEmpty(this.excludeItems)) {
            try {
                writer = new BufferedWriter(new FileWriter(fileName));
                Iterator excludeTypes = this.excludeItems.keySet().iterator();
                Set excludedFiles = null;
                String excludeString = null;
                while (excludeTypes.hasNext()) {
                    excludeString = (String)excludeTypes.next();
                    excludedFiles = (Set)this.excludeItems.get(excludeString);
                    exclude = RB.getStringResource("report.warning.file." + excludeString + ".txt");
                    writer.newLine();
                    writer.write(exclude);
                    writer.newLine();
                    writer.newLine();
                    if (AnalyzerHelper.isEmpty(excludedFiles)) continue;
                    Iterator excluded = excludedFiles.iterator();
                    while (excluded.hasNext()) {
                        writer.write((String)excluded.next());
                        writer.newLine();
                    }
                }
            }
            catch (IOException excludeTypes) {
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException excludeTypes) {}
            }
            String message = Message.format((String)RB.getStringResource("report.warning.file.execuded.fmt"), (Object)fileName);
            if (this.cDataMigHelper.itemStorePresent()) {
                message = RB.getStringResource("report.info.itemstore.found.txt");
            }
        }
        this.reportCPORTErrors();
    }

    private void reportMigratedItems() {
        if (!AnalyzerHelper.isEmpty(this.migratedItems)) {
            Iterator<String> itr = this.migratedItems.keySet().iterator();
            String dir = null;
            List<String> migratedFiles = null;
            while (itr.hasNext()) {
                dir = itr.next();
                migratedFiles = this.migratedItems.get(dir);
                AnalyzerHelper.log("List of migrated files for dir " + dir, 4);
                for (int j = 0; j < migratedFiles.size(); ++j) {
                    if (!(migratedFiles.get(j) instanceof String)) continue;
                    AnalyzerHelper.log(migratedFiles.get(j), 4);
                }
            }
        }
    }

    private void reportCPORTErrors() {
        DataMigratorHelper.CPORTExecutionResult cportResults = this.cDataMigHelper.getCOPRTExecutionResult();
        String directory = null;
        String logFile = null;
        String logFilePath = null;
        String cportMessage = null;
        File errorLogFile = null;
        if (cportResults.errorsOccured()) {
            List erroredDirs = cportResults.getErrorDirectories();
            for (int index = 0; index < erroredDirs.size(); ++index) {
                directory = (String)erroredDirs.get(index);
                logFile = cportResults.getLogFilePath(directory);
                errorLogFile = new File(logFile);
                logFilePath = this.getOutputDirectory() + File.separator + "logs" + File.separator + cportResults.getLogFileName(directory);
                try {
                    FileUtils.copyFile((File)errorLogFile, (File)new File(logFilePath));
                }
                catch (IOException exception) {
                    AnalyzerHelper.log(exception.getMessage(), 0);
                }
                cportMessage = Message.format((String)RB.getStringResource("report.warning.cport.execute.errors.fmt"), (Object[])new String[]{directory, logFilePath});
            }
        }
    }
}

