/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.migration.core;

import com.sas.apps.content.migration.core.ContentExporter;
import com.sas.apps.content.migration.core.RB;
import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.export.common.ConfigItems;
import com.sas.apps.content.migration.utils.Constants;
import com.sas.text.Message;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.listener.CommonsLoggingListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContentExportScriptBuilder {
    private static ContentExportScriptBuilder cIinstance;
    private String cOutputDirectory;
    private static String cProductName;
    private ContentExporter cContentExporter;
    private Document cBuildScript = null;
    private static final String cBuildFileName = "build_cmu.xml";
    private static final String EXECUTE_TASK_NAME = "Execute";
    private static final String ANT_CONTRIBXML_PATH = "net/sf/antcontrib/antlib.xml";
    private static final String PROPERTIES_FILE = "_Configuration.properties";
    private static final String EXCLUDE_NAME_METACHAR = "**";
    private int zippedIndex = 1;

    private ContentExportScriptBuilder(ContentExporter contentExporter) {
        this.cContentExporter = contentExporter;
        ContentExportScriptBuilder contentExportScriptBuilder = this;
        this.cOutputDirectory = contentExportScriptBuilder.cContentExporter.getProperties().getProperty("cmu.package.dir");
        cProductName = this.cContentExporter.getProductName();
        this.init();
    }

    public static ContentExportScriptBuilder getContentExportExecutorInstance(ContentExporter contentExporter) {
        cIinstance = new ContentExportScriptBuilder(contentExporter);
        return cIinstance;
    }

    private static boolean createNewInstance() {
        return cIinstance == null;
    }

    private void init() {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.cBuildScript = docBuilder.newDocument();
            this.cBuildScript.setDocumentURI(this.cOutputDirectory);
        }
        catch (ParserConfigurationException exception) {
            AnalyzerHelper.log(exception);
        }
    }

    public void runExport() {
        this.createBuildFile();
        this.executeBuild();
    }

    private void createBuildFile() {
        Node scriptRoot = this.createProject();
        this.cBuildScript.appendChild(scriptRoot);
        if (this.cContentExporter != null) {
            scriptRoot.appendChild(this.createTaskDef());
        }
        scriptRoot.appendChild(this.createTarget());
        this.storeDocument();
    }

    private void executeBuild() {
        File buildFile = new File(this.cOutputDirectory, cBuildFileName);
        CommonsLoggingListener logListener = new CommonsLoggingListener();
        Project p = new Project();
        p.addBuildListener((BuildListener)logListener);
        p.fireBuildStarted();
        p.setUserProperty("ant.file", buildFile.getAbsolutePath());
        p.init();
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        p.addReference("ant.projectHelper", (Object)helper);
        helper.parse(p, (Object)buildFile);
        p.executeTarget(p.getDefaultTarget());
        p.fireBuildFinished(null);
    }

    private void clearContextDirs(Node target) {
        HashMap<String, String> filesetAttrib = new HashMap<String, String>();
        filesetAttrib.put("dir", ".");
        filesetAttrib.put("excludes", "*.xml, *.log, packagedFiles/**");
        Node filsestNode = this.createNode("fileset", filesetAttrib);
        HashMap<String, String> deleteAttrib = new HashMap<String, String>();
        deleteAttrib.put("includeemptydirs", "true");
        Node deleteNode = this.createNode("delete", deleteAttrib);
        deleteNode.appendChild(filsestNode);
        target.appendChild(deleteNode);
    }

    private Node createProject() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", cProductName);
        attributes.put("default", EXECUTE_TASK_NAME);
        attributes.put("basedir", ".");
        return this.createNode("project", attributes);
    }

    private Node createNode(String nodeName, Map<String, String> attributes) {
        Element node = this.cBuildScript.createElement(nodeName);
        String attribName2 = null;
        String attribValue = null;
        if (attributes != null && attributes.size() > 0) {
            for (String attribName2 : attributes.keySet()) {
                attribValue = attributes.get(attribName2);
                node.setAttribute(attribName2, attribValue);
            }
        }
        return node;
    }

    private void storeDocument() {
        try {
            Transformer xmlGenerator = TransformerFactory.newInstance().newTransformer();
            xmlGenerator.setOutputProperty("method", "xml");
            DOMSource xmlSource = new DOMSource(this.cBuildScript);
            String filePath = this.cOutputDirectory;
            File executeFile = this.getExecuteScriptFile(filePath);
            if (executeFile != null) {
                StreamResult xmlDestination = new StreamResult(executeFile.toURI().toString());
                xmlGenerator.transform(xmlSource, xmlDestination);
            }
        }
        catch (TransformerConfigurationException exception) {
            AnalyzerHelper.log(exception);
        }
        catch (TransformerException exception) {
            AnalyzerHelper.log(exception);
        }
    }

    private File getExecuteScriptFile(String filePath) {
        File xmlFile = null;
        try {
            xmlFile = new File(filePath, cBuildFileName);
            if (!xmlFile.exists()) {
                xmlFile.createNewFile();
            }
        }
        catch (Exception exception) {
            AnalyzerHelper.log(exception);
        }
        return xmlFile;
    }

    private Node createTaskDef() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("resource", ANT_CONTRIBXML_PATH);
        Node taskDefRoot = this.createNode("taskdef", attributes);
        return taskDefRoot;
    }

    private Node createTarget() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", EXECUTE_TASK_NAME);
        attributes.put("description", "execute migration");
        Node target = this.createNode("target", attributes);
        if (this.cContentExporter != null) {
            this.clearContextDirs(target);
            target.appendChild(this.createEcho("Copying configuration files"));
            this.appendMakeContextDirNode(target);
            this.createPropertyFileNodes(target);
            this.createCommonPropertiesFile(target);
            this.createCopyConfigItemsNode(target);
        }
        return target;
    }

    private Node createNode(String nodeName, String attribute, String attributeValue) {
        Element node = this.cBuildScript.createElement(nodeName);
        node.setAttribute(attribute, attributeValue);
        return node;
    }

    private void appendMakeContextDirNode(Node target) {
        Map<String, String> servers = this.cContentExporter.getComponentNames();
        String serverName2 = null;
        String migAppRoot = this.cOutputDirectory;
        if (!AnalyzerHelper.isEmpty(servers)) {
            for (String serverName2 : servers.values()) {
                File contextRoot = new File(migAppRoot, serverName2);
                target.appendChild(this.createDirectory(contextRoot.getPath()));
            }
        }
    }

    private Node createEcho(String message) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("message", message);
        return this.createNode("echo", attributes);
    }

    private void createPropertyFileNodes(Node target) {
        Map<String, Map<String, String>> properties = this.cContentExporter.getComponentProperties();
        Node serverProperty = null;
        String serverName = null;
        if (properties != null && properties.size() > 0) {
            Iterator<String> keys = properties.keySet().iterator();
            Map<String, String> componentsName = this.cContentExporter.getComponentNames();
            String serverDirName = null;
            if (keys != null) {
                while (keys.hasNext()) {
                    serverName = keys.next();
                    serverDirName = componentsName.get(serverName);
                    serverProperty = this.createPropertyFileNode(serverDirName, properties.get(serverName));
                    target.appendChild(serverProperty);
                }
            }
        }
    }

    private void createCommonPropertiesFile(Node target) {
        Map<String, String> properties = this.cContentExporter.getCommonProperties();
        if (properties != null) {
            Constants.logger.info(RB.getStringResource("scriptbuilder.objectspawner.file.node.created.txt"));
            target.appendChild(this.createPropertyFileNode(null, properties));
        } else {
            Constants.logger.info(RB.getStringResource("scriptbuilder.objectspawner.prop.map.notfound.txt"));
        }
    }

    private Node createPropertyFileNode(String serverName, Map properties) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Node propertiesNode = null;
        String propName2 = null;
        String propValue = null;
        String outDir = null;
        String propsFile = null;
        if (serverName != null) {
            outDir = this.cOutputDirectory + File.separator + serverName;
            propsFile = serverName + PROPERTIES_FILE;
        } else {
            outDir = this.cOutputDirectory;
            propsFile = "cmu_common.properties";
        }
        File propertiesFile = new File(outDir, propsFile);
        String fileName = propertiesFile.getPath();
        attributes.put("file", fileName);
        propertiesNode = this.createNode("propertyfile", attributes);
        Constants.logger.info(Message.format((String)RB.getStringResource("scriptbuilder.prop.file.node.created.fmt"), (Object)fileName));
        for (String propName2 : properties.keySet()) {
            propValue = (String)properties.get(propName2);
            propertiesNode.appendChild(this.createEntryNode(propName2, propValue));
        }
        return propertiesNode;
    }

    private Node createFileCopyNode(String source, String destination, boolean isDirectory, List excludeList) {
        Node copyNode = null;
        HashMap<String, String> attributes = new HashMap<String, String>();
        String copy = isDirectory ? "dir" : "file";
        attributes.put("todir", destination);
        attributes.put("failonerror", "false");
        copyNode = this.createNode("copy", attributes);
        attributes.clear();
        attributes.put(copy, source);
        Node fileSet = this.createNode("fileset", attributes);
        if (isDirectory && excludeList != null) {
            this.appendExcludeNode(fileSet, excludeList);
        }
        copyNode.appendChild(fileSet);
        return copyNode;
    }

    private void appendExcludeNode(Node fileSet, List excludeList) {
        String excludeItem = null;
        String excludeString = null;
        for (int index = 0; index < excludeList.size(); ++index) {
            excludeItem = (String)excludeList.get(index);
            excludeString = EXCLUDE_NAME_METACHAR + File.separator + excludeItem + File.separator + EXCLUDE_NAME_METACHAR;
            fileSet.appendChild(this.createNode("exclude", "name", excludeString));
        }
    }

    public void createCopyConfigItemsNode(Node parent) {
        ConfigItems configItems = this.cContentExporter.getConfigItems();
        Map<String, String> componentNames = this.cContentExporter.getComponentNames();
        if (!AnalyzerHelper.isEmpty(componentNames) && configItems != null) {
            Iterator<String> keys = componentNames.keySet().iterator();
            String componentName = null;
            List configItem = null;
            List rootConfigs = configItems.getConfigItems();
            if (!AnalyzerHelper.isEmpty(rootConfigs)) {
                this.createCopyConfigItemsNode(parent, rootConfigs, null, "levdata", configItems);
            }
            while (keys.hasNext()) {
                componentName = keys.next();
                String outDirName = componentNames.get(componentName);
                configItem = configItems.getConfigItems(componentName);
                this.createCopyConfigItemsNode(parent, configItem, componentName, outDirName, configItems);
            }
        }
    }

    private void createCopyConfigItemsNode(Node parent, List configItem, String componentName, String outDirName, ConfigItems configItems) {
        String config = null;
        Node fileCopy = null;
        Node makeDir = null;
        String configDirName = null;
        boolean isDirectory = false;
        String configSubDir = null;
        List excludeList = null;
        boolean compress = false;
        String relativeDestination = null;
        if (!AnalyzerHelper.isEmpty(configItem)) {
            for (int index = 0; index < configItem.size(); ++index) {
                config = (String)configItem.get(index);
                compress = configItems.compress(componentName, config);
                relativeDestination = configItems.getRelativeDestination(componentName, config);
                if (!AnalyzerHelper.isEmpty(relativeDestination)) {
                    configSubDir = outDirName != null ? File.separator + outDirName + File.separator : File.separator;
                    configDirName = this.cOutputDirectory + configSubDir + relativeDestination;
                    makeDir = this.createDirectory(configDirName);
                    parent.appendChild(makeDir);
                    isDirectory = AnalyzerHelper.isDirectory(config);
                } else {
                    isDirectory = AnalyzerHelper.isDirectory(config);
                    if (isDirectory) {
                        configSubDir = outDirName != null ? File.separator + outDirName + File.separator : File.separator;
                        configDirName = this.cOutputDirectory + configSubDir + AnalyzerHelper.parseConfigItemName(config);
                        makeDir = this.createDirectory(configDirName);
                        parent.appendChild(makeDir);
                    } else {
                        configDirName = this.cOutputDirectory + (outDirName != null ? File.separator + outDirName : "");
                    }
                }
                if (isDirectory) {
                    excludeList = componentName != null ? configItems.getExcludeConfigItem(componentName, config) : configItems.getRootExcludeConfigItem(config);
                }
                if (!compress) {
                    fileCopy = this.createFileCopyNode(config, configDirName, isDirectory, excludeList);
                    parent.appendChild(fileCopy);
                } else {
                    List zippedItems = configItems.getZippedConfigItems(componentName, config);
                    this.processZippedItems(config, configDirName, isDirectory, zippedItems, parent);
                }
                configDirName = null;
            }
        }
    }

    private void processZippedItems(String config, String configDirName, boolean isDirectory, List zippedItems, Node parent) {
        Node zippedNode = null;
        if (!AnalyzerHelper.isEmpty(zippedItems)) {
            for (int index = 0; index < zippedItems.size(); ++index) {
                Node echoNode;
                ConfigItems.ZippedConfigItem zippedItem = (ConfigItems.ZippedConfigItem)zippedItems.get(index);
                List excludeList = zippedItem.getExcludeList();
                List includeList = zippedItem.getIncludeList();
                String prefix = zippedItem.getPrefix();
                String relDestination = zippedItem.getRelativeDestination();
                if (relDestination != null) {
                    parent.appendChild(this.createDirectory(configDirName + File.separator + relDestination));
                }
                if ((echoNode = this.createEchoNode("Creating zip for " + config)) != null) {
                    parent.appendChild(echoNode);
                }
                if ((zippedNode = this.createZipFileNode(config, configDirName, isDirectory, excludeList, includeList, prefix, relDestination)) == null) continue;
                parent.appendChild(zippedNode);
            }
        }
    }

    private Node createEchoNode(String message) {
        Node echoNode = null;
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("message", message);
        echoNode = this.createNode("echo", attributes);
        return echoNode;
    }

    private String getExcludeList(List excludeList, File baseDir) {
        StringBuffer excludes = new StringBuffer();
        String itemName = null;
        File itemFile = null;
        if (!AnalyzerHelper.isEmpty(excludeList)) {
            for (int index = 0; index < excludeList.size(); ++index) {
                itemName = (String)excludeList.get(index);
                if (itemName == null) continue;
                excludes.append(itemName.replaceAll("\\s+", "?"));
                itemFile = new File(baseDir, itemName);
                if (itemFile.isDirectory()) {
                    excludes.append(File.separator + EXCLUDE_NAME_METACHAR);
                }
                excludes.append(",");
            }
            if (excludes.length() > 0) {
                excludes.deleteCharAt(excludes.length() - 1);
            }
        }
        return excludes.toString();
    }

    private Node createZipFileNode(String config, String configDirName, boolean isDirectory, List excludeList, List includeList, String prefix, String relDestination) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        String excludes = null;
        String destFileName = null;
        Node zipNode = null;
        File configFile = new File(config);
        String destDir = null;
        Constants.logger.info("Creating Zip file node for: " + config + " " + configDirName);
        if (isDirectory && configDirName != null) {
            destFileName = Math.abs(config.hashCode()) + String.valueOf(this.zippedIndex) + "Cab.zip";
            ++this.zippedIndex;
            destDir = configDirName + (relDestination != null ? File.separator + relDestination : "");
            attributes.put("destfile", destDir + File.separator + destFileName);
            zipNode = this.createNode("zip", attributes);
            attributes.clear();
            attributes.put("dir", config);
            if (prefix != null) {
                attributes.put("prefix", prefix);
            }
            int hashConfigDir = configDirName.hashCode();
            excludes = ContentExportScriptBuilder.createIncludesFile(excludeList, configFile, "ExcludesList" + hashConfigDir);
            if (!AnalyzerHelper.isEmpty(excludes)) {
                Constants.logger.debug("Files excluded from ZIP : " + excludes);
                attributes.put("excludesFile", excludes);
            }
            String includes = ContentExportScriptBuilder.createIncludesFile(includeList, configFile, "IncludesList" + hashConfigDir);
            if (!AnalyzerHelper.isEmpty(includeList)) {
                Constants.logger.debug("Files included in ZIP : " + includeList);
                attributes.put("includesFile", includes);
            }
            Node zipFileSetNode = this.createNode("zipfileset", attributes);
            zipNode.appendChild(zipFileSetNode);
        }
        return zipNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createIncludesFile(List listIncludes, File baseDir, String name) {
        File includesFile = null;
        BufferedWriter includesFileWriter = null;
        String itemName = null;
        File itemFile = null;
        String includes = null;
        boolean isFileExist = true;
        try {
            try {
                includesFile = File.createTempFile(name, ".tmp");
            }
            catch (Exception e) {
                File tempFolder = new File(".", "Temp" + File.separator + "CMUTemp");
                tempFolder.mkdirs();
                includesFile = File.createTempFile(name, ".tmp", tempFolder);
            }
            includesFile.deleteOnExit();
            includesFileWriter = new BufferedWriter(new FileWriter(includesFile));
            if (!AnalyzerHelper.isEmpty(listIncludes)) {
                for (int index = 0; index < listIncludes.size(); ++index) {
                    itemName = (String)listIncludes.get(index);
                    if (itemName == null) continue;
                    includes = itemName.replaceAll("\\s+", "?");
                    itemFile = new File(baseDir, itemName);
                    if (itemFile.isDirectory()) {
                        includes = includes + File.separator + EXCLUDE_NAME_METACHAR;
                    }
                    includesFileWriter.write(includes);
                    includesFileWriter.newLine();
                }
            }
        }
        catch (IOException ioex) {
            AnalyzerHelper.log(ioex);
        }
        finally {
            if (includesFileWriter != null) {
                try {
                    includesFileWriter.close();
                }
                catch (IOException ioex) {
                    AnalyzerHelper.log(ioex);
                }
            }
        }
        return includesFile.getAbsolutePath();
    }

    private Node createEntryNode(String name, String value) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("key", name);
        attributes.put("value", value);
        return this.createNode("entry", attributes);
    }

    private Node createDirectory(String name) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("dir", name);
        return this.createNode("mkdir", attributes);
    }

    public void addExternalConfigItems(String source) {
    }
}

