/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.analyze.core;

public class DataSource {
    private String directory;
    private String includePattern;
    private String excludePattern;
    private boolean migrationPermission;
    private boolean migrateCatalog;

    public boolean migrateCatalog() {
        return this.migrateCatalog;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getIncludePattern() {
        return this.includePattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public boolean migrationPermission() {
        return this.migrationPermission;
    }

    private DataSource(DataSourceBuilder dsBuilder) {
        this.directory = dsBuilder.directory;
        this.includePattern = dsBuilder.includePattern;
        this.excludePattern = dsBuilder.excludePattern;
        this.migrationPermission = dsBuilder.migrationPermission;
        this.migrateCatalog = dsBuilder.migrateCatalog;
    }

    public static class DataSourceBuilder {
        private String directory;
        private String includePattern;
        private String excludePattern;
        private boolean migrationPermission;
        private boolean migrateCatalog;
        private StringBuffer excludeBuff = new StringBuffer();
        private StringBuffer includeBuff = new StringBuffer();
        private String sep1 = "";
        private String sep2 = "";

        public DataSourceBuilder(String sourceDir) {
            this.directory = sourceDir;
        }

        public DataSourceBuilder includes(String includePattern) {
            if (this.includeBuff != null && this.includeBuff.length() >= 1) {
                this.sep1 = ",";
                this.includeBuff.append(this.sep1).append(includePattern);
            } else {
                this.includeBuff.append(this.sep1).append(includePattern);
                this.sep1 = ",";
            }
            this.includePattern = this.includeBuff.toString();
            return this;
        }

        public DataSourceBuilder excludes(String excludePattern) {
            if (this.excludeBuff != null && this.excludeBuff.length() >= 1) {
                this.sep2 = ",";
                this.excludeBuff.append(this.sep2).append(excludePattern);
            } else {
                this.excludeBuff.append(this.sep2).append(excludePattern);
                this.sep2 = ",";
            }
            this.excludePattern = this.excludeBuff.toString();
            return this;
        }

        public DataSource build() {
            return new DataSource(this);
        }

        public DataSourceBuilder migratePermission(boolean migrationPermission) {
            this.migrationPermission = migrationPermission;
            return this;
        }

        public DataSourceBuilder migrateCatalog(boolean migrateCatalog) {
            this.migrateCatalog = migrateCatalog;
            return this;
        }
    }
}

