/*
 * Decompiled with CFR 0.152.
 */
package com.sas.apps.content.analyze.core;

import com.sas.apps.content.analyze.core.AnalysisResult;
import com.sas.apps.content.analyze.core.DataMigratorInterface;
import com.sas.apps.content.analyze.core.DataSource;
import com.sas.apps.content.analyze.core.ExcludeType;
import com.sas.apps.content.analyze.core.MigrationException;
import com.sas.apps.content.migration.core.ContentMigrationAdapter;
import com.sas.apps.content.migration.core.ContentMigrationException;
import com.sas.apps.content.migration.core.ContentMigrationFramework;
import com.sas.apps.content.migration.export.common.AnalyzerHelper;
import com.sas.apps.content.migration.export.common.DataMigratorHelper;
import com.sas.apps.content.migration.export.common.Directory;
import com.sas.apps.content.migration.utils.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationBuilder;
import org.apache.tools.ant.Project;

public class DataMigratorImpl
implements DataMigratorInterface {
    private static final int ERROR = -1;
    private Project project = new Project();

    public static DataMigratorInterface getSMUDataMigrator(Project proj) {
        return new DataMigratorImpl(proj);
    }

    public DataMigratorImpl(Project proj) {
        this.project = proj;
    }

    @Override
    public AnalysisResult anaylze(DataSource source) throws MigrationException {
        DataMigratorHelper cDataMigHelper = null;
        Directory dataDir = null;
        HashMap<ExcludeType, List<String>> result = new HashMap<ExcludeType, List<String>>();
        AnalysisResult analysisResult = new AnalysisResult();
        List softLinkList = new ArrayList();
        List unaccessableList = new ArrayList();
        cDataMigHelper = DataMigratorHelper.getInstance(0L);
        String srcDirSet = source.getDirectory();
        dataDir = Directory.getDirectoryInstance(srcDirSet);
        if (dataDir != null) {
            analysisResult.setSize(dataDir.getRootOnlySize());
            softLinkList = dataDir.getSoftLinks();
            unaccessableList = dataDir.getUnaccessibleFileList();
        }
        if (softLinkList != null && softLinkList.size() >= 1) {
            result.put(ExcludeType.SYMLINK, softLinkList);
        }
        if (unaccessableList != null && unaccessableList.size() >= 1) {
            result.put(ExcludeType.UNACCSIBLE, unaccessableList);
        }
        if (result != null) {
            analysisResult.setResult(result);
        }
        return analysisResult;
    }

    @Override
    public void export(DataSource dataSource, File target) throws MigrationException {
        ContentMigrationFramework framework = new ContentMigrationFramework();
        this.getEnvironment(framework, target);
        Properties properties = new Properties();
        String userExclude = null;
        String userInclude = null;
        if (dataSource != null && target != null) {
            userExclude = dataSource.getExcludePattern();
            userInclude = dataSource.getIncludePattern();
            properties.setProperty("cmu.base.dir", this.project.getProperty("config.lev.dir"));
            properties.setProperty("cmu.source.dirs", dataSource.getDirectory());
            if (dataSource.migrationPermission()) {
                properties.setProperty("source.dir.permission.migration", "true");
            } else {
                properties.setProperty("source.dir.permission.migration", "false");
            }
            if (dataSource.migrateCatalog()) {
                properties.setProperty("source.dir.catalog.migration", "true");
            } else {
                properties.setProperty("source.dir.catalog.migration", "false");
            }
            try {
                properties.setProperty("cmu.package.dir", target.getCanonicalPath());
            }
            catch (IOException e) {
                AnalyzerHelper.log(e);
            }
            properties.setProperty("cmu.migration.mode", "export");
            properties.setProperty("cmu.sasroot", this.project.getProperty("SMU.SASROOT"));
            if (userExclude != null && !userExclude.equals("")) {
                AnalyzerHelper.log("User exclude pattern : " + userExclude, 2);
                properties.setProperty("cmu.exclude.filter", userExclude);
            }
            if (userInclude != null && !userInclude.equals("")) {
                AnalyzerHelper.log("User include pattern : " + userInclude, 2);
                properties.setProperty("cmu.include.filter", userInclude);
            }
        } else {
            Constants.logger.info("Required property missing");
        }
        if (properties != null && !properties.isEmpty()) {
            ContentMigrationAdapter adapter = new ContentMigrationAdapter();
            try {
                adapter.migrateContents(properties);
            }
            catch (ContentMigrationException e) {
                AnalyzerHelper.log(e);
            }
        } else {
            Constants.logger.error("Required properties not provided so not able to create package");
        }
    }

    @Override
    public void importData(File packageDir, File destination) throws MigrationException {
        ContentMigrationFramework framework = new ContentMigrationFramework();
        File logDest = new File(destination, "Logs");
        this.getEnvironment(framework, logDest);
        Properties properties = new Properties();
        if (destination != null && packageDir != null) {
            properties.setProperty("config.xml.dir.path", this.project.getProperty("cfgwizard.install.dir"));
            properties.setProperty("deploywizard.groovy.path", this.project.getProperty("default.groovy.path"));
            try {
                properties.setProperty("cmu.package.dir", packageDir.getCanonicalPath());
                properties.setProperty("cmu.target.dir", destination.getCanonicalPath());
            }
            catch (IOException e) {
                AnalyzerHelper.log(e);
            }
            properties.setProperty("cmu.migration.mode", "import");
            if (this.project.getProperty("changeSourceDirectoryStructure") != null && !this.project.getProperty("changeSourceDirectoryStructure").equals("")) {
                properties.setProperty("changeSourceDirectoryStructure", this.project.getProperty("changeSourceDirectoryStructure"));
            }
        } else {
            Constants.logger.info("Required property missing");
        }
        if (properties != null && !properties.isEmpty()) {
            ContentMigrationAdapter adapter = new ContentMigrationAdapter();
            try {
                adapter.migrateContents(properties);
            }
            catch (ContentMigrationException e) {
                AnalyzerHelper.log(e);
            }
        } else {
            Constants.logger.error("Required properties not provided so not able to import package");
        }
    }

    public void getEnvironment(ContentMigrationFramework framework, File destination) {
        File packageDir = null;
        try {
            String dirString = destination.getCanonicalPath();
            if (dirString == null) {
                Constants.logger.error("The migration package output directory is required.");
                System.exit(-1);
            }
            if (!(packageDir = new File(dirString)).isAbsolute()) {
                Constants.logger.error("An absolute path for the package directory is required.");
                System.exit(-1);
            }
            if (!packageDir.exists() && !packageDir.mkdirs()) {
                Constants.logger.error("The metadata host provided, " + packageDir.getAbsolutePath() + " is not a known host name.  Please correct and re-run the utility.");
                System.exit(-1);
            }
            this.configureLog4j(null, null, framework);
            framework.setOutputDirectory(packageDir);
            Properties logProp = framework.makeLog4jProperties();
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration oldConfiguration = ctx.getConfiguration();
            if (oldConfiguration.getAppender("File") == null) {
                PropertiesConfiguration newConfiguration = new PropertiesConfigurationBuilder().setRootProperties(logProp).setLoggerContext(ctx).build();
                ArrayList composites = new ArrayList((Configuration)newConfiguration, oldConfiguration){
                    final /* synthetic */ Configuration val$newConfiguration;
                    final /* synthetic */ Configuration val$oldConfiguration;
                    {
                        this.val$newConfiguration = configuration;
                        this.val$oldConfiguration = configuration2;
                        this.add(this.val$newConfiguration);
                        this.add(this.val$oldConfiguration);
                    }
                };
                CompositeConfiguration composite = new CompositeConfiguration((List)composites);
                composite.reconfigure();
                ctx.start((Configuration)composite);
            }
            Constants.logger.info("Content Migration Utility version 9.3-1.0");
        }
        catch (IOException e) {
            AnalyzerHelper.log(e);
        }
    }

    public void configureLog4j(String propPath, String outputPath, ContentMigrationFramework framework) {
        Properties results = new Properties();
        Object migrateLog = null;
        if (propPath != null) {
            File propFile = new File(propPath);
            if (propFile.exists()) {
                try {
                    FileInputStream fis = new FileInputStream(propFile);
                    results.load(fis);
                    fis.close();
                }
                catch (IOException iOException) {}
            } else {
                AnalyzerHelper.log("The log4j properties file you specified does not exist.", 2);
                this.loadDefaultLog4JProperties(results);
            }
        } else {
            this.loadDefaultLog4JProperties(results);
        }
        if (migrateLog != null) {
            results.put("log4j.appender.logfile.File", (Object)migrateLog);
            results.put("log4j.logger.CMULOG", "debug, logfile");
        }
        if (framework != null) {
            framework.setLogProperties(results);
        }
    }

    private void loadDefaultLog4JProperties(Properties prop) {
        prop.put("appender.SAS_CONSOLE.type", "Console");
        prop.put("appender.SAS_CONSOLE.name", "STDOUT");
        prop.put("appender.SAS_CONSOLE.layout.type", "PatternLayout");
        prop.put("appender.SAS_CONSOLE.layout.pattern", "%d{ABSOLUTE} [%-6.6p] %c  %m%n");
        prop.put("appender.SAS_FILE.type", "Null");
        prop.put("appender.SAS_FILE.name", "File");
        prop.put("rootLogger.level", "ERROR");
        prop.put("rootLogger.appenderRefs", "SAS_CONSOLE");
        prop.put("rootLogger.appenderRef.console.ref", "STDOUT");
        prop.put("logger.CMU.name", "CMU");
        prop.put("logger.CMU.level", "DEBUG");
        prop.put("logger.CMU.appenderRefs", "SAS_CONSOLE");
        prop.put("logger.CMU.appenderRef.SAS_CONSOLE.ref", "STDOUT");
        prop.put("logger.comsasssn.name", "com.sas.ssn");
        prop.put("logger.comsasssn.level", "TRACE");
        prop.put("logger.comsasssn.appenderRefs", "SAS_CONSOLE");
        prop.put("logger.comsasssn.appenderRef.SAS_CONSOLE.ref", "STDOUT");
        prop.put("logger.CMULOG.name", "CMULOG");
        prop.put("logger.CMULOG.additivity", "false");
        prop.put("logger.CMULOG.level", "DEBUG");
        prop.put("logger.CMULOG.appenderRefs", "SAS_FILE");
        prop.put("logger.CMULOG.appenderRef.SAS_FILE.ref", "File");
    }
}

