/*
 * Decompiled with CFR 0.152.
 */
package MITI.summary;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.messages.MIRSummaryUtil.SUMMY;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRStructuralFeature;
import MITI.sdk.mix.MIRObjectCache;
import MITI.summary.SummaryExpression;
import MITI.summary.SummaryExpressionPrinter;
import java.util.TreeMap;

public abstract class Summarizer {
    protected MIRObjectCache cache;
    protected TreeMap<MIRFeature, SummaryExpression> featureSummaries = new TreeMap();
    private SummaryExpressionPrinter printer = new SummaryExpressionPrinter(this.featureSummaries);
    public static final String[] OPERATION_CHARACTERS = new String[]{" ", ".", "+", "-", "*", "/"};

    public Summarizer(MIRObjectCache mIRObjectCache, boolean bl) {
        this.cache = mIRObjectCache;
    }

    public static String quoteIfContainsChar(String string, String[] stringArray, String string2, String string3) {
        int n;
        if (!(string = string.trim()).startsWith(string2) || !string.endsWith(string3)) {
            for (n = 0; n < string.length(); ++n) {
                if (n != 0 ? Character.isJavaIdentifierPart(string.charAt(n)) : Character.isJavaIdentifierStart(string.charAt(n))) continue;
                string = string2 + string + string3;
                break;
            }
        }
        if (!string.startsWith(string2) || !string.endsWith(string3)) {
            for (n = 0; n < stringArray.length; ++n) {
                if (!string.contains(stringArray[n])) continue;
                string = string2 + string + string3;
                break;
            }
        }
        return string;
    }

    protected String makeNameSafe(String string) {
        return Summarizer.quoteIfContainsChar(string, OPERATION_CHARACTERS, "\"", "\"");
    }

    public String buildSummaryExpression(MIRFeature mIRFeature) throws MIRException {
        return this.buildSummaryExpression(mIRFeature, false);
    }

    public String buildSummaryExpression(MIRFeature mIRFeature, boolean bl) throws MIRException {
        SummaryExpression summaryExpression = this.featureSummaries.get(mIRFeature);
        if (summaryExpression != null) {
            return summaryExpression.getExpression();
        }
        if (mIRFeature.getDestinationOfFeatureMaps().size() > 0) {
            for (MIRFeatureMap mIRFeatureMap : mIRFeature.getDestinationOfFeatureMaps()) {
                SummaryExpression summaryExpression2 = new SummaryExpression("([expression is too complext or refers to itself])", false, false);
                this.featureSummaries.put(mIRFeature, summaryExpression2);
                for (MIRFeature mIRFeature2 : mIRFeatureMap.getSourceFeatures()) {
                    this.buildSummaryExpression(mIRFeature2, bl);
                }
                for (MIRFeature mIRFeature2 : mIRFeatureMap.getControlFeatures()) {
                    this.buildSummaryExpression(mIRFeature2, bl);
                }
                Object object = "";
                boolean bl2 = false;
                boolean bl3 = false;
                if (mIRFeatureMap.getOperation().isEmpty() && mIRFeatureMap.getSourceFeatureCount() == 1 && (mIRFeatureMap.getExpression() == null || mIRFeatureMap.getExpression().getStatementNodeCount() < 1 || mIRFeatureMap.getExpression().getStatementNodes().first().getReferencedExpressionNodeCount() == 0)) {
                    if (this.featureSummaries.get(mIRFeatureMap.getSourceFeatures().first()) == null) {
                        throw new MIRException(SUMMY.ERR_MISSED_FEATURE_WHILE_CALCULATING_SUMMARY.getMessage(mIRFeatureMap.getSourceFeatures().first().getPath()));
                    }
                    SummaryExpression summaryExpression3 = this.featureSummaries.get(mIRFeatureMap.getSourceFeatures().first());
                    object = summaryExpression3.getExpression();
                    bl2 = summaryExpression3.isPassThrough();
                    bl3 = summaryExpression3.isAggregated();
                } else if (mIRFeatureMap.getExpression() != null) {
                    object = this.printer.convertExpression(mIRFeatureMap);
                    bl2 = this.printer.isSimple();
                    bl3 = this.printer.isAggregation();
                } else {
                    bl2 = true;
                    for (MIRFeature mIRFeature3 : mIRFeatureMap.getSourceFeatures()) {
                        SummaryExpression summaryExpression4 = this.featureSummaries.get(mIRFeature3);
                        if (summaryExpression4 == null || summaryExpression4.getExpression().isEmpty()) continue;
                        object = (String)object + (!((String)object).isEmpty() ? "," : "") + summaryExpression4.getExpression();
                        bl2 &= summaryExpression4.isPassThrough();
                        bl3 |= summaryExpression4.isAggregated();
                    }
                }
                if (((String)object).length() > 1000) {
                    object = "(" + ((String)object).substring(0, 100) + "... ..." + ((String)object).substring(((String)object).length() - 100, ((String)object).length()) + ")";
                }
                this.featureSummaries.put(mIRFeature, new SummaryExpression((String)object, bl2, bl3));
                summaryExpression2 = null;
            }
        } else if (this.featureSummaries.get(mIRFeature) == null) {
            String string;
            if (mIRFeature.isInstanceOf((short)99) && !((MIRStructuralFeature)mIRFeature).getInitialValue().isEmpty()) {
                string = ((MIRStructuralFeature)mIRFeature).getInitialValue();
            } else {
                String string2 = Summarizer.quoteIfContainsChar(MIRBridgeLib.getPhysicalName(mIRFeature.getClassifier()), OPERATION_CHARACTERS, "\"", "\"");
                String string3 = Summarizer.quoteIfContainsChar(MIRBridgeLib.getPhysicalName(mIRFeature), OPERATION_CHARACTERS, "\"", "\"");
                string = (bl ? string2 + "." : "") + string3;
            }
            this.featureSummaries.put(mIRFeature, new SummaryExpression(string, true, false));
        }
        if ((summaryExpression = this.featureSummaries.get(mIRFeature)) != null) {
            return summaryExpression.getExpression();
        }
        return "";
    }
}

