/*
 * Decompiled with CFR 0.152.
 */
package MITI.summary;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRTypeLib;
import MITI.bridges.bridgelib.MIRUdpLib;
import MITI.bridges.profiles.ProfileIds;
import MITI.lineage.links.ModelLineageAugmenter;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MIRSummaryUtil.SUMMY;
import MITI.sdk.MIRBaseType;
import MITI.sdk.MIRCallTransformation;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConcreteType;
import MITI.sdk.MIRCondition;
import MITI.sdk.MIRConnectedTransformation;
import MITI.sdk.MIRConnection;
import MITI.sdk.MIRConnectionDataAttribute;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRConnectionDataSet;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRDate;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDiDesignContent;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRDiRuntimeContent;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIREmbeddedCallStep;
import MITI.sdk.MIREmbeddedCallTransformation;
import MITI.sdk.MIREmbeddedTransformation;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRFolder;
import MITI.sdk.MIRFolderContent;
import MITI.sdk.MIRJoinCondition;
import MITI.sdk.MIRJoinRelationship;
import MITI.sdk.MIRJoinTransformation;
import MITI.sdk.MIRLineageSummaryContent;
import MITI.sdk.MIRLookupTransformation;
import MITI.sdk.MIRMappingModel;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespace;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRQueryColumn;
import MITI.sdk.MIRQueryJoin;
import MITI.sdk.MIRQueryTable;
import MITI.sdk.MIRSqlQuery;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIRStructuralFeature;
import MITI.sdk.MIRSummaryMap;
import MITI.sdk.MIRTransformation;
import MITI.sdk.MIRTransformationDataSet;
import MITI.sdk.MIRType;
import MITI.sdk.MIR_Object;
import MITI.sdk.mix.MIRMixCache;
import MITI.sdk.util.ObjectCollector;
import MITI.summary.Summarizer;
import MITI.summary.SummaryExpression;
import MITI.util.EscapedStringTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;

public class EtlSummarizer
extends Summarizer {
    public static final String SUMMARY_CONTENT_NAME = "Summary Content";
    public static final String SUMMARY_MODEL_NAME = "Summary Model";
    private MIRMixCache mixCache;
    private LinkedHashMap<MIRFeature, MIRConnectionDataAttribute> featureAttributes = new LinkedHashMap();
    private boolean printFullyQualifiedNames;

    public EtlSummarizer(MIRMixCache mIRMixCache, boolean bl) {
        super(mIRMixCache, bl);
        this.mixCache = mIRMixCache;
    }

    public int getModelProfileId(MIRModel mIRModel) {
        return ProfileIds.META_INTEGRATION;
    }

    public static byte addUsage(byte by, byte by2) {
        switch (by) {
            case 0: {
                switch (by2) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 2;
                    }
                }
                return 0;
            }
            case 1: {
                switch (by2) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                }
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        switch (by2) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return -1;
    }

    public static byte retUsage(MIRStoreConnection mIRStoreConnection) {
        return mIRStoreConnection.getSourceOfMappingModel() != null ? (mIRStoreConnection.getDestinationOfMappingModel() != null ? (byte)2 : 0) : (mIRStoreConnection.getDestinationOfMappingModel() != null ? (byte)1 : 0);
    }

    public static void ensureUsage(MIRStoreConnection mIRStoreConnection, byte by) {
        MIRObject mIRObject = mIRStoreConnection.getParent();
        if (mIRObject.isInstanceOf((short)80)) {
            MIRConnection mIRConnection;
            MIRContent mIRContent;
            MIRMappingModel mIRMappingModel = (MIRMappingModel)mIRObject;
            if ((by == 0 || by == 2) && mIRStoreConnection.getSourceOfMappingModel() == null) {
                mIRStoreConnection.addSourceOfMappingModel(mIRMappingModel);
            }
            if ((by == 1 || by == 2) && mIRStoreConnection.getDestinationOfMappingModel() == null) {
                mIRStoreConnection.addDestinationOfMappingModel(mIRMappingModel);
            }
            if ((mIRContent = mIRMappingModel.getContent()) != null && (mIRConnection = mIRContent.getClientOfConnection(mIRStoreConnection.getPhysicalName().isEmpty() ? mIRStoreConnection.getName() : mIRStoreConnection.getPhysicalName())) != null) {
                mIRConnection.setUsage(by == -1 ? (byte)0 : by);
            }
        }
    }

    public static byte detectUsage(byte by, MIRClassifier mIRClassifier) {
        if (mIRClassifier.isInstanceOf((short)254)) {
            MIRConnectionDataSet mIRConnectionDataSet = (MIRConnectionDataSet)mIRClassifier;
            MIRConnectedTransformation mIRConnectedTransformation = mIRConnectionDataSet.getConnectedTransformation();
            if (mIRConnectedTransformation != null) {
                if (mIRConnectedTransformation.isInstanceOf((short)251) || mIRConnectedTransformation.isInstanceOf((short)241)) {
                    by = EtlSummarizer.addUsage(by, (byte)0);
                } else if (mIRConnectedTransformation.isInstanceOf((short)260)) {
                    by = EtlSummarizer.addUsage(by, (byte)1);
                } else if (mIRConnectedTransformation.isInstanceOf((short)238)) {
                    for (MIRClassifierMap mIRClassifierMap : mIRConnectedTransformation.getClassifierMaps()) {
                        if (mIRClassifierMap.containsSourceClassifier(mIRConnectionDataSet)) {
                            by = EtlSummarizer.addUsage(by, (byte)0);
                            continue;
                        }
                        if (mIRClassifierMap.getDestinationClassifier() != mIRConnectionDataSet) continue;
                        by = EtlSummarizer.addUsage(by, (byte)1);
                    }
                }
            } else {
                if (mIRConnectionDataSet.getSourceOfClassifierMapCount() > 0 || mIRConnectionDataSet.getControlOfClassifierMapCount() > 0) {
                    by = EtlSummarizer.addUsage(by, (byte)0);
                }
                if (mIRConnectionDataSet.getDestinationOfClassifierMap() != null) {
                    by = EtlSummarizer.addUsage(by, (byte)1);
                }
            }
        } else if (mIRClassifier.isInstanceOf((short)243)) {
            MIRQueryTable mIRQueryTable = (MIRQueryTable)mIRClassifier;
            if (mIRQueryTable.getInputOfEmbeddedTransformation() != null || mIRQueryTable.getSourceOfClassifierMapCount() > 0) {
                by = EtlSummarizer.addUsage(by, (byte)0);
            }
            if (mIRQueryTable.getOutputOfEmbeddedTransformation() != null) {
                by = EtlSummarizer.addUsage(by, (byte)1);
            }
        }
        return by;
    }

    public static byte detectUsage(MIRStoreConnection mIRStoreConnection) throws MIRException {
        byte by = -1;
        ObjectCollector objectCollector = new ObjectCollector(new short[]{321});
        mIRStoreConnection.depthTraversal(objectCollector);
        for (MIRConnectionNamespace mIRConnectionDataPackage : objectCollector.getObjects()) {
            for (MIRNamespaceElement mIRNamespaceElement : mIRConnectionDataPackage.getNamespaceElements()) {
                if (!mIRNamespaceElement.isInstanceOf((short)75)) continue;
                by = EtlSummarizer.addUsage(by, EtlSummarizer.detectUsage(by, (MIRClassifier)mIRNamespaceElement));
            }
            for (MIRNamespaceElement mIRNamespaceElement : mIRConnectionDataPackage.getImportedNamespaceElements()) {
                if (!mIRNamespaceElement.isInstanceOf((short)75)) continue;
                by = EtlSummarizer.addUsage(by, EtlSummarizer.detectUsage(by, (MIRClassifier)mIRNamespaceElement));
            }
            for (MIRClassifier mIRClassifier : mIRConnectionDataPackage.getClassifiers()) {
                by = EtlSummarizer.addUsage(by, EtlSummarizer.detectUsage(by, mIRClassifier));
            }
        }
        for (MIRConnectionPackage mIRConnectionPackage : mIRStoreConnection.getConnectionPackages()) {
            for (MIRClassifier mIRClassifier : mIRConnectionPackage.getClassifiers()) {
                by = EtlSummarizer.addUsage(by, EtlSummarizer.detectUsage(by, mIRClassifier));
            }
            for (MIRNamespaceElement mIRNamespaceElement : mIRConnectionPackage.getNamespaceElements()) {
                if (!mIRNamespaceElement.isInstanceOf((short)75)) continue;
                by = EtlSummarizer.addUsage(by, EtlSummarizer.detectUsage(by, (MIRClassifier)mIRNamespaceElement));
            }
        }
        return by;
    }

    private static byte ensureSummaryUsage(MIRDirectoryStructureModel mIRDirectoryStructureModel, MIRStoreConnection mIRStoreConnection) {
        byte by = -1;
        MIRStoreContent mIRStoreContent = mIRDirectoryStructureModel.getConnectionStoreContent(mIRStoreConnection.getName());
        if (mIRStoreContent == null) {
            MIRConnection mIRConnection;
            MIRFolderContent mIRFolderContent = mIRDirectoryStructureModel.getFolderContent(mIRStoreConnection.getName());
            if (mIRFolderContent != null && mIRFolderContent.isInstanceOf((short)295)) {
                mIRStoreContent = (MIRStoreContent)mIRFolderContent;
            } else if (mIRStoreConnection.getRootModel().getContent() != null && (mIRConnection = mIRStoreConnection.getRootModel().getContent().getClientOfConnection(mIRStoreConnection.getName())) != null) {
                mIRStoreContent = mIRConnection.getSupplierStoreContent();
            }
        }
        if (mIRStoreContent != null) {
            for (MIRConnection mIRConnection : mIRStoreContent.getClientOfConnections()) {
                by = EtlSummarizer.addUsage(by, mIRConnection.getUsage());
            }
            for (MIRConnection mIRConnection : mIRStoreContent.getSupplierOfConnections()) {
                by = EtlSummarizer.addUsage(by, mIRConnection.getUsage());
            }
        }
        EtlSummarizer.ensureUsage(mIRStoreConnection, by);
        return by;
    }

    private static void summarizeDescriptions(MIRFeatureMap mIRFeatureMap, MIRSummaryMap mIRSummaryMap) {
        if (!mIRFeatureMap.getDescription().isEmpty() && !mIRSummaryMap.getDescription().contains(mIRFeatureMap.getDescription())) {
            mIRSummaryMap.setDescription(mIRSummaryMap.getDescription() + (mIRSummaryMap.getDescription().isEmpty() ? "" : ".") + mIRFeatureMap.getDescription());
        }
    }

    protected LinkedHashSet<MIRFeature> traceDataFeature(MIRFeature mIRFeature) {
        LinkedHashSet<MIRFeature> linkedHashSet = new LinkedHashSet<MIRFeature>();
        this.traceDataFeature(mIRFeature, new LinkedHashSet<MIRFeature>(), linkedHashSet);
        return linkedHashSet;
    }

    protected void traceDataFeature(MIRFeature mIRFeature, LinkedHashSet<MIRFeature> linkedHashSet, LinkedHashSet<MIRFeature> linkedHashSet2) {
        if (mIRFeature != null && !linkedHashSet.contains(mIRFeature)) {
            linkedHashSet.add(mIRFeature);
            if (mIRFeature.getDestinationOfFeatureMapCount() == 0) {
                if (mIRFeature.isInstanceOf((short)261) && !linkedHashSet2.contains(mIRFeature)) {
                    linkedHashSet2.add(mIRFeature);
                }
            } else {
                for (MIRFeatureMap mIRFeatureMap : mIRFeature.getDestinationOfFeatureMaps()) {
                    for (MIRFeature mIRFeature2 : mIRFeatureMap.getSourceFeatures()) {
                        this.traceDataFeature(mIRFeature2, linkedHashSet, linkedHashSet2);
                    }
                }
            }
        }
    }

    protected void traceFeature(MIRFeature mIRFeature, MIRSummaryMap mIRSummaryMap, boolean bl, LinkedHashSet<MIRFeature> linkedHashSet, LinkedHashSet<MIRFeature> linkedHashSet2) {
        this.traceFeature(mIRFeature, mIRSummaryMap, bl, false, linkedHashSet, linkedHashSet2, new LinkedHashSet<MIRFeature>());
    }

    protected void traceFeature(MIRFeature mIRFeature, MIRSummaryMap mIRSummaryMap, boolean bl, boolean bl2, LinkedHashSet<MIRFeature> linkedHashSet, LinkedHashSet<MIRFeature> linkedHashSet2, LinkedHashSet<MIRFeature> linkedHashSet3) {
        block24: {
            block25: {
                Object object;
                block26: {
                    block27: {
                        if (!bl && linkedHashSet2 == null) {
                            return;
                        }
                        boolean bl3 = linkedHashSet.contains(mIRFeature);
                        boolean bl4 = linkedHashSet3.contains(mIRFeature);
                        if (bl && (bl3 && !bl4 && bl2 || bl4 && !bl2)) {
                            LinkedHashSet<MIRFeature> linkedHashSet4 = this.traceDataFeature(mIRFeature);
                            StringBuilder stringBuilder = new StringBuilder();
                            if (!bl4 && bl2) {
                                linkedHashSet3.add(mIRFeature);
                            }
                            for (MIRFeature mIRFeature2 : linkedHashSet4) {
                                if (!bl4 && bl2 && !mIRSummaryMap.containsMaskedFeature(mIRFeature2)) {
                                    mIRSummaryMap.addMaskedFeature(mIRFeature2);
                                }
                                stringBuilder.append(stringBuilder.length() == 0 ? mIRFeature2.getName() : "," + mIRFeature2.getName());
                            }
                            if (stringBuilder.length() > 0) {
                                String object3 = "{\"type\":\"maskedConflict\", \"sources\":\"%s\"}";
                                String string = String.format(object3, stringBuilder.toString());
                                mIRSummaryMap.setControlOperation(mIRSummaryMap.getControlOperation().isEmpty() ? string : String.format("%s,\r\n%s", mIRSummaryMap.getControlOperation(), string));
                            }
                            return;
                        }
                        if (mIRFeature == null || (!bl ? linkedHashSet2.contains(mIRFeature) : bl3 || bl4)) break block24;
                        if (bl) {
                            if (bl2) {
                                linkedHashSet3.add(mIRFeature);
                            } else {
                                linkedHashSet.add(mIRFeature);
                            }
                        } else {
                            linkedHashSet2.add(mIRFeature);
                        }
                        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRFeature.getRootModel(), mIRFeature.getElementType(), "Masking", (byte)0, "INFA", "", "SQL_VARCHAR", false);
                        if (mIRPropertyType != null && (object = MIRUdpLib.getPropertyValue(mIRPropertyType, mIRFeature)) != null) {
                            bl2 = true;
                            String string = "M(" + ((MIRPropertyValue)object).getValue() + ")";
                            if (!string.isEmpty() && mIRSummaryMap.getDecorations().indexOf(string) == -1) {
                                mIRSummaryMap.setDecorations(mIRSummaryMap.getDecorations() + (mIRSummaryMap.getDecorations().isEmpty() ? "" : ", ") + string);
                            }
                        }
                        if (mIRFeature.getDestinationOfFeatureMapCount() != 0) break block25;
                        if (!mIRFeature.isInstanceOf((short)261)) break block26;
                        if (mIRSummaryMap.getDestinationFeature() == mIRFeature) break block24;
                        if (!bl) break block27;
                        if (!mIRSummaryMap.containsSourceFeature(mIRFeature)) {
                            mIRSummaryMap.addSourceFeature(mIRFeature);
                        }
                        if (bl2 && !mIRSummaryMap.containsMaskedFeature(mIRFeature)) {
                            mIRSummaryMap.addMaskedFeature(mIRFeature);
                        }
                        break block24;
                    }
                    if (mIRSummaryMap.containsControlFeature(mIRFeature)) break block24;
                    mIRSummaryMap.addControlFeature(mIRFeature);
                    break block24;
                }
                if (this.featureSummaries.get(mIRFeature) != null) break block24;
                object = "";
                if (mIRFeature.isInstanceOf((short)99)) {
                    object = ((MIRStructuralFeature)mIRFeature).getInitialValue();
                }
                this.featureSummaries.put(mIRFeature, new SummaryExpression((String)object, false, false));
                break block24;
            }
            for (MIRFeatureMap mIRFeatureMap : mIRFeature.getDestinationOfFeatureMaps()) {
                if (linkedHashSet.size() + linkedHashSet3.size() == 1) {
                    mIRSummaryMap.setBulk(true);
                }
                EtlSummarizer.summarizeDescriptions(mIRFeatureMap, mIRSummaryMap);
                if (bl) {
                    mIRSummaryMap.setBulk(mIRSummaryMap.getBulk() && mIRFeatureMap.getBulk());
                }
                if (mIRFeatureMap.getSourceFeatureCount() == 0 && mIRFeatureMap.getControlFeatureCount() == 0) {
                    if (this.featureSummaries.get(mIRFeature) != null) continue;
                    String string = mIRFeatureMap.getOperation();
                    this.featureSummaries.put(mIRFeature, new SummaryExpression(string, false, false));
                    continue;
                }
                for (MIRFeature mIRFeature3 : mIRFeatureMap.getSourceFeatures()) {
                    this.traceFeature(mIRFeature3, mIRSummaryMap, bl, bl2, linkedHashSet, linkedHashSet2, linkedHashSet3);
                }
                if (linkedHashSet2 == null) continue;
                for (MIRFeature mIRFeature3 : mIRFeatureMap.getControlFeatures()) {
                    if (!linkedHashSet2.contains(mIRFeature3) && mIRFeature3.isInstanceOf((short)84)) {
                        try {
                            this.summarizeControlLinks(mIRFeature3, mIRFeatureMap, mIRSummaryMap);
                        }
                        catch (MIRException mIRException) {
                            BLIB.DBG_DEBUG.log(mIRException, new Object[0]);
                        }
                    }
                    this.traceFeature(mIRFeature3, mIRSummaryMap, false, bl2, linkedHashSet, linkedHashSet2, linkedHashSet3);
                }
            }
        }
    }

    short getQueryFileterElementType(String string) {
        int n = 0;
        if (string.contains("WHERE")) {
            n = 89;
        } else if (string.contains("GROUP BY")) {
            n = 65;
        } else if (string.contains("JOIN")) {
            n = 92;
        } else if (string.contains("ORDER BY")) {
            n = 253;
        }
        return (short)n;
    }

    void summarizeControlLinks(MIRFeature mIRFeature2, MIRFeatureMap mIRFeatureMap, MIRSummaryMap mIRSummaryMap) throws MIRException {
        CharSequence charSequence;
        MIRFeatureMap mIRFeatureMap2 = mIRFeature2.getDestinationOfFeatureMap();
        if (mIRFeatureMap2 == null) {
            return;
        }
        MIRTransformation mIRTransformation = mIRFeatureMap2.getClassifierMap().getTransformation();
        int n = 0;
        if (mIRTransformation != null) {
            block0 : switch (mIRTransformation.getElementType()) {
                case 240: {
                    n = 92;
                    break;
                }
                case 237: {
                    n = 89;
                    break;
                }
                case 219: {
                    n = 65;
                    break;
                }
                case 241: {
                    n = 92;
                    break;
                }
                case 318: {
                    n = this.getQueryFileterElementType(mIRFeature2.getName().toUpperCase());
                    if (n != 0) break;
                    switch (mIRFeature2.getElementType()) {
                        case 333: {
                            n = 89;
                            break block0;
                        }
                        case 334: {
                            n = 92;
                        }
                    }
                }
            }
        }
        if (n == 0) {
            charSequence = mIRFeature2.getName().toLowerCase();
            if (((String)charSequence).contains("filter")) {
                n = 89;
            } else if (((String)charSequence).contains("group")) {
                n = 65;
            } else if (((String)charSequence).contains("join") || ((String)charSequence).contains("lookup")) {
                n = 92;
            } else if (((String)charSequence).contains("sql")) {
                n = 318;
            } else if (mIRFeatureMap2.getSourceFeatureCount() > 0 && mIRFeatureMap2.getSourceFeatures().stream().filter(mIRFeature -> mIRFeature.isInstanceOf((short)255)).count() == 0L) {
                n = 318;
            }
        }
        if (n != 0) {
            charSequence = new StringBuilder(mIRFeatureMap2.getOperation());
            if (((StringBuilder)charSequence).length() == 0 && n == 65 && mIRFeatureMap != null && mIRFeatureMap.getOperation().toLowerCase().contains("count(")) {
                ((StringBuilder)charSequence).append(mIRFeatureMap.getOperation());
            }
            if (((StringBuilder)charSequence).length() == 0) {
                mIRFeatureMap2.getSourceFeatures().stream().forEach(arg_0 -> EtlSummarizer.lambda$summarizeControlLinks$1((StringBuilder)charSequence, arg_0));
            }
            String string = "{\"type\":\"%s\", \"formula\":\"%s\", \"sources\":\"%s\"}";
            String string2 = this.getTraceFeaturesFullyQualifiedNames(mIRFeatureMap2.getSourceFeatures());
            String string3 = String.format(string, this.getControlGroupName((short)n), charSequence, string2);
            mIRSummaryMap.setControlOperation(mIRSummaryMap.getControlOperation().isEmpty() ? string3 : String.format("%s,\r\n%s", mIRSummaryMap.getControlOperation(), string3));
        }
    }

    String getTraceFeaturesFullyQualifiedNames(Set<MIRFeature> set) {
        StringBuilder stringBuilder = new StringBuilder();
        for (MIRFeature mIRFeature : set) {
            MIRSummaryMap mIRSummaryMap = new MIRSummaryMap();
            if (mIRFeature.isInstanceOf((short)334)) {
                this.traceForSourceFeature(mIRFeature, mIRSummaryMap, true, new LinkedHashSet<MIRFeature>(), new LinkedHashSet<MIRFeature>());
            } else {
                this.traceFeature(mIRFeature, mIRSummaryMap, true, new LinkedHashSet<MIRFeature>(), null);
            }
            TreeMap<MIRFeature, String> treeMap = this.buildFullyQualifiedNames(mIRSummaryMap, true);
            for (MIRFeature mIRFeature2 : mIRSummaryMap.getSourceFeatures()) {
                String string = treeMap.get(mIRFeature2);
                stringBuilder.append(stringBuilder.length() == 0 ? string : "," + string);
            }
            mIRSummaryMap.delete();
        }
        return stringBuilder.toString();
    }

    String getControlGroupName(short s) {
        switch (s) {
            case 318: {
                return "Sql";
            }
            case 65: 
            case 340: {
                return "Group";
            }
            case 253: {
                return "Sort";
            }
        }
        return MIRElementType.getName(s);
    }

    void traceForSourceFeature(MIRFeature mIRFeature, MIRSummaryMap mIRSummaryMap, boolean bl, LinkedHashSet<MIRFeature> linkedHashSet, LinkedHashSet<MIRFeature> linkedHashSet2) {
        if (mIRFeature != null && !(!bl ? linkedHashSet2.contains(mIRFeature) : linkedHashSet.contains(mIRFeature))) {
            boolean bl2;
            boolean bl3 = mIRFeature == mIRSummaryMap.getDestinationFeature();
            boolean bl4 = bl2 = mIRFeature.isInstanceOf((short)261) || mIRFeature.isInstanceOf((short)242) || mIRFeature.isInstanceOf((short)329);
            if (bl) {
                linkedHashSet.add(mIRFeature);
            } else {
                linkedHashSet2.add(mIRFeature);
            }
            if (!(bl2 && !bl3 && this.isSummaryTable(mIRFeature.getClassifier()) || mIRFeature.getDestinationOfFeatureMaps().size() <= 0)) {
                ArrayList<MIRFeatureMap> arrayList = new ArrayList<MIRFeatureMap>(mIRFeature.getDestinationOfFeatureMaps());
                for (MIRFeatureMap mIRFeatureMap : arrayList) {
                    if (linkedHashSet.size() == 1) {
                        mIRSummaryMap.setBulk(true);
                    }
                    EtlSummarizer.summarizeDescriptions(mIRFeatureMap, mIRSummaryMap);
                    if (bl) {
                        mIRSummaryMap.setBulk(mIRSummaryMap.getBulk() && mIRFeatureMap.getBulk());
                    }
                    for (MIRFeature mIRFeature2 : mIRFeatureMap.getSourceFeatures()) {
                        this.traceForSourceFeature(mIRFeature2, mIRSummaryMap, bl, linkedHashSet, linkedHashSet2);
                    }
                    for (MIRFeature mIRFeature2 : mIRFeatureMap.getControlFeatures()) {
                        if (!linkedHashSet2.contains(mIRFeature2) && (mIRFeature2.hasLineageOption(128) || mIRFeature2.isInstanceOf((short)84))) {
                            try {
                                this.summarizeControlLinks(mIRFeature2, mIRFeatureMap, mIRSummaryMap);
                            }
                            catch (MIRException mIRException) {
                                BLIB.DBG_DEBUG.log(mIRException, new Object[0]);
                            }
                        }
                        this.traceForSourceFeature(mIRFeature2, mIRSummaryMap, false, linkedHashSet, linkedHashSet2);
                    }
                }
            } else if (bl) {
                if (!mIRSummaryMap.containsSourceFeature(mIRFeature)) {
                    mIRSummaryMap.addSourceFeature(mIRFeature);
                }
            } else if (!mIRSummaryMap.containsControlFeature(mIRFeature)) {
                mIRSummaryMap.addControlFeature(mIRFeature);
            }
        }
    }

    private String getContentId(MIRMappingModel mIRMappingModel) {
        String string = new String();
        MIRContent mIRContent = mIRMappingModel.getContent();
        if (mIRContent != null && this.mixCache.getObjectIdentifier(mIRContent) != null) {
            string = Integer.toString(this.mixCache.getObjectIdentifier(mIRContent).getObjectId());
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String traceFeature(MIRFeature mIRFeature, LinkedHashSet<MIRFeature> linkedHashSet) throws MIRException {
        MIRSummaryMap mIRSummaryMap = new MIRSummaryMap();
        String string = "";
        try {
            if (mIRFeature.isInstanceOf((short)334)) {
                this.traceForSourceFeature(mIRFeature, mIRSummaryMap, true, new LinkedHashSet<MIRFeature>(), new LinkedHashSet<MIRFeature>());
            } else {
                this.traceFeature(mIRFeature, mIRSummaryMap, true, new LinkedHashSet<MIRFeature>(), new LinkedHashSet<MIRFeature>());
            }
            TreeMap<MIRFeature, String> treeMap = this.buildFullyQualifiedNames(mIRSummaryMap, false);
            for (MIRFeature mIRFeature2 : mIRSummaryMap.getSourceFeatures()) {
                String string2 = treeMap.get(mIRFeature2);
                this.featureSummaries.put(mIRFeature2, new SummaryExpression(string2, true, false));
            }
            this.buildSummaryExpression(mIRFeature, this.printFullyQualifiedNames);
            SummaryExpression summaryExpression = (SummaryExpression)this.featureSummaries.get(mIRFeature);
            if (!summaryExpression.isPassThrough()) {
                if (summaryExpression.getExpression().length() > 1 && summaryExpression.getExpression().charAt(0) == '(' && summaryExpression.getExpression().charAt(summaryExpression.getExpression().length() - 1) == ')') {
                    summaryExpression.setExpression(summaryExpression.getExpression().substring(1, summaryExpression.getExpression().length() - 1));
                }
                mIRSummaryMap.setOperation(summaryExpression.getExpression());
            }
            mIRSummaryMap.setAggregated(summaryExpression.isAggregated());
            this.featureSummaries.clear();
        }
        finally {
            string = mIRSummaryMap.getOperation();
            if (linkedHashSet != null) {
                for (MIRFeature mIRFeature3 : mIRSummaryMap.getSourceFeatures()) {
                    linkedHashSet.add(mIRFeature3);
                }
            }
            mIRSummaryMap.delete();
        }
        return string;
    }

    protected TreeMap<MIRFeature, String> buildFullyQualifiedNames(MIRSummaryMap mIRSummaryMap, boolean bl) {
        TreeMap<MIRFeature, String> treeMap = new TreeMap<MIRFeature, String>();
        this.buildFullyQualifiedNames(mIRSummaryMap.getSourceFeatures(), treeMap, bl);
        return treeMap;
    }

    protected void buildFullyQualifiedNames(Set<MIRFeature> set, TreeMap<MIRFeature, String> treeMap, boolean bl) {
        MIRNamespaceElement mIRNamespaceElement;
        Object object;
        Object object2;
        String string;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = "";
        Object object3 = "";
        String string3 = "";
        boolean bl5 = true;
        for (MIRFeature mIRFeature : set) {
            string = "";
            object2 = "";
            object = "";
            mIRNamespaceElement = mIRFeature.getClassifier();
            string = MIRBridgeLib.getPhysicalName(mIRNamespaceElement);
            MIRConnectionDataPackage mIRConnectionDataPackage = mIRNamespaceElement.getConnectionDataPackage();
            if (mIRConnectionDataPackage != null) {
                object2 = MIRBridgeLib.getPhysicalName(mIRConnectionDataPackage);
                MIRNamespace mIRNamespace = mIRConnectionDataPackage.getNamespace();
                if (mIRNamespace != null) {
                    object = MIRBridgeLib.getPhysicalName(mIRNamespace);
                }
            }
            if (bl5) {
                string2 = object;
                object3 = object2;
                string3 = string;
            } else {
                if (string2.compareToIgnoreCase((String)object) != 0) {
                    bl2 = true;
                    bl3 = true;
                    bl4 = true;
                    break;
                }
                if (((String)object3).compareToIgnoreCase((String)object2) != 0) {
                    bl3 = true;
                    bl4 = true;
                }
                if (string3.compareToIgnoreCase(string) != 0) {
                    bl4 = true;
                }
            }
            bl5 = false;
        }
        for (MIRFeature mIRFeature : set) {
            string = this.makeNameSafe(MIRBridgeLib.getPhysicalName(mIRFeature));
            if (bl4 || bl) {
                object2 = mIRFeature.getClassifier();
                string = this.makeNameSafe(MIRBridgeLib.getPhysicalName((MIRObject)object2)) + "." + string;
                if (bl3 && (object = ((MIRClassifier)object2).getConnectionDataPackage()) != null) {
                    string = this.makeNameSafe(MIRBridgeLib.getPhysicalName((MIRObject)object)) + "." + string;
                    if (bl2 && (mIRNamespaceElement = ((MIRNamespaceElement)object).getNamespace()) != null) {
                        string = this.makeNameSafe(MIRBridgeLib.getPhysicalName(mIRNamespaceElement)) + "." + string;
                    }
                }
            }
            treeMap.put(mIRFeature, string);
        }
    }

    protected void processDataSet(MIRMappingModel mIRMappingModel, MIRClassifier mIRClassifier) throws MIRException {
        String string = this.getContentId(mIRMappingModel);
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            if (mIRFeature.getDestinationOfFeatureMap() == null || !mIRFeature.isInstanceOf((short)261)) continue;
            MIRSummaryMap mIRSummaryMap = new MIRSummaryMap();
            mIRSummaryMap.setExternalContentId(string);
            mIRSummaryMap.addDestinationFeature(mIRFeature);
            mIRSummaryMap.setBulk(false);
            this.traceFeature(mIRFeature, mIRSummaryMap, true, new LinkedHashSet<MIRFeature>(), new LinkedHashSet<MIRFeature>());
            TreeMap<MIRFeature, String> treeMap = this.buildFullyQualifiedNames(mIRSummaryMap, false);
            for (MIRFeature mIRFeature2 : mIRSummaryMap.getSourceFeatures()) {
                String string2 = treeMap.get(mIRFeature2);
                this.featureSummaries.put(mIRFeature2, new SummaryExpression(string2, true, false));
            }
            this.buildSummaryExpression(mIRFeature, this.printFullyQualifiedNames);
            SummaryExpression summaryExpression = (SummaryExpression)this.featureSummaries.get(mIRFeature);
            if (!summaryExpression.isPassThrough()) {
                if (summaryExpression.getExpression().length() > 1 && summaryExpression.getExpression().charAt(0) == '(' && summaryExpression.getExpression().charAt(summaryExpression.getExpression().length() - 1) == ')') {
                    summaryExpression.setExpression(summaryExpression.getExpression().substring(1, summaryExpression.getExpression().length() - 1));
                }
                mIRSummaryMap.setOperation(summaryExpression.getExpression());
            }
            mIRSummaryMap.setAggregated(summaryExpression.isAggregated());
            if (!mIRSummaryMap.getControlOperation().isEmpty()) {
                mIRSummaryMap.setControlOperation(String.format("[%s]", mIRSummaryMap.getControlOperation()));
            }
            this.featureSummaries.clear();
        }
    }

    protected void buildSummaryLinks(MIREmbeddedCallTransformation mIREmbeddedCallTransformation) throws MIRException {
        for (MIRTransformation mIRTransformation : mIREmbeddedCallTransformation.getTransformations()) {
            MIRTransformation mIRTransformation2;
            if (mIRTransformation.isInstanceOf((short)220)) {
                mIRTransformation2 = (MIRConnectedTransformation)mIRTransformation;
                for (MIRConnectionDataSet mIRConnectionDataSet : ((MIRConnectedTransformation)mIRTransformation2).getConnectionDataSets()) {
                    this.processDataSet((MIRDiModel)mIREmbeddedCallTransformation.getRootModel(), mIRConnectionDataSet);
                }
                continue;
            }
            if (mIRTransformation.isInstanceOf((short)257)) {
                mIRTransformation2 = (MIRCallTransformation)mIRTransformation;
                for (MIRConnectionDataSet mIRConnectionDataSet : ((MIRCallTransformation)mIRTransformation2).getInputConnectionDataSets()) {
                    this.processDataSet((MIRDiModel)mIREmbeddedCallTransformation.getRootModel(), mIRConnectionDataSet);
                }
                continue;
            }
            if (!mIRTransformation.isInstanceOf((short)320)) continue;
            this.buildSummaryLinks((MIREmbeddedCallTransformation)mIRTransformation);
        }
    }

    public boolean isSummaryTable(MIRClassifier mIRClassifier) {
        if (mIRClassifier == null) {
            return false;
        }
        return mIRClassifier.getConnectionDataPackage() != null || mIRClassifier.getImportedByPackageCount() > 0;
    }

    public void buildSummaryLinks(MIRSqlQuery mIRSqlQuery) throws MIRException {
        for (MIRTransformationDataSet mIRElement : mIRSqlQuery.getOutputTransformationDataSets()) {
            if (!this.isSummaryTable(mIRElement)) continue;
            for (MIRFeature mIRFeature : mIRElement.getFeatures()) {
                MIRFeatureMap mIRFeatureMap;
                if (!mIRFeature.isInstanceOf((short)242) && !mIRFeature.isInstanceOf((short)329)) continue;
                MIRSummaryMap mIRSummaryMap = new MIRSummaryMap();
                mIRSummaryMap.setExternalContentId("");
                mIRSummaryMap.addDestinationFeature(mIRFeature);
                if (((MIRQueryTable)mIRFeature.getClassifier()).getQueryGroupBy() != null) {
                    mIRSummaryMap.setAggregated(((MIRQueryColumn)mIRFeature).getQueryGroupBy() == null);
                }
                this.traceForSourceFeature(mIRFeature, mIRSummaryMap, true, new LinkedHashSet<MIRFeature>(), new LinkedHashSet<MIRFeature>());
                this.buildSummaryExpression(mIRFeature, this.printFullyQualifiedNames);
                SummaryExpression summaryExpression = (SummaryExpression)this.featureSummaries.get(mIRFeature);
                if (!summaryExpression.isPassThrough()) {
                    if (summaryExpression.getExpression().length() > 1 && summaryExpression.getExpression().charAt(0) == '(' && summaryExpression.getExpression().charAt(summaryExpression.getExpression().length() - 1) == ')') {
                        summaryExpression.setExpression(summaryExpression.getExpression().substring(1, summaryExpression.getExpression().length() - 1));
                    }
                    mIRSummaryMap.setOperation(summaryExpression.getExpression());
                }
                mIRSummaryMap.setAggregated(summaryExpression.isAggregated());
                if (mIRSummaryMap.getOperation().isEmpty() && (mIRFeatureMap = mIRFeature.getDestinationOfFeatureMap()) != null) {
                    mIRSummaryMap.setOperation(mIRFeatureMap.getOperation());
                }
                if (mIRSummaryMap.getControlOperation().isEmpty()) continue;
                mIRSummaryMap.setControlOperation(String.format("[%s]", mIRSummaryMap.getControlOperation()));
            }
        }
        for (MIRSqlQuery mIRSqlQuery2 : mIRSqlQuery.getSubSqlQueries()) {
            this.buildSummaryLinks(mIRSqlQuery2);
        }
    }

    public void buildSummaryLinks(MIRDiModel mIRDiModel) throws MIRException {
        this.buildSummaryLinks(mIRDiModel, false);
    }

    public void buildSummaryLinks(MIRDiModel mIRDiModel, boolean bl) throws MIRException {
        this.printFullyQualifiedNames = bl;
        new ModelLineageAugmenter(mIRDiModel);
        for (MIRConnectionDataSet object2 : mIRDiModel.getOutputConnectionDataSets()) {
            this.processDataSet(mIRDiModel, object2);
        }
        if (mIRDiModel.getVariableConnectionDataSet() != null) {
            this.processDataSet(mIRDiModel, mIRDiModel.getVariableConnectionDataSet());
        }
        for (MIRTransformation mIRTransformation : mIRDiModel.getTransformations()) {
            Object object;
            if (mIRTransformation.isInstanceOf((short)220)) {
                object = (MIRConnectedTransformation)mIRTransformation;
                for (MIRConnectionDataSet mIRConnectionDataSet : ((MIRConnectedTransformation)object).getConnectionDataSets()) {
                    this.processDataSet(mIRDiModel, mIRConnectionDataSet);
                }
                continue;
            }
            if (mIRTransformation.isInstanceOf((short)257)) {
                object = (MIRCallTransformation)mIRTransformation;
                for (MIRConnectionDataSet mIRConnectionDataSet : ((MIRCallTransformation)object).getInputConnectionDataSets()) {
                    this.processDataSet(mIRDiModel, mIRConnectionDataSet);
                }
                continue;
            }
            if (mIRTransformation.isInstanceOf((short)320)) {
                this.buildSummaryLinks((MIREmbeddedCallTransformation)mIRTransformation);
                continue;
            }
            if (!mIRTransformation.isInstanceOf((short)318)) continue;
            object = new ArrayList();
            Object object2 = (MIRSqlQuery)mIRTransformation;
            for (Iterator iterator : ((MIREmbeddedTransformation)object2).getOutputTransformationDataSets()) {
                for (MIRSqlQuery mIRSqlQuery : ((MIRSqlQuery)object2).getSubSqlQueries()) {
                    for (MIRTransformationDataSet mIRTransformationDataSet : mIRSqlQuery.getOutputTransformationDataSets()) {
                        for (MIRFeature mIRFeature : ((MIRClassifier)((Object)iterator)).getFeatures()) {
                            if (mIRFeature.getDestinationOfFeatureMap() != null) continue;
                            for (MIRFeature mIRFeature2 : mIRTransformationDataSet.getFeatures()) {
                                if (mIRFeature2.getPosition() != mIRFeature.getPosition()) continue;
                                MIRFeatureMap mIRFeatureMap = mIRFeature.getDestinationOfFeatureMap();
                                if (mIRFeatureMap == null) {
                                    mIRFeatureMap = new MIRFeatureMap();
                                    mIRFeatureMap.addDestinationFeature(mIRFeature);
                                    ((ArrayList)object).add(mIRFeatureMap);
                                }
                                if (mIRFeatureMap.containsSourceFeature(mIRFeature2)) continue;
                                mIRFeatureMap.addSourceFeature(mIRFeature2);
                            }
                        }
                    }
                }
            }
            this.buildSummaryLinks((MIRSqlQuery)mIRTransformation);
            while (!((ArrayList)object).isEmpty()) {
                ((MIRFeatureMap)((ArrayList)object).get(0)).delete();
                ((ArrayList)object).remove(0);
            }
        }
        ObjectCollector objectCollector = new ObjectCollector(new short[]{76});
        mIRDiModel.depthTraversal(objectCollector);
        ObjectCollector objectCollector2 = new ObjectCollector(new short[]{78});
        mIRDiModel.depthTraversal(objectCollector2);
        for (Object object2 : objectCollector2.getObjects()) {
            ArrayList<MIRFeature> arrayList = new ArrayList<MIRFeature>();
            for (MIRFeature mIRFeature : ((MIRFeatureMap)object2).getControlFeatures()) {
                if (!mIRFeature.isInstanceOf((short)84)) continue;
                arrayList.add(mIRFeature);
            }
            for (MIRFeature mIRFeature : arrayList) {
                ((MIRFeatureMap)object2).removeControlFeature(mIRFeature);
            }
        }
        MIRTypeLib.factorizeTypes(mIRDiModel, true, true);
    }

    String getReference(MIRObject mIRObject) {
        if (mIRObject.isInstanceOf((short)218)) {
            return "";
        }
        String string = MIRBridgeLib.getPhysicalName(mIRObject);
        string = EscapedStringTokenizer.escapeChar(string, '/', '\\');
        if (mIRObject.getParent() == null || mIRObject.getParent().isInstanceOf((short)218)) {
            return string;
        }
        return this.getReference(mIRObject.getParent()) + "/" + string;
    }

    String getActivityStepReference(MIREmbeddedCallStep mIREmbeddedCallStep) {
        return this.getReference(mIREmbeddedCallStep);
    }

    String getStoreConnectionReference(MIRStoreConnection mIRStoreConnection) {
        return MIRBridgeLib.getPhysicalName(mIRStoreConnection);
    }

    String getTransformationTaskCallReference(MIRCallTransformation mIRCallTransformation) {
        return this.getReference(mIRCallTransformation);
    }

    void mergeAttributes(MIRModelObject mIRModelObject, MIRModelObject mIRModelObject2) {
        if (mIRModelObject2.getComment().isEmpty() && !mIRModelObject.getComment().isEmpty()) {
            mIRModelObject2.setComment(mIRModelObject.getComment());
        }
        if (mIRModelObject2.getDescription().trim().isEmpty()) {
            if (!mIRModelObject.getDescription().trim().isEmpty()) {
                mIRModelObject2.setDescription(mIRModelObject.getDescription());
            }
        } else if (!mIRModelObject.getDescription().trim().isEmpty() && mIRModelObject2.getDescription().trim().toUpperCase().indexOf(mIRModelObject.getDescription().toUpperCase().trim()) == -1) {
            mIRModelObject2.setDescription(mIRModelObject2.getDescription() + " " + mIRModelObject.getDescription());
        }
    }

    protected MIRConcreteType copyTypesChain(MIRType mIRType, MIRModel mIRModel) {
        MIRConcreteType mIRConcreteType = null;
        if (mIRType != null) {
            if (mIRType.isInstanceOf((short)5)) {
                MIRDerivedType mIRDerivedType = (MIRDerivedType)mIRType;
                MIRConcreteType mIRConcreteType2 = mIRDerivedType.getDerivedFromConcreteType();
                MIRConcreteType mIRConcreteType3 = this.copyTypesChain(mIRConcreteType2, mIRModel);
                mIRConcreteType = new MIRDerivedType(mIRDerivedType);
                ((MIRDerivedType)mIRConcreteType).addDerivedFromConcreteType(mIRConcreteType3);
            } else if (mIRType.isInstanceOf((short)4)) {
                mIRConcreteType = new MIRBaseType((MIRBaseType)mIRType);
            }
            if (mIRConcreteType != null) {
                mIRModel.addType(mIRConcreteType);
            }
        }
        return mIRConcreteType;
    }

    void mergeClassifier(MIRElement mIRElement, MIRElement mIRElement2, MIRNamespace mIRNamespace, LinkedHashSet<MIRFeature> linkedHashSet) {
        String string;
        Object object;
        MIRObject mIRObject;
        Object object2;
        MIRClassifier mIRClassifier;
        if (mIRElement2.isInstanceOf((short)254)) {
            mIRClassifier = (MIRConnectionDataSet)mIRElement2;
            object2 = ((MIRConnectionDataSet)mIRClassifier).getConnectedTransformation();
            if (object2 == null && (mIRObject = ((MIRConnectionDataSet)mIRClassifier).getParent()).isInstanceOf((short)79)) {
                object2 = (MIRConnectedTransformation)mIRObject;
            }
            if (object2 != null && ((MIRConnectedTransformation)object2).getUserDefinedQuery() && ((MIR_Object)object2).getRootModel() != null) {
                mIRObject = ((MIR_Object)object2).getRootModel();
                object = mIRObject.getPath();
                if (!((String)object).isEmpty() && mIRClassifier.getDescription().indexOf((String)object) == -1) {
                    mIRClassifier.setDescription(mIRClassifier.getDescription() + (String)object + "\n");
                }
                if (((MIR_Object)object2).isInstanceOf((short)251)) {
                    for (MIRClassifierMap object3 : mIRClassifier.getSourceOfClassifierMaps()) {
                        string = object3.getOperation();
                        if (string.isEmpty()) continue;
                        mIRClassifier.setDescription(mIRClassifier.getDescription() + "SQL (" + ((MIRObject)object2).getName() + ") : " + string + "\n");
                    }
                } else if (((MIR_Object)object2).isInstanceOf((short)260)) {
                    String string2;
                    MIRClassifierMap mIRClassifierMap = mIRClassifier.getDestinationOfClassifierMap();
                    if (mIRClassifierMap != null && !(string2 = mIRClassifierMap.getOperation()).isEmpty()) {
                        mIRClassifier.setDescription(mIRClassifier.getDescription() + "SQL (" + ((MIRObject)object2).getName() + ") : " + string2 + "\n");
                    }
                } else if (((MIR_Object)object2).isInstanceOf((short)241)) {
                    for (MIRClassifierMap mIRClassifierMap : mIRClassifier.getSourceOfClassifierMaps()) {
                        string = mIRClassifierMap.getOperation();
                        if (string.isEmpty()) continue;
                        mIRClassifier.setDescription(mIRClassifier.getDescription() + "SQL (" + ((MIRObject)object2).getName() + ") : " + string + "\n");
                    }
                }
            }
        }
        if (mIRElement2.isInstanceOf((short)254) || mIRElement2.isInstanceOf((short)243)) {
            mIRClassifier = (MIRClassifier)mIRElement2;
            object2 = MIRBridgeLib.getPhysicalName(mIRClassifier);
            mIRObject = mIRNamespace.getNamespaceElement((String)object2);
            if (mIRObject != null && !mIRObject.isInstanceOf((short)254)) {
                BLIB.ERR_FILE_DIRECTORY_COLLISION.log(mIRNamespace.getPath(), MIRElementType.getName(((MIRNamespaceElement)mIRObject).getElementType()), mIRClassifier.getPath());
                return;
            }
            object = (MIRConnectionDataSet)mIRObject;
            if (object == null) {
                object = new MIRConnectionDataSet();
                ((MIRClassifier)object).setFrom(mIRClassifier);
                ((MIRObject)object).setName((String)object2);
                ((MIRModelObject)object).setPhysicalName("");
                mIRNamespace.addNamespaceElement((MIRNamespaceElement)object);
            }
            this.mergeAttributes(mIRClassifier, (MIRModelObject)object);
            for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
                if (mIRFeature.isInstanceOf((short)334) || mIRFeature.isInstanceOf((short)335) || mIRFeature.isInstanceOf((short)333) || mIRFeature.isInstanceOf((short)337)) continue;
                if (mIRFeature.isInstanceOf((short)261) || mIRFeature.isInstanceOf((short)242) || mIRFeature.isInstanceOf((short)329)) {
                    string = MIRBridgeLib.getPhysicalName(mIRFeature);
                    MIRConnectionDataAttribute mIRConnectionDataAttribute = (MIRConnectionDataAttribute)((MIRClassifier)object).getFeature(string);
                    if (mIRConnectionDataAttribute == null) {
                        mIRConnectionDataAttribute = new MIRConnectionDataAttribute();
                        mIRConnectionDataAttribute.setFrom(mIRFeature);
                        mIRConnectionDataAttribute.setName(string);
                        mIRConnectionDataAttribute.setPhysicalName("");
                        ((MIRClassifier)object).addFeature(mIRConnectionDataAttribute);
                        MIRConcreteType mIRConcreteType = this.copyTypesChain(mIRFeature.getType(), mIRNamespace.getRootModel());
                        if (mIRConcreteType != null) {
                            mIRConnectionDataAttribute.addType(mIRConcreteType);
                        }
                    }
                    this.mergeAttributes(mIRFeature, mIRConnectionDataAttribute);
                    linkedHashSet.add(mIRFeature);
                    this.featureAttributes.put(mIRFeature, mIRConnectionDataAttribute);
                    continue;
                }
                if (mIRFeature.isInstanceOf((short)84)) continue;
                SUMMY.ERR_MODEL_CONNECTION_REFERS_TO_WRONG_OBJECT_TYPE.log(mIRElement.getPath(), mIRFeature.getPath());
            }
        } else {
            SUMMY.ERR_MODEL_CONNECTION_REFERS_TO_WRONG_OBJECT_TYPE.log(mIRElement.getPath(), mIRElement2.getPath());
        }
    }

    void mergeStoreConnections(MIRMappingModel mIRMappingModel, MIRMappingModel mIRMappingModel2, LinkedHashSet<MIRFeature> linkedHashSet) throws MIRException {
        Object object;
        MIRElement mIRElement;
        Object object2;
        for (MIRStoreConnection object3 : mIRMappingModel.getStoreConnections()) {
            MIRElement mIRElement2;
            MIRObject mIRObject = mIRMappingModel2.getRootModel().getContent();
            object2 = "";
            if (mIRObject.getRootModel().isInstanceOf((short)286) && (mIRElement = ((MIRDirectoryStructureModel)mIRObject.getRootModel()).getConnectionStoreContent(object3.getName())) != null) {
                object2 = mIRElement.getNativeType();
            }
            if ((mIRElement = mIRMappingModel2.getStoreConnection(MIRBridgeLib.getPhysicalName(object3))) == null) {
                MIRConnection mIRConnection;
                mIRElement = new MIRStoreConnection(object3);
                if (mIRElement.getNativeType().isEmpty()) {
                    mIRElement.setNativeType((String)object2);
                }
                mIRMappingModel2.addStoreConnection((MIRStoreConnection)mIRElement);
                object = this.getStoreConnectionReference((MIRStoreConnection)mIRElement);
                MIRConnection mIRConnection2 = ((MIRContent)mIRObject).getClientOfConnection((String)object);
                if (mIRConnection2 == null && (mIRConnection = ((MIRContent)(mIRElement2 = mIRMappingModel.getRootModel().getContent())).getClientOfConnection(MIRBridgeLib.getPhysicalName(object3))) != null) {
                    MIRConnection mIRConnection3 = new MIRConnection();
                    mIRConnection3.setName((String)object);
                    mIRConnection3.addClientContent((MIRContent)mIRObject);
                    mIRConnection3.addSupplierStoreContent(mIRConnection.getSupplierStoreContent());
                    mIRConnection3.setUsage((byte)-1);
                }
            }
            for (MIRConnectionPackage mIRConnectionPackage : object3.getConnectionPackages()) {
                mIRElement2 = ((MIRStoreConnection)mIRElement).getConnectionPackage(MIRBridgeLib.getPhysicalName(mIRConnectionPackage));
                if (mIRElement2 == null) {
                    mIRElement2 = new MIRConnectionPackage(mIRConnectionPackage);
                    ((MIRStoreConnection)mIRElement).addConnectionPackage((MIRConnectionPackage)mIRElement2);
                }
                this.mergeConnectionDataPackageClassifers(mIRConnectionPackage, (MIRConnectionDataPackage)mIRElement2, linkedHashSet);
            }
            for (MIRConnectionNamespace mIRConnectionNamespace : object3.getConnectionNamespaces()) {
                mIRElement2 = ((MIRStoreConnection)mIRElement).getConnectionNamespace(MIRBridgeLib.getPhysicalName(mIRConnectionNamespace));
                if (mIRElement2 == null) {
                    mIRElement2 = new MIRConnectionNamespace(mIRConnectionNamespace);
                    ((MIRStoreConnection)mIRElement).addConnectionNamespace((MIRConnectionNamespace)mIRElement2);
                }
                this.mergeConnectionDataPackageClassifers(mIRConnectionNamespace, (MIRConnectionDataPackage)mIRElement2, linkedHashSet);
                this.mergeConnectionNamespaceClassifers(mIRConnectionNamespace, (MIRConnectionNamespace)mIRElement2, linkedHashSet);
            }
        }
        ObjectCollector objectCollector = new ObjectCollector(new short[]{346});
        mIRMappingModel.depthTraversal(objectCollector);
        for (MIRObject mIRObject : objectCollector.getObjects()) {
            object2 = this.searchSummyConnectionDataSet(((MIRJoinRelationship)mIRObject).getLeftClassifier(), mIRMappingModel2);
            mIRElement = this.searchSummyConnectionDataSet(((MIRJoinRelationship)mIRObject).getRightClassifier(), mIRMappingModel2);
            object = ((MIRJoinRelationship)mIRObject).getContexts();
            if (((String)object).isEmpty()) {
                object = this.getContentId(mIRMappingModel);
            }
            this.mergeJoinRelationship(mIRMappingModel2, (MIRClassifier)object2, (MIRClassifier)mIRElement, ((MIRJoinRelationship)mIRObject).getType(), ((MIRJoinRelationship)mIRObject).getCondition(), (String)object);
        }
    }

    private void mergeConnectionNamespaceClassifers(MIRConnectionNamespace mIRConnectionNamespace, MIRConnectionNamespace mIRConnectionNamespace2, LinkedHashSet<MIRFeature> linkedHashSet) {
        for (MIRNamespaceElement mIRNamespaceElement : mIRConnectionNamespace.getNamespaceElements()) {
            if (!mIRNamespaceElement.isInstanceOf((short)321)) continue;
            MIRNamespaceElement mIRNamespaceElement2 = mIRConnectionNamespace2.getNamespaceElement(MIRBridgeLib.getPhysicalName(mIRNamespaceElement));
            if (mIRNamespaceElement2 == null) {
                mIRNamespaceElement2 = new MIRConnectionNamespace((MIRConnectionNamespace)mIRNamespaceElement);
                mIRConnectionNamespace2.addNamespaceElement(mIRNamespaceElement2);
            } else if (!mIRNamespaceElement2.isInstanceOf((short)321)) {
                BLIB.ERR_FILE_DIRECTORY_COLLISION.log(mIRConnectionNamespace2.getPath(), MIRElementType.getName(mIRNamespaceElement2.getElementType()), mIRNamespaceElement.getPath());
                continue;
            }
            this.mergeConnectionDataPackageClassifers((MIRConnectionNamespace)mIRNamespaceElement, (MIRConnectionDataPackage)mIRNamespaceElement2, linkedHashSet);
            this.mergeConnectionNamespaceClassifers((MIRConnectionNamespace)mIRNamespaceElement, (MIRConnectionNamespace)mIRNamespaceElement2, linkedHashSet);
        }
    }

    private void mergeConnectionDataPackageClassifers(MIRConnectionDataPackage mIRConnectionDataPackage, MIRConnectionDataPackage mIRConnectionDataPackage2, LinkedHashSet<MIRFeature> linkedHashSet) {
        for (MIRClassifier mIRNamespaceElement : mIRConnectionDataPackage.getClassifiers()) {
            this.mergeClassifier(mIRConnectionDataPackage, mIRNamespaceElement, mIRConnectionDataPackage2, linkedHashSet);
        }
        for (MIRNamespaceElement mIRNamespaceElement : mIRConnectionDataPackage.getNamespaceElements()) {
            if (mIRNamespaceElement.isInstanceOf((short)321)) continue;
            this.mergeClassifier(mIRConnectionDataPackage, mIRNamespaceElement, mIRConnectionDataPackage2, linkedHashSet);
        }
        for (MIRNamespaceElement mIRNamespaceElement : mIRConnectionDataPackage.getImportedNamespaceElements()) {
            this.mergeClassifier(mIRConnectionDataPackage, mIRNamespaceElement, mIRConnectionDataPackage2, linkedHashSet);
        }
    }

    private MIRJoinRelationship getJoinRelationship(MIRClassifier mIRClassifier, MIRClassifier mIRClassifier2, byte by, String string) {
        MIRJoinRelationship mIRJoinRelationship = null;
        for (MIRJoinRelationship mIRJoinRelationship2 : mIRClassifier.getLeftOfJoinRelationships()) {
            if (mIRJoinRelationship2.getRightClassifier() == null || mIRJoinRelationship2.getRightClassifier() != mIRClassifier2 || mIRJoinRelationship2.getCondition().compareTo(string) != 0 || mIRJoinRelationship2.getType() != by) continue;
            mIRJoinRelationship = mIRJoinRelationship2;
            break;
        }
        return mIRJoinRelationship;
    }

    private MIRJoinRelationship mergeJoinRelationship(MIRMappingModel mIRMappingModel, MIRClassifier mIRClassifier, MIRClassifier mIRClassifier2, byte by, String string, String string2) {
        if (mIRClassifier != null && mIRClassifier2 != null) {
            MIRJoinRelationship mIRJoinRelationship = this.getJoinRelationship(mIRClassifier, mIRClassifier2, by, string);
            if (mIRJoinRelationship == null) {
                mIRJoinRelationship = new MIRJoinRelationship();
                mIRJoinRelationship.setName(mIRClassifier.getName() + "=>" + mIRClassifier2.getName());
                mIRJoinRelationship.addLeftClassifier(mIRClassifier);
                mIRJoinRelationship.addRightClassifier(mIRClassifier2);
                mIRJoinRelationship.setType(by);
                mIRJoinRelationship.setCondition(string);
                mIRJoinRelationship.setContexts(string2);
            } else if (mIRJoinRelationship.getContexts().indexOf(string2) == -1) {
                mIRJoinRelationship.setContexts(mIRJoinRelationship.getContexts() + (mIRJoinRelationship.getContexts().isEmpty() ? "" : ", ") + string2);
            }
            return mIRJoinRelationship;
        }
        return null;
    }

    LinkedHashSet<MIRConnectionDataSet> traceCondition(LinkedHashSet<MIRConnectionDataSet> linkedHashSet, MIRFeature mIRFeature, LinkedHashSet<MIRFeature> linkedHashSet2) {
        if (!linkedHashSet2.contains(mIRFeature)) {
            linkedHashSet2.add(mIRFeature);
            MIRClassifier mIRClassifier = mIRFeature.getClassifier();
            if (mIRClassifier != null && mIRClassifier.isInstanceOf((short)254)) {
                MIRConnectionDataSet mIRConnectionDataSet = (MIRConnectionDataSet)mIRClassifier;
                if (!linkedHashSet.contains(mIRConnectionDataSet)) {
                    linkedHashSet.add((MIRConnectionDataSet)mIRClassifier);
                }
            } else {
                MIRFeatureMap mIRFeatureMap = mIRFeature.getDestinationOfFeatureMap();
                if (mIRFeatureMap != null) {
                    for (MIRFeature mIRFeature2 : mIRFeatureMap.getSourceFeatures()) {
                        this.traceCondition(linkedHashSet, mIRFeature2, linkedHashSet2);
                    }
                }
            }
        }
        return linkedHashSet;
    }

    private MIRConnectionDataSet searchSummyConnectionDataSet(MIRClassifier mIRClassifier, MIRMappingModel mIRMappingModel) {
        if (mIRClassifier != null && mIRMappingModel != null) {
            MIRConnectionPackage mIRConnectionPackage;
            MIRStoreConnection mIRStoreConnection;
            MIRModelObject mIRModelObject;
            MIRConnectionDataPackage mIRConnectionDataPackage = mIRClassifier.getConnectionDataPackage();
            if (mIRConnectionDataPackage == null && (mIRModelObject = mIRClassifier.getNamespace()) != null && mIRModelObject.isInstanceOf((short)215)) {
                mIRConnectionDataPackage = (MIRConnectionPackage)mIRModelObject;
            }
            if (mIRConnectionDataPackage != null && (mIRModelObject = MIRBridgeLib.getStoreConnection(mIRConnectionDataPackage)) != null && (mIRStoreConnection = mIRMappingModel.getStoreConnection(MIRBridgeLib.getPhysicalName(mIRModelObject))) != null && (mIRConnectionPackage = mIRStoreConnection.getConnectionPackage(MIRBridgeLib.getPhysicalName(mIRConnectionDataPackage))) != null) {
                return (MIRConnectionDataSet)mIRConnectionPackage.getNamespaceElement(MIRBridgeLib.getPhysicalName(mIRClassifier));
            }
        }
        return null;
    }

    private LinkedHashSet<MIRJoinCondition> getExpressionJoinConditions(MIRFeature mIRFeature, MIRFeature mIRFeature2) throws MIRException {
        LinkedHashSet<MIRJoinCondition> linkedHashSet = new LinkedHashSet<MIRJoinCondition>();
        LinkedHashSet<MIRFeature> linkedHashSet2 = new LinkedHashSet<MIRFeature>();
        LinkedHashSet<MIRFeature> linkedHashSet3 = new LinkedHashSet<MIRFeature>();
        this.traceFeature(mIRFeature, linkedHashSet2);
        this.traceFeature(mIRFeature2, linkedHashSet3);
        for (MIRFeature mIRFeature3 : linkedHashSet2) {
            for (MIRFeature mIRFeature4 : linkedHashSet3) {
                MIRJoinCondition mIRJoinCondition = null;
                for (MIRJoinCondition mIRJoinCondition2 : mIRFeature3.getLeftOfJoinConditions()) {
                    if (mIRFeature4 != mIRJoinCondition2.getRightFeature()) continue;
                    mIRJoinCondition = mIRJoinCondition2;
                    break;
                }
                if (mIRJoinCondition == null) {
                    mIRJoinCondition = new MIRJoinCondition();
                    mIRJoinCondition.setName(mIRFeature3.getName() + "=>" + mIRFeature4.getName());
                    mIRJoinCondition.addLeftFeature(mIRFeature3);
                    mIRJoinCondition.addRightFeature(mIRFeature4);
                }
                linkedHashSet.add(mIRJoinCondition);
            }
        }
        return linkedHashSet;
    }

    private MIRFeature getReferencedFeature(MIRElementNode mIRElementNode, MIRFeatureMap mIRFeatureMap, LinkedHashSet<MIRElementNode> linkedHashSet) {
        MIRFeature mIRFeature = null;
        for (MIRElementNamePart mIRElementNamePart : mIRElementNode.getElementNameParts()) {
            if (mIRElementNamePart.getSourceElementType() == 77) {
                block1: for (MIRElement mIRElement : mIRElementNamePart.getReferencedElements()) {
                    if (mIRElement.isInstanceOf((short)77)) {
                        for (MIRFeatureMap mIRFeatureMap2 : ((MIRFeature)mIRElement).getSourceOfFeatureMaps()) {
                            if (mIRFeatureMap2 != mIRFeatureMap) continue;
                            mIRFeature = (MIRFeature)mIRElement;
                            continue block1;
                        }
                        continue;
                    }
                    if (!mIRElement.isInstanceOf((short)111) || linkedHashSet.contains(mIRElement)) continue;
                    linkedHashSet.add((MIRElementNode)mIRElement);
                    mIRFeature = this.getReferencedFeature((MIRElementNode)mIRElement, mIRFeatureMap, linkedHashSet);
                }
            }
            if (mIRFeature == null) continue;
            break;
        }
        return mIRFeature;
    }

    private LinkedHashSet<MIRJoinCondition> getExpressionJoinConditions(MIRFeature mIRFeature, MIRFeatureMap mIRFeatureMap) throws MIRException {
        MIRExpression mIRExpression = mIRFeatureMap.getExpression();
        if (mIRExpression == null) {
            mIRExpression = mIRFeatureMap.getClassifierMap().getExpression();
        }
        LinkedHashSet<MIRJoinCondition> linkedHashSet = new LinkedHashSet<MIRJoinCondition>();
        if (mIRExpression != null) {
            for (MIRElementNamePart mIRElementNamePart : mIRFeature.getReferencedByElementNameParts()) {
                MIRFeature mIRFeature2;
                MIRExpressionNode mIRExpressionNode;
                MIRExpression mIRExpression2 = null;
                MIROperatorNode mIROperatorNode = null;
                boolean bl = false;
                for (MIRObject mIRObject = mIRElementNamePart.getParent(); mIRObject != null; mIRObject = mIRObject.getParent()) {
                    if (mIRObject.isInstanceOf((short)111)) {
                        boolean bl2 = bl = ((MIRElementNode)mIRObject).getLeftOfOperatorNode() != null;
                    }
                    if (mIROperatorNode == null && mIRObject.isInstanceOf((short)115)) {
                        mIROperatorNode = (MIROperatorNode)mIRObject;
                    }
                    if (!mIRObject.isInstanceOf((short)112)) continue;
                    mIRExpression2 = (MIRExpression)mIRObject;
                    break;
                }
                if (mIRExpression2 != mIRExpression || mIROperatorNode == null) continue;
                MIRElementNode mIRElementNode = null;
                MIRExpressionNode mIRExpressionNode2 = mIRExpressionNode = bl ? mIROperatorNode.getRightExpressionNode() : mIROperatorNode.getLeftExpressionNode();
                if (mIRExpressionNode != null && mIRExpressionNode.isInstanceOf((short)111)) {
                    mIRElementNode = (MIRElementNode)mIRExpressionNode;
                }
                if (mIRElementNode == null || (mIRFeature2 = this.getReferencedFeature(mIRElementNode, mIRFeatureMap, new LinkedHashSet<MIRElementNode>())) == null) break;
                linkedHashSet = this.getExpressionJoinConditions(bl ? mIRFeature : mIRFeature2, bl ? mIRFeature2 : mIRFeature);
                break;
            }
        }
        return linkedHashSet;
    }

    private void addJoinCondition(MIRJoinCondition mIRJoinCondition, MIRMappingModel mIRMappingModel, String string, byte by, String string2) {
        if (mIRJoinCondition.getJoinRelationship() == null && mIRJoinCondition.getLeftFeature() != null && mIRJoinCondition.getRightFeature() != null) {
            MIRJoinRelationship mIRJoinRelationship = this.mergeJoinRelationship(mIRMappingModel, mIRJoinCondition.getLeftFeature().getClassifier(), mIRJoinCondition.getRightFeature().getClassifier(), by, string, string2);
            if (mIRJoinRelationship != null) {
                mIRJoinRelationship.addJoinCondition(mIRJoinCondition);
            } else {
                mIRJoinCondition.delete();
            }
        }
    }

    private void processJoinTransformations(MIRMappingModel mIRMappingModel, MIRElement mIRElement, byte by, MIRClassifier mIRClassifier, MIRClassifier mIRClassifier2) throws MIRException {
        ObjectCollector objectCollector = new ObjectCollector(new short[]{84});
        mIRElement.depthTraversal(objectCollector);
        ArrayList<MIRFeatureMap> arrayList = new ArrayList<MIRFeatureMap>();
        String string = this.getContentId(mIRMappingModel);
        for (MIRCondition mIRElement2 : objectCollector.getObjects()) {
            if (mIRElement2.getDestinationOfFeatureMap() == null) continue;
            arrayList.add(mIRElement2.getDestinationOfFeatureMap());
        }
        if (mIRElement.isInstanceOf((short)334) && ((MIRQueryJoin)mIRElement).getDestinationOfFeatureMap() != null) {
            arrayList.add(((MIRQueryJoin)mIRElement).getDestinationOfFeatureMap());
        }
        if (arrayList.size() == 0 && mIRClassifier != null && mIRClassifier2 != null) {
            this.mergeJoinRelationship(mIRMappingModel, mIRClassifier, mIRClassifier2, by, "", string);
            return;
        }
        for (MIRFeatureMap mIRFeatureMap : arrayList) {
            String string2 = mIRFeatureMap.getOperation();
            LinkedHashSet<MIRConnectionDataSet> linkedHashSet = new LinkedHashSet<MIRConnectionDataSet>();
            LinkedHashSet<MIRConnectionDataSet> linkedHashSet2 = new LinkedHashSet<MIRConnectionDataSet>();
            MIRJoinCondition mIRJoinCondition = new MIRJoinCondition();
            string2 = this.traceFeature(mIRFeatureMap.getDestinationFeature(), null);
            Object object = mIRFeatureMap.getSourceFeatures().iterator();
            while (object.hasNext()) {
                boolean bl;
                MIRFeature mIRFeature = (MIRFeature)object.next();
                LinkedHashSet<MIRJoinCondition> linkedHashSet3 = this.getExpressionJoinConditions(mIRFeature, mIRFeatureMap);
                for (MIRJoinCondition mIRJoinCondition2 : linkedHashSet3) {
                    this.addJoinCondition(mIRJoinCondition2, mIRMappingModel, string2, by, string);
                }
                if (linkedHashSet3.size() != 0 || mIRClassifier == null || mIRClassifier2 == null) continue;
                boolean bl2 = bl = mIRClassifier.containsFeature(mIRFeature) && (mIRClassifier != mIRClassifier2 || linkedHashSet2.size() != 0 || linkedHashSet.size() <= 0);
                if (bl) {
                    this.traceCondition(linkedHashSet, mIRFeature, new LinkedHashSet<MIRFeature>());
                    if (mIRJoinCondition.getLeftFeature() != null) continue;
                    mIRJoinCondition.addLeftFeature(mIRFeature);
                    continue;
                }
                this.traceCondition(linkedHashSet2, mIRFeature, new LinkedHashSet<MIRFeature>());
                if (mIRJoinCondition.getRightFeature() != null) continue;
                mIRJoinCondition.addRightFeature(mIRFeature);
            }
            if (mIRJoinCondition.getLeftFeature() != null && mIRJoinCondition.getRightFeature() != null && ((object = this.getJoinRelationship(mIRClassifier, mIRClassifier2, by, string2)) == null || !mIRJoinCondition.getLeftFeature().hasLineageOption(1) && !mIRJoinCondition.getRightFeature().hasLineageOption(1))) {
                mIRJoinCondition.setName(mIRJoinCondition.getLeftFeature().getName() + "=>" + mIRJoinCondition.getRightFeature().getName());
                this.addJoinCondition(mIRJoinCondition, mIRMappingModel, string2, by, string);
            }
            if (mIRJoinCondition.getJoinRelationship() != null) continue;
            mIRJoinCondition.delete();
        }
    }

    private void processJoinTransformations(MIRMappingModel mIRMappingModel, MIRDiModel mIRDiModel, MIRTransformation mIRTransformation, byte by, MIRTransformationDataSet mIRTransformationDataSet, MIRTransformationDataSet mIRTransformationDataSet2) throws MIRException {
        if (mIRTransformationDataSet != null && mIRTransformationDataSet2 != null) {
            ObjectCollector objectCollector = new ObjectCollector(new short[]{84});
            mIRTransformation.depthTraversal(objectCollector);
            for (MIRCondition mIRCondition : objectCollector.getObjects()) {
                MIRFeatureMap mIRFeatureMap = mIRCondition.getDestinationOfFeatureMap();
                if (mIRFeatureMap == null) continue;
                String string = mIRFeatureMap.getOperation();
                LinkedHashSet<MIRConnectionDataSet> linkedHashSet = new LinkedHashSet<MIRConnectionDataSet>();
                LinkedHashSet<MIRConnectionDataSet> linkedHashSet2 = new LinkedHashSet<MIRConnectionDataSet>();
                for (MIRFeature mIRFeature : mIRFeatureMap.getSourceFeatures()) {
                    if (mIRTransformationDataSet.containsFeature(mIRFeature)) {
                        this.traceCondition(linkedHashSet, mIRFeature, new LinkedHashSet<MIRFeature>());
                        continue;
                    }
                    this.traceCondition(linkedHashSet2, mIRFeature, new LinkedHashSet<MIRFeature>());
                }
                if (linkedHashSet.size() <= 0 || linkedHashSet2.size() <= 0) continue;
                for (MIRConnectionDataSet mIRConnectionDataSet : linkedHashSet) {
                    for (MIRConnectionDataSet mIRConnectionDataSet2 : linkedHashSet2) {
                        MIRConnectionDataSet mIRConnectionDataSet3 = this.searchSummyConnectionDataSet(mIRConnectionDataSet, mIRDiModel);
                        MIRConnectionDataSet mIRConnectionDataSet4 = this.searchSummyConnectionDataSet(mIRConnectionDataSet2, mIRDiModel);
                        this.mergeJoinRelationship(mIRDiModel, mIRConnectionDataSet3, mIRConnectionDataSet4, by, string, this.getContentId(mIRMappingModel));
                    }
                }
            }
        }
    }

    public void processJoinRelationship(MIRMappingModel mIRMappingModel) throws MIRException {
        MIRElement mIRElement22;
        Object object22;
        ObjectCollector objectCollector52;
        ObjectCollector objectCollector222;
        this.featureSummaries.clear();
        ObjectCollector objectCollector3 = new ObjectCollector(new short[]{240});
        mIRMappingModel.depthTraversal(objectCollector3);
        for (ObjectCollector objectCollector222 : objectCollector3.getObjects()) {
            objectCollector52 = ((MIRJoinTransformation)((Object)objectCollector222)).getLeftTransformationDataSet();
            object22 = ((MIRJoinTransformation)((Object)objectCollector222)).getRightTransformationDataSet();
            this.processJoinTransformations(mIRMappingModel, (MIRElement)((Object)objectCollector222), ((MIRJoinTransformation)((Object)objectCollector222)).getType(), (MIRClassifier)((Object)objectCollector52), (MIRClassifier)object22);
        }
        ObjectCollector objectCollector4 = new ObjectCollector(new short[]{334});
        mIRMappingModel.depthTraversal(objectCollector4);
        for (ObjectCollector objectCollector52 : objectCollector4.getObjects()) {
            object22 = ((MIRQueryJoin)((Object)objectCollector52)).getLeftQueryTable();
            mIRElement22 = ((MIRQueryJoin)((Object)objectCollector52)).getRightQueryTable();
            this.processJoinTransformations(mIRMappingModel, (MIRElement)((Object)objectCollector52), ((MIRQueryJoin)((Object)objectCollector52)).getJoinType(), (MIRClassifier)object22, (MIRClassifier)mIRElement22);
        }
        objectCollector222 = new ObjectCollector(new short[]{241});
        mIRMappingModel.depthTraversal(objectCollector222);
        for (Object object22 : objectCollector222.getObjects()) {
            mIRElement22 = ((MIRLookupTransformation)object22).getControlTransformationDataSet();
            Object object3 = ((MIRLookupTransformation)object22).getDataTransformationDataSet();
            if (mIRElement22 == null) {
                mIRElement22 = ((MIRLookupTransformation)object22).getOutputTransformationDataSet();
            }
            if (object3 == null) {
                object3 = ((MIRLookupTransformation)object22).getOutputTransformationDataSet();
            }
            this.processJoinTransformations(mIRMappingModel, (MIRElement)object22, (byte)5, (MIRClassifier)mIRElement22, (MIRClassifier)object3);
        }
        objectCollector52 = new ObjectCollector(new short[]{251});
        mIRMappingModel.depthTraversal(objectCollector52);
        for (MIRElement mIRElement22 : objectCollector52.getObjects()) {
            for (MIRClassifierMap mIRClassifierMap : ((MIRTransformation)mIRElement22).getClassifierMaps()) {
                LinkedHashSet<MIRConnectionDataSet> linkedHashSet = new LinkedHashSet<MIRConnectionDataSet>();
                LinkedHashSet<MIRConnectionDataSet> linkedHashSet2 = new LinkedHashSet<MIRConnectionDataSet>();
                for (MIRClassifier mIRClassifier : mIRClassifierMap.getSourceClassifiers()) {
                    if (!mIRClassifier.isInstanceOf((short)254)) continue;
                    if (linkedHashSet.size() == 0) {
                        linkedHashSet.add((MIRConnectionDataSet)mIRClassifier);
                        continue;
                    }
                    if (linkedHashSet2.contains(mIRClassifier)) continue;
                    linkedHashSet2.add((MIRConnectionDataSet)mIRClassifier);
                }
                if (linkedHashSet.size() <= 0 || linkedHashSet2.size() <= 0) continue;
                for (MIRConnectionDataSet mIRConnectionDataSet : linkedHashSet) {
                    for (MIRConnectionDataSet mIRConnectionDataSet2 : linkedHashSet2) {
                        this.processJoinTransformations(mIRMappingModel, mIRElement22, (byte)0, mIRConnectionDataSet, mIRConnectionDataSet2);
                    }
                }
            }
        }
    }

    private void processJoinRelationship(MIRMappingModel mIRMappingModel, MIRDiModel mIRDiModel) throws MIRException {
        MIRElement mIRElement22;
        ObjectCollector objectCollector32;
        ObjectCollector objectCollector2 = new ObjectCollector(new short[]{240});
        mIRMappingModel.depthTraversal(objectCollector2);
        for (ObjectCollector objectCollector32 : objectCollector2.getObjects()) {
            Object object = ((MIRJoinTransformation)((Object)objectCollector32)).getLeftTransformationDataSet();
            mIRElement22 = ((MIRJoinTransformation)((Object)objectCollector32)).getRightTransformationDataSet();
            this.processJoinTransformations(mIRMappingModel, mIRDiModel, (MIRTransformation)((Object)objectCollector32), ((MIRJoinTransformation)((Object)objectCollector32)).getType(), (MIRTransformationDataSet)object, (MIRTransformationDataSet)mIRElement22);
        }
        ObjectCollector objectCollector4 = new ObjectCollector(new short[]{241});
        mIRMappingModel.depthTraversal(objectCollector4);
        for (Object object : objectCollector4.getObjects()) {
            mIRElement22 = ((MIRLookupTransformation)object).getControlTransformationDataSet();
            MIRTransformationDataSet mIRTransformationDataSet = ((MIRLookupTransformation)object).getDataTransformationDataSet();
            this.processJoinTransformations(mIRMappingModel, mIRDiModel, (MIRTransformation)object, (byte)5, (MIRTransformationDataSet)mIRElement22, mIRTransformationDataSet);
        }
        objectCollector32 = new ObjectCollector(new short[]{251});
        mIRMappingModel.depthTraversal(objectCollector32);
        for (MIRElement mIRElement22 : objectCollector32.getObjects()) {
            for (MIRClassifierMap mIRClassifierMap : ((MIRTransformation)mIRElement22).getClassifierMaps()) {
                LinkedHashSet<MIRConnectionDataSet> linkedHashSet = new LinkedHashSet<MIRConnectionDataSet>();
                LinkedHashSet<MIRConnectionDataSet> linkedHashSet2 = new LinkedHashSet<MIRConnectionDataSet>();
                for (MIRClassifier mIRClassifier : mIRClassifierMap.getSourceClassifiers()) {
                    if (!mIRClassifier.isInstanceOf((short)254)) continue;
                    if (linkedHashSet.size() == 0) {
                        linkedHashSet.add((MIRConnectionDataSet)mIRClassifier);
                        continue;
                    }
                    if (linkedHashSet2.contains(mIRClassifier)) continue;
                    linkedHashSet2.add((MIRConnectionDataSet)mIRClassifier);
                }
                if (linkedHashSet.size() <= 0 || linkedHashSet2.size() <= 0) continue;
                for (MIRConnectionDataSet mIRConnectionDataSet : linkedHashSet) {
                    for (MIRConnectionDataSet mIRConnectionDataSet2 : linkedHashSet2) {
                        MIRConnectionDataSet mIRConnectionDataSet3 = this.searchSummyConnectionDataSet(mIRConnectionDataSet, mIRDiModel);
                        MIRConnectionDataSet mIRConnectionDataSet4 = this.searchSummyConnectionDataSet(mIRConnectionDataSet2, mIRDiModel);
                        this.mergeJoinRelationship(mIRDiModel, mIRConnectionDataSet3, mIRConnectionDataSet4, (byte)0, mIRClassifierMap.getOperation(), this.getContentId(mIRMappingModel));
                    }
                }
            }
        }
    }

    public void summarizeModel(MIRMappingModel mIRMappingModel, MIRDiModel mIRDiModel) throws MIRException {
        LinkedHashSet<MIRFeature> linkedHashSet = new LinkedHashSet<MIRFeature>();
        this.mergeStoreConnections(mIRMappingModel, mIRDiModel, linkedHashSet);
        this.processJoinRelationship(mIRMappingModel, mIRDiModel);
        for (MIRFeature mIRFeature : linkedHashSet) {
            MIRConnectionDataAttribute mIRConnectionDataAttribute = this.featureAttributes.get(mIRFeature);
            if (!mIRFeature.isInstanceOf((short)261) && !mIRFeature.isInstanceOf((short)242) && !mIRFeature.isInstanceOf((short)329)) continue;
            for (MIRSummaryMap mIRSummaryMap : mIRFeature.getDestinationOfSummaryMaps()) {
                MIRConnectionDataAttribute mIRConnectionDataAttribute2;
                MIRSummaryMap mIRSummaryMap2 = null;
                for (MIRSummaryMap mIRSummaryMap3 : mIRConnectionDataAttribute.getDestinationOfSummaryMaps()) {
                    if (mIRSummaryMap3.getOperation().compareToIgnoreCase(mIRSummaryMap.getOperation()) != 0 || mIRSummaryMap3.getExternalContentId().compareToIgnoreCase(mIRSummaryMap.getExternalContentId()) != 0) continue;
                    mIRSummaryMap2 = mIRSummaryMap3;
                }
                if (mIRSummaryMap2 == null) {
                    mIRSummaryMap2 = new MIRSummaryMap(mIRSummaryMap);
                    mIRSummaryMap2.addDestinationFeature(mIRConnectionDataAttribute);
                    mIRSummaryMap2.setExternalContentId(this.getContentId(mIRMappingModel));
                }
                for (MIRFeature mIRFeature2 : mIRSummaryMap.getSourceFeatures()) {
                    mIRConnectionDataAttribute2 = this.featureAttributes.get(mIRFeature2);
                    if (mIRConnectionDataAttribute2 == null || mIRSummaryMap2.containsSourceFeature(mIRConnectionDataAttribute2)) continue;
                    mIRSummaryMap2.addSourceFeature(mIRConnectionDataAttribute2);
                }
                for (MIRFeature mIRFeature3 : mIRSummaryMap.getControlFeatures()) {
                    mIRConnectionDataAttribute2 = this.featureAttributes.get(mIRFeature3);
                    if (mIRConnectionDataAttribute2 == null || mIRSummaryMap2.containsControlFeature(mIRConnectionDataAttribute2)) continue;
                    mIRSummaryMap2.addControlFeature(mIRConnectionDataAttribute2);
                }
                for (MIRFeature mIRFeature4 : mIRSummaryMap.getDataControlFeatures()) {
                    mIRConnectionDataAttribute2 = this.featureAttributes.get(mIRFeature4);
                    if (mIRConnectionDataAttribute2 == null || mIRSummaryMap2.containsDataControlFeature(mIRConnectionDataAttribute2)) continue;
                    mIRSummaryMap2.addDataControlFeature(mIRConnectionDataAttribute2);
                }
                if (mIRSummaryMap2.getSourceFeatureCount() != 0 || mIRSummaryMap2.getControlFeatureCount() != 0 || mIRSummaryMap2.getDataControlFeatureCount() != 0 || !mIRSummaryMap2.getOperation().isEmpty()) continue;
                mIRSummaryMap2.removeDestinationFeature();
            }
        }
    }

    protected void summarizeRuntime(MIRDiRuntimeContent mIRDiRuntimeContent, MIRDiModel mIRDiModel) throws MIRException {
        try {
            MIRDiModel mIRDiModel2 = (MIRDiModel)this.mixCache.loadModel(mIRDiRuntimeContent);
            this.summarizeModel(mIRDiModel2, mIRDiModel);
            this.mixCache.removeModel(mIRDiModel2);
            mIRDiModel2.delete();
            mIRDiModel2 = null;
        }
        catch (MIRException mIRException) {
            BLIB.DBG_DEBUG.log(mIRException, "Fail to process summary of runtime");
        }
    }

    protected void summarizeFolder(MIRFolderContent mIRFolderContent, MIRDiModel mIRDiModel) throws MIRException {
        if (mIRFolderContent.isInstanceOf((short)157)) {
            MIRFolder mIRFolder = (MIRFolder)mIRFolderContent;
            for (MIRFolderContent mIRFolderContent2 : mIRFolder.getFolderContents()) {
                this.summarizeFolder(mIRFolderContent2, mIRDiModel);
            }
        } else if (mIRFolderContent.isInstanceOf((short)278) && ((MIRDiDesignContent)mIRFolderContent).getExecutable()) {
            MIRDiDesignContent mIRDiDesignContent = (MIRDiDesignContent)mIRFolderContent;
            for (MIRDiRuntimeContent mIRDiRuntimeContent : mIRDiDesignContent.getExecutedDiRuntimeContents()) {
                this.summarizeRuntime(mIRDiRuntimeContent, mIRDiModel);
            }
        } else if (mIRFolderContent.isInstanceOf((short)283)) {
            this.summarizeRuntime((MIRDiRuntimeContent)mIRFolderContent, mIRDiModel);
        }
    }

    public MIRLineageSummaryContent summarizeDirectoryStructure(MIRDirectoryStructureModel mIRDirectoryStructureModel) throws MIRException {
        MIRLineageSummaryContent mIRLineageSummaryContent = new MIRLineageSummaryContent();
        mIRLineageSummaryContent.setName(SUMMARY_CONTENT_NAME);
        mIRLineageSummaryContent.setLastModificationTime(MIRDate.getCurrentDate());
        mIRDirectoryStructureModel.addFolderContent(mIRLineageSummaryContent);
        MIRDiModel mIRDiModel = new MIRDiModel();
        mIRDiModel.setName(SUMMARY_MODEL_NAME);
        mIRLineageSummaryContent.addModel(mIRDiModel);
        MIRMetadataOrigin mIRMetadataOrigin = new MIRMetadataOrigin();
        mIRDiModel.addMetadataOrigin(mIRMetadataOrigin);
        if (mIRDirectoryStructureModel.getMetadataOrigin() != null) {
            mIRMetadataOrigin.setFrom(mIRDirectoryStructureModel.getMetadataOrigin());
        }
        mIRMetadataOrigin.setProfileId(ProfileIds.META_INTEGRATION_ETL_SUMMARY__RUNTIME_SUMMARY);
        for (MIRFolderContent mIRElement : mIRDirectoryStructureModel.getFolderContents()) {
            this.summarizeFolder(mIRElement, mIRDiModel);
        }
        for (MIRStoreConnection mIRStoreConnection : mIRDiModel.getStoreConnections()) {
            EtlSummarizer.ensureSummaryUsage(mIRDirectoryStructureModel, mIRStoreConnection);
        }
        MIRTypeLib.factorizeTypes(mIRDiModel, true, true);
        this.mixCache.saveModel(mIRLineageSummaryContent);
        this.mixCache.removeModel(mIRDiModel);
        mIRDiModel.delete();
        mIRDiModel = null;
        return mIRLineageSummaryContent;
    }

    private static /* synthetic */ void lambda$summarizeControlLinks$1(StringBuilder stringBuilder, MIRFeature mIRFeature) {
        stringBuilder.append(stringBuilder.length() == 0 ? mIRFeature.getName() : "," + mIRFeature.getName());
    }
}

