/*
 * Decompiled with CFR 0.152.
 */
package MITI.server.services.common.mir;

import MITI.server.services.common.mir.ObjectIdentity;

public class ObjectIdentifier
implements ObjectIdentity,
Comparable<ObjectIdentifier> {
    private int modelId = 0;
    private int objectId = 0;

    public ObjectIdentifier() {
    }

    public ObjectIdentifier(int n, int n2) {
        this.modelId = n;
        this.objectId = n2;
    }

    public ObjectIdentifier(ObjectIdentifier objectIdentifier) {
        this(objectIdentifier.modelId, objectIdentifier.objectId);
    }

    public int getModelId() {
        return this.modelId;
    }

    public void setModelId(int n) {
        this.modelId = n;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public void setObjectId(int n) {
        this.objectId = n;
    }

    @Override
    public ObjectIdentifier getId() {
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectIdentifier) {
            ObjectIdentifier objectIdentifier = (ObjectIdentifier)object;
            return this.modelId == objectIdentifier.modelId && this.objectId == objectIdentifier.objectId;
        }
        return false;
    }

    public static boolean equals(ObjectIdentifier objectIdentifier, ObjectIdentifier objectIdentifier2) {
        if (objectIdentifier == null) {
            return objectIdentifier2 == null;
        }
        return objectIdentifier.equals(objectIdentifier2);
    }

    public int hashCode() {
        return this.modelId << 20 + this.objectId;
    }

    public final String serialize() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[').append(this.modelId).append(',').append(this.objectId).append(']');
        return stringBuffer.toString();
    }

    public String toString() {
        return this.serialize();
    }

    public static ObjectIdentifier deserialize(String string) {
        if (string == null) {
            return null;
        }
        if (!(string = string.trim()).startsWith("[") || !string.endsWith("]")) {
            return null;
        }
        String[] stringArray = (string = string.substring(1, string.length() - 1)).split(",");
        if (stringArray == null || stringArray.length != 2) {
            return null;
        }
        ObjectIdentifier objectIdentifier = new ObjectIdentifier();
        try {
            objectIdentifier.setModelId(Integer.parseInt(stringArray[0].trim()));
            objectIdentifier.setObjectId(Integer.parseInt(stringArray[1].trim()));
        }
        catch (NumberFormatException numberFormatException) {
            objectIdentifier = null;
        }
        return objectIdentifier;
    }

    @Override
    public int compareTo(ObjectIdentifier objectIdentifier) {
        if (this.modelId > objectIdentifier.modelId) {
            return 1;
        }
        if (this.modelId < objectIdentifier.modelId) {
            return -1;
        }
        if (this.objectId > objectIdentifier.objectId) {
            return 1;
        }
        if (this.objectId < objectIdentifier.objectId) {
            return -1;
        }
        return 0;
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(').append(this.modelId).append(',').append(this.objectId).append(')');
        return stringBuffer.toString();
    }
}

