/*
 * Decompiled with CFR 0.152.
 */
package MITI.server.services.common.mir;

import MITI.sdk.MIRMetaAttribute;
import MITI.server.services.common.mir.LinkIdentifier;

public class AttributeIdentifier
implements Comparable<AttributeIdentifier> {
    private static final String PHYSICAL_NAME_OR_NAME = "$PhysicalNameOrName";
    private static final String DB_LABEL = "Label";
    private static final String DB_COMMENT = "Comment";
    private short type = (short)-1;
    private String name = null;
    private LinkIdentifier link = null;

    public AttributeIdentifier() {
    }

    public String toString() {
        return this.toMPath();
    }

    public AttributeIdentifier(short s) {
        this.type = s;
    }

    public AttributeIdentifier(AttributeIdentifier attributeIdentifier) {
        this.type = attributeIdentifier.type;
        this.name = attributeIdentifier.name;
        if (attributeIdentifier.link != null) {
            this.link = new LinkIdentifier(attributeIdentifier.link);
        }
    }

    public AttributeIdentifier(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public final short getId() {
        return this.link == null ? (short)this.type : (short)-1;
    }

    public short getType() {
        return this.type;
    }

    public void setType(short s) {
        this.type = s;
    }

    public LinkIdentifier getLink() {
        return this.link;
    }

    public void setLink(LinkIdentifier linkIdentifier) {
        this.link = linkIdentifier;
    }

    public boolean _isUdp() {
        return this.type == -1 && this.name != null && !this.name.isEmpty();
    }

    public boolean equals(Object object) {
        if (object instanceof AttributeIdentifier) {
            AttributeIdentifier attributeIdentifier = (AttributeIdentifier)object;
            if (this.type == -1) {
                if ((this.name == null || this.name.isEmpty()) && attributeIdentifier.name != null && !attributeIdentifier.name.isEmpty()) {
                    return false;
                }
                if (this.name != null && !this.name.isEmpty() && !this.name.equals(attributeIdentifier.name)) {
                    return false;
                }
            }
            if (this.link == null && attributeIdentifier.link != null) {
                return false;
            }
            if (this.link != null && !this.link.equals(attributeIdentifier.link)) {
                return false;
            }
            return this.type == attributeIdentifier.type;
        }
        if (object instanceof Short) {
            return this.link == null && this.type == (Short)object;
        }
        return false;
    }

    public int hashCode() {
        if (this.type == -1 && this.name != null && !this.name.isEmpty()) {
            return this.name.hashCode();
        }
        return this.type;
    }

    @Override
    public int compareTo(AttributeIdentifier attributeIdentifier) {
        if (this.type == -1 && attributeIdentifier.type == -1) {
            if (this.name == null || this.name.isEmpty()) {
                if (attributeIdentifier.name != null && !attributeIdentifier.name.isEmpty()) {
                    return -1;
                }
            } else {
                if (attributeIdentifier.name == null || attributeIdentifier.name.isEmpty()) {
                    return 1;
                }
                int n = this.name.compareTo(attributeIdentifier.name);
                if (n != 0) {
                    return n;
                }
            }
        } else {
            if (this.type > attributeIdentifier.type) {
                return 1;
            }
            if (this.type < attributeIdentifier.type) {
                return -1;
            }
        }
        if (this.link == null) {
            if (attributeIdentifier.link == null) {
                return 0;
            }
            return -1;
        }
        if (attributeIdentifier.link == null) {
            return 1;
        }
        return this.link.compareTo(attributeIdentifier.link);
    }

    public String toMPath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.link != null) {
            stringBuffer.append(this.link.toMPath());
        }
        if (this.type > -1) {
            stringBuffer.append("@");
            MIRMetaAttribute mIRMetaAttribute = MIRMetaAttribute.getByAttributeType(this.type);
            stringBuffer.append(mIRMetaAttribute.getName().substring(0, 1).toLowerCase()).append(mIRMetaAttribute.getName().substring(1));
        } else if (this.type < -1) {
            stringBuffer.append("@");
            stringBuffer.append(AttributeIdentifier.getSpecialAttributeName(this.type));
        } else if (this.name != null) {
            stringBuffer.append("@");
            stringBuffer.append("'").append(this.name).append("'");
        }
        return stringBuffer.toString();
    }

    public static boolean isSpecialAttribute(short s) {
        return s < -1;
    }

    public static String getSpecialAttributeName(short s) {
        if (s == -2) {
            return PHYSICAL_NAME_OR_NAME;
        }
        if (s == -3) {
            return DB_LABEL;
        }
        if (s == -4) {
            return DB_COMMENT;
        }
        return null;
    }

    public boolean _isReadOnly() {
        if (AttributeIdentifier.isSpecialAttribute(this.type) || this.link != null) {
            return true;
        }
        if (this._isUdp()) {
            return false;
        }
        return this.type == 251 || this.type == 252 || this.type == 207 || this.type == 172 || this.type == 147 || this.type == 225 || this.type == 264;
    }

    public boolean _isSpecialAttribute() {
        return AttributeIdentifier.isSpecialAttribute(this.type);
    }

    public String _getAttributeName() {
        if (this._isUdp()) {
            return this.name;
        }
        if (AttributeIdentifier.isSpecialAttribute(this.type)) {
            return AttributeIdentifier.getSpecialAttributeName(this.type);
        }
        MIRMetaAttribute mIRMetaAttribute = MIRMetaAttribute.getByAttributeType(this.type);
        return mIRMetaAttribute.getName();
    }

    public boolean _isSimple() {
        return this.link == null;
    }
}

