/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.validation;

import MITI.MIRException;
import MITI.messages.MIR.MIRSDK;
import MITI.messages.MIR.MVLD;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.validation.MIRValidate;
import MITI.sdk.validation.MIRValidationLevel;

public class MIRValidation {
    public static void validateModel(MIRModel mIRModel, MIRValidationLevel.Enum enum_, boolean bl) throws MIRException {
        if (enum_ == MIRValidationLevel.DISABLED) {
            return;
        }
        if (!bl) {
            switch (enum_) {
                case NONE: 
                case DISABLED: {
                    MVLD.NO_VALIDATION.log(new Object[0]);
                    break;
                }
                case BASIC: 
                case BROWSE: {
                    MVLD.BASIC_VALIDATION.log(new Object[0]);
                    break;
                }
                case ADVANCED: {
                    MVLD.DETAILED_VALIDATION.log(new Object[0]);
                    break;
                }
            }
            if (enum_ != MIRValidationLevel.NONE) {
                MVLD.VALIDATING_MODEL.log(mIRModel.getName());
            }
        }
        if (!MIRValidation.validate(mIRModel, enum_)) {
            throw new MIRException(MVLD.MODEL_NOT_CONSISTENT.getMessage(new Object[0]));
        }
    }

    public static boolean validate(MIRObject mIRObject, MIRValidationLevel.Enum enum_) {
        MIRValidate mIRValidate = new MIRValidate();
        boolean bl = false;
        try {
            bl = mIRValidate.validate(mIRObject, enum_);
        }
        catch (MIRException mIRException) {
            MIRSDK.EXCEPTION.log(mIRException, mIRException.getMessage());
        }
        return bl;
    }

    public static String buildValidationName(MIRObject mIRObject) {
        if (mIRObject == null) {
            return "<null>";
        }
        return mIRObject.getPath();
    }
}

