/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.validation;

import MITI.MIRException;
import MITI.messages.MIR.MVLD;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.validation.MIRLoopDetector;
import MITI.sdk.validation.MIRValidateObject;
import MITI.sdk.validation.MIRValidationLevel;
import java.util.HashSet;
import java.util.TreeSet;

class MIRValidate
extends MIRValidateObject {
    private MIRObject root = null;
    private TreeSet<MIRObject> validatedObjects = new TreeSet();

    MIRValidate() {
        this.nativeIds = new HashSet();
    }

    @Override
    String buildValidationName(MIRObject mIRObject) {
        if (mIRObject == null) {
            return "<null>";
        }
        return mIRObject.getPath();
    }

    @Override
    boolean hasBeenValidated(MIRObject mIRObject) {
        return this.validatedObjects.contains(mIRObject);
    }

    @Override
    MIRObject getRoot() {
        return this.root;
    }

    boolean validate(MIRObject mIRObject, MIRValidationLevel.Enum enum_) throws MIRException {
        if (enum_ == MIRValidationLevel.NONE) {
            return true;
        }
        this.validatedObjects.clear();
        this.nativeIds.clear();
        this.root = mIRObject;
        boolean bl = this.validate(mIRObject, enum_, true);
        MIRLoopDetector mIRLoopDetector = new MIRLoopDetector();
        mIRLoopDetector.hasLoop(mIRObject);
        this.validatedObjects.clear();
        this.nativeIds.clear();
        return bl;
    }

    @Override
    boolean validateParentHierarchy(MIRObject mIRObject) {
        if (this.validatedObjects.contains(mIRObject)) {
            return true;
        }
        MIRModel mIRModel = mIRObject.getRootModel();
        if (mIRModel != null && mIRModel != this.root.getRootModel() && mIRModel != this.root.getRootObject()) {
            MVLD.VALID_CROSS_MODEL_LINK.log(MIRElementType.getName(mIRObject.getElementType()), this.buildValidationName(mIRObject), this.buildValidationName(this.root));
        } else {
            MIRObject mIRObject2 = mIRObject.getRootObject();
            if (mIRObject2 == this.root || mIRObject2 == this.root.getRootObject()) {
                return true;
            }
            if (!this.validatedObjects.contains(mIRObject2)) {
                this.validatedObjects.add(mIRObject2);
                MVLD.VALID_MISSING_PARENT.log(MIRElementType.getName(mIRObject2.getElementType()), this.buildValidationName(mIRObject2), this.buildValidationName(this.root));
            }
        }
        return false;
    }

    @Override
    boolean validateMIR_Object(MIRObject mIRObject, MIRValidationLevel.Enum enum_, boolean bl) throws MIRException {
        this.validatedObjects.add(mIRObject);
        return true;
    }
}

