/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.mix.ids;

import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRType;
import MITI.sdk.MIR_Object;
import MITI.sdk.mix.MIRObjectCache;
import MITI.server.services.common.mir.ObjectDefinition;
import MITI.server.services.common.mir.ObjectIdentifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class ModelObjectCache
implements MIRObjectCache {
    private static final int OBJECT_INC_FACTOR = 1000;
    private int modelId;
    private int maxId;
    private MIRObject[] objects;
    private static Comparator<MIRObject> childrenComparator = new Comparator<MIRObject>(){

        @Override
        public int compare(MIRObject mIRObject, MIRObject mIRObject2) {
            int n = 0;
            n = mIRObject.getElementType() - mIRObject2.getElementType();
            if (n == 0) {
                n = mIRObject.getName().compareTo(mIRObject2.getName());
                if (n == 0 && mIRObject instanceof MIRType) {
                    n = ((MIRType)mIRObject).getDataType().compareTo(((MIRType)mIRObject2).getDataType());
                }
                if (n == 0) {
                    n = mIRObject.toString().compareTo(mIRObject2.toString());
                }
            }
            return n;
        }
    };

    public ModelObjectCache(int n) {
        this.modelId = n;
        this.maxId = 0;
        this.objects = new MIRObject[0];
    }

    public void clear() {
        this.maxId = 0;
        this.objects = new MIRObject[0];
    }

    public void put(ObjectIdentifier objectIdentifier, MIRObject mIRObject) {
        if (objectIdentifier.getObjectId() > this.maxId) {
            this.maxId = objectIdentifier.getObjectId();
            if (this.maxId >= this.objects.length) {
                this.objects = Arrays.copyOf(this.objects, this.maxId + 1000);
            }
        }
        mIRObject.setModelId(this.modelId);
        mIRObject.setObjectId(objectIdentifier.getObjectId());
        this.objects[mIRObject.getObjectId()] = mIRObject;
    }

    public void add(MIRObject mIRObject) {
        new PopulateIds().run(mIRObject);
    }

    @Override
    public MIRObject getMirObject(ObjectIdentifier objectIdentifier) {
        if (objectIdentifier.getObjectId() > 0 && objectIdentifier.getObjectId() < this.objects.length) {
            return this.objects[objectIdentifier.getObjectId()];
        }
        return null;
    }

    @Override
    public ObjectIdentifier getObjectIdentifier(MIRObject mIRObject) {
        if (mIRObject.getModelId() == this.modelId && mIRObject.getObjectId() > 0 && mIRObject.getObjectId() < this.objects.length) {
            return new ObjectIdentifier(this.modelId, mIRObject.getObjectId());
        }
        return null;
    }

    @Override
    public ObjectDefinition getObjectDefinition(MIRObject mIRObject) {
        if (mIRObject.getModelId() == this.modelId && mIRObject.getObjectId() > 0 && mIRObject.getObjectId() < this.objects.length) {
            return new ObjectDefinition(this.modelId, mIRObject.getObjectId(), mIRObject.getElementType(), mIRObject.getName());
        }
        return null;
    }

    public int hashCode() {
        return this.modelId;
    }

    public boolean equals(Object object) {
        ModelObjectCache modelObjectCache = (ModelObjectCache)object;
        return this.modelId == modelObjectCache.modelId;
    }

    private class PopulateIds {
        private ArrayList<MIRObject> objs = new ArrayList();

        private PopulateIds() {
        }

        public void run(MIRObject mIRObject) {
            this.traverse(mIRObject);
            for (MIRObject mIRObject2 : this.objs) {
                ObjectIdentifier objectIdentifier = new ObjectIdentifier(ModelObjectCache.this.modelId, ModelObjectCache.this.maxId + 1);
                ModelObjectCache.this.put(objectIdentifier, mIRObject2);
            }
        }

        private void traverse(MIRObject mIRObject) {
            if (mIRObject.getModelId() == ModelObjectCache.this.modelId && mIRObject.getObjectId() > 0) {
                ModelObjectCache.this.put(new ObjectIdentifier(ModelObjectCache.this.modelId, mIRObject.getObjectId()), mIRObject);
            } else {
                this.objs.add(mIRObject);
            }
            MIRMetaClass mIRMetaClass = mIRObject.getMetaClass();
            for (MIRMetaLink mIRMetaLink : mIRMetaClass.getLinks()) {
                if (mIRMetaLink.getType() != 3) continue;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Iterator<? extends MIRObject> iterator = mIRMetaLink.getIterator((MIR_Object)mIRObject);
                while (iterator.hasNext()) {
                    MIRObject mIRObject2 = iterator.next();
                    if (mIRObject2.isInstanceOf((short)218)) continue;
                    arrayList.add(mIRObject2);
                }
                Collections.sort(arrayList, childrenComparator);
                for (MIRObject mIRObject3 : arrayList) {
                    this.traverse(mIRObject3);
                }
            }
        }
    }
}

