/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.mix.checksum;

import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRType;
import MITI.sdk.MIR_Object;
import MITI.sdk.mix.checksum.MixChecksum;
import MITI.util.StringDigest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;

public abstract class ModelChecksum
extends MixChecksum {
    private StringDigest structure = StringDigest.getMd5();
    private File debugOutputFile;
    private PrintStream debugOutputStream;
    private String structureValue = null;

    protected ModelChecksum() {
    }

    public void setDebugOutputFile(File file) {
        this.debugOutputFile = file;
    }

    @Override
    public String getStructure() {
        return this.structureValue;
    }

    public void compute(MIRModel mIRModel) {
        this.openDebugStream();
        try {
            this.processObject(mIRModel);
        }
        finally {
            this.closeDebugStream();
            this.structureValue = this.structure.toString();
        }
    }

    private void openDebugStream() {
        if (this.debugOutputFile != null) {
            try {
                this.debugOutputStream = new PrintStream(this.debugOutputFile, "UTF-8");
            }
            catch (FileNotFoundException | UnsupportedEncodingException iOException) {
                // empty catch block
            }
        }
    }

    private void closeDebugStream() {
        if (this.debugOutputStream != null) {
            this.debugOutputStream.flush();
            this.debugOutputStream.close();
            this.debugOutputStream = null;
        }
    }

    protected abstract String getStructure(MIRObject var1);

    private void updateChecksum(StringDigest stringDigest, String string) {
        if (string != null && !string.isEmpty()) {
            stringDigest.update(string).update((byte)0);
        }
    }

    protected boolean traverse(MIRObject mIRObject) {
        return true;
    }

    private final void processObject(MIRObject mIRObject) {
        String string = this.getStructure(mIRObject);
        if (this.debugOutputStream != null) {
            this.debugOutputStream.println(string);
        }
        this.updateChecksum(this.structure, string);
        if (this.traverse(mIRObject)) {
            MIRMetaClass mIRMetaClass = mIRObject.getMetaClass();
            for (MIRMetaLink mIRMetaLink : mIRMetaClass.getLinks()) {
                if (mIRMetaLink.getType() != 3) continue;
                Iterator<? extends MIRObject> iterator = mIRMetaLink.getIterator((MIR_Object)mIRObject);
                while (iterator.hasNext()) {
                    this.processObject(iterator.next());
                }
            }
        }
    }

    protected String getID(MIRObject mIRObject) {
        String string = mIRObject.getName();
        if (mIRObject instanceof MIRType) {
            string = string + ((MIRType)mIRObject).getDataType();
        }
        return string;
    }
}

