/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.mix.checksum;

public abstract class MixChecksum {
    protected static final String CHECKSUM_START = "<checksum>";
    protected static final String CHECKSUM_END = "</checksum>";
    protected static final String STRUCTURE_START = "<structure>";
    protected static final String STRUCTURE_END = "</structure>";

    public abstract String getStructure();

    public static ChecksumDiff compare(MixChecksum mixChecksum, MixChecksum mixChecksum2) {
        if (mixChecksum == null || mixChecksum2 == null) {
            return ChecksumDiff.MISSING;
        }
        if (mixChecksum.getStructure() == null || mixChecksum2.getStructure() == null) {
            return ChecksumDiff.MISSING;
        }
        if (!mixChecksum.getStructure().equals(mixChecksum2.getStructure())) {
            return ChecksumDiff.STRUCTURE;
        }
        return ChecksumDiff.EQUAL;
    }

    public String toXml() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CHECKSUM_START);
        stringBuilder.append(STRUCTURE_START).append(this.getStructure()).append(STRUCTURE_END);
        stringBuilder.append(CHECKSUM_END);
        return stringBuilder.toString();
    }

    public static enum ChecksumDiff {
        MISSING,
        STRUCTURE,
        LINEAGE,
        EQUAL;

    }
}

