/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.mix.checksum;

import MITI.sdk.mix.checksum.MixChecksum;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class FileChecksum
extends MixChecksum {
    private String structure;

    public FileChecksum(String string, String string2) {
        this.structure = string;
    }

    public static FileChecksum read(File file) {
        if (file.isFile() && file.canRead()) {
            char[] cArray = new char[4096];
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
                bufferedReader.read(cArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return FileChecksum.read(new String(cArray));
        }
        return null;
    }

    public static FileChecksum read(String string) {
        if (string != null) {
            String string2;
            int n = string.indexOf("<checksum>");
            int n2 = string.indexOf("</checksum>");
            if (n > -1 && n2 > -1 && (string2 = FileChecksum.getSubstring(string, "<structure>", n, n2)) != null) {
                return new FileChecksum(string2, "");
            }
        }
        return null;
    }

    private static String getSubstring(String string, String string2, int n, int n2) {
        int n3 = string.indexOf(string2, n);
        if (n3 > n && n3 < n2) {
            return string.substring(n3 + string2.length(), n3 + string2.length() + 32);
        }
        return null;
    }

    @Override
    public String getStructure() {
        return this.structure;
    }

    public static MixChecksum.ChecksumDiff compare(File file, File file2) {
        return FileChecksum.compare(FileChecksum.read(file), FileChecksum.read(file2));
    }

    public static void main(String[] stringArray) {
        FileChecksum fileChecksum;
        FileChecksum fileChecksum2;
        if (stringArray.length != 2) {
            System.err.println("Missing source or target file");
            System.exit(3);
        }
        if ((fileChecksum2 = FileChecksum.read(new File(stringArray[0]))) == null) {
            System.err.println("Missing checksum on source");
            System.exit(1);
        }
        if ((fileChecksum = FileChecksum.read(new File(stringArray[1]))).getStructure() == null) {
            System.err.println("Missing checksum on destination");
            System.exit(2);
        }
        MixChecksum.ChecksumDiff checksumDiff = MixChecksum.compare(fileChecksum2, fileChecksum);
        System.out.println("ChecksumDiff: " + checksumDiff.toString());
        if (checksumDiff == MixChecksum.ChecksumDiff.EQUAL) {
            System.exit(0);
        }
        System.exit(-1);
    }
}

