/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.id;

import MITI.sdk.MIRObject;
import MITI.sdk.id.MIRSystemIdCache;
import MITI.sdk.id.objects.MIRObjectIdentity;

public class MIRSystemId {
    private Type type = null;
    private String id = "";
    private boolean isRandom = false;

    protected MIRSystemId(MIRSystemIdCache mIRSystemIdCache, MIRObject mIRObject) {
        MIRSystemId mIRSystemId;
        MIRObjectIdentity mIRObjectIdentity = MIRObjectIdentity.compute(mIRObject);
        this.type = mIRObjectIdentity.type;
        if (mIRObjectIdentity.content != null) {
            mIRSystemId = mIRSystemIdCache.getObjectIdentity(mIRObjectIdentity.content);
            this.id = this.id + mIRSystemId.getId() + "##";
            this.isRandom |= mIRSystemId.isRandom();
        }
        if (mIRObjectIdentity.parent != null) {
            mIRSystemId = mIRSystemIdCache.getObjectIdentity(mIRObjectIdentity.parent);
            this.id = this.id + mIRSystemId.getId() + "/";
            this.isRandom |= mIRSystemId.isRandom;
        }
        this.id = this.id + mIRObjectIdentity.localPart;
        this.isRandom |= this.type == Type.RANDOM;
        if (!mIRSystemIdCache.isUnique(mIRObject, this)) {
            this.isRandom = true;
            this.id = this.id + "#" + mIRSystemIdCache.generateUniqueId();
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isRandom() {
        return this.isRandom;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof MIRSystemId) {
            MIRSystemId mIRSystemId = (MIRSystemId)object;
            return this.id.equals(mIRSystemId.id);
        }
        return false;
    }

    public static enum Type {
        NATIVE_ID("nid"),
        LOGICAL("lid"),
        PHYSICAL("pid"),
        RANDOM("nsid");

        private String uri = null;

        private Type(String string2) {
            this.uri = string2;
        }

        public String toString() {
            return this.uri;
        }
    }
}

