/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.collections;

import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRTypeValue;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class MIRSingleObjectCollection<T extends MIRObject>
implements MIRObjectCollection<T> {
    private MIRSdkCollection.Type type;
    private boolean caseSensitive;
    private T obj;

    public MIRSingleObjectCollection(MIRSdkCollection.Type type) {
        this.type = type;
        this.caseSensitive = MIRObjectCollections.__getSdkCaseSensitive();
    }

    public MIRSingleObjectCollection(T t) {
        this(MIRSdkCollection.Type.OBJECT);
        this.obj = t;
    }

    @Override
    public MIRSdkCollection.Type getType() {
        return this.type;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public T get() {
        return this.obj;
    }

    @Override
    public T get(String string) {
        if (string == null) {
            return this.obj;
        }
        if (this.obj != null) {
            String string2 = this.getName((MIRObject)this.obj);
            if (this.caseSensitive && string.equals(string2) || !this.caseSensitive && string.equalsIgnoreCase(string2)) {
                return this.obj;
            }
        }
        return null;
    }

    @Override
    public void rename(T t, String string) {
    }

    @Override
    public boolean allowName(MIRObject mIRObject) {
        if (this.type == MIRSdkCollection.Type.OBJECT) {
            return true;
        }
        String string = this.getName(mIRObject);
        if (this.type == MIRSdkCollection.Type.OPTIONAL_NAME && string.isEmpty()) {
            return true;
        }
        T t = this.get(this.getName(mIRObject));
        return t == null || t == mIRObject;
    }

    @Override
    public String getName(MIRObject mIRObject) {
        if (this.type == MIRSdkCollection.Type.PHYSICAL_NAME) {
            String string;
            if (mIRObject.isInstanceOf((short)59) && !(string = ((MIRModelObject)mIRObject).getPhysicalName()).isEmpty()) {
                return string;
            }
        } else if (this.type == MIRSdkCollection.Type.NAME_VALUE && mIRObject.getName().isEmpty() && mIRObject.isInstanceOf((short)7)) {
            return ((MIRTypeValue)mIRObject).getValue();
        }
        return mIRObject.getName();
    }

    @Override
    public boolean add(T t) {
        if (this.obj == null) {
            this.obj = t;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(T t) {
        return this.obj == t;
    }

    @Override
    public Iterator<T> iterator() {
        return this.obj != null ? Collections.singleton(this.obj).iterator() : Collections.emptyIterator();
    }

    @Override
    public boolean remove(T t) {
        if (this.obj == t) {
            this.obj = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.obj == null;
    }

    @Override
    public int size() {
        return this.obj != null ? 1 : 0;
    }

    @Override
    public Collection<T> values() {
        return Collections.singleton(this.obj);
    }

    @Override
    public T first() {
        return this.obj;
    }

    @Override
    public T last() {
        return this.obj;
    }
}

