/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRConfigurationContent;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRRepository;
import MITI.sdk.MIRSecurityObject;
import MITI.sdk.MIRUser;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRUserGroup
extends MIRSecurityObject {
    protected transient boolean aBusiness = false;
    protected transient MIRConfigurationContent hasDefaultConfigurationContent = null;
    protected transient MIRRepository hasRepository = null;
    protected transient MIRObjectCollection<MIRUser> users = null;
    private static MIRMetaClass metaClass = MIRUserGroup.staticGetMetaClass();

    public MIRUserGroup() {
    }

    public MIRUserGroup(MIRUserGroup mIRUserGroup) {
        this.setFrom(mIRUserGroup);
    }

    @Override
    public Object clone() {
        return new MIRUserGroup(this);
    }

    @Override
    public short getElementType() {
        return 170;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)170)) {
            this.setBusiness(((MIRUserGroup)mIR_Object).getBusiness());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasRepository != null) {
            return this.hasRepository;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasRepository != null ? 1 : 0) + super.getParentCount();
    }

    public final void setBusiness(boolean bl) {
        this.aBusiness = bl;
    }

    public final boolean getBusiness() {
        return this.aBusiness;
    }

    public final void addDefaultConfigurationContent(MIRConfigurationContent mIRConfigurationContent) {
        if (mIRConfigurationContent == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("UserGroup", "DefaultConfigurationContent"));
        }
        if (mIRConfigurationContent._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("UserGroup", "DefaultConfigurationContent"));
        }
        if (this.hasDefaultConfigurationContent != null) {
            if (this.hasDefaultConfigurationContent._equals(mIRConfigurationContent)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("UserGroup", "DefaultConfigurationContent"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("UserGroup", "DefaultConfigurationContent"));
        }
        this.hasDefaultConfigurationContent = mIRConfigurationContent;
        mIRConfigurationContent.getDefaultOfUserGroupCollection().add(this);
    }

    public final MIRConfigurationContent getDefaultConfigurationContent() {
        return this.hasDefaultConfigurationContent;
    }

    public final boolean removeDefaultConfigurationContent() {
        if (this.hasDefaultConfigurationContent != null) {
            this.hasDefaultConfigurationContent.defaultOfUserGroups.remove(this);
            if (this.hasDefaultConfigurationContent.defaultOfUserGroups.isEmpty()) {
                this.hasDefaultConfigurationContent.defaultOfUserGroups = null;
            }
            this.hasDefaultConfigurationContent = null;
            return true;
        }
        return false;
    }

    public final void addRepository(MIRRepository mIRRepository) {
        if (mIRRepository == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("UserGroup", "Repository"));
        }
        if (mIRRepository._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("UserGroup", "Repository"));
        }
        if (this.hasRepository != null) {
            if (this.hasRepository._equals(mIRRepository)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("UserGroup", "Repository"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("UserGroup", "Repository"));
        }
        if (mIRRepository.userGroups != null && !mIRRepository._allowName(mIRRepository.userGroups, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Repository", mIRRepository.getPath(), "UserGroup", "Object", this.getName()));
        }
        this.hasRepository = mIRRepository;
        mIRRepository.getUserGroupCollection().add(this);
    }

    public final MIRRepository getRepository() {
        return this.hasRepository;
    }

    public final boolean removeRepository() {
        if (this.hasRepository != null) {
            this.hasRepository.userGroups.remove(this);
            if (this.hasRepository.userGroups.isEmpty()) {
                this.hasRepository.userGroups = null;
            }
            this.hasRepository = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRUser> getUserCollection() {
        this.users = MIRObjectCollections.get(this.users, MIRSdkCollection.Type.OBJECT);
        return this.users;
    }

    public SortedSet<MIRUser> getUsers() {
        return MIRObjectCollections.sortedSet(this.users);
    }

    public final void addUser(MIRUser mIRUser) {
        if (mIRUser == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("UserGroup", "User"));
        }
        if (mIRUser._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("UserGroup", "User"));
        }
        if (this.users != null && this.users.contains(mIRUser)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("UserGroup", "User"));
        }
        this.getUserCollection().add(mIRUser);
        mIRUser.getUserGroupCollection().add(this);
    }

    public final int getUserCount() {
        if (this.users != null) {
            return this.users.size();
        }
        return 0;
    }

    public final boolean containsUser(MIRUser mIRUser) {
        if (mIRUser != null && this.users != null) {
            return this.users.contains(mIRUser);
        }
        return false;
    }

    public final MIRUser getUser(String string) {
        if (this.users != null) {
            return this.users.get(string);
        }
        return null;
    }

    public final Iterator<MIRUser> getUserIterator() {
        if (this.users != null) {
            return this.users.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeUser(MIRUser mIRUser) {
        if (mIRUser != null && this.users != null && this.users.remove(mIRUser)) {
            mIRUser.userGroups.remove(this);
            if (mIRUser.userGroups.isEmpty()) {
                mIRUser.userGroups = null;
            }
            if (this.users.isEmpty()) {
                this.users = null;
            }
            return true;
        }
        return false;
    }

    public final void removeUsers() {
        if (this.users != null) {
            for (MIRUser mIRUser : this.users) {
                mIRUser.userGroups.remove(this);
                if (!mIRUser.userGroups.isEmpty()) continue;
                mIRUser.userGroups = null;
            }
            this.users = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRSecurityObject.staticGetMetaClass(), 170, "UserGroup", false);
            new MIRMetaAttribute(metaClass, 263, "Business", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaLink(metaClass, 455, "DefaultConfigurationContent", true, 0, 168, 456);
            new MIRMetaLink(metaClass, 430, "Repository", true, 2, 156, 429);
            new MIRMetaLink(metaClass, 453, "User", false, 0, 176, 454);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRUserGroup.staticGetMetaClass();
    }

    @Override
    protected boolean _isValidName() {
        if (this.hasRepository != null && !this.hasRepository._allowName(this.hasRepository.userGroups, this)) {
            return false;
        }
        return super._isValidName();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasDefaultConfigurationContent != null) {
            this.hasDefaultConfigurationContent.defaultOfUserGroups.rename(this, string);
        }
        if (this.hasRepository != null) {
            this.hasRepository.userGroups.rename(this, string);
        }
        if (this.users != null) {
            for (MIRUser mIRUser : this.users) {
                mIRUser.userGroups.rename(this, string);
            }
        }
        super._rename(string);
    }
}

