/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRSummaryMap
extends MIRElement {
    protected transient boolean aAggregated = false;
    protected transient boolean aBulk = false;
    protected transient String aControlOperation = "";
    protected transient String aDecorations = "";
    protected transient String aExternalContentId = "";
    protected transient String aOperation = "";
    protected transient MIRObjectCollection<MIRFeature> controlFeatures = null;
    protected transient MIRObjectCollection<MIRFeature> dataControlFeatures = null;
    protected transient MIRFeature hasDestinationFeature = null;
    protected transient MIRObjectCollection<MIRFeature> maskedFeatures = null;
    protected transient MIRObjectCollection<MIRFeature> sourceFeatures = null;
    private static MIRMetaClass metaClass = MIRSummaryMap.staticGetMetaClass();

    public MIRSummaryMap() {
    }

    public MIRSummaryMap(MIRSummaryMap mIRSummaryMap) {
        this.setFrom(mIRSummaryMap);
    }

    @Override
    public Object clone() {
        return new MIRSummaryMap(this);
    }

    @Override
    public short getElementType() {
        return 262;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)262)) {
            this.setAggregated(((MIRSummaryMap)mIR_Object).getAggregated());
            this.setBulk(((MIRSummaryMap)mIR_Object).getBulk());
            this.setControlOperation(((MIRSummaryMap)mIR_Object).getControlOperation());
            this.setDecorations(((MIRSummaryMap)mIR_Object).getDecorations());
            this.setExternalContentId(((MIRSummaryMap)mIR_Object).getExternalContentId());
            this.setOperation(((MIRSummaryMap)mIR_Object).getOperation());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasDestinationFeature != null) {
            return this.hasDestinationFeature;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasDestinationFeature != null ? 1 : 0) + super.getParentCount();
    }

    public final void setAggregated(boolean bl) {
        this.aAggregated = bl;
    }

    public final boolean getAggregated() {
        return this.aAggregated;
    }

    public final void setBulk(boolean bl) {
        this.aBulk = bl;
    }

    public final boolean getBulk() {
        return this.aBulk;
    }

    public final void setControlOperation(String string) {
        this.aControlOperation = string == null ? "" : string;
    }

    public final String getControlOperation() {
        return this.aControlOperation;
    }

    public final void setDecorations(String string) {
        this.aDecorations = string == null ? "" : string;
    }

    public final String getDecorations() {
        return this.aDecorations;
    }

    public final void setExternalContentId(String string) {
        this.aExternalContentId = string == null ? "" : string;
    }

    public final String getExternalContentId() {
        return this.aExternalContentId;
    }

    public final void setOperation(String string) {
        this.aOperation = string == null ? "" : string;
    }

    public final String getOperation() {
        return this.aOperation;
    }

    protected MIRObjectCollection<MIRFeature> getControlFeatureCollection() {
        this.controlFeatures = MIRObjectCollections.get(this.controlFeatures, MIRSdkCollection.Type.OBJECT);
        return this.controlFeatures;
    }

    public SortedSet<MIRFeature> getControlFeatures() {
        return MIRObjectCollections.sortedSet(this.controlFeatures);
    }

    public final void addControlFeature(MIRFeature mIRFeature) {
        if (mIRFeature == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("SummaryMap", "ControlFeature"));
        }
        if (mIRFeature._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("SummaryMap", "ControlFeature"));
        }
        if (this.controlFeatures != null && this.controlFeatures.contains(mIRFeature)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("SummaryMap", "ControlFeature"));
        }
        this.getControlFeatureCollection().add(mIRFeature);
        mIRFeature.getControlOfSummaryMapCollection().add(this);
    }

    public final int getControlFeatureCount() {
        if (this.controlFeatures != null) {
            return this.controlFeatures.size();
        }
        return 0;
    }

    public final boolean containsControlFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null && this.controlFeatures != null) {
            return this.controlFeatures.contains(mIRFeature);
        }
        return false;
    }

    public final MIRFeature getControlFeature(String string) {
        if (this.controlFeatures != null) {
            return this.controlFeatures.get(string);
        }
        return null;
    }

    public final Iterator<MIRFeature> getControlFeatureIterator() {
        if (this.controlFeatures != null) {
            return this.controlFeatures.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeControlFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null && this.controlFeatures != null && this.controlFeatures.remove(mIRFeature)) {
            mIRFeature.controlOfSummaryMaps.remove(this);
            if (mIRFeature.controlOfSummaryMaps.isEmpty()) {
                mIRFeature.controlOfSummaryMaps = null;
            }
            if (this.controlFeatures.isEmpty()) {
                this.controlFeatures = null;
            }
            return true;
        }
        return false;
    }

    public final void removeControlFeatures() {
        if (this.controlFeatures != null) {
            for (MIRFeature mIRFeature : this.controlFeatures) {
                mIRFeature.controlOfSummaryMaps.remove(this);
                if (!mIRFeature.controlOfSummaryMaps.isEmpty()) continue;
                mIRFeature.controlOfSummaryMaps = null;
            }
            this.controlFeatures = null;
        }
    }

    protected MIRObjectCollection<MIRFeature> getDataControlFeatureCollection() {
        this.dataControlFeatures = MIRObjectCollections.get(this.dataControlFeatures, MIRSdkCollection.Type.OBJECT);
        return this.dataControlFeatures;
    }

    public SortedSet<MIRFeature> getDataControlFeatures() {
        return MIRObjectCollections.sortedSet(this.dataControlFeatures);
    }

    public final void addDataControlFeature(MIRFeature mIRFeature) {
        if (mIRFeature == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("SummaryMap", "DataControlFeature"));
        }
        if (mIRFeature._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("SummaryMap", "DataControlFeature"));
        }
        if (this.dataControlFeatures != null && this.dataControlFeatures.contains(mIRFeature)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("SummaryMap", "DataControlFeature"));
        }
        this.getDataControlFeatureCollection().add(mIRFeature);
        mIRFeature.getDataControlOfSummaryMapCollection().add(this);
    }

    public final int getDataControlFeatureCount() {
        if (this.dataControlFeatures != null) {
            return this.dataControlFeatures.size();
        }
        return 0;
    }

    public final boolean containsDataControlFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null && this.dataControlFeatures != null) {
            return this.dataControlFeatures.contains(mIRFeature);
        }
        return false;
    }

    public final MIRFeature getDataControlFeature(String string) {
        if (this.dataControlFeatures != null) {
            return this.dataControlFeatures.get(string);
        }
        return null;
    }

    public final Iterator<MIRFeature> getDataControlFeatureIterator() {
        if (this.dataControlFeatures != null) {
            return this.dataControlFeatures.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeDataControlFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null && this.dataControlFeatures != null && this.dataControlFeatures.remove(mIRFeature)) {
            mIRFeature.dataControlOfSummaryMaps.remove(this);
            if (mIRFeature.dataControlOfSummaryMaps.isEmpty()) {
                mIRFeature.dataControlOfSummaryMaps = null;
            }
            if (this.dataControlFeatures.isEmpty()) {
                this.dataControlFeatures = null;
            }
            return true;
        }
        return false;
    }

    public final void removeDataControlFeatures() {
        if (this.dataControlFeatures != null) {
            for (MIRFeature mIRFeature : this.dataControlFeatures) {
                mIRFeature.dataControlOfSummaryMaps.remove(this);
                if (!mIRFeature.dataControlOfSummaryMaps.isEmpty()) continue;
                mIRFeature.dataControlOfSummaryMaps = null;
            }
            this.dataControlFeatures = null;
        }
    }

    public final void addDestinationFeature(MIRFeature mIRFeature) {
        if (mIRFeature == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("SummaryMap", "DestinationFeature"));
        }
        if (mIRFeature._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("SummaryMap", "DestinationFeature"));
        }
        if (this.hasDestinationFeature != null) {
            if (this.hasDestinationFeature._equals(mIRFeature)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("SummaryMap", "DestinationFeature"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("SummaryMap", "DestinationFeature"));
        }
        this.hasDestinationFeature = mIRFeature;
        mIRFeature.getDestinationOfSummaryMapCollection().add(this);
    }

    public final MIRFeature getDestinationFeature() {
        return this.hasDestinationFeature;
    }

    public final boolean removeDestinationFeature() {
        if (this.hasDestinationFeature != null) {
            this.hasDestinationFeature.destinationOfSummaryMaps.remove(this);
            if (this.hasDestinationFeature.destinationOfSummaryMaps.isEmpty()) {
                this.hasDestinationFeature.destinationOfSummaryMaps = null;
            }
            this.hasDestinationFeature = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRFeature> getMaskedFeatureCollection() {
        this.maskedFeatures = MIRObjectCollections.get(this.maskedFeatures, MIRSdkCollection.Type.OBJECT);
        return this.maskedFeatures;
    }

    public SortedSet<MIRFeature> getMaskedFeatures() {
        return MIRObjectCollections.sortedSet(this.maskedFeatures);
    }

    public final void addMaskedFeature(MIRFeature mIRFeature) {
        if (mIRFeature == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("SummaryMap", "MaskedFeature"));
        }
        if (mIRFeature._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("SummaryMap", "MaskedFeature"));
        }
        if (this.maskedFeatures != null && this.maskedFeatures.contains(mIRFeature)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("SummaryMap", "MaskedFeature"));
        }
        this.getMaskedFeatureCollection().add(mIRFeature);
        mIRFeature.getMaskedOfSummaryMapCollection().add(this);
    }

    public final int getMaskedFeatureCount() {
        if (this.maskedFeatures != null) {
            return this.maskedFeatures.size();
        }
        return 0;
    }

    public final boolean containsMaskedFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null && this.maskedFeatures != null) {
            return this.maskedFeatures.contains(mIRFeature);
        }
        return false;
    }

    public final MIRFeature getMaskedFeature(String string) {
        if (this.maskedFeatures != null) {
            return this.maskedFeatures.get(string);
        }
        return null;
    }

    public final Iterator<MIRFeature> getMaskedFeatureIterator() {
        if (this.maskedFeatures != null) {
            return this.maskedFeatures.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeMaskedFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null && this.maskedFeatures != null && this.maskedFeatures.remove(mIRFeature)) {
            mIRFeature.maskedOfSummaryMaps.remove(this);
            if (mIRFeature.maskedOfSummaryMaps.isEmpty()) {
                mIRFeature.maskedOfSummaryMaps = null;
            }
            if (this.maskedFeatures.isEmpty()) {
                this.maskedFeatures = null;
            }
            return true;
        }
        return false;
    }

    public final void removeMaskedFeatures() {
        if (this.maskedFeatures != null) {
            for (MIRFeature mIRFeature : this.maskedFeatures) {
                mIRFeature.maskedOfSummaryMaps.remove(this);
                if (!mIRFeature.maskedOfSummaryMaps.isEmpty()) continue;
                mIRFeature.maskedOfSummaryMaps = null;
            }
            this.maskedFeatures = null;
        }
    }

    protected MIRObjectCollection<MIRFeature> getSourceFeatureCollection() {
        this.sourceFeatures = MIRObjectCollections.get(this.sourceFeatures, MIRSdkCollection.Type.OBJECT);
        return this.sourceFeatures;
    }

    public SortedSet<MIRFeature> getSourceFeatures() {
        return MIRObjectCollections.sortedSet(this.sourceFeatures);
    }

    public final void addSourceFeature(MIRFeature mIRFeature) {
        if (mIRFeature == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("SummaryMap", "SourceFeature"));
        }
        if (mIRFeature._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("SummaryMap", "SourceFeature"));
        }
        if (this.sourceFeatures != null && this.sourceFeatures.contains(mIRFeature)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("SummaryMap", "SourceFeature"));
        }
        this.getSourceFeatureCollection().add(mIRFeature);
        mIRFeature.getSourceOfSummaryMapCollection().add(this);
    }

    public final int getSourceFeatureCount() {
        if (this.sourceFeatures != null) {
            return this.sourceFeatures.size();
        }
        return 0;
    }

    public final boolean containsSourceFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null && this.sourceFeatures != null) {
            return this.sourceFeatures.contains(mIRFeature);
        }
        return false;
    }

    public final MIRFeature getSourceFeature(String string) {
        if (this.sourceFeatures != null) {
            return this.sourceFeatures.get(string);
        }
        return null;
    }

    public final Iterator<MIRFeature> getSourceFeatureIterator() {
        if (this.sourceFeatures != null) {
            return this.sourceFeatures.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSourceFeature(MIRFeature mIRFeature) {
        if (mIRFeature != null && this.sourceFeatures != null && this.sourceFeatures.remove(mIRFeature)) {
            mIRFeature.sourceOfSummaryMaps.remove(this);
            if (mIRFeature.sourceOfSummaryMaps.isEmpty()) {
                mIRFeature.sourceOfSummaryMaps = null;
            }
            if (this.sourceFeatures.isEmpty()) {
                this.sourceFeatures = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSourceFeatures() {
        if (this.sourceFeatures != null) {
            for (MIRFeature mIRFeature : this.sourceFeatures) {
                mIRFeature.sourceOfSummaryMaps.remove(this);
                if (!mIRFeature.sourceOfSummaryMaps.isEmpty()) continue;
                mIRFeature.sourceOfSummaryMaps = null;
            }
            this.sourceFeatures = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRElement.staticGetMetaClass(), 262, "SummaryMap", false);
            new MIRMetaAttribute(metaClass, 358, "Operation", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 457, "Aggregated", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaAttribute(metaClass, 488, "ExternalContentId", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 502, "Decorations", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 518, "Bulk", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaAttribute(metaClass, 532, "ControlOperation", "java.lang.String", null, "");
            new MIRMetaLink(metaClass, 573, "ControlFeature", false, 0, 77, 574);
            new MIRMetaLink(metaClass, 1017, "DataControlFeature", false, 0, 77, 1016);
            new MIRMetaLink(metaClass, 684, "DestinationFeature", true, 2, 77, 683);
            new MIRMetaLink(metaClass, 1145, "MaskedFeature", false, 1, 77, 1144);
            new MIRMetaLink(metaClass, 680, "SourceFeature", false, 0, 77, 679);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRSummaryMap.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.controlFeatures != null) {
            for (MIRFeature mIRFeature : this.controlFeatures) {
                mIRFeature.controlOfSummaryMaps.rename(this, string);
            }
        }
        if (this.dataControlFeatures != null) {
            for (MIRFeature mIRFeature : this.dataControlFeatures) {
                mIRFeature.dataControlOfSummaryMaps.rename(this, string);
            }
        }
        if (this.hasDestinationFeature != null) {
            this.hasDestinationFeature.destinationOfSummaryMaps.rename(this, string);
        }
        if (this.maskedFeatures != null) {
            for (MIRFeature mIRFeature : this.maskedFeatures) {
                mIRFeature.maskedOfSummaryMaps.rename(this, string);
            }
        }
        if (this.sourceFeatures != null) {
            for (MIRFeature mIRFeature : this.sourceFeatures) {
                mIRFeature.sourceOfSummaryMaps.rename(this, string);
            }
        }
        super._rename(string);
    }
}

