/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRConnectionClassifier;
import MITI.sdk.MIRConnectionElement;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRMappingModel;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRStoreType;
import MITI.sdk.MIRSystemPackage;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRStoreConnection
extends MIRSystemPackage {
    protected transient String aConnection = "";
    protected transient short aMatchingRule = 0;
    protected transient byte aStoreType = 0;
    protected transient MIRObjectCollection<MIRConnectionClassifier> connectionClassifiers = null;
    protected transient MIRObjectCollection<MIRConnectionElement> connectionElements = null;
    protected transient MIRObjectCollection<MIRConnectionNamespace> connectionNamespaces = null;
    protected transient MIRObjectCollection<MIRConnectionPackage> connectionPackages = null;
    protected transient MIRMappingModel hasDestinationOfMappingModel = null;
    protected transient MIRModel hasModel = null;
    protected transient MIRMappingModel hasSourceOfMappingModel = null;
    private static MIRMetaClass metaClass = MIRStoreConnection.staticGetMetaClass();

    public MIRStoreConnection() {
    }

    public MIRStoreConnection(MIRStoreConnection mIRStoreConnection) {
        this.setFrom(mIRStoreConnection);
    }

    @Override
    public Object clone() {
        return new MIRStoreConnection(this);
    }

    @Override
    public short getElementType() {
        return 216;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)216)) {
            this.setConnection(((MIRStoreConnection)mIR_Object).getConnection());
            this.setMatchingRule(((MIRStoreConnection)mIR_Object).getMatchingRule());
            this.setStoreType(((MIRStoreConnection)mIR_Object).getStoreType());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasModel != null) {
            return this.hasModel;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasModel != null ? 1 : 0) + super.getParentCount();
    }

    public final void setConnection(String string) {
        this.aConnection = string == null ? "" : string;
    }

    public final String getConnection() {
        return this.aConnection;
    }

    public final void setMatchingRule(short s) {
        this.aMatchingRule = s;
    }

    public final short getMatchingRule() {
        return this.aMatchingRule;
    }

    public final void setStoreType(byte by) {
        this.aStoreType = by;
    }

    public final byte getStoreType() {
        return this.aStoreType;
    }

    protected MIRObjectCollection<MIRConnectionClassifier> getConnectionClassifierCollection() {
        this.connectionClassifiers = MIRObjectCollections.get(this.connectionClassifiers, MIRSdkCollection.Type.OBJECT);
        return this.connectionClassifiers;
    }

    public SortedSet<MIRConnectionClassifier> getConnectionClassifiers() {
        return MIRObjectCollections.sortedSet(this.connectionClassifiers);
    }

    public final void addConnectionClassifier(MIRConnectionClassifier mIRConnectionClassifier) {
        if (mIRConnectionClassifier == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StoreConnection", "ConnectionClassifier"));
        }
        if (mIRConnectionClassifier._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StoreConnection", "ConnectionClassifier"));
        }
        if (mIRConnectionClassifier.hasStoreConnection != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ConnectionClassifier", "StoreConnection"));
        }
        if (this.connectionClassifiers != null && this.connectionClassifiers.contains(mIRConnectionClassifier)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StoreConnection", "ConnectionClassifier"));
        }
        this.getConnectionClassifierCollection().add(mIRConnectionClassifier);
        mIRConnectionClassifier.hasStoreConnection = this;
    }

    public final int getConnectionClassifierCount() {
        if (this.connectionClassifiers != null) {
            return this.connectionClassifiers.size();
        }
        return 0;
    }

    public final boolean containsConnectionClassifier(MIRConnectionClassifier mIRConnectionClassifier) {
        if (mIRConnectionClassifier != null && this.connectionClassifiers != null) {
            return this.connectionClassifiers.contains(mIRConnectionClassifier);
        }
        return false;
    }

    public final MIRConnectionClassifier getConnectionClassifier(String string) {
        if (this.connectionClassifiers != null) {
            return this.connectionClassifiers.get(string);
        }
        return null;
    }

    public final Iterator<MIRConnectionClassifier> getConnectionClassifierIterator() {
        if (this.connectionClassifiers != null) {
            return this.connectionClassifiers.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeConnectionClassifier(MIRConnectionClassifier mIRConnectionClassifier) {
        if (mIRConnectionClassifier != null && this.connectionClassifiers != null && this.connectionClassifiers.remove(mIRConnectionClassifier)) {
            mIRConnectionClassifier.hasStoreConnection = null;
            if (this.connectionClassifiers.isEmpty()) {
                this.connectionClassifiers = null;
            }
            return true;
        }
        return false;
    }

    public final void removeConnectionClassifiers() {
        if (this.connectionClassifiers != null) {
            for (MIRConnectionClassifier mIRConnectionClassifier : this.connectionClassifiers) {
                mIRConnectionClassifier.hasStoreConnection = null;
            }
            this.connectionClassifiers = null;
        }
    }

    protected MIRObjectCollection<MIRConnectionElement> getConnectionElementCollection() {
        this.connectionElements = MIRObjectCollections.get(this.connectionElements, MIRSdkCollection.Type.OBJECT);
        return this.connectionElements;
    }

    public SortedSet<MIRConnectionElement> getConnectionElements() {
        return MIRObjectCollections.sortedSet(this.connectionElements);
    }

    public final void addConnectionElement(MIRConnectionElement mIRConnectionElement) {
        if (mIRConnectionElement == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StoreConnection", "ConnectionElement"));
        }
        if (mIRConnectionElement._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StoreConnection", "ConnectionElement"));
        }
        if (mIRConnectionElement.hasStoreConnection != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ConnectionElement", "StoreConnection"));
        }
        if (this.connectionElements != null && this.connectionElements.contains(mIRConnectionElement)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StoreConnection", "ConnectionElement"));
        }
        this.getConnectionElementCollection().add(mIRConnectionElement);
        mIRConnectionElement.hasStoreConnection = this;
    }

    public final int getConnectionElementCount() {
        if (this.connectionElements != null) {
            return this.connectionElements.size();
        }
        return 0;
    }

    public final boolean containsConnectionElement(MIRConnectionElement mIRConnectionElement) {
        if (mIRConnectionElement != null && this.connectionElements != null) {
            return this.connectionElements.contains(mIRConnectionElement);
        }
        return false;
    }

    public final MIRConnectionElement getConnectionElement(String string) {
        if (this.connectionElements != null) {
            return this.connectionElements.get(string);
        }
        return null;
    }

    public final Iterator<MIRConnectionElement> getConnectionElementIterator() {
        if (this.connectionElements != null) {
            return this.connectionElements.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeConnectionElement(MIRConnectionElement mIRConnectionElement) {
        if (mIRConnectionElement != null && this.connectionElements != null && this.connectionElements.remove(mIRConnectionElement)) {
            mIRConnectionElement.hasStoreConnection = null;
            if (this.connectionElements.isEmpty()) {
                this.connectionElements = null;
            }
            return true;
        }
        return false;
    }

    public final void removeConnectionElements() {
        if (this.connectionElements != null) {
            for (MIRConnectionElement mIRConnectionElement : this.connectionElements) {
                mIRConnectionElement.hasStoreConnection = null;
            }
            this.connectionElements = null;
        }
    }

    protected MIRObjectCollection<MIRConnectionNamespace> getConnectionNamespaceCollection() {
        this.connectionNamespaces = MIRObjectCollections.get(this.connectionNamespaces, MIRSdkCollection.Type.NAME);
        return this.connectionNamespaces;
    }

    public SortedSet<MIRConnectionNamespace> getConnectionNamespaces() {
        return MIRObjectCollections.sortedSet(this.connectionNamespaces);
    }

    public final void addConnectionNamespace(MIRConnectionNamespace mIRConnectionNamespace) {
        if (mIRConnectionNamespace == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StoreConnection", "ConnectionNamespace"));
        }
        if (mIRConnectionNamespace._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StoreConnection", "ConnectionNamespace"));
        }
        if (mIRConnectionNamespace.hasStoreConnection != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ConnectionNamespace", "StoreConnection"));
        }
        if (this.connectionNamespaces != null) {
            if (this.connectionNamespaces.contains(mIRConnectionNamespace)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StoreConnection", "ConnectionNamespace"));
            }
            if (!this._allowName(this.connectionNamespaces, mIRConnectionNamespace)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("StoreConnection", this.getPath(), "ConnectionNamespace", "Name", mIRConnectionNamespace.getPath()));
            }
        }
        this.getConnectionNamespaceCollection().add(mIRConnectionNamespace);
        mIRConnectionNamespace.hasStoreConnection = this;
    }

    public final boolean addConnectionNamespaceUniqueName(MIRConnectionNamespace mIRConnectionNamespace) {
        return this.addConnectionNamespaceUniqueName(mIRConnectionNamespace, '/');
    }

    public final boolean addConnectionNamespaceUniqueName(MIRConnectionNamespace mIRConnectionNamespace, char c) {
        if (mIRConnectionNamespace == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StoreConnection", "ConnectionNamespace"));
        }
        if (mIRConnectionNamespace._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StoreConnection", "ConnectionNamespace"));
        }
        if (mIRConnectionNamespace.hasStoreConnection != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ConnectionNamespace", "StoreConnection"));
        }
        boolean bl = false;
        if (this.connectionNamespaces != null) {
            if (this.connectionNamespaces.contains(mIRConnectionNamespace)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StoreConnection", "ConnectionNamespace"));
            }
            if (!this._allowName(this.connectionNamespaces, mIRConnectionNamespace)) {
                mIRConnectionNamespace._rename(mIRConnectionNamespace._setUniqueName(this.connectionNamespaces, c));
                bl = true;
            }
        }
        this.getConnectionNamespaceCollection().add(mIRConnectionNamespace);
        mIRConnectionNamespace.hasStoreConnection = this;
        return bl;
    }

    public final int getConnectionNamespaceCount() {
        if (this.connectionNamespaces != null) {
            return this.connectionNamespaces.size();
        }
        return 0;
    }

    public final boolean containsConnectionNamespace(MIRConnectionNamespace mIRConnectionNamespace) {
        if (mIRConnectionNamespace != null && this.connectionNamespaces != null) {
            return this.connectionNamespaces.contains(mIRConnectionNamespace);
        }
        return false;
    }

    public final MIRConnectionNamespace getConnectionNamespace(String string) {
        if (this.connectionNamespaces != null) {
            return this.connectionNamespaces.get(string);
        }
        return null;
    }

    public final Iterator<MIRConnectionNamespace> getConnectionNamespaceIterator() {
        if (this.connectionNamespaces != null) {
            return this.connectionNamespaces.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeConnectionNamespace(MIRConnectionNamespace mIRConnectionNamespace) {
        if (mIRConnectionNamespace != null && this.connectionNamespaces != null && this.connectionNamespaces.remove(mIRConnectionNamespace)) {
            mIRConnectionNamespace.hasStoreConnection = null;
            if (this.connectionNamespaces.isEmpty()) {
                this.connectionNamespaces = null;
            }
            return true;
        }
        return false;
    }

    public final void removeConnectionNamespaces() {
        if (this.connectionNamespaces != null) {
            for (MIRConnectionNamespace mIRConnectionNamespace : this.connectionNamespaces) {
                mIRConnectionNamespace.hasStoreConnection = null;
            }
            this.connectionNamespaces = null;
        }
    }

    protected MIRObjectCollection<MIRConnectionPackage> getConnectionPackageCollection() {
        this.connectionPackages = MIRObjectCollections.get(this.connectionPackages, MIRSdkCollection.Type.PHYSICAL_NAME);
        return this.connectionPackages;
    }

    public SortedSet<MIRConnectionPackage> getConnectionPackages() {
        return MIRObjectCollections.sortedSet(this.connectionPackages);
    }

    public final void addConnectionPackage(MIRConnectionPackage mIRConnectionPackage) {
        if (mIRConnectionPackage == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StoreConnection", "ConnectionPackage"));
        }
        if (mIRConnectionPackage._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StoreConnection", "ConnectionPackage"));
        }
        if (mIRConnectionPackage.hasStoreConnection != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ConnectionPackage", "StoreConnection"));
        }
        if (this.connectionPackages != null) {
            if (this.connectionPackages.contains(mIRConnectionPackage)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StoreConnection", "ConnectionPackage"));
            }
            if (!this._allowName(this.connectionPackages, mIRConnectionPackage)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("StoreConnection", this.getPath(), "ConnectionPackage", "PhysicalName", mIRConnectionPackage.getPath()));
            }
        }
        this.getConnectionPackageCollection().add(mIRConnectionPackage);
        mIRConnectionPackage.hasStoreConnection = this;
    }

    public final boolean addConnectionPackageUniqueName(MIRConnectionPackage mIRConnectionPackage) {
        return this.addConnectionPackageUniqueName(mIRConnectionPackage, '/');
    }

    public final boolean addConnectionPackageUniqueName(MIRConnectionPackage mIRConnectionPackage, char c) {
        if (mIRConnectionPackage == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StoreConnection", "ConnectionPackage"));
        }
        if (mIRConnectionPackage._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StoreConnection", "ConnectionPackage"));
        }
        if (mIRConnectionPackage.hasStoreConnection != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ConnectionPackage", "StoreConnection"));
        }
        boolean bl = false;
        if (this.connectionPackages != null) {
            if (this.connectionPackages.contains(mIRConnectionPackage)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StoreConnection", "ConnectionPackage"));
            }
            if (!this._allowName(this.connectionPackages, mIRConnectionPackage)) {
                mIRConnectionPackage._rename(mIRConnectionPackage._setUniqueName(this.connectionPackages, c));
                bl = true;
            }
        }
        this.getConnectionPackageCollection().add(mIRConnectionPackage);
        mIRConnectionPackage.hasStoreConnection = this;
        return bl;
    }

    public final int getConnectionPackageCount() {
        if (this.connectionPackages != null) {
            return this.connectionPackages.size();
        }
        return 0;
    }

    public final boolean containsConnectionPackage(MIRConnectionPackage mIRConnectionPackage) {
        if (mIRConnectionPackage != null && this.connectionPackages != null) {
            return this.connectionPackages.contains(mIRConnectionPackage);
        }
        return false;
    }

    public final MIRConnectionPackage getConnectionPackage(String string) {
        if (this.connectionPackages != null) {
            return this.connectionPackages.get(string);
        }
        return null;
    }

    public final Iterator<MIRConnectionPackage> getConnectionPackageIterator() {
        if (this.connectionPackages != null) {
            return this.connectionPackages.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeConnectionPackage(MIRConnectionPackage mIRConnectionPackage) {
        if (mIRConnectionPackage != null && this.connectionPackages != null && this.connectionPackages.remove(mIRConnectionPackage)) {
            mIRConnectionPackage.hasStoreConnection = null;
            if (this.connectionPackages.isEmpty()) {
                this.connectionPackages = null;
            }
            return true;
        }
        return false;
    }

    public final void removeConnectionPackages() {
        if (this.connectionPackages != null) {
            for (MIRConnectionPackage mIRConnectionPackage : this.connectionPackages) {
                mIRConnectionPackage.hasStoreConnection = null;
            }
            this.connectionPackages = null;
        }
    }

    public final void addDestinationOfMappingModel(MIRMappingModel mIRMappingModel) {
        if (mIRMappingModel == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StoreConnection", "DestinationOfMappingModel"));
        }
        if (mIRMappingModel._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StoreConnection", "DestinationOfMappingModel"));
        }
        if (this.hasDestinationOfMappingModel != null) {
            if (this.hasDestinationOfMappingModel._equals(mIRMappingModel)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StoreConnection", "DestinationOfMappingModel"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("StoreConnection", "DestinationOfMappingModel"));
        }
        this.hasDestinationOfMappingModel = mIRMappingModel;
        mIRMappingModel.getDestinationStoreConnectionCollection().add(this);
    }

    public final MIRMappingModel getDestinationOfMappingModel() {
        return this.hasDestinationOfMappingModel;
    }

    public final boolean removeDestinationOfMappingModel() {
        if (this.hasDestinationOfMappingModel != null) {
            this.hasDestinationOfMappingModel.destinationStoreConnections.remove(this);
            if (this.hasDestinationOfMappingModel.destinationStoreConnections.isEmpty()) {
                this.hasDestinationOfMappingModel.destinationStoreConnections = null;
            }
            this.hasDestinationOfMappingModel = null;
            return true;
        }
        return false;
    }

    public final void addModel(MIRModel mIRModel) {
        if (mIRModel == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StoreConnection", "Model"));
        }
        if (mIRModel._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StoreConnection", "Model"));
        }
        if (this.hasModel != null) {
            if (this.hasModel._equals(mIRModel)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StoreConnection", "Model"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("StoreConnection", "Model"));
        }
        if (mIRModel.storeConnections != null && !mIRModel._allowName(mIRModel.storeConnections, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Model", mIRModel.getPath(), "StoreConnection", "Object", this.getName()));
        }
        this.hasModel = mIRModel;
        mIRModel.getStoreConnectionCollection().add(this);
    }

    public final MIRModel getModel() {
        return this.hasModel;
    }

    public final boolean removeModel() {
        if (this.hasModel != null) {
            this.hasModel.storeConnections.remove(this);
            if (this.hasModel.storeConnections.isEmpty()) {
                this.hasModel.storeConnections = null;
            }
            this.hasModel = null;
            return true;
        }
        return false;
    }

    public final void addSourceOfMappingModel(MIRMappingModel mIRMappingModel) {
        if (mIRMappingModel == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StoreConnection", "SourceOfMappingModel"));
        }
        if (mIRMappingModel._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StoreConnection", "SourceOfMappingModel"));
        }
        if (this.hasSourceOfMappingModel != null) {
            if (this.hasSourceOfMappingModel._equals(mIRMappingModel)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StoreConnection", "SourceOfMappingModel"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("StoreConnection", "SourceOfMappingModel"));
        }
        this.hasSourceOfMappingModel = mIRMappingModel;
        mIRMappingModel.getSourceStoreConnectionCollection().add(this);
    }

    public final MIRMappingModel getSourceOfMappingModel() {
        return this.hasSourceOfMappingModel;
    }

    public final boolean removeSourceOfMappingModel() {
        if (this.hasSourceOfMappingModel != null) {
            this.hasSourceOfMappingModel.sourceStoreConnections.remove(this);
            if (this.hasSourceOfMappingModel.sourceStoreConnections.isEmpty()) {
                this.hasSourceOfMappingModel.sourceStoreConnections = null;
            }
            this.hasSourceOfMappingModel = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRSystemPackage.staticGetMetaClass(), 216, "StoreConnection", false);
            new MIRMetaAttribute(metaClass, 339, "StoreType", "java.lang.Byte", MIRStoreType.class, new Byte(0));
            new MIRMetaAttribute(metaClass, 317, "Connection", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 447, "MatchingRule", "java.lang.Short", null, new Short(0));
            new MIRMetaLink(metaClass, 1007, "ConnectionClassifier", false, 3, 328, 1006);
            new MIRMetaLink(metaClass, 939, "ConnectionElement", false, 3, 317, 938);
            new MIRMetaLink(metaClass, 966, "ConnectionNamespace", false, 3, 321, 965);
            new MIRMetaLink(metaClass, 791, "ConnectionPackage", false, 3, 215, 792);
            new MIRMetaLink(metaClass, 734, "DestinationOfMappingModel", true, 1, 80, 733);
            new MIRMetaLink(metaClass, 784, "Model", true, 2, 218, 783);
            new MIRMetaLink(metaClass, 736, "SourceOfMappingModel", true, 1, 80, 735);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRStoreConnection.staticGetMetaClass();
    }

    @Override
    protected boolean _isValidName() {
        if (this.hasModel != null && !this.hasModel._allowName(this.hasModel.storeConnections, this)) {
            return false;
        }
        return super._isValidName();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasDestinationOfMappingModel != null) {
            this.hasDestinationOfMappingModel.destinationStoreConnections.rename(this, string);
        }
        if (this.hasModel != null) {
            this.hasModel.storeConnections.rename(this, string);
        }
        if (this.hasSourceOfMappingModel != null) {
            this.hasSourceOfMappingModel.sourceStoreConnections.rename(this, string);
        }
        super._rename(string);
    }
}

