/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRStepReference;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class MIRStepElement
extends MIRElement {
    protected transient MIRObjectCollection<MIRStepReference> predecessorOfStepReferences = null;
    protected transient MIRObjectCollection<MIRStepReference> successorOfStepReferences = null;
    private static MIRMetaClass metaClass = MIRStepElement.staticGetMetaClass();

    @Override
    public short getElementType() {
        return 348;
    }

    protected MIRObjectCollection<MIRStepReference> getPredecessorOfStepReferenceCollection() {
        this.predecessorOfStepReferences = MIRObjectCollections.get(this.predecessorOfStepReferences, MIRSdkCollection.Type.OBJECT);
        return this.predecessorOfStepReferences;
    }

    public SortedSet<MIRStepReference> getPredecessorOfStepReferences() {
        return MIRObjectCollections.sortedSet(this.predecessorOfStepReferences);
    }

    public final void addPredecessorOfStepReference(MIRStepReference mIRStepReference) {
        if (mIRStepReference == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StepElement", "PredecessorOfStepReference"));
        }
        if (mIRStepReference._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StepElement", "PredecessorOfStepReference"));
        }
        if (mIRStepReference.hasPredecessorStepElement != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("StepReference", "PredecessorStepElement"));
        }
        if (this.predecessorOfStepReferences != null && this.predecessorOfStepReferences.contains(mIRStepReference)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StepElement", "PredecessorOfStepReference"));
        }
        this.getPredecessorOfStepReferenceCollection().add(mIRStepReference);
        mIRStepReference.hasPredecessorStepElement = this;
    }

    public final int getPredecessorOfStepReferenceCount() {
        if (this.predecessorOfStepReferences != null) {
            return this.predecessorOfStepReferences.size();
        }
        return 0;
    }

    public final boolean containsPredecessorOfStepReference(MIRStepReference mIRStepReference) {
        if (mIRStepReference != null && this.predecessorOfStepReferences != null) {
            return this.predecessorOfStepReferences.contains(mIRStepReference);
        }
        return false;
    }

    public final MIRStepReference getPredecessorOfStepReference(String string) {
        if (this.predecessorOfStepReferences != null) {
            return this.predecessorOfStepReferences.get(string);
        }
        return null;
    }

    public final Iterator<MIRStepReference> getPredecessorOfStepReferenceIterator() {
        if (this.predecessorOfStepReferences != null) {
            return this.predecessorOfStepReferences.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removePredecessorOfStepReference(MIRStepReference mIRStepReference) {
        if (mIRStepReference != null && this.predecessorOfStepReferences != null && this.predecessorOfStepReferences.remove(mIRStepReference)) {
            mIRStepReference.hasPredecessorStepElement = null;
            if (this.predecessorOfStepReferences.isEmpty()) {
                this.predecessorOfStepReferences = null;
            }
            return true;
        }
        return false;
    }

    public final void removePredecessorOfStepReferences() {
        if (this.predecessorOfStepReferences != null) {
            for (MIRStepReference mIRStepReference : this.predecessorOfStepReferences) {
                mIRStepReference.hasPredecessorStepElement = null;
            }
            this.predecessorOfStepReferences = null;
        }
    }

    protected MIRObjectCollection<MIRStepReference> getSuccessorOfStepReferenceCollection() {
        this.successorOfStepReferences = MIRObjectCollections.get(this.successorOfStepReferences, MIRSdkCollection.Type.OBJECT);
        return this.successorOfStepReferences;
    }

    public SortedSet<MIRStepReference> getSuccessorOfStepReferences() {
        return MIRObjectCollections.sortedSet(this.successorOfStepReferences);
    }

    public final void addSuccessorOfStepReference(MIRStepReference mIRStepReference) {
        if (mIRStepReference == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("StepElement", "SuccessorOfStepReference"));
        }
        if (mIRStepReference._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("StepElement", "SuccessorOfStepReference"));
        }
        if (mIRStepReference.hasSuccessorStepElement != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("StepReference", "SuccessorStepElement"));
        }
        if (this.successorOfStepReferences != null && this.successorOfStepReferences.contains(mIRStepReference)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("StepElement", "SuccessorOfStepReference"));
        }
        this.getSuccessorOfStepReferenceCollection().add(mIRStepReference);
        mIRStepReference.hasSuccessorStepElement = this;
    }

    public final int getSuccessorOfStepReferenceCount() {
        if (this.successorOfStepReferences != null) {
            return this.successorOfStepReferences.size();
        }
        return 0;
    }

    public final boolean containsSuccessorOfStepReference(MIRStepReference mIRStepReference) {
        if (mIRStepReference != null && this.successorOfStepReferences != null) {
            return this.successorOfStepReferences.contains(mIRStepReference);
        }
        return false;
    }

    public final MIRStepReference getSuccessorOfStepReference(String string) {
        if (this.successorOfStepReferences != null) {
            return this.successorOfStepReferences.get(string);
        }
        return null;
    }

    public final Iterator<MIRStepReference> getSuccessorOfStepReferenceIterator() {
        if (this.successorOfStepReferences != null) {
            return this.successorOfStepReferences.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSuccessorOfStepReference(MIRStepReference mIRStepReference) {
        if (mIRStepReference != null && this.successorOfStepReferences != null && this.successorOfStepReferences.remove(mIRStepReference)) {
            mIRStepReference.hasSuccessorStepElement = null;
            if (this.successorOfStepReferences.isEmpty()) {
                this.successorOfStepReferences = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSuccessorOfStepReferences() {
        if (this.successorOfStepReferences != null) {
            for (MIRStepReference mIRStepReference : this.successorOfStepReferences) {
                mIRStepReference.hasSuccessorStepElement = null;
            }
            this.successorOfStepReferences = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRElement.staticGetMetaClass(), 348, "StepElement", true);
            new MIRMetaLink(metaClass, 860, "PredecessorOfStepReference", false, 1, 306, 879);
            new MIRMetaLink(metaClass, 861, "SuccessorOfStepReference", false, 3, 306, 880);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRStepElement.staticGetMetaClass();
    }
}

