/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRAuthenticationMode;
import MITI.sdk.MIRExternalServer;
import MITI.sdk.MIRFolderContentModel;
import MITI.sdk.MIRGlobalRole;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRObjectRole;
import MITI.sdk.MIRScheduledEvent;
import MITI.sdk.MIRUser;
import MITI.sdk.MIRUserGroup;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRRepository
extends MIRFolderContentModel {
    protected transient byte aAuthenticationMode = 0;
    protected transient MIRObjectCollection<MIRExternalServer> externalServers = null;
    protected transient MIRObjectCollection<MIRGlobalRole> globalRoles = null;
    protected transient MIRObjectCollection<MIRObjectRole> objectRoles = null;
    protected transient MIRObjectCollection<MIRScheduledEvent> scheduledEvents = null;
    protected transient MIRObjectCollection<MIRUser> users = null;
    protected transient MIRObjectCollection<MIRUserGroup> userGroups = null;
    private static MIRMetaClass metaClass = MIRRepository.staticGetMetaClass();

    public MIRRepository() {
    }

    public MIRRepository(MIRRepository mIRRepository) {
        this.setFrom(mIRRepository);
    }

    @Override
    public Object clone() {
        return new MIRRepository(this);
    }

    @Override
    public short getElementType() {
        return 156;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)156)) {
            this.setAuthenticationMode(((MIRRepository)mIR_Object).getAuthenticationMode());
        }
    }

    public final void setAuthenticationMode(byte by) {
        this.aAuthenticationMode = by;
    }

    public final byte getAuthenticationMode() {
        return this.aAuthenticationMode;
    }

    protected MIRObjectCollection<MIRExternalServer> getExternalServerCollection() {
        this.externalServers = MIRObjectCollections.get(this.externalServers, MIRSdkCollection.Type.OBJECT);
        return this.externalServers;
    }

    public SortedSet<MIRExternalServer> getExternalServers() {
        return MIRObjectCollections.sortedSet(this.externalServers);
    }

    public final void addExternalServer(MIRExternalServer mIRExternalServer) {
        if (mIRExternalServer == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Repository", "ExternalServer"));
        }
        if (mIRExternalServer._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Repository", "ExternalServer"));
        }
        if (mIRExternalServer.hasRepository != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ExternalServer", "Repository"));
        }
        if (this.externalServers != null && this.externalServers.contains(mIRExternalServer)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Repository", "ExternalServer"));
        }
        this.getExternalServerCollection().add(mIRExternalServer);
        mIRExternalServer.hasRepository = this;
    }

    public final int getExternalServerCount() {
        if (this.externalServers != null) {
            return this.externalServers.size();
        }
        return 0;
    }

    public final boolean containsExternalServer(MIRExternalServer mIRExternalServer) {
        if (mIRExternalServer != null && this.externalServers != null) {
            return this.externalServers.contains(mIRExternalServer);
        }
        return false;
    }

    public final MIRExternalServer getExternalServer(String string) {
        if (this.externalServers != null) {
            return this.externalServers.get(string);
        }
        return null;
    }

    public final Iterator<MIRExternalServer> getExternalServerIterator() {
        if (this.externalServers != null) {
            return this.externalServers.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeExternalServer(MIRExternalServer mIRExternalServer) {
        if (mIRExternalServer != null && this.externalServers != null && this.externalServers.remove(mIRExternalServer)) {
            mIRExternalServer.hasRepository = null;
            if (this.externalServers.isEmpty()) {
                this.externalServers = null;
            }
            return true;
        }
        return false;
    }

    public final void removeExternalServers() {
        if (this.externalServers != null) {
            for (MIRExternalServer mIRExternalServer : this.externalServers) {
                mIRExternalServer.hasRepository = null;
            }
            this.externalServers = null;
        }
    }

    protected MIRObjectCollection<MIRGlobalRole> getGlobalRoleCollection() {
        this.globalRoles = MIRObjectCollections.get(this.globalRoles, MIRSdkCollection.Type.OBJECT);
        return this.globalRoles;
    }

    public SortedSet<MIRGlobalRole> getGlobalRoles() {
        return MIRObjectCollections.sortedSet(this.globalRoles);
    }

    public final void addGlobalRole(MIRGlobalRole mIRGlobalRole) {
        if (mIRGlobalRole == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Repository", "GlobalRole"));
        }
        if (mIRGlobalRole._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Repository", "GlobalRole"));
        }
        if (mIRGlobalRole.hasRepository != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("GlobalRole", "Repository"));
        }
        if (this.globalRoles != null && this.globalRoles.contains(mIRGlobalRole)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Repository", "GlobalRole"));
        }
        this.getGlobalRoleCollection().add(mIRGlobalRole);
        mIRGlobalRole.hasRepository = this;
    }

    public final int getGlobalRoleCount() {
        if (this.globalRoles != null) {
            return this.globalRoles.size();
        }
        return 0;
    }

    public final boolean containsGlobalRole(MIRGlobalRole mIRGlobalRole) {
        if (mIRGlobalRole != null && this.globalRoles != null) {
            return this.globalRoles.contains(mIRGlobalRole);
        }
        return false;
    }

    public final MIRGlobalRole getGlobalRole(String string) {
        if (this.globalRoles != null) {
            return this.globalRoles.get(string);
        }
        return null;
    }

    public final Iterator<MIRGlobalRole> getGlobalRoleIterator() {
        if (this.globalRoles != null) {
            return this.globalRoles.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeGlobalRole(MIRGlobalRole mIRGlobalRole) {
        if (mIRGlobalRole != null && this.globalRoles != null && this.globalRoles.remove(mIRGlobalRole)) {
            mIRGlobalRole.hasRepository = null;
            if (this.globalRoles.isEmpty()) {
                this.globalRoles = null;
            }
            return true;
        }
        return false;
    }

    public final void removeGlobalRoles() {
        if (this.globalRoles != null) {
            for (MIRGlobalRole mIRGlobalRole : this.globalRoles) {
                mIRGlobalRole.hasRepository = null;
            }
            this.globalRoles = null;
        }
    }

    protected MIRObjectCollection<MIRObjectRole> getObjectRoleCollection() {
        this.objectRoles = MIRObjectCollections.get(this.objectRoles, MIRSdkCollection.Type.OBJECT);
        return this.objectRoles;
    }

    public SortedSet<MIRObjectRole> getObjectRoles() {
        return MIRObjectCollections.sortedSet(this.objectRoles);
    }

    public final void addObjectRole(MIRObjectRole mIRObjectRole) {
        if (mIRObjectRole == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Repository", "ObjectRole"));
        }
        if (mIRObjectRole._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Repository", "ObjectRole"));
        }
        if (mIRObjectRole.hasRepository != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ObjectRole", "Repository"));
        }
        if (this.objectRoles != null && this.objectRoles.contains(mIRObjectRole)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Repository", "ObjectRole"));
        }
        this.getObjectRoleCollection().add(mIRObjectRole);
        mIRObjectRole.hasRepository = this;
    }

    public final int getObjectRoleCount() {
        if (this.objectRoles != null) {
            return this.objectRoles.size();
        }
        return 0;
    }

    public final boolean containsObjectRole(MIRObjectRole mIRObjectRole) {
        if (mIRObjectRole != null && this.objectRoles != null) {
            return this.objectRoles.contains(mIRObjectRole);
        }
        return false;
    }

    public final MIRObjectRole getObjectRole(String string) {
        if (this.objectRoles != null) {
            return this.objectRoles.get(string);
        }
        return null;
    }

    public final Iterator<MIRObjectRole> getObjectRoleIterator() {
        if (this.objectRoles != null) {
            return this.objectRoles.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeObjectRole(MIRObjectRole mIRObjectRole) {
        if (mIRObjectRole != null && this.objectRoles != null && this.objectRoles.remove(mIRObjectRole)) {
            mIRObjectRole.hasRepository = null;
            if (this.objectRoles.isEmpty()) {
                this.objectRoles = null;
            }
            return true;
        }
        return false;
    }

    public final void removeObjectRoles() {
        if (this.objectRoles != null) {
            for (MIRObjectRole mIRObjectRole : this.objectRoles) {
                mIRObjectRole.hasRepository = null;
            }
            this.objectRoles = null;
        }
    }

    protected MIRObjectCollection<MIRScheduledEvent> getScheduledEventCollection() {
        this.scheduledEvents = MIRObjectCollections.get(this.scheduledEvents, MIRSdkCollection.Type.NAME);
        return this.scheduledEvents;
    }

    public SortedSet<MIRScheduledEvent> getScheduledEvents() {
        return MIRObjectCollections.sortedSet(this.scheduledEvents);
    }

    public final void addScheduledEvent(MIRScheduledEvent mIRScheduledEvent) {
        if (mIRScheduledEvent == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Repository", "ScheduledEvent"));
        }
        if (mIRScheduledEvent._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Repository", "ScheduledEvent"));
        }
        if (mIRScheduledEvent.hasRepository != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ScheduledEvent", "Repository"));
        }
        if (this.scheduledEvents != null) {
            if (this.scheduledEvents.contains(mIRScheduledEvent)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Repository", "ScheduledEvent"));
            }
            if (!this._allowName(this.scheduledEvents, mIRScheduledEvent)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Repository", this.getPath(), "ScheduledEvent", "Name", mIRScheduledEvent.getPath()));
            }
        }
        this.getScheduledEventCollection().add(mIRScheduledEvent);
        mIRScheduledEvent.hasRepository = this;
    }

    public final boolean addScheduledEventUniqueName(MIRScheduledEvent mIRScheduledEvent) {
        return this.addScheduledEventUniqueName(mIRScheduledEvent, '/');
    }

    public final boolean addScheduledEventUniqueName(MIRScheduledEvent mIRScheduledEvent, char c) {
        if (mIRScheduledEvent == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Repository", "ScheduledEvent"));
        }
        if (mIRScheduledEvent._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Repository", "ScheduledEvent"));
        }
        if (mIRScheduledEvent.hasRepository != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ScheduledEvent", "Repository"));
        }
        boolean bl = false;
        if (this.scheduledEvents != null) {
            if (this.scheduledEvents.contains(mIRScheduledEvent)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Repository", "ScheduledEvent"));
            }
            if (!this._allowName(this.scheduledEvents, mIRScheduledEvent)) {
                mIRScheduledEvent._rename(mIRScheduledEvent._setUniqueName(this.scheduledEvents, c));
                bl = true;
            }
        }
        this.getScheduledEventCollection().add(mIRScheduledEvent);
        mIRScheduledEvent.hasRepository = this;
        return bl;
    }

    public final int getScheduledEventCount() {
        if (this.scheduledEvents != null) {
            return this.scheduledEvents.size();
        }
        return 0;
    }

    public final boolean containsScheduledEvent(MIRScheduledEvent mIRScheduledEvent) {
        if (mIRScheduledEvent != null && this.scheduledEvents != null) {
            return this.scheduledEvents.contains(mIRScheduledEvent);
        }
        return false;
    }

    public final MIRScheduledEvent getScheduledEvent(String string) {
        if (this.scheduledEvents != null) {
            return this.scheduledEvents.get(string);
        }
        return null;
    }

    public final Iterator<MIRScheduledEvent> getScheduledEventIterator() {
        if (this.scheduledEvents != null) {
            return this.scheduledEvents.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeScheduledEvent(MIRScheduledEvent mIRScheduledEvent) {
        if (mIRScheduledEvent != null && this.scheduledEvents != null && this.scheduledEvents.remove(mIRScheduledEvent)) {
            mIRScheduledEvent.hasRepository = null;
            if (this.scheduledEvents.isEmpty()) {
                this.scheduledEvents = null;
            }
            return true;
        }
        return false;
    }

    public final void removeScheduledEvents() {
        if (this.scheduledEvents != null) {
            for (MIRScheduledEvent mIRScheduledEvent : this.scheduledEvents) {
                mIRScheduledEvent.hasRepository = null;
            }
            this.scheduledEvents = null;
        }
    }

    protected MIRObjectCollection<MIRUser> getUserCollection() {
        this.users = MIRObjectCollections.get(this.users, MIRSdkCollection.Type.NAME);
        return this.users;
    }

    public SortedSet<MIRUser> getUsers() {
        return MIRObjectCollections.sortedSet(this.users);
    }

    public final void addUser(MIRUser mIRUser) {
        if (mIRUser == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Repository", "User"));
        }
        if (mIRUser._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Repository", "User"));
        }
        if (mIRUser.hasRepository != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("User", "Repository"));
        }
        if (this.users != null) {
            if (this.users.contains(mIRUser)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Repository", "User"));
            }
            if (!this._allowName(this.users, mIRUser)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Repository", this.getPath(), "User", "Name", mIRUser.getPath()));
            }
        }
        this.getUserCollection().add(mIRUser);
        mIRUser.hasRepository = this;
    }

    public final boolean addUserUniqueName(MIRUser mIRUser) {
        return this.addUserUniqueName(mIRUser, '/');
    }

    public final boolean addUserUniqueName(MIRUser mIRUser, char c) {
        if (mIRUser == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Repository", "User"));
        }
        if (mIRUser._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Repository", "User"));
        }
        if (mIRUser.hasRepository != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("User", "Repository"));
        }
        boolean bl = false;
        if (this.users != null) {
            if (this.users.contains(mIRUser)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Repository", "User"));
            }
            if (!this._allowName(this.users, mIRUser)) {
                mIRUser._rename(mIRUser._setUniqueName(this.users, c));
                bl = true;
            }
        }
        this.getUserCollection().add(mIRUser);
        mIRUser.hasRepository = this;
        return bl;
    }

    public final int getUserCount() {
        if (this.users != null) {
            return this.users.size();
        }
        return 0;
    }

    public final boolean containsUser(MIRUser mIRUser) {
        if (mIRUser != null && this.users != null) {
            return this.users.contains(mIRUser);
        }
        return false;
    }

    public final MIRUser getUser(String string) {
        if (this.users != null) {
            return this.users.get(string);
        }
        return null;
    }

    public final Iterator<MIRUser> getUserIterator() {
        if (this.users != null) {
            return this.users.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeUser(MIRUser mIRUser) {
        if (mIRUser != null && this.users != null && this.users.remove(mIRUser)) {
            mIRUser.hasRepository = null;
            if (this.users.isEmpty()) {
                this.users = null;
            }
            return true;
        }
        return false;
    }

    public final void removeUsers() {
        if (this.users != null) {
            for (MIRUser mIRUser : this.users) {
                mIRUser.hasRepository = null;
            }
            this.users = null;
        }
    }

    protected MIRObjectCollection<MIRUserGroup> getUserGroupCollection() {
        this.userGroups = MIRObjectCollections.get(this.userGroups, MIRSdkCollection.Type.NAME);
        return this.userGroups;
    }

    public SortedSet<MIRUserGroup> getUserGroups() {
        return MIRObjectCollections.sortedSet(this.userGroups);
    }

    public final void addUserGroup(MIRUserGroup mIRUserGroup) {
        if (mIRUserGroup == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Repository", "UserGroup"));
        }
        if (mIRUserGroup._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Repository", "UserGroup"));
        }
        if (mIRUserGroup.hasRepository != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("UserGroup", "Repository"));
        }
        if (this.userGroups != null) {
            if (this.userGroups.contains(mIRUserGroup)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Repository", "UserGroup"));
            }
            if (!this._allowName(this.userGroups, mIRUserGroup)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Repository", this.getPath(), "UserGroup", "Name", mIRUserGroup.getPath()));
            }
        }
        this.getUserGroupCollection().add(mIRUserGroup);
        mIRUserGroup.hasRepository = this;
    }

    public final boolean addUserGroupUniqueName(MIRUserGroup mIRUserGroup) {
        return this.addUserGroupUniqueName(mIRUserGroup, '/');
    }

    public final boolean addUserGroupUniqueName(MIRUserGroup mIRUserGroup, char c) {
        if (mIRUserGroup == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Repository", "UserGroup"));
        }
        if (mIRUserGroup._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Repository", "UserGroup"));
        }
        if (mIRUserGroup.hasRepository != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("UserGroup", "Repository"));
        }
        boolean bl = false;
        if (this.userGroups != null) {
            if (this.userGroups.contains(mIRUserGroup)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Repository", "UserGroup"));
            }
            if (!this._allowName(this.userGroups, mIRUserGroup)) {
                mIRUserGroup._rename(mIRUserGroup._setUniqueName(this.userGroups, c));
                bl = true;
            }
        }
        this.getUserGroupCollection().add(mIRUserGroup);
        mIRUserGroup.hasRepository = this;
        return bl;
    }

    public final int getUserGroupCount() {
        if (this.userGroups != null) {
            return this.userGroups.size();
        }
        return 0;
    }

    public final boolean containsUserGroup(MIRUserGroup mIRUserGroup) {
        if (mIRUserGroup != null && this.userGroups != null) {
            return this.userGroups.contains(mIRUserGroup);
        }
        return false;
    }

    public final MIRUserGroup getUserGroup(String string) {
        if (this.userGroups != null) {
            return this.userGroups.get(string);
        }
        return null;
    }

    public final Iterator<MIRUserGroup> getUserGroupIterator() {
        if (this.userGroups != null) {
            return this.userGroups.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeUserGroup(MIRUserGroup mIRUserGroup) {
        if (mIRUserGroup != null && this.userGroups != null && this.userGroups.remove(mIRUserGroup)) {
            mIRUserGroup.hasRepository = null;
            if (this.userGroups.isEmpty()) {
                this.userGroups = null;
            }
            return true;
        }
        return false;
    }

    public final void removeUserGroups() {
        if (this.userGroups != null) {
            for (MIRUserGroup mIRUserGroup : this.userGroups) {
                mIRUserGroup.hasRepository = null;
            }
            this.userGroups = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRFolderContentModel.staticGetMetaClass(), 156, "Repository", false);
            new MIRMetaAttribute(metaClass, 415, "AuthenticationMode", "java.lang.Byte", MIRAuthenticationMode.class, new Byte(0));
            new MIRMetaLink(metaClass, 483, "ExternalServer", false, 3, 179, 484);
            new MIRMetaLink(metaClass, 1138, "GlobalRole", false, 3, 357, 1135);
            new MIRMetaLink(metaClass, 1139, "ObjectRole", false, 3, 358, 1137);
            new MIRMetaLink(metaClass, 431, "ScheduledEvent", false, 3, 177, 432);
            new MIRMetaLink(metaClass, 451, "User", false, 3, 176, 452);
            new MIRMetaLink(metaClass, 429, "UserGroup", false, 3, 170, 430);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRRepository.staticGetMetaClass();
    }
}

