/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRCondition;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRReport;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public abstract class MIRReportItem
extends MIRModelObject {
    protected transient short aPosition = 0;
    protected transient MIRObjectCollection<MIRReportItem> childReportItems = null;
    protected transient MIRObjectCollection<MIRCondition> conditions = null;
    protected transient MIRReportItem hasParentReportItem = null;
    protected transient MIRObjectCollection<MIRReportItem> referencedByReportItems = null;
    protected transient MIRObjectCollection<MIRReportItem> referencedReportItems = null;
    protected transient MIRReport hasReport = null;
    private static MIRMetaClass metaClass = MIRReportItem.staticGetMetaClass();
    protected static final Comparator<MIRReportItem> ByPosition = new Comparator<MIRReportItem>(){

        @Override
        public int compare(MIRReportItem mIRReportItem, MIRReportItem mIRReportItem2) {
            return mIRReportItem.getPosition() - mIRReportItem2.getPosition();
        }
    };

    @Override
    public short getElementType() {
        return 124;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)124)) {
            this.setPosition(((MIRReportItem)mIR_Object).getPosition());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasParentReportItem != null) {
            return this.hasParentReportItem;
        }
        if (this.hasReport != null) {
            return this.hasReport;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasParentReportItem != null ? 1 : 0) + (this.hasReport != null ? 1 : 0) + super.getParentCount();
    }

    public final void setPosition(short s) {
        this.aPosition = s;
    }

    public final short getPosition() {
        return this.aPosition;
    }

    protected MIRObjectCollection<MIRReportItem> getChildReportItemCollection() {
        this.childReportItems = MIRObjectCollections.get(this.childReportItems, MIRSdkCollection.Type.OBJECT);
        return this.childReportItems;
    }

    public SortedSet<MIRReportItem> getChildReportItems() {
        return MIRObjectCollections.sortedSet(this.childReportItems);
    }

    public final void addChildReportItem(MIRReportItem mIRReportItem) {
        if (mIRReportItem == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ReportItem", "ChildReportItem"));
        }
        if (mIRReportItem._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ReportItem", "ChildReportItem"));
        }
        if (mIRReportItem.hasParentReportItem != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ReportItem", "ParentReportItem"));
        }
        if (this.childReportItems != null && this.childReportItems.contains(mIRReportItem)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ReportItem", "ChildReportItem"));
        }
        this.getChildReportItemCollection().add(mIRReportItem);
        mIRReportItem.hasParentReportItem = this;
    }

    public final int getChildReportItemCount() {
        if (this.childReportItems != null) {
            return this.childReportItems.size();
        }
        return 0;
    }

    public final boolean containsChildReportItem(MIRReportItem mIRReportItem) {
        if (mIRReportItem != null && this.childReportItems != null) {
            return this.childReportItems.contains(mIRReportItem);
        }
        return false;
    }

    public final MIRReportItem getChildReportItem(String string) {
        if (this.childReportItems != null) {
            return this.childReportItems.get(string);
        }
        return null;
    }

    public final Iterator<MIRReportItem> getChildReportItemIterator() {
        if (this.childReportItems != null) {
            return this.childReportItems.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final List<MIRReportItem> getChildReportItemByPosition() {
        if (this.childReportItems != null) {
            ArrayList<MIRReportItem> arrayList = new ArrayList<MIRReportItem>();
            arrayList.addAll(this.childReportItems.values());
            MIRObjectCollections.sort(arrayList, ByPosition);
            return arrayList;
        }
        return MIRObjectCollections.emptyList();
    }

    public final boolean removeChildReportItem(MIRReportItem mIRReportItem) {
        if (mIRReportItem != null && this.childReportItems != null && this.childReportItems.remove(mIRReportItem)) {
            mIRReportItem.hasParentReportItem = null;
            if (this.childReportItems.isEmpty()) {
                this.childReportItems = null;
            }
            return true;
        }
        return false;
    }

    public final void removeChildReportItems() {
        if (this.childReportItems != null) {
            for (MIRReportItem mIRReportItem : this.childReportItems) {
                mIRReportItem.hasParentReportItem = null;
            }
            this.childReportItems = null;
        }
    }

    protected MIRObjectCollection<MIRCondition> getConditionCollection() {
        this.conditions = MIRObjectCollections.get(this.conditions, MIRSdkCollection.Type.OBJECT);
        return this.conditions;
    }

    public SortedSet<MIRCondition> getConditions() {
        return MIRObjectCollections.sortedSet(this.conditions);
    }

    public final void addCondition(MIRCondition mIRCondition) {
        if (mIRCondition == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ReportItem", "Condition"));
        }
        if (mIRCondition._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ReportItem", "Condition"));
        }
        if (this.conditions != null && this.conditions.contains(mIRCondition)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ReportItem", "Condition"));
        }
        this.getConditionCollection().add(mIRCondition);
        mIRCondition.getReportItemCollection().add(this);
    }

    public final int getConditionCount() {
        if (this.conditions != null) {
            return this.conditions.size();
        }
        return 0;
    }

    public final boolean containsCondition(MIRCondition mIRCondition) {
        if (mIRCondition != null && this.conditions != null) {
            return this.conditions.contains(mIRCondition);
        }
        return false;
    }

    public final MIRCondition getCondition(String string) {
        if (this.conditions != null) {
            return this.conditions.get(string);
        }
        return null;
    }

    public final Iterator<MIRCondition> getConditionIterator() {
        if (this.conditions != null) {
            return this.conditions.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeCondition(MIRCondition mIRCondition) {
        if (mIRCondition != null && this.conditions != null && this.conditions.remove(mIRCondition)) {
            mIRCondition.reportItems.remove(this);
            if (mIRCondition.reportItems.isEmpty()) {
                mIRCondition.reportItems = null;
            }
            if (this.conditions.isEmpty()) {
                this.conditions = null;
            }
            return true;
        }
        return false;
    }

    public final void removeConditions() {
        if (this.conditions != null) {
            for (MIRCondition mIRCondition : this.conditions) {
                mIRCondition.reportItems.remove(this);
                if (!mIRCondition.reportItems.isEmpty()) continue;
                mIRCondition.reportItems = null;
            }
            this.conditions = null;
        }
    }

    public final void addParentReportItem(MIRReportItem mIRReportItem) {
        if (mIRReportItem == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ReportItem", "ParentReportItem"));
        }
        if (mIRReportItem._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ReportItem", "ParentReportItem"));
        }
        if (this.hasParentReportItem != null) {
            if (this.hasParentReportItem._equals(mIRReportItem)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ReportItem", "ParentReportItem"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ReportItem", "ParentReportItem"));
        }
        this.hasParentReportItem = mIRReportItem;
        mIRReportItem.getChildReportItemCollection().add(this);
    }

    public final MIRReportItem getParentReportItem() {
        return this.hasParentReportItem;
    }

    public final boolean removeParentReportItem() {
        if (this.hasParentReportItem != null) {
            this.hasParentReportItem.childReportItems.remove(this);
            if (this.hasParentReportItem.childReportItems.isEmpty()) {
                this.hasParentReportItem.childReportItems = null;
            }
            this.hasParentReportItem = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRReportItem> getReferencedByReportItemCollection() {
        this.referencedByReportItems = MIRObjectCollections.get(this.referencedByReportItems, MIRSdkCollection.Type.OBJECT);
        return this.referencedByReportItems;
    }

    public SortedSet<MIRReportItem> getReferencedByReportItems() {
        return MIRObjectCollections.sortedSet(this.referencedByReportItems);
    }

    public final void addReferencedByReportItem(MIRReportItem mIRReportItem) {
        if (mIRReportItem == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ReportItem", "ReferencedByReportItem"));
        }
        if (mIRReportItem._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ReportItem", "ReferencedByReportItem"));
        }
        if (this.referencedByReportItems != null && this.referencedByReportItems.contains(mIRReportItem)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ReportItem", "ReferencedByReportItem"));
        }
        this.getReferencedByReportItemCollection().add(mIRReportItem);
        mIRReportItem.getReferencedReportItemCollection().add(this);
    }

    public final int getReferencedByReportItemCount() {
        if (this.referencedByReportItems != null) {
            return this.referencedByReportItems.size();
        }
        return 0;
    }

    public final boolean containsReferencedByReportItem(MIRReportItem mIRReportItem) {
        if (mIRReportItem != null && this.referencedByReportItems != null) {
            return this.referencedByReportItems.contains(mIRReportItem);
        }
        return false;
    }

    public final MIRReportItem getReferencedByReportItem(String string) {
        if (this.referencedByReportItems != null) {
            return this.referencedByReportItems.get(string);
        }
        return null;
    }

    public final Iterator<MIRReportItem> getReferencedByReportItemIterator() {
        if (this.referencedByReportItems != null) {
            return this.referencedByReportItems.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeReferencedByReportItem(MIRReportItem mIRReportItem) {
        if (mIRReportItem != null && this.referencedByReportItems != null && this.referencedByReportItems.remove(mIRReportItem)) {
            mIRReportItem.referencedReportItems.remove(this);
            if (mIRReportItem.referencedReportItems.isEmpty()) {
                mIRReportItem.referencedReportItems = null;
            }
            if (this.referencedByReportItems.isEmpty()) {
                this.referencedByReportItems = null;
            }
            return true;
        }
        return false;
    }

    public final void removeReferencedByReportItems() {
        if (this.referencedByReportItems != null) {
            for (MIRReportItem mIRReportItem : this.referencedByReportItems) {
                mIRReportItem.referencedReportItems.remove(this);
                if (!mIRReportItem.referencedReportItems.isEmpty()) continue;
                mIRReportItem.referencedReportItems = null;
            }
            this.referencedByReportItems = null;
        }
    }

    protected MIRObjectCollection<MIRReportItem> getReferencedReportItemCollection() {
        this.referencedReportItems = MIRObjectCollections.get(this.referencedReportItems, MIRSdkCollection.Type.OBJECT);
        return this.referencedReportItems;
    }

    public SortedSet<MIRReportItem> getReferencedReportItems() {
        return MIRObjectCollections.sortedSet(this.referencedReportItems);
    }

    public final void addReferencedReportItem(MIRReportItem mIRReportItem) {
        if (mIRReportItem == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ReportItem", "ReferencedReportItem"));
        }
        if (mIRReportItem._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ReportItem", "ReferencedReportItem"));
        }
        if (this.referencedReportItems != null && this.referencedReportItems.contains(mIRReportItem)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ReportItem", "ReferencedReportItem"));
        }
        this.getReferencedReportItemCollection().add(mIRReportItem);
        mIRReportItem.getReferencedByReportItemCollection().add(this);
    }

    public final int getReferencedReportItemCount() {
        if (this.referencedReportItems != null) {
            return this.referencedReportItems.size();
        }
        return 0;
    }

    public final boolean containsReferencedReportItem(MIRReportItem mIRReportItem) {
        if (mIRReportItem != null && this.referencedReportItems != null) {
            return this.referencedReportItems.contains(mIRReportItem);
        }
        return false;
    }

    public final MIRReportItem getReferencedReportItem(String string) {
        if (this.referencedReportItems != null) {
            return this.referencedReportItems.get(string);
        }
        return null;
    }

    public final Iterator<MIRReportItem> getReferencedReportItemIterator() {
        if (this.referencedReportItems != null) {
            return this.referencedReportItems.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeReferencedReportItem(MIRReportItem mIRReportItem) {
        if (mIRReportItem != null && this.referencedReportItems != null && this.referencedReportItems.remove(mIRReportItem)) {
            mIRReportItem.referencedByReportItems.remove(this);
            if (mIRReportItem.referencedByReportItems.isEmpty()) {
                mIRReportItem.referencedByReportItems = null;
            }
            if (this.referencedReportItems.isEmpty()) {
                this.referencedReportItems = null;
            }
            return true;
        }
        return false;
    }

    public final void removeReferencedReportItems() {
        if (this.referencedReportItems != null) {
            for (MIRReportItem mIRReportItem : this.referencedReportItems) {
                mIRReportItem.referencedByReportItems.remove(this);
                if (!mIRReportItem.referencedByReportItems.isEmpty()) continue;
                mIRReportItem.referencedByReportItems = null;
            }
            this.referencedReportItems = null;
        }
    }

    public final void addReport(MIRReport mIRReport) {
        if (mIRReport == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ReportItem", "Report"));
        }
        if (mIRReport._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ReportItem", "Report"));
        }
        if (this.hasReport != null) {
            if (this.hasReport._equals(mIRReport)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ReportItem", "Report"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ReportItem", "Report"));
        }
        this.hasReport = mIRReport;
        mIRReport.getReportItemCollection().add(this);
    }

    public final MIRReport getReport() {
        return this.hasReport;
    }

    public final boolean removeReport() {
        if (this.hasReport != null) {
            this.hasReport.reportItems.remove(this);
            if (this.hasReport.reportItems.isEmpty()) {
                this.hasReport.reportItems = null;
            }
            this.hasReport = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModelObject.staticGetMetaClass(), 124, "ReportItem", true);
            new MIRMetaAttribute(metaClass, 186, "Position", "java.lang.Short", null, new Short(0));
            new MIRMetaLink(metaClass, 322, "ChildReportItem", false, 3, 124, 321);
            new MIRMetaLink(metaClass, 373, "Condition", false, 0, 84, 374);
            new MIRMetaLink(metaClass, 321, "ParentReportItem", true, 2, 124, 322);
            new MIRMetaLink(metaClass, 368, "ReferencedByReportItem", false, 0, 124, 367);
            new MIRMetaLink(metaClass, 367, "ReferencedReportItem", false, 1, 124, 368);
            new MIRMetaLink(metaClass, 320, "Report", true, 2, 119, 315);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRReportItem.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.conditions != null) {
            for (MIRCondition mIRModelObject : this.conditions) {
                mIRModelObject.reportItems.rename(this, string);
            }
        }
        if (this.hasParentReportItem != null) {
            this.hasParentReportItem.childReportItems.rename(this, string);
        }
        if (this.referencedByReportItems != null) {
            for (MIRReportItem mIRReportItem : this.referencedByReportItems) {
                mIRReportItem.referencedReportItems.rename(this, string);
            }
        }
        if (this.referencedReportItems != null) {
            for (MIRReportItem mIRReportItem : this.referencedReportItems) {
                mIRReportItem.referencedByReportItems.rename(this, string);
            }
        }
        if (this.hasReport != null) {
            this.hasReport.reportItems.rename(this, string);
        }
        super._rename(string);
    }
}

