/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRPropertyElementTypeScope;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRTypeValue;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class MIRPropertyType
extends MIRModelObject {
    protected transient String aDataType = "";
    protected transient String aGroup = "";
    protected transient String aInitialValue = "";
    protected transient short aPosition = 0;
    protected transient String aUsage = "USER";
    protected transient MIRObjectCollection<MIRPropertyValue> instanciatedPropertyValues = null;
    protected transient MIRPropertyElementTypeScope hasPropertyElementTypeScope = null;
    protected transient MIRObjectCollection<MIRTypeValue> typeValues = null;
    private static MIRMetaClass metaClass = MIRPropertyType.staticGetMetaClass();
    protected static final Comparator<MIRPropertyType> ByPosition = new Comparator<MIRPropertyType>(){

        @Override
        public int compare(MIRPropertyType mIRPropertyType, MIRPropertyType mIRPropertyType2) {
            return mIRPropertyType.getPosition() - mIRPropertyType2.getPosition();
        }
    };

    public MIRPropertyType() {
    }

    public MIRPropertyType(MIRPropertyType mIRPropertyType) {
        this.setFrom(mIRPropertyType);
    }

    @Override
    public Object clone() {
        return new MIRPropertyType(this);
    }

    @Override
    public short getElementType() {
        return 70;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)70)) {
            this.setDataType(((MIRPropertyType)mIR_Object).getDataType());
            this.setGroup(((MIRPropertyType)mIR_Object).getGroup());
            this.setInitialValue(((MIRPropertyType)mIR_Object).getInitialValue());
            this.setPosition(((MIRPropertyType)mIR_Object).getPosition());
            this.setUsage(((MIRPropertyType)mIR_Object).getUsage());
            if (((MIRPropertyType)mIR_Object).getTypeValueCount() > 0) {
                Iterator<MIRTypeValue> iterator = ((MIRPropertyType)mIR_Object).getTypeValueIterator();
                while (iterator.hasNext()) {
                    this.addTypeValue(new MIRTypeValue(iterator.next()));
                }
            }
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasPropertyElementTypeScope != null) {
            return this.hasPropertyElementTypeScope;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasPropertyElementTypeScope != null ? 1 : 0) + super.getParentCount();
    }

    public final void setDataType(String string) {
        this.aDataType = string == null ? "" : string;
    }

    public final String getDataType() {
        return this.aDataType;
    }

    public final void setGroup(String string) {
        this.aGroup = string == null ? "" : string;
    }

    public final String getGroup() {
        return this.aGroup;
    }

    public final void setInitialValue(String string) {
        this.aInitialValue = string == null ? "" : string;
    }

    public final String getInitialValue() {
        return this.aInitialValue;
    }

    public final void setPosition(short s) {
        this.aPosition = s;
    }

    public final short getPosition() {
        return this.aPosition;
    }

    public final void setUsage(String string) {
        this.aUsage = string == null ? "USER" : string;
    }

    public final String getUsage() {
        return this.aUsage;
    }

    protected MIRObjectCollection<MIRPropertyValue> getInstanciatedPropertyValueCollection() {
        this.instanciatedPropertyValues = MIRObjectCollections.get(this.instanciatedPropertyValues, MIRSdkCollection.Type.OBJECT);
        return this.instanciatedPropertyValues;
    }

    public SortedSet<MIRPropertyValue> getInstanciatedPropertyValues() {
        return MIRObjectCollections.sortedSet(this.instanciatedPropertyValues);
    }

    public final void addInstanciatedPropertyValue(MIRPropertyValue mIRPropertyValue) {
        if (mIRPropertyValue == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("PropertyType", "InstanciatedPropertyValue"));
        }
        if (mIRPropertyValue._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("PropertyType", "InstanciatedPropertyValue"));
        }
        if (mIRPropertyValue.hasPropertyType != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("PropertyValue", "PropertyType"));
        }
        if (this.instanciatedPropertyValues != null && this.instanciatedPropertyValues.contains(mIRPropertyValue)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("PropertyType", "InstanciatedPropertyValue"));
        }
        String string = mIRPropertyValue.getName();
        this.getInstanciatedPropertyValueCollection().add(mIRPropertyValue);
        mIRPropertyValue.hasPropertyType = this;
        mIRPropertyValue._rename(string);
    }

    public final int getInstanciatedPropertyValueCount() {
        if (this.instanciatedPropertyValues != null) {
            return this.instanciatedPropertyValues.size();
        }
        return 0;
    }

    public final boolean containsInstanciatedPropertyValue(MIRPropertyValue mIRPropertyValue) {
        if (mIRPropertyValue != null && this.instanciatedPropertyValues != null) {
            return this.instanciatedPropertyValues.contains(mIRPropertyValue);
        }
        return false;
    }

    public final MIRPropertyValue getInstanciatedPropertyValue(String string) {
        if (this.instanciatedPropertyValues != null) {
            return this.instanciatedPropertyValues.get(string);
        }
        return null;
    }

    public final Iterator<MIRPropertyValue> getInstanciatedPropertyValueIterator() {
        if (this.instanciatedPropertyValues != null) {
            return this.instanciatedPropertyValues.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeInstanciatedPropertyValue(MIRPropertyValue mIRPropertyValue) {
        if (mIRPropertyValue != null && this.instanciatedPropertyValues != null) {
            String string = mIRPropertyValue.getName();
            if (this.instanciatedPropertyValues.remove(mIRPropertyValue)) {
                mIRPropertyValue.hasPropertyType = null;
                if (this.instanciatedPropertyValues.isEmpty()) {
                    this.instanciatedPropertyValues = null;
                }
                mIRPropertyValue._rename(string);
                return true;
            }
        }
        return false;
    }

    public final void removeInstanciatedPropertyValues() {
        if (this.instanciatedPropertyValues != null) {
            for (MIRPropertyValue mIRPropertyValue : this.instanciatedPropertyValues) {
                mIRPropertyValue.hasPropertyType = null;
            }
            this.instanciatedPropertyValues = null;
        }
    }

    public final void addPropertyElementTypeScope(MIRPropertyElementTypeScope mIRPropertyElementTypeScope) {
        if (mIRPropertyElementTypeScope == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("PropertyType", "PropertyElementTypeScope"));
        }
        if (mIRPropertyElementTypeScope._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("PropertyType", "PropertyElementTypeScope"));
        }
        if (this.hasPropertyElementTypeScope != null) {
            if (this.hasPropertyElementTypeScope._equals(mIRPropertyElementTypeScope)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("PropertyType", "PropertyElementTypeScope"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("PropertyType", "PropertyElementTypeScope"));
        }
        this.hasPropertyElementTypeScope = mIRPropertyElementTypeScope;
        mIRPropertyElementTypeScope.getPropertyTypeCollection().add(this);
    }

    public final MIRPropertyElementTypeScope getPropertyElementTypeScope() {
        return this.hasPropertyElementTypeScope;
    }

    public final boolean removePropertyElementTypeScope() {
        if (this.hasPropertyElementTypeScope != null) {
            this.hasPropertyElementTypeScope.propertyTypes.remove(this);
            if (this.hasPropertyElementTypeScope.propertyTypes.isEmpty()) {
                this.hasPropertyElementTypeScope.propertyTypes = null;
            }
            this.hasPropertyElementTypeScope = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRTypeValue> getTypeValueCollection() {
        this.typeValues = MIRObjectCollections.get(this.typeValues, MIRSdkCollection.Type.NAME_VALUE);
        return this.typeValues;
    }

    public SortedSet<MIRTypeValue> getTypeValues() {
        return MIRObjectCollections.sortedSet(this.typeValues);
    }

    public final void addTypeValue(MIRTypeValue mIRTypeValue) {
        if (mIRTypeValue == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("PropertyType", "TypeValue"));
        }
        if (mIRTypeValue._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("PropertyType", "TypeValue"));
        }
        if (mIRTypeValue.hasPropertyType != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("TypeValue", "PropertyType"));
        }
        if (this.typeValues != null) {
            if (this.typeValues.contains(mIRTypeValue)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("PropertyType", "TypeValue"));
            }
            if (!this._allowName(this.typeValues, mIRTypeValue)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("PropertyType", this.getPath(), "TypeValue", "NameValue", mIRTypeValue.getPath()));
            }
        }
        this.getTypeValueCollection().add(mIRTypeValue);
        mIRTypeValue.hasPropertyType = this;
    }

    public final boolean addTypeValueUniqueName(MIRTypeValue mIRTypeValue) {
        return this.addTypeValueUniqueName(mIRTypeValue, '/');
    }

    public final boolean addTypeValueUniqueName(MIRTypeValue mIRTypeValue, char c) {
        if (mIRTypeValue == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("PropertyType", "TypeValue"));
        }
        if (mIRTypeValue._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("PropertyType", "TypeValue"));
        }
        if (mIRTypeValue.hasPropertyType != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("TypeValue", "PropertyType"));
        }
        boolean bl = false;
        if (this.typeValues != null) {
            if (this.typeValues.contains(mIRTypeValue)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("PropertyType", "TypeValue"));
            }
            if (!this._allowName(this.typeValues, mIRTypeValue)) {
                mIRTypeValue._rename(mIRTypeValue._setUniqueName(this.typeValues, c));
                bl = true;
            }
        }
        this.getTypeValueCollection().add(mIRTypeValue);
        mIRTypeValue.hasPropertyType = this;
        return bl;
    }

    public final int getTypeValueCount() {
        if (this.typeValues != null) {
            return this.typeValues.size();
        }
        return 0;
    }

    public final boolean containsTypeValue(MIRTypeValue mIRTypeValue) {
        if (mIRTypeValue != null && this.typeValues != null) {
            return this.typeValues.contains(mIRTypeValue);
        }
        return false;
    }

    public final MIRTypeValue getTypeValue(String string) {
        if (this.typeValues != null) {
            return this.typeValues.get(string);
        }
        return null;
    }

    public final Iterator<MIRTypeValue> getTypeValueIterator() {
        if (this.typeValues != null) {
            return this.typeValues.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final List<MIRTypeValue> getTypeValueByPosition() {
        if (this.typeValues != null) {
            ArrayList<MIRTypeValue> arrayList = new ArrayList<MIRTypeValue>();
            arrayList.addAll(this.typeValues.values());
            MIRObjectCollections.sort(arrayList, MIRTypeValue.ByPosition);
            return arrayList;
        }
        return MIRObjectCollections.emptyList();
    }

    public final boolean removeTypeValue(MIRTypeValue mIRTypeValue) {
        if (mIRTypeValue != null && this.typeValues != null && this.typeValues.remove(mIRTypeValue)) {
            mIRTypeValue.hasPropertyType = null;
            if (this.typeValues.isEmpty()) {
                this.typeValues = null;
            }
            return true;
        }
        return false;
    }

    public final void removeTypeValues() {
        if (this.typeValues != null) {
            for (MIRTypeValue mIRTypeValue : this.typeValues) {
                mIRTypeValue.hasPropertyType = null;
            }
            this.typeValues = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModelObject.staticGetMetaClass(), 70, "PropertyType", false);
            new MIRMetaAttribute(metaClass, 244, "InitialValue", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 243, "DataType", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 142, "Position", "java.lang.Short", null, new Short(0));
            new MIRMetaAttribute(metaClass, 143, "Usage", "java.lang.String", null, "USER");
            new MIRMetaAttribute(metaClass, 141, "Group", "java.lang.String", null, "");
            new MIRMetaLink(metaClass, 221, "InstanciatedPropertyValue", false, 1, 71, 222);
            new MIRMetaLink(metaClass, 220, "PropertyElementTypeScope", true, 2, 69, 218);
            new MIRMetaLink(metaClass, 379, "TypeValue", false, 3, 7, 380);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRPropertyType.staticGetMetaClass();
    }

    public String getFullName() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.aUsage.equals("USER")) {
            if (this.aGroup.length() != 0) {
                stringBuilder.append(this.aGroup);
                stringBuilder.append(".");
            }
        } else {
            if (this.aUsage.length() != 0) {
                stringBuilder.append(this.aUsage);
                stringBuilder.append(".");
            }
            if (this.aGroup.length() != 0) {
                stringBuilder.append(this.aGroup);
                stringBuilder.append(".");
            }
        }
        stringBuilder.append(this.aName);
        return stringBuilder.toString();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasPropertyElementTypeScope != null) {
            this.hasPropertyElementTypeScope.propertyTypes.rename(this, string);
        }
        super._rename(string);
    }

    public static class MIRPropertyTypeComparator
    implements Comparator<MIRPropertyType> {
        @Override
        public int compare(MIRPropertyType mIRPropertyType, MIRPropertyType mIRPropertyType2) {
            int n = 0;
            n = mIRPropertyType.getUsage().compareTo(mIRPropertyType2.getUsage());
            if (n != 0) {
                return n;
            }
            n = mIRPropertyType.getPropertyElementTypeScope().getScope() - mIRPropertyType2.getPropertyElementTypeScope().getScope();
            if (n != 0) {
                return n;
            }
            n = mIRPropertyType.getGroup().compareTo(mIRPropertyType2.getGroup());
            if (n != 0) {
                return n;
            }
            n = mIRPropertyType.getPosition() - mIRPropertyType2.getPosition();
            if (n != 0) {
                return n;
            }
            n = mIRPropertyType.getName().compareTo(mIRPropertyType2.getName());
            return n;
        }
    }
}

