/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRPhysicalObject;
import MITI.sdk.MIRPhysicalTargetType;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRPhysicalTarget
extends MIRModelObject {
    protected transient byte aTargetType = 0;
    protected transient MIRObjectCollection<MIRPhysicalObject> physicalObjects = null;
    protected transient MIRStoreModel hasStoreModel = null;
    private static MIRMetaClass metaClass = MIRPhysicalTarget.staticGetMetaClass();

    public MIRPhysicalTarget() {
    }

    public MIRPhysicalTarget(MIRPhysicalTarget mIRPhysicalTarget) {
        this.setFrom(mIRPhysicalTarget);
    }

    @Override
    public Object clone() {
        return new MIRPhysicalTarget(this);
    }

    @Override
    public short getElementType() {
        return 53;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)53)) {
            this.setTargetType(((MIRPhysicalTarget)mIR_Object).getTargetType());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasStoreModel != null) {
            return this.hasStoreModel;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasStoreModel != null ? 1 : 0) + super.getParentCount();
    }

    public final void setTargetType(byte by) {
        this.aTargetType = by;
    }

    public final byte getTargetType() {
        return this.aTargetType;
    }

    protected MIRObjectCollection<MIRPhysicalObject> getPhysicalObjectCollection() {
        this.physicalObjects = MIRObjectCollections.get(this.physicalObjects, MIRSdkCollection.Type.OBJECT);
        return this.physicalObjects;
    }

    public SortedSet<MIRPhysicalObject> getPhysicalObjects() {
        return MIRObjectCollections.sortedSet(this.physicalObjects);
    }

    public final void addPhysicalObject(MIRPhysicalObject mIRPhysicalObject) {
        if (mIRPhysicalObject == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("PhysicalTarget", "PhysicalObject"));
        }
        if (mIRPhysicalObject._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("PhysicalTarget", "PhysicalObject"));
        }
        if (mIRPhysicalObject.hasPhysicalTarget != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("PhysicalObject", "PhysicalTarget"));
        }
        if (this.physicalObjects != null && this.physicalObjects.contains(mIRPhysicalObject)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("PhysicalTarget", "PhysicalObject"));
        }
        this.getPhysicalObjectCollection().add(mIRPhysicalObject);
        mIRPhysicalObject.hasPhysicalTarget = this;
    }

    public final int getPhysicalObjectCount() {
        if (this.physicalObjects != null) {
            return this.physicalObjects.size();
        }
        return 0;
    }

    public final boolean containsPhysicalObject(MIRPhysicalObject mIRPhysicalObject) {
        if (mIRPhysicalObject != null && this.physicalObjects != null) {
            return this.physicalObjects.contains(mIRPhysicalObject);
        }
        return false;
    }

    public final MIRPhysicalObject getPhysicalObject(String string) {
        if (this.physicalObjects != null) {
            return this.physicalObjects.get(string);
        }
        return null;
    }

    public final Iterator<MIRPhysicalObject> getPhysicalObjectIterator() {
        if (this.physicalObjects != null) {
            return this.physicalObjects.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removePhysicalObject(MIRPhysicalObject mIRPhysicalObject) {
        if (mIRPhysicalObject != null && this.physicalObjects != null && this.physicalObjects.remove(mIRPhysicalObject)) {
            mIRPhysicalObject.hasPhysicalTarget = null;
            if (this.physicalObjects.isEmpty()) {
                this.physicalObjects = null;
            }
            return true;
        }
        return false;
    }

    public final void removePhysicalObjects() {
        if (this.physicalObjects != null) {
            for (MIRPhysicalObject mIRPhysicalObject : this.physicalObjects) {
                mIRPhysicalObject.hasPhysicalTarget = null;
            }
            this.physicalObjects = null;
        }
    }

    public final void addStoreModel(MIRStoreModel mIRStoreModel) {
        if (mIRStoreModel == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("PhysicalTarget", "StoreModel"));
        }
        if (mIRStoreModel._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("PhysicalTarget", "StoreModel"));
        }
        if (this.hasStoreModel != null) {
            if (this.hasStoreModel._equals(mIRStoreModel)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("PhysicalTarget", "StoreModel"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("PhysicalTarget", "StoreModel"));
        }
        if (mIRStoreModel.physicalTargets != null && !mIRStoreModel._allowName(mIRStoreModel.physicalTargets, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("StoreModel", mIRStoreModel.getPath(), "PhysicalTarget", "Object", this.getName()));
        }
        this.hasStoreModel = mIRStoreModel;
        mIRStoreModel.getPhysicalTargetCollection().add(this);
    }

    public final MIRStoreModel getStoreModel() {
        return this.hasStoreModel;
    }

    public final boolean removeStoreModel() {
        if (this.hasStoreModel != null) {
            this.hasStoreModel.physicalTargets.remove(this);
            if (this.hasStoreModel.physicalTargets.isEmpty()) {
                this.hasStoreModel.physicalTargets = null;
            }
            this.hasStoreModel = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModelObject.staticGetMetaClass(), 53, "PhysicalTarget", false);
            new MIRMetaAttribute(metaClass, 123, "TargetType", "java.lang.Byte", MIRPhysicalTargetType.class, new Byte(0));
            new MIRMetaLink(metaClass, 208, "PhysicalObject", false, 3, 54, 202);
            new MIRMetaLink(metaClass, 209, "StoreModel", true, 2, 2, 174);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRPhysicalTarget.staticGetMetaClass();
    }

    @Override
    protected boolean _isValidName() {
        if (this.hasStoreModel != null && !this.hasStoreModel._allowName(this.hasStoreModel.physicalTargets, this)) {
            return false;
        }
        return super._isValidName();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasStoreModel != null) {
            this.hasStoreModel.physicalTargets.rename(this, string);
        }
        super._rename(string);
    }
}

