/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRArgument;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConcurrencyType;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIRSQLViewEntity;
import MITI.sdk.MIRType;
import MITI.sdk.MIRVisibilityType;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class MIROperation
extends MIRNamespaceElement {
    protected transient boolean aCppAbstract = false;
    protected transient byte aCppConcurrency = 0;
    protected transient boolean aCppFriend = false;
    protected transient byte aCppScope = 0;
    protected transient boolean aCppStatic = false;
    protected transient boolean aCppVirtual = false;
    protected transient short aPosition = 0;
    protected transient String aPostcondition = "";
    protected transient String aPrecondition = "";
    protected transient String aSemantics = "";
    protected transient MIRObjectCollection<MIRArgument> arguments = null;
    protected transient MIRClass hasAssociatedClass = null;
    protected transient MIRSQLViewEntity hasAssociatedSQLViewEntity = null;
    protected transient MIRObjectCollection<MIRClassifierMap> classifierMaps = null;
    protected transient MIRObjectCollection<MIROperationNode> operationNodes = null;
    protected transient MIRType hasReturnType = null;
    private static MIRMetaClass metaClass = MIROperation.staticGetMetaClass();
    protected static final Comparator<MIROperation> ByPosition = new Comparator<MIROperation>(){

        @Override
        public int compare(MIROperation mIROperation, MIROperation mIROperation2) {
            return mIROperation.getPosition() - mIROperation2.getPosition();
        }
    };

    public MIROperation() {
    }

    public MIROperation(MIROperation mIROperation) {
        this.setFrom(mIROperation);
    }

    @Override
    public Object clone() {
        return new MIROperation(this);
    }

    @Override
    public short getElementType() {
        return 23;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)23)) {
            this.setCppAbstract(((MIROperation)mIR_Object).getCppAbstract());
            this.setCppConcurrency(((MIROperation)mIR_Object).getCppConcurrency());
            this.setCppFriend(((MIROperation)mIR_Object).getCppFriend());
            this.setCppScope(((MIROperation)mIR_Object).getCppScope());
            this.setCppStatic(((MIROperation)mIR_Object).getCppStatic());
            this.setCppVirtual(((MIROperation)mIR_Object).getCppVirtual());
            this.setPosition(((MIROperation)mIR_Object).getPosition());
            this.setPostcondition(((MIROperation)mIR_Object).getPostcondition());
            this.setPrecondition(((MIROperation)mIR_Object).getPrecondition());
            this.setSemantics(((MIROperation)mIR_Object).getSemantics());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasAssociatedClass != null) {
            return this.hasAssociatedClass;
        }
        if (this.hasAssociatedSQLViewEntity != null) {
            return this.hasAssociatedSQLViewEntity;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasAssociatedClass != null ? 1 : 0) + (this.hasAssociatedSQLViewEntity != null ? 1 : 0) + super.getParentCount();
    }

    public final void setCppAbstract(boolean bl) {
        this.aCppAbstract = bl;
    }

    public final boolean getCppAbstract() {
        return this.aCppAbstract;
    }

    public final void setCppConcurrency(byte by) {
        this.aCppConcurrency = by;
    }

    public final byte getCppConcurrency() {
        return this.aCppConcurrency;
    }

    public final void setCppFriend(boolean bl) {
        this.aCppFriend = bl;
    }

    public final boolean getCppFriend() {
        return this.aCppFriend;
    }

    public final void setCppScope(byte by) {
        this.aCppScope = by;
    }

    public final byte getCppScope() {
        return this.aCppScope;
    }

    public final void setCppStatic(boolean bl) {
        this.aCppStatic = bl;
    }

    public final boolean getCppStatic() {
        return this.aCppStatic;
    }

    public final void setCppVirtual(boolean bl) {
        this.aCppVirtual = bl;
    }

    public final boolean getCppVirtual() {
        return this.aCppVirtual;
    }

    public final void setPosition(short s) {
        this.aPosition = s;
    }

    public final short getPosition() {
        return this.aPosition;
    }

    public final void setPostcondition(String string) {
        this.aPostcondition = string == null ? "" : string;
    }

    public final String getPostcondition() {
        return this.aPostcondition;
    }

    public final void setPrecondition(String string) {
        this.aPrecondition = string == null ? "" : string;
    }

    public final String getPrecondition() {
        return this.aPrecondition;
    }

    public final void setSemantics(String string) {
        this.aSemantics = string == null ? "" : string;
    }

    public final String getSemantics() {
        return this.aSemantics;
    }

    protected MIRObjectCollection<MIRArgument> getArgumentCollection() {
        this.arguments = MIRObjectCollections.get(this.arguments, MIRSdkCollection.Type.OPTIONAL_NAME);
        return this.arguments;
    }

    public SortedSet<MIRArgument> getArguments() {
        return MIRObjectCollections.sortedSet(this.arguments);
    }

    public final void addArgument(MIRArgument mIRArgument) {
        if (mIRArgument == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Operation", "Argument"));
        }
        if (mIRArgument._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Operation", "Argument"));
        }
        if (mIRArgument.hasOperation != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Argument", "Operation"));
        }
        if (this.arguments != null) {
            if (this.arguments.contains(mIRArgument)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Operation", "Argument"));
            }
            if (!this._allowName(this.arguments, mIRArgument)) {
                throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Operation", this.getPath(), "Argument", "OptionalName", mIRArgument.getPath()));
            }
        }
        this.getArgumentCollection().add(mIRArgument);
        mIRArgument.hasOperation = this;
    }

    public final boolean addArgumentUniqueName(MIRArgument mIRArgument) {
        return this.addArgumentUniqueName(mIRArgument, '/');
    }

    public final boolean addArgumentUniqueName(MIRArgument mIRArgument, char c) {
        if (mIRArgument == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Operation", "Argument"));
        }
        if (mIRArgument._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Operation", "Argument"));
        }
        if (mIRArgument.hasOperation != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Argument", "Operation"));
        }
        boolean bl = false;
        if (this.arguments != null) {
            if (this.arguments.contains(mIRArgument)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Operation", "Argument"));
            }
            if (!this._allowName(this.arguments, mIRArgument)) {
                mIRArgument._rename(mIRArgument._setUniqueName(this.arguments, c));
                bl = true;
            }
        }
        this.getArgumentCollection().add(mIRArgument);
        mIRArgument.hasOperation = this;
        return bl;
    }

    public final int getArgumentCount() {
        if (this.arguments != null) {
            return this.arguments.size();
        }
        return 0;
    }

    public final boolean containsArgument(MIRArgument mIRArgument) {
        if (mIRArgument != null && this.arguments != null) {
            return this.arguments.contains(mIRArgument);
        }
        return false;
    }

    public final MIRArgument getArgument(String string) {
        if (this.arguments != null) {
            return this.arguments.get(string);
        }
        return null;
    }

    public final Iterator<MIRArgument> getArgumentIterator() {
        if (this.arguments != null) {
            return this.arguments.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final List<MIRArgument> getArgumentByPosition() {
        if (this.arguments != null) {
            ArrayList<MIRArgument> arrayList = new ArrayList<MIRArgument>();
            arrayList.addAll(this.arguments.values());
            MIRObjectCollections.sort(arrayList, MIRArgument.ByPosition);
            return arrayList;
        }
        return MIRObjectCollections.emptyList();
    }

    public final boolean removeArgument(MIRArgument mIRArgument) {
        if (mIRArgument != null && this.arguments != null && this.arguments.remove(mIRArgument)) {
            mIRArgument.hasOperation = null;
            if (this.arguments.isEmpty()) {
                this.arguments = null;
            }
            return true;
        }
        return false;
    }

    public final void removeArguments() {
        if (this.arguments != null) {
            for (MIRArgument mIRArgument : this.arguments) {
                mIRArgument.hasOperation = null;
            }
            this.arguments = null;
        }
    }

    public final void addAssociatedClass(MIRClass mIRClass) {
        if (mIRClass == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Operation", "AssociatedClass"));
        }
        if (mIRClass._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Operation", "AssociatedClass"));
        }
        if (this.hasAssociatedClass != null) {
            if (this.hasAssociatedClass._equals(mIRClass)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Operation", "AssociatedClass"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Operation", "AssociatedClass"));
        }
        this.hasAssociatedClass = mIRClass;
        mIRClass.getOperationCollection().add(this);
    }

    public final MIRClass getAssociatedClass() {
        return this.hasAssociatedClass;
    }

    public final boolean removeAssociatedClass() {
        if (this.hasAssociatedClass != null) {
            this.hasAssociatedClass.operations.remove(this);
            if (this.hasAssociatedClass.operations.isEmpty()) {
                this.hasAssociatedClass.operations = null;
            }
            this.hasAssociatedClass = null;
            return true;
        }
        return false;
    }

    public final void addAssociatedSQLViewEntity(MIRSQLViewEntity mIRSQLViewEntity) {
        if (mIRSQLViewEntity == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Operation", "AssociatedSQLViewEntity"));
        }
        if (mIRSQLViewEntity._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Operation", "AssociatedSQLViewEntity"));
        }
        if (this.hasAssociatedSQLViewEntity != null) {
            if (this.hasAssociatedSQLViewEntity._equals(mIRSQLViewEntity)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Operation", "AssociatedSQLViewEntity"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Operation", "AssociatedSQLViewEntity"));
        }
        this.hasAssociatedSQLViewEntity = mIRSQLViewEntity;
        mIRSQLViewEntity.getOperationCollection().add(this);
    }

    public final MIRSQLViewEntity getAssociatedSQLViewEntity() {
        return this.hasAssociatedSQLViewEntity;
    }

    public final boolean removeAssociatedSQLViewEntity() {
        if (this.hasAssociatedSQLViewEntity != null) {
            this.hasAssociatedSQLViewEntity.operations.remove(this);
            if (this.hasAssociatedSQLViewEntity.operations.isEmpty()) {
                this.hasAssociatedSQLViewEntity.operations = null;
            }
            this.hasAssociatedSQLViewEntity = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRClassifierMap> getClassifierMapCollection() {
        this.classifierMaps = MIRObjectCollections.get(this.classifierMaps, MIRSdkCollection.Type.OBJECT);
        return this.classifierMaps;
    }

    public SortedSet<MIRClassifierMap> getClassifierMaps() {
        return MIRObjectCollections.sortedSet(this.classifierMaps);
    }

    public final void addClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Operation", "ClassifierMap"));
        }
        if (mIRClassifierMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Operation", "ClassifierMap"));
        }
        if (mIRClassifierMap.hasDatabaseOperation != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ClassifierMap", "DatabaseOperation"));
        }
        if (this.classifierMaps != null && this.classifierMaps.contains(mIRClassifierMap)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Operation", "ClassifierMap"));
        }
        this.getClassifierMapCollection().add(mIRClassifierMap);
        mIRClassifierMap.hasDatabaseOperation = this;
    }

    public final int getClassifierMapCount() {
        if (this.classifierMaps != null) {
            return this.classifierMaps.size();
        }
        return 0;
    }

    public final boolean containsClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap != null && this.classifierMaps != null) {
            return this.classifierMaps.contains(mIRClassifierMap);
        }
        return false;
    }

    public final MIRClassifierMap getClassifierMap(String string) {
        if (this.classifierMaps != null) {
            return this.classifierMaps.get(string);
        }
        return null;
    }

    public final Iterator<MIRClassifierMap> getClassifierMapIterator() {
        if (this.classifierMaps != null) {
            return this.classifierMaps.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeClassifierMap(MIRClassifierMap mIRClassifierMap) {
        if (mIRClassifierMap != null && this.classifierMaps != null && this.classifierMaps.remove(mIRClassifierMap)) {
            mIRClassifierMap.hasDatabaseOperation = null;
            if (this.classifierMaps.isEmpty()) {
                this.classifierMaps = null;
            }
            return true;
        }
        return false;
    }

    public final void removeClassifierMaps() {
        if (this.classifierMaps != null) {
            for (MIRClassifierMap mIRClassifierMap : this.classifierMaps) {
                mIRClassifierMap.hasDatabaseOperation = null;
            }
            this.classifierMaps = null;
        }
    }

    protected MIRObjectCollection<MIROperationNode> getOperationNodeCollection() {
        this.operationNodes = MIRObjectCollections.get(this.operationNodes, MIRSdkCollection.Type.OBJECT);
        return this.operationNodes;
    }

    public SortedSet<MIROperationNode> getOperationNodes() {
        return MIRObjectCollections.sortedSet(this.operationNodes);
    }

    public final void addOperationNode(MIROperationNode mIROperationNode) {
        if (mIROperationNode == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Operation", "OperationNode"));
        }
        if (mIROperationNode._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Operation", "OperationNode"));
        }
        if (mIROperationNode.hasOperation != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("OperationNode", "Operation"));
        }
        if (this.operationNodes != null && this.operationNodes.contains(mIROperationNode)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Operation", "OperationNode"));
        }
        this.getOperationNodeCollection().add(mIROperationNode);
        mIROperationNode.hasOperation = this;
    }

    public final int getOperationNodeCount() {
        if (this.operationNodes != null) {
            return this.operationNodes.size();
        }
        return 0;
    }

    public final boolean containsOperationNode(MIROperationNode mIROperationNode) {
        if (mIROperationNode != null && this.operationNodes != null) {
            return this.operationNodes.contains(mIROperationNode);
        }
        return false;
    }

    public final MIROperationNode getOperationNode(String string) {
        if (this.operationNodes != null) {
            return this.operationNodes.get(string);
        }
        return null;
    }

    public final Iterator<MIROperationNode> getOperationNodeIterator() {
        if (this.operationNodes != null) {
            return this.operationNodes.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeOperationNode(MIROperationNode mIROperationNode) {
        if (mIROperationNode != null && this.operationNodes != null && this.operationNodes.remove(mIROperationNode)) {
            mIROperationNode.hasOperation = null;
            if (this.operationNodes.isEmpty()) {
                this.operationNodes = null;
            }
            return true;
        }
        return false;
    }

    public final void removeOperationNodes() {
        if (this.operationNodes != null) {
            for (MIROperationNode mIROperationNode : this.operationNodes) {
                mIROperationNode.hasOperation = null;
            }
            this.operationNodes = null;
        }
    }

    public final void addReturnType(MIRType mIRType) {
        if (mIRType == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Operation", "ReturnType"));
        }
        if (mIRType._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Operation", "ReturnType"));
        }
        if (this.hasReturnType != null) {
            if (this.hasReturnType._equals(mIRType)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Operation", "ReturnType"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Operation", "ReturnType"));
        }
        this.hasReturnType = mIRType;
        mIRType.getOperationCollection().add(this);
    }

    public final MIRType getReturnType() {
        return this.hasReturnType;
    }

    public final boolean removeReturnType() {
        if (this.hasReturnType != null) {
            this.hasReturnType.operations.remove(this);
            if (this.hasReturnType.operations.isEmpty()) {
                this.hasReturnType.operations = null;
            }
            this.hasReturnType = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRNamespaceElement.staticGetMetaClass(), 23, "Operation", false);
            new MIRMetaAttribute(metaClass, 117, "Position", "java.lang.Short", null, new Short(0));
            new MIRMetaAttribute(metaClass, 114, "CppScope", "java.lang.Byte", MIRVisibilityType.class, new Byte(0));
            new MIRMetaAttribute(metaClass, 112, "CppConcurrency", "java.lang.Byte", MIRConcurrencyType.class, new Byte(0));
            new MIRMetaAttribute(metaClass, 111, "CppAbstract", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaAttribute(metaClass, 113, "CppFriend", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaAttribute(metaClass, 115, "CppStatic", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaAttribute(metaClass, 116, "CppVirtual", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaAttribute(metaClass, 120, "Semantics", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 119, "Precondition", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 118, "Postcondition", "java.lang.String", null, "");
            new MIRMetaLink(metaClass, 192, "Argument", false, 3, 24, 3);
            new MIRMetaLink(metaClass, 194, "AssociatedClass", true, 2, 13, 38);
            new MIRMetaLink(metaClass, 195, "AssociatedSQLViewEntity", true, 2, 25, 230);
            new MIRMetaLink(metaClass, 1109, "ClassifierMap", false, 3, 76, 1103);
            new MIRMetaLink(metaClass, 304, "OperationNode", false, 0, 114, 305);
            new MIRMetaLink(metaClass, 193, "ReturnType", true, 0, 3, 249);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIROperation.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasAssociatedClass != null) {
            this.hasAssociatedClass.operations.rename(this, string);
        }
        if (this.hasAssociatedSQLViewEntity != null) {
            this.hasAssociatedSQLViewEntity.operations.rename(this, string);
        }
        if (this.hasReturnType != null) {
            this.hasReturnType.operations.rename(this, string);
        }
        super._rename(string);
    }
}

