/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRIndexMember;
import MITI.sdk.MIRKey;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class MIRIndex
extends MIRNamespaceElement {
    protected transient boolean aClustered = false;
    protected transient boolean aGenerate = true;
    protected transient boolean aUnique = false;
    protected transient MIRClass hasAssociatedClass = null;
    protected transient MIRObjectCollection<MIRIndexMember> indexMembers = null;
    protected transient MIRKey hasKey = null;
    private static MIRMetaClass metaClass = MIRIndex.staticGetMetaClass();

    public MIRIndex() {
    }

    public MIRIndex(MIRIndex mIRIndex) {
        this.setFrom(mIRIndex);
    }

    @Override
    public Object clone() {
        return new MIRIndex(this);
    }

    @Override
    public short getElementType() {
        return 51;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)51)) {
            this.setClustered(((MIRIndex)mIR_Object).getClustered());
            this.setGenerate(((MIRIndex)mIR_Object).getGenerate());
            this.setUnique(((MIRIndex)mIR_Object).getUnique());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasAssociatedClass != null) {
            return this.hasAssociatedClass;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasAssociatedClass != null ? 1 : 0) + super.getParentCount();
    }

    public final void setClustered(boolean bl) {
        this.aClustered = bl;
    }

    public final boolean getClustered() {
        return this.aClustered;
    }

    public final void setGenerate(boolean bl) {
        this.aGenerate = bl;
    }

    public final boolean getGenerate() {
        return this.aGenerate;
    }

    public final void setUnique(boolean bl) {
        this.aUnique = bl;
    }

    public final boolean getUnique() {
        return this.aUnique;
    }

    public final void addAssociatedClass(MIRClass mIRClass) {
        if (mIRClass == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Index", "AssociatedClass"));
        }
        if (mIRClass._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Index", "AssociatedClass"));
        }
        if (this.hasAssociatedClass != null) {
            if (this.hasAssociatedClass._equals(mIRClass)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Index", "AssociatedClass"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Index", "AssociatedClass"));
        }
        this.hasAssociatedClass = mIRClass;
        mIRClass.getIndexCollection().add(this);
    }

    public final MIRClass getAssociatedClass() {
        return this.hasAssociatedClass;
    }

    public final boolean removeAssociatedClass() {
        if (this.hasAssociatedClass != null) {
            this.hasAssociatedClass.indexes.remove(this);
            if (this.hasAssociatedClass.indexes.isEmpty()) {
                this.hasAssociatedClass.indexes = null;
            }
            this.hasAssociatedClass = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRIndexMember> getIndexMemberCollection() {
        this.indexMembers = MIRObjectCollections.get(this.indexMembers, MIRSdkCollection.Type.OBJECT);
        return this.indexMembers;
    }

    public SortedSet<MIRIndexMember> getIndexMembers() {
        return MIRObjectCollections.sortedSet(this.indexMembers);
    }

    public final void addIndexMember(MIRIndexMember mIRIndexMember) {
        if (mIRIndexMember == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Index", "IndexMember"));
        }
        if (mIRIndexMember._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Index", "IndexMember"));
        }
        if (mIRIndexMember.hasIndex != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("IndexMember", "Index"));
        }
        if (this.indexMembers != null && this.indexMembers.contains(mIRIndexMember)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Index", "IndexMember"));
        }
        this.getIndexMemberCollection().add(mIRIndexMember);
        mIRIndexMember.hasIndex = this;
    }

    public final int getIndexMemberCount() {
        if (this.indexMembers != null) {
            return this.indexMembers.size();
        }
        return 0;
    }

    public final boolean containsIndexMember(MIRIndexMember mIRIndexMember) {
        if (mIRIndexMember != null && this.indexMembers != null) {
            return this.indexMembers.contains(mIRIndexMember);
        }
        return false;
    }

    public final MIRIndexMember getIndexMember(String string) {
        if (this.indexMembers != null) {
            return this.indexMembers.get(string);
        }
        return null;
    }

    public final Iterator<MIRIndexMember> getIndexMemberIterator() {
        if (this.indexMembers != null) {
            return this.indexMembers.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final List<MIRIndexMember> getIndexMemberByPosition() {
        if (this.indexMembers != null) {
            ArrayList<MIRIndexMember> arrayList = new ArrayList<MIRIndexMember>();
            arrayList.addAll(this.indexMembers.values());
            MIRObjectCollections.sort(arrayList, MIRIndexMember.ByPosition);
            return arrayList;
        }
        return MIRObjectCollections.emptyList();
    }

    public final boolean removeIndexMember(MIRIndexMember mIRIndexMember) {
        if (mIRIndexMember != null && this.indexMembers != null && this.indexMembers.remove(mIRIndexMember)) {
            mIRIndexMember.hasIndex = null;
            if (this.indexMembers.isEmpty()) {
                this.indexMembers = null;
            }
            return true;
        }
        return false;
    }

    public final void removeIndexMembers() {
        if (this.indexMembers != null) {
            for (MIRIndexMember mIRIndexMember : this.indexMembers) {
                mIRIndexMember.hasIndex = null;
            }
            this.indexMembers = null;
        }
    }

    public final void addKey(MIRKey mIRKey) {
        if (mIRKey == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Index", "Key"));
        }
        if (mIRKey._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Index", "Key"));
        }
        if (this.hasKey != null) {
            if (this.hasKey._equals(mIRKey)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Index", "Key"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Index", "Key"));
        }
        if (mIRKey.hasIndex != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Key", "Index"));
        }
        this.hasKey = mIRKey;
        mIRKey.hasIndex = this;
    }

    public final MIRKey getKey() {
        return this.hasKey;
    }

    public final boolean removeKey() {
        if (this.hasKey != null) {
            this.hasKey.hasIndex = null;
            this.hasKey = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRNamespaceElement.staticGetMetaClass(), 51, "Index", false);
            new MIRMetaAttribute(metaClass, 79, "Clustered", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaAttribute(metaClass, 80, "Generate", "java.lang.Boolean", null, new Boolean(true));
            new MIRMetaAttribute(metaClass, 81, "Unique", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaLink(metaClass, 143, "AssociatedClass", true, 2, 13, 48);
            new MIRMetaLink(metaClass, 144, "IndexMember", false, 3, 52, 147);
            new MIRMetaLink(metaClass, 145, "Key", true, 0, 20, 153);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRIndex.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasAssociatedClass != null) {
            this.hasAssociatedClass.indexes.rename(this, string);
        }
        super._rename(string);
    }
}

