/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRAttribute;
import MITI.sdk.MIRGeneralizationRole;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRRelationship;
import MITI.sdk.MIRVisibilityType;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRGeneralization
extends MIRRelationship {
    protected transient boolean aComplete = false;
    protected transient boolean aCppFriend = false;
    protected transient byte aCppScope = 0;
    protected transient boolean aCppVirtual = false;
    protected transient boolean aExclusive = false;
    protected transient MIRObjectCollection<MIRAttribute> discriminatorAttributes = null;
    protected transient MIRObjectCollection<MIRGeneralizationRole> subtypeGeneralizationRoles = null;
    protected transient MIRObjectCollection<MIRGeneralizationRole> supertypeGeneralizationRoles = null;
    private static MIRMetaClass metaClass = MIRGeneralization.staticGetMetaClass();

    public MIRGeneralization() {
    }

    public MIRGeneralization(MIRGeneralization mIRGeneralization) {
        this.setFrom(mIRGeneralization);
    }

    @Override
    public Object clone() {
        return new MIRGeneralization(this);
    }

    @Override
    public short getElementType() {
        return 16;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)16)) {
            this.setComplete(((MIRGeneralization)mIR_Object).getComplete());
            this.setCppFriend(((MIRGeneralization)mIR_Object).getCppFriend());
            this.setCppScope(((MIRGeneralization)mIR_Object).getCppScope());
            this.setCppVirtual(((MIRGeneralization)mIR_Object).getCppVirtual());
            this.setExclusive(((MIRGeneralization)mIR_Object).getExclusive());
        }
    }

    public final void setComplete(boolean bl) {
        this.aComplete = bl;
    }

    public final boolean getComplete() {
        return this.aComplete;
    }

    public final void setCppFriend(boolean bl) {
        this.aCppFriend = bl;
    }

    public final boolean getCppFriend() {
        return this.aCppFriend;
    }

    public final void setCppScope(byte by) {
        this.aCppScope = by;
    }

    public final byte getCppScope() {
        return this.aCppScope;
    }

    public final void setCppVirtual(boolean bl) {
        this.aCppVirtual = bl;
    }

    public final boolean getCppVirtual() {
        return this.aCppVirtual;
    }

    public final void setExclusive(boolean bl) {
        this.aExclusive = bl;
    }

    public final boolean getExclusive() {
        return this.aExclusive;
    }

    protected MIRObjectCollection<MIRAttribute> getDiscriminatorAttributeCollection() {
        this.discriminatorAttributes = MIRObjectCollections.get(this.discriminatorAttributes, MIRSdkCollection.Type.OBJECT);
        return this.discriminatorAttributes;
    }

    public SortedSet<MIRAttribute> getDiscriminatorAttributes() {
        return MIRObjectCollections.sortedSet(this.discriminatorAttributes);
    }

    public final void addDiscriminatorAttribute(MIRAttribute mIRAttribute) {
        if (mIRAttribute == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Generalization", "DiscriminatorAttribute"));
        }
        if (mIRAttribute._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Generalization", "DiscriminatorAttribute"));
        }
        if (this.discriminatorAttributes != null && this.discriminatorAttributes.contains(mIRAttribute)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Generalization", "DiscriminatorAttribute"));
        }
        this.getDiscriminatorAttributeCollection().add(mIRAttribute);
        mIRAttribute.getDiscriminatorOfGeneralizationCollection().add(this);
    }

    public final int getDiscriminatorAttributeCount() {
        if (this.discriminatorAttributes != null) {
            return this.discriminatorAttributes.size();
        }
        return 0;
    }

    public final boolean containsDiscriminatorAttribute(MIRAttribute mIRAttribute) {
        if (mIRAttribute != null && this.discriminatorAttributes != null) {
            return this.discriminatorAttributes.contains(mIRAttribute);
        }
        return false;
    }

    public final MIRAttribute getDiscriminatorAttribute(String string) {
        if (this.discriminatorAttributes != null) {
            return this.discriminatorAttributes.get(string);
        }
        return null;
    }

    public final Iterator<MIRAttribute> getDiscriminatorAttributeIterator() {
        if (this.discriminatorAttributes != null) {
            return this.discriminatorAttributes.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeDiscriminatorAttribute(MIRAttribute mIRAttribute) {
        if (mIRAttribute != null && this.discriminatorAttributes != null && this.discriminatorAttributes.remove(mIRAttribute)) {
            mIRAttribute.discriminatorOfGeneralizations.remove(this);
            if (mIRAttribute.discriminatorOfGeneralizations.isEmpty()) {
                mIRAttribute.discriminatorOfGeneralizations = null;
            }
            if (this.discriminatorAttributes.isEmpty()) {
                this.discriminatorAttributes = null;
            }
            return true;
        }
        return false;
    }

    public final void removeDiscriminatorAttributes() {
        if (this.discriminatorAttributes != null) {
            for (MIRAttribute mIRAttribute : this.discriminatorAttributes) {
                mIRAttribute.discriminatorOfGeneralizations.remove(this);
                if (!mIRAttribute.discriminatorOfGeneralizations.isEmpty()) continue;
                mIRAttribute.discriminatorOfGeneralizations = null;
            }
            this.discriminatorAttributes = null;
        }
    }

    protected MIRObjectCollection<MIRGeneralizationRole> getSubtypeGeneralizationRoleCollection() {
        this.subtypeGeneralizationRoles = MIRObjectCollections.get(this.subtypeGeneralizationRoles, MIRSdkCollection.Type.OBJECT);
        return this.subtypeGeneralizationRoles;
    }

    public SortedSet<MIRGeneralizationRole> getSubtypeGeneralizationRoles() {
        return MIRObjectCollections.sortedSet(this.subtypeGeneralizationRoles);
    }

    public final void addSubtypeGeneralizationRole(MIRGeneralizationRole mIRGeneralizationRole) {
        if (mIRGeneralizationRole == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Generalization", "SubtypeGeneralizationRole"));
        }
        if (mIRGeneralizationRole._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Generalization", "SubtypeGeneralizationRole"));
        }
        if (mIRGeneralizationRole.hasSubtypeOfGeneralization != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("GeneralizationRole", "SubtypeOfGeneralization"));
        }
        if (this.subtypeGeneralizationRoles != null && this.subtypeGeneralizationRoles.contains(mIRGeneralizationRole)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Generalization", "SubtypeGeneralizationRole"));
        }
        this.getSubtypeGeneralizationRoleCollection().add(mIRGeneralizationRole);
        mIRGeneralizationRole.hasSubtypeOfGeneralization = this;
    }

    public final int getSubtypeGeneralizationRoleCount() {
        if (this.subtypeGeneralizationRoles != null) {
            return this.subtypeGeneralizationRoles.size();
        }
        return 0;
    }

    public final boolean containsSubtypeGeneralizationRole(MIRGeneralizationRole mIRGeneralizationRole) {
        if (mIRGeneralizationRole != null && this.subtypeGeneralizationRoles != null) {
            return this.subtypeGeneralizationRoles.contains(mIRGeneralizationRole);
        }
        return false;
    }

    public final MIRGeneralizationRole getSubtypeGeneralizationRole(String string) {
        if (this.subtypeGeneralizationRoles != null) {
            return this.subtypeGeneralizationRoles.get(string);
        }
        return null;
    }

    public final Iterator<MIRGeneralizationRole> getSubtypeGeneralizationRoleIterator() {
        if (this.subtypeGeneralizationRoles != null) {
            return this.subtypeGeneralizationRoles.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSubtypeGeneralizationRole(MIRGeneralizationRole mIRGeneralizationRole) {
        if (mIRGeneralizationRole != null && this.subtypeGeneralizationRoles != null && this.subtypeGeneralizationRoles.remove(mIRGeneralizationRole)) {
            mIRGeneralizationRole.hasSubtypeOfGeneralization = null;
            if (this.subtypeGeneralizationRoles.isEmpty()) {
                this.subtypeGeneralizationRoles = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSubtypeGeneralizationRoles() {
        if (this.subtypeGeneralizationRoles != null) {
            for (MIRGeneralizationRole mIRGeneralizationRole : this.subtypeGeneralizationRoles) {
                mIRGeneralizationRole.hasSubtypeOfGeneralization = null;
            }
            this.subtypeGeneralizationRoles = null;
        }
    }

    protected MIRObjectCollection<MIRGeneralizationRole> getSupertypeGeneralizationRoleCollection() {
        this.supertypeGeneralizationRoles = MIRObjectCollections.get(this.supertypeGeneralizationRoles, MIRSdkCollection.Type.OBJECT);
        return this.supertypeGeneralizationRoles;
    }

    public SortedSet<MIRGeneralizationRole> getSupertypeGeneralizationRoles() {
        return MIRObjectCollections.sortedSet(this.supertypeGeneralizationRoles);
    }

    public final void addSupertypeGeneralizationRole(MIRGeneralizationRole mIRGeneralizationRole) {
        if (mIRGeneralizationRole == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Generalization", "SupertypeGeneralizationRole"));
        }
        if (mIRGeneralizationRole._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Generalization", "SupertypeGeneralizationRole"));
        }
        if (mIRGeneralizationRole.hasSupertypeOfGeneralization != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("GeneralizationRole", "SupertypeOfGeneralization"));
        }
        if (this.supertypeGeneralizationRoles != null && this.supertypeGeneralizationRoles.contains(mIRGeneralizationRole)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Generalization", "SupertypeGeneralizationRole"));
        }
        this.getSupertypeGeneralizationRoleCollection().add(mIRGeneralizationRole);
        mIRGeneralizationRole.hasSupertypeOfGeneralization = this;
    }

    public final int getSupertypeGeneralizationRoleCount() {
        if (this.supertypeGeneralizationRoles != null) {
            return this.supertypeGeneralizationRoles.size();
        }
        return 0;
    }

    public final boolean containsSupertypeGeneralizationRole(MIRGeneralizationRole mIRGeneralizationRole) {
        if (mIRGeneralizationRole != null && this.supertypeGeneralizationRoles != null) {
            return this.supertypeGeneralizationRoles.contains(mIRGeneralizationRole);
        }
        return false;
    }

    public final MIRGeneralizationRole getSupertypeGeneralizationRole(String string) {
        if (this.supertypeGeneralizationRoles != null) {
            return this.supertypeGeneralizationRoles.get(string);
        }
        return null;
    }

    public final Iterator<MIRGeneralizationRole> getSupertypeGeneralizationRoleIterator() {
        if (this.supertypeGeneralizationRoles != null) {
            return this.supertypeGeneralizationRoles.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSupertypeGeneralizationRole(MIRGeneralizationRole mIRGeneralizationRole) {
        if (mIRGeneralizationRole != null && this.supertypeGeneralizationRoles != null && this.supertypeGeneralizationRoles.remove(mIRGeneralizationRole)) {
            mIRGeneralizationRole.hasSupertypeOfGeneralization = null;
            if (this.supertypeGeneralizationRoles.isEmpty()) {
                this.supertypeGeneralizationRoles = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSupertypeGeneralizationRoles() {
        if (this.supertypeGeneralizationRoles != null) {
            for (MIRGeneralizationRole mIRGeneralizationRole : this.supertypeGeneralizationRoles) {
                mIRGeneralizationRole.hasSupertypeOfGeneralization = null;
            }
            this.supertypeGeneralizationRoles = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRRelationship.staticGetMetaClass(), 16, "Generalization", false);
            new MIRMetaAttribute(metaClass, 73, "CppScope", "java.lang.Byte", MIRVisibilityType.class, new Byte(0));
            new MIRMetaAttribute(metaClass, 74, "CppVirtual", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaAttribute(metaClass, 72, "CppFriend", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaAttribute(metaClass, 209, "Exclusive", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaAttribute(metaClass, 208, "Complete", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaLink(metaClass, 131, "DiscriminatorAttribute", false, 0, 14, 23);
            new MIRMetaLink(metaClass, 386, "SubtypeGeneralizationRole", false, 3, 155, 388);
            new MIRMetaLink(metaClass, 385, "SupertypeGeneralizationRole", false, 3, 155, 387);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRGeneralization.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.discriminatorAttributes != null) {
            for (MIRAttribute mIRAttribute : this.discriminatorAttributes) {
                mIRAttribute.discriminatorOfGeneralizations.rename(this, string);
            }
        }
        super._rename(string);
    }
}

