/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRRepositoryObject;
import MITI.sdk.MIRVersion;
import MITI.sdk.MIR_Object;

public class MIRFileAttachment
extends MIRRepositoryObject {
    protected transient String aLocation = "";
    protected transient int aSize = 0;
    protected transient MIRContent hasContent = null;
    protected transient MIRVersion hasVersion = null;
    private static MIRMetaClass metaClass = MIRFileAttachment.staticGetMetaClass();

    public MIRFileAttachment() {
    }

    public MIRFileAttachment(MIRFileAttachment mIRFileAttachment) {
        this.setFrom(mIRFileAttachment);
    }

    @Override
    public Object clone() {
        return new MIRFileAttachment(this);
    }

    @Override
    public short getElementType() {
        return 160;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)160)) {
            this.setLocation(((MIRFileAttachment)mIR_Object).getLocation());
            this.setSize(((MIRFileAttachment)mIR_Object).getSize());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasContent != null) {
            return this.hasContent;
        }
        if (this.hasVersion != null) {
            return this.hasVersion;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasContent != null ? 1 : 0) + (this.hasVersion != null ? 1 : 0) + super.getParentCount();
    }

    public final void setLocation(String string) {
        this.aLocation = string == null ? "" : string;
    }

    public final String getLocation() {
        return this.aLocation;
    }

    public final void setSize(int n) {
        this.aSize = n;
    }

    public final int getSize() {
        return this.aSize;
    }

    public final void addContent(MIRContent mIRContent) {
        if (mIRContent == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("FileAttachment", "Content"));
        }
        if (mIRContent._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("FileAttachment", "Content"));
        }
        if (this.hasContent != null) {
            if (this.hasContent._equals(mIRContent)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("FileAttachment", "Content"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("FileAttachment", "Content"));
        }
        if (mIRContent.fileAttachments != null && !mIRContent._allowName(mIRContent.fileAttachments, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Content", mIRContent.getPath(), "FileAttachment", "Object", this.getName()));
        }
        this.hasContent = mIRContent;
        mIRContent.getFileAttachmentCollection().add(this);
    }

    public final MIRContent getContent() {
        return this.hasContent;
    }

    public final boolean removeContent() {
        if (this.hasContent != null) {
            this.hasContent.fileAttachments.remove(this);
            if (this.hasContent.fileAttachments.isEmpty()) {
                this.hasContent.fileAttachments = null;
            }
            this.hasContent = null;
            return true;
        }
        return false;
    }

    public final void addVersion(MIRVersion mIRVersion) {
        if (mIRVersion == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("FileAttachment", "Version"));
        }
        if (mIRVersion._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("FileAttachment", "Version"));
        }
        if (this.hasVersion != null) {
            if (this.hasVersion._equals(mIRVersion)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("FileAttachment", "Version"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("FileAttachment", "Version"));
        }
        if (mIRVersion.fileAttachments != null && !mIRVersion._allowName(mIRVersion.fileAttachments, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Version", mIRVersion.getPath(), "FileAttachment", "Object", this.getName()));
        }
        this.hasVersion = mIRVersion;
        mIRVersion.getFileAttachmentCollection().add(this);
    }

    public final MIRVersion getVersion() {
        return this.hasVersion;
    }

    public final boolean removeVersion() {
        if (this.hasVersion != null) {
            this.hasVersion.fileAttachments.remove(this);
            if (this.hasVersion.fileAttachments.isEmpty()) {
                this.hasVersion.fileAttachments = null;
            }
            this.hasVersion = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRRepositoryObject.staticGetMetaClass(), 160, "FileAttachment", false);
            new MIRMetaAttribute(metaClass, 256, "Location", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 522, "Size", "java.lang.Integer", null, new Integer(0));
            new MIRMetaLink(metaClass, 1015, "Content", true, 2, 159, 1014);
            new MIRMetaLink(metaClass, 399, "Version", true, 2, 31, 400);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRFileAttachment.staticGetMetaClass();
    }

    @Override
    protected boolean _isValidName() {
        if (this.hasContent != null && !this.hasContent._allowName(this.hasContent.fileAttachments, this)) {
            return false;
        }
        if (this.hasVersion != null && !this.hasVersion._allowName(this.hasVersion.fileAttachments, this)) {
            return false;
        }
        return super._isValidName();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasContent != null) {
            this.hasContent.fileAttachments.rename(this, string);
        }
        if (this.hasVersion != null) {
            this.hasVersion.fileAttachments.rename(this, string);
        }
        super._rename(string);
    }
}

