/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRConnectionElement;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRJoinCondition;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRReportField;
import MITI.sdk.MIRSQLViewAttribute;
import MITI.sdk.MIRSummaryMap;
import MITI.sdk.MIRType;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class MIRFeature
extends MIRModelObject {
    protected transient int aLineageOptions = 0;
    protected transient short aPosition = 0;
    protected transient MIRClassifier hasClassifier = null;
    protected transient MIRObjectCollection<MIRFeatureMap> controlOfFeatureMaps = null;
    protected transient MIRObjectCollection<MIRSummaryMap> controlOfSummaryMaps = null;
    protected transient MIRObjectCollection<MIRSummaryMap> dataControlOfSummaryMaps = null;
    protected transient MIRObjectCollection<MIRFeatureMap> destinationOfFeatureMaps = null;
    protected transient MIRObjectCollection<MIRSummaryMap> destinationOfSummaryMaps = null;
    protected transient MIRConnectionElement hasDomainConnectionElement = null;
    protected transient MIRObjectCollection<MIRJoinCondition> leftOfJoinConditions = null;
    protected transient MIRObjectCollection<MIRSummaryMap> maskedOfSummaryMaps = null;
    protected transient MIRObjectCollection<MIRReportField> reportFields = null;
    protected transient MIRObjectCollection<MIRJoinCondition> rightOfJoinConditions = null;
    protected transient MIRObjectCollection<MIRFeatureMap> sourceOfFeatureMaps = null;
    protected transient MIRObjectCollection<MIRSQLViewAttribute> sourceOfSQLViewAttributes = null;
    protected transient MIRObjectCollection<MIRSummaryMap> sourceOfSummaryMaps = null;
    protected transient MIRType hasType = null;
    private static MIRMetaClass metaClass = MIRFeature.staticGetMetaClass();
    protected static final Comparator<MIRFeature> ByPosition = new Comparator<MIRFeature>(){

        @Override
        public int compare(MIRFeature mIRFeature, MIRFeature mIRFeature2) {
            return mIRFeature.getPosition() - mIRFeature2.getPosition();
        }
    };

    @Override
    public short getElementType() {
        return 77;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)77)) {
            this.setLineageOptions(((MIRFeature)mIR_Object).getLineageOptions());
            this.setPosition(((MIRFeature)mIR_Object).getPosition());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasClassifier != null) {
            return this.hasClassifier;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasClassifier != null ? 1 : 0) + super.getParentCount();
    }

    public final void setLineageOptions(int n) {
        this.aLineageOptions = n;
    }

    public final int getLineageOptions() {
        return this.aLineageOptions;
    }

    public final void setPosition(short s) {
        this.aPosition = s;
    }

    public final short getPosition() {
        return this.aPosition;
    }

    public final void addClassifier(MIRClassifier mIRClassifier) {
        if (mIRClassifier == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Feature", "Classifier"));
        }
        if (mIRClassifier._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Feature", "Classifier"));
        }
        if (this.hasClassifier != null) {
            if (this.hasClassifier._equals(mIRClassifier)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Feature", "Classifier"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Feature", "Classifier"));
        }
        if (mIRClassifier.features != null && !mIRClassifier._allowName(mIRClassifier.features, this)) {
            throw new IllegalArgumentException(MIRSDK.NAME_COLLISION.getMessage("Classifier", mIRClassifier.getPath(), "Feature", "Object", this.getName()));
        }
        this.hasClassifier = mIRClassifier;
        mIRClassifier.getFeatureCollection().add(this);
    }

    public final MIRClassifier getClassifier() {
        return this.hasClassifier;
    }

    public final boolean removeClassifier() {
        if (this.hasClassifier != null) {
            this.hasClassifier.features.remove(this);
            if (this.hasClassifier.features.isEmpty()) {
                this.hasClassifier.features = null;
            }
            this.hasClassifier = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRFeatureMap> getControlOfFeatureMapCollection() {
        this.controlOfFeatureMaps = MIRObjectCollections.get(this.controlOfFeatureMaps, MIRSdkCollection.Type.OBJECT);
        return this.controlOfFeatureMaps;
    }

    public SortedSet<MIRFeatureMap> getControlOfFeatureMaps() {
        return MIRObjectCollections.sortedSet(this.controlOfFeatureMaps);
    }

    public final void addControlOfFeatureMap(MIRFeatureMap mIRFeatureMap) {
        if (mIRFeatureMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Feature", "ControlOfFeatureMap"));
        }
        if (mIRFeatureMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Feature", "ControlOfFeatureMap"));
        }
        if (this.controlOfFeatureMaps != null && this.controlOfFeatureMaps.contains(mIRFeatureMap)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Feature", "ControlOfFeatureMap"));
        }
        this.getControlOfFeatureMapCollection().add(mIRFeatureMap);
        mIRFeatureMap.getControlFeatureCollection().add(this);
    }

    public final int getControlOfFeatureMapCount() {
        if (this.controlOfFeatureMaps != null) {
            return this.controlOfFeatureMaps.size();
        }
        return 0;
    }

    public final boolean containsControlOfFeatureMap(MIRFeatureMap mIRFeatureMap) {
        if (mIRFeatureMap != null && this.controlOfFeatureMaps != null) {
            return this.controlOfFeatureMaps.contains(mIRFeatureMap);
        }
        return false;
    }

    public final MIRFeatureMap getControlOfFeatureMap(String string) {
        if (this.controlOfFeatureMaps != null) {
            return this.controlOfFeatureMaps.get(string);
        }
        return null;
    }

    public final Iterator<MIRFeatureMap> getControlOfFeatureMapIterator() {
        if (this.controlOfFeatureMaps != null) {
            return this.controlOfFeatureMaps.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeControlOfFeatureMap(MIRFeatureMap mIRFeatureMap) {
        if (mIRFeatureMap != null && this.controlOfFeatureMaps != null && this.controlOfFeatureMaps.remove(mIRFeatureMap)) {
            mIRFeatureMap.controlFeatures.remove(this);
            if (mIRFeatureMap.controlFeatures.isEmpty()) {
                mIRFeatureMap.controlFeatures = null;
            }
            if (this.controlOfFeatureMaps.isEmpty()) {
                this.controlOfFeatureMaps = null;
            }
            return true;
        }
        return false;
    }

    public final void removeControlOfFeatureMaps() {
        if (this.controlOfFeatureMaps != null) {
            for (MIRFeatureMap mIRFeatureMap : this.controlOfFeatureMaps) {
                mIRFeatureMap.controlFeatures.remove(this);
                if (!mIRFeatureMap.controlFeatures.isEmpty()) continue;
                mIRFeatureMap.controlFeatures = null;
            }
            this.controlOfFeatureMaps = null;
        }
    }

    protected MIRObjectCollection<MIRSummaryMap> getControlOfSummaryMapCollection() {
        this.controlOfSummaryMaps = MIRObjectCollections.get(this.controlOfSummaryMaps, MIRSdkCollection.Type.OBJECT);
        return this.controlOfSummaryMaps;
    }

    public SortedSet<MIRSummaryMap> getControlOfSummaryMaps() {
        return MIRObjectCollections.sortedSet(this.controlOfSummaryMaps);
    }

    public final void addControlOfSummaryMap(MIRSummaryMap mIRSummaryMap) {
        if (mIRSummaryMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Feature", "ControlOfSummaryMap"));
        }
        if (mIRSummaryMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Feature", "ControlOfSummaryMap"));
        }
        if (this.controlOfSummaryMaps != null && this.controlOfSummaryMaps.contains(mIRSummaryMap)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Feature", "ControlOfSummaryMap"));
        }
        this.getControlOfSummaryMapCollection().add(mIRSummaryMap);
        mIRSummaryMap.getControlFeatureCollection().add(this);
    }

    public final int getControlOfSummaryMapCount() {
        if (this.controlOfSummaryMaps != null) {
            return this.controlOfSummaryMaps.size();
        }
        return 0;
    }

    public final boolean containsControlOfSummaryMap(MIRSummaryMap mIRSummaryMap) {
        if (mIRSummaryMap != null && this.controlOfSummaryMaps != null) {
            return this.controlOfSummaryMaps.contains(mIRSummaryMap);
        }
        return false;
    }

    public final MIRSummaryMap getControlOfSummaryMap(String string) {
        if (this.controlOfSummaryMaps != null) {
            return this.controlOfSummaryMaps.get(string);
        }
        return null;
    }

    public final Iterator<MIRSummaryMap> getControlOfSummaryMapIterator() {
        if (this.controlOfSummaryMaps != null) {
            return this.controlOfSummaryMaps.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeControlOfSummaryMap(MIRSummaryMap mIRSummaryMap) {
        if (mIRSummaryMap != null && this.controlOfSummaryMaps != null && this.controlOfSummaryMaps.remove(mIRSummaryMap)) {
            mIRSummaryMap.controlFeatures.remove(this);
            if (mIRSummaryMap.controlFeatures.isEmpty()) {
                mIRSummaryMap.controlFeatures = null;
            }
            if (this.controlOfSummaryMaps.isEmpty()) {
                this.controlOfSummaryMaps = null;
            }
            return true;
        }
        return false;
    }

    public final void removeControlOfSummaryMaps() {
        if (this.controlOfSummaryMaps != null) {
            for (MIRSummaryMap mIRSummaryMap : this.controlOfSummaryMaps) {
                mIRSummaryMap.controlFeatures.remove(this);
                if (!mIRSummaryMap.controlFeatures.isEmpty()) continue;
                mIRSummaryMap.controlFeatures = null;
            }
            this.controlOfSummaryMaps = null;
        }
    }

    protected MIRObjectCollection<MIRSummaryMap> getDataControlOfSummaryMapCollection() {
        this.dataControlOfSummaryMaps = MIRObjectCollections.get(this.dataControlOfSummaryMaps, MIRSdkCollection.Type.OBJECT);
        return this.dataControlOfSummaryMaps;
    }

    public SortedSet<MIRSummaryMap> getDataControlOfSummaryMaps() {
        return MIRObjectCollections.sortedSet(this.dataControlOfSummaryMaps);
    }

    public final void addDataControlOfSummaryMap(MIRSummaryMap mIRSummaryMap) {
        if (mIRSummaryMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Feature", "DataControlOfSummaryMap"));
        }
        if (mIRSummaryMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Feature", "DataControlOfSummaryMap"));
        }
        if (this.dataControlOfSummaryMaps != null && this.dataControlOfSummaryMaps.contains(mIRSummaryMap)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Feature", "DataControlOfSummaryMap"));
        }
        this.getDataControlOfSummaryMapCollection().add(mIRSummaryMap);
        mIRSummaryMap.getDataControlFeatureCollection().add(this);
    }

    public final int getDataControlOfSummaryMapCount() {
        if (this.dataControlOfSummaryMaps != null) {
            return this.dataControlOfSummaryMaps.size();
        }
        return 0;
    }

    public final boolean containsDataControlOfSummaryMap(MIRSummaryMap mIRSummaryMap) {
        if (mIRSummaryMap != null && this.dataControlOfSummaryMaps != null) {
            return this.dataControlOfSummaryMaps.contains(mIRSummaryMap);
        }
        return false;
    }

    public final MIRSummaryMap getDataControlOfSummaryMap(String string) {
        if (this.dataControlOfSummaryMaps != null) {
            return this.dataControlOfSummaryMaps.get(string);
        }
        return null;
    }

    public final Iterator<MIRSummaryMap> getDataControlOfSummaryMapIterator() {
        if (this.dataControlOfSummaryMaps != null) {
            return this.dataControlOfSummaryMaps.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeDataControlOfSummaryMap(MIRSummaryMap mIRSummaryMap) {
        if (mIRSummaryMap != null && this.dataControlOfSummaryMaps != null && this.dataControlOfSummaryMaps.remove(mIRSummaryMap)) {
            mIRSummaryMap.dataControlFeatures.remove(this);
            if (mIRSummaryMap.dataControlFeatures.isEmpty()) {
                mIRSummaryMap.dataControlFeatures = null;
            }
            if (this.dataControlOfSummaryMaps.isEmpty()) {
                this.dataControlOfSummaryMaps = null;
            }
            return true;
        }
        return false;
    }

    public final void removeDataControlOfSummaryMaps() {
        if (this.dataControlOfSummaryMaps != null) {
            for (MIRSummaryMap mIRSummaryMap : this.dataControlOfSummaryMaps) {
                mIRSummaryMap.dataControlFeatures.remove(this);
                if (!mIRSummaryMap.dataControlFeatures.isEmpty()) continue;
                mIRSummaryMap.dataControlFeatures = null;
            }
            this.dataControlOfSummaryMaps = null;
        }
    }

    protected MIRObjectCollection<MIRFeatureMap> getDestinationOfFeatureMapCollection() {
        this.destinationOfFeatureMaps = MIRObjectCollections.get(this.destinationOfFeatureMaps, MIRSdkCollection.Type.OBJECT);
        return this.destinationOfFeatureMaps;
    }

    public SortedSet<MIRFeatureMap> getDestinationOfFeatureMaps() {
        return MIRObjectCollections.sortedSet(this.destinationOfFeatureMaps);
    }

    public final void addDestinationOfFeatureMap(MIRFeatureMap mIRFeatureMap) {
        if (mIRFeatureMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Feature", "DestinationOfFeatureMap"));
        }
        if (mIRFeatureMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Feature", "DestinationOfFeatureMap"));
        }
        if (mIRFeatureMap.hasDestinationFeature != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("FeatureMap", "DestinationFeature"));
        }
        if (this.destinationOfFeatureMaps != null && this.destinationOfFeatureMaps.contains(mIRFeatureMap)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Feature", "DestinationOfFeatureMap"));
        }
        this.getDestinationOfFeatureMapCollection().add(mIRFeatureMap);
        mIRFeatureMap.hasDestinationFeature = this;
    }

    public final int getDestinationOfFeatureMapCount() {
        if (this.destinationOfFeatureMaps != null) {
            return this.destinationOfFeatureMaps.size();
        }
        return 0;
    }

    public final boolean containsDestinationOfFeatureMap(MIRFeatureMap mIRFeatureMap) {
        if (mIRFeatureMap != null && this.destinationOfFeatureMaps != null) {
            return this.destinationOfFeatureMaps.contains(mIRFeatureMap);
        }
        return false;
    }

    public final MIRFeatureMap getDestinationOfFeatureMap(String string) {
        if (this.destinationOfFeatureMaps != null) {
            return this.destinationOfFeatureMaps.get(string);
        }
        return null;
    }

    public final Iterator<MIRFeatureMap> getDestinationOfFeatureMapIterator() {
        if (this.destinationOfFeatureMaps != null) {
            return this.destinationOfFeatureMaps.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeDestinationOfFeatureMap(MIRFeatureMap mIRFeatureMap) {
        if (mIRFeatureMap != null && this.destinationOfFeatureMaps != null && this.destinationOfFeatureMaps.remove(mIRFeatureMap)) {
            mIRFeatureMap.hasDestinationFeature = null;
            if (this.destinationOfFeatureMaps.isEmpty()) {
                this.destinationOfFeatureMaps = null;
            }
            return true;
        }
        return false;
    }

    public final void removeDestinationOfFeatureMaps() {
        if (this.destinationOfFeatureMaps != null) {
            for (MIRFeatureMap mIRFeatureMap : this.destinationOfFeatureMaps) {
                mIRFeatureMap.hasDestinationFeature = null;
            }
            this.destinationOfFeatureMaps = null;
        }
    }

    protected MIRObjectCollection<MIRSummaryMap> getDestinationOfSummaryMapCollection() {
        this.destinationOfSummaryMaps = MIRObjectCollections.get(this.destinationOfSummaryMaps, MIRSdkCollection.Type.OBJECT);
        return this.destinationOfSummaryMaps;
    }

    public SortedSet<MIRSummaryMap> getDestinationOfSummaryMaps() {
        return MIRObjectCollections.sortedSet(this.destinationOfSummaryMaps);
    }

    public final void addDestinationOfSummaryMap(MIRSummaryMap mIRSummaryMap) {
        if (mIRSummaryMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Feature", "DestinationOfSummaryMap"));
        }
        if (mIRSummaryMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Feature", "DestinationOfSummaryMap"));
        }
        if (mIRSummaryMap.hasDestinationFeature != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("SummaryMap", "DestinationFeature"));
        }
        if (this.destinationOfSummaryMaps != null && this.destinationOfSummaryMaps.contains(mIRSummaryMap)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Feature", "DestinationOfSummaryMap"));
        }
        this.getDestinationOfSummaryMapCollection().add(mIRSummaryMap);
        mIRSummaryMap.hasDestinationFeature = this;
    }

    public final int getDestinationOfSummaryMapCount() {
        if (this.destinationOfSummaryMaps != null) {
            return this.destinationOfSummaryMaps.size();
        }
        return 0;
    }

    public final boolean containsDestinationOfSummaryMap(MIRSummaryMap mIRSummaryMap) {
        if (mIRSummaryMap != null && this.destinationOfSummaryMaps != null) {
            return this.destinationOfSummaryMaps.contains(mIRSummaryMap);
        }
        return false;
    }

    public final MIRSummaryMap getDestinationOfSummaryMap(String string) {
        if (this.destinationOfSummaryMaps != null) {
            return this.destinationOfSummaryMaps.get(string);
        }
        return null;
    }

    public final Iterator<MIRSummaryMap> getDestinationOfSummaryMapIterator() {
        if (this.destinationOfSummaryMaps != null) {
            return this.destinationOfSummaryMaps.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeDestinationOfSummaryMap(MIRSummaryMap mIRSummaryMap) {
        if (mIRSummaryMap != null && this.destinationOfSummaryMaps != null && this.destinationOfSummaryMaps.remove(mIRSummaryMap)) {
            mIRSummaryMap.hasDestinationFeature = null;
            if (this.destinationOfSummaryMaps.isEmpty()) {
                this.destinationOfSummaryMaps = null;
            }
            return true;
        }
        return false;
    }

    public final void removeDestinationOfSummaryMaps() {
        if (this.destinationOfSummaryMaps != null) {
            for (MIRSummaryMap mIRSummaryMap : this.destinationOfSummaryMaps) {
                mIRSummaryMap.hasDestinationFeature = null;
            }
            this.destinationOfSummaryMaps = null;
        }
    }

    public final void addDomainConnectionElement(MIRConnectionElement mIRConnectionElement) {
        if (mIRConnectionElement == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Feature", "DomainConnectionElement"));
        }
        if (mIRConnectionElement._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Feature", "DomainConnectionElement"));
        }
        if (this.hasDomainConnectionElement != null) {
            if (this.hasDomainConnectionElement._equals(mIRConnectionElement)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Feature", "DomainConnectionElement"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Feature", "DomainConnectionElement"));
        }
        this.hasDomainConnectionElement = mIRConnectionElement;
        mIRConnectionElement.getDomainOfFeatureCollection().add(this);
    }

    public final MIRConnectionElement getDomainConnectionElement() {
        return this.hasDomainConnectionElement;
    }

    public final boolean removeDomainConnectionElement() {
        if (this.hasDomainConnectionElement != null) {
            this.hasDomainConnectionElement.domainOfFeatures.remove(this);
            if (this.hasDomainConnectionElement.domainOfFeatures.isEmpty()) {
                this.hasDomainConnectionElement.domainOfFeatures = null;
            }
            this.hasDomainConnectionElement = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRJoinCondition> getLeftOfJoinConditionCollection() {
        this.leftOfJoinConditions = MIRObjectCollections.get(this.leftOfJoinConditions, MIRSdkCollection.Type.OBJECT);
        return this.leftOfJoinConditions;
    }

    public SortedSet<MIRJoinCondition> getLeftOfJoinConditions() {
        return MIRObjectCollections.sortedSet(this.leftOfJoinConditions);
    }

    public final void addLeftOfJoinCondition(MIRJoinCondition mIRJoinCondition) {
        if (mIRJoinCondition == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Feature", "LeftOfJoinCondition"));
        }
        if (mIRJoinCondition._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Feature", "LeftOfJoinCondition"));
        }
        if (mIRJoinCondition.hasLeftFeature != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("JoinCondition", "LeftFeature"));
        }
        if (this.leftOfJoinConditions != null && this.leftOfJoinConditions.contains(mIRJoinCondition)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Feature", "LeftOfJoinCondition"));
        }
        this.getLeftOfJoinConditionCollection().add(mIRJoinCondition);
        mIRJoinCondition.hasLeftFeature = this;
    }

    public final int getLeftOfJoinConditionCount() {
        if (this.leftOfJoinConditions != null) {
            return this.leftOfJoinConditions.size();
        }
        return 0;
    }

    public final boolean containsLeftOfJoinCondition(MIRJoinCondition mIRJoinCondition) {
        if (mIRJoinCondition != null && this.leftOfJoinConditions != null) {
            return this.leftOfJoinConditions.contains(mIRJoinCondition);
        }
        return false;
    }

    public final MIRJoinCondition getLeftOfJoinCondition(String string) {
        if (this.leftOfJoinConditions != null) {
            return this.leftOfJoinConditions.get(string);
        }
        return null;
    }

    public final Iterator<MIRJoinCondition> getLeftOfJoinConditionIterator() {
        if (this.leftOfJoinConditions != null) {
            return this.leftOfJoinConditions.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeLeftOfJoinCondition(MIRJoinCondition mIRJoinCondition) {
        if (mIRJoinCondition != null && this.leftOfJoinConditions != null && this.leftOfJoinConditions.remove(mIRJoinCondition)) {
            mIRJoinCondition.hasLeftFeature = null;
            if (this.leftOfJoinConditions.isEmpty()) {
                this.leftOfJoinConditions = null;
            }
            return true;
        }
        return false;
    }

    public final void removeLeftOfJoinConditions() {
        if (this.leftOfJoinConditions != null) {
            for (MIRJoinCondition mIRJoinCondition : this.leftOfJoinConditions) {
                mIRJoinCondition.hasLeftFeature = null;
            }
            this.leftOfJoinConditions = null;
        }
    }

    protected MIRObjectCollection<MIRSummaryMap> getMaskedOfSummaryMapCollection() {
        this.maskedOfSummaryMaps = MIRObjectCollections.get(this.maskedOfSummaryMaps, MIRSdkCollection.Type.OBJECT);
        return this.maskedOfSummaryMaps;
    }

    public SortedSet<MIRSummaryMap> getMaskedOfSummaryMaps() {
        return MIRObjectCollections.sortedSet(this.maskedOfSummaryMaps);
    }

    public final void addMaskedOfSummaryMap(MIRSummaryMap mIRSummaryMap) {
        if (mIRSummaryMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Feature", "MaskedOfSummaryMap"));
        }
        if (mIRSummaryMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Feature", "MaskedOfSummaryMap"));
        }
        if (this.maskedOfSummaryMaps != null && this.maskedOfSummaryMaps.contains(mIRSummaryMap)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Feature", "MaskedOfSummaryMap"));
        }
        this.getMaskedOfSummaryMapCollection().add(mIRSummaryMap);
        mIRSummaryMap.getMaskedFeatureCollection().add(this);
    }

    public final int getMaskedOfSummaryMapCount() {
        if (this.maskedOfSummaryMaps != null) {
            return this.maskedOfSummaryMaps.size();
        }
        return 0;
    }

    public final boolean containsMaskedOfSummaryMap(MIRSummaryMap mIRSummaryMap) {
        if (mIRSummaryMap != null && this.maskedOfSummaryMaps != null) {
            return this.maskedOfSummaryMaps.contains(mIRSummaryMap);
        }
        return false;
    }

    public final MIRSummaryMap getMaskedOfSummaryMap(String string) {
        if (this.maskedOfSummaryMaps != null) {
            return this.maskedOfSummaryMaps.get(string);
        }
        return null;
    }

    public final Iterator<MIRSummaryMap> getMaskedOfSummaryMapIterator() {
        if (this.maskedOfSummaryMaps != null) {
            return this.maskedOfSummaryMaps.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeMaskedOfSummaryMap(MIRSummaryMap mIRSummaryMap) {
        if (mIRSummaryMap != null && this.maskedOfSummaryMaps != null && this.maskedOfSummaryMaps.remove(mIRSummaryMap)) {
            mIRSummaryMap.maskedFeatures.remove(this);
            if (mIRSummaryMap.maskedFeatures.isEmpty()) {
                mIRSummaryMap.maskedFeatures = null;
            }
            if (this.maskedOfSummaryMaps.isEmpty()) {
                this.maskedOfSummaryMaps = null;
            }
            return true;
        }
        return false;
    }

    public final void removeMaskedOfSummaryMaps() {
        if (this.maskedOfSummaryMaps != null) {
            for (MIRSummaryMap mIRSummaryMap : this.maskedOfSummaryMaps) {
                mIRSummaryMap.maskedFeatures.remove(this);
                if (!mIRSummaryMap.maskedFeatures.isEmpty()) continue;
                mIRSummaryMap.maskedFeatures = null;
            }
            this.maskedOfSummaryMaps = null;
        }
    }

    protected MIRObjectCollection<MIRReportField> getReportFieldCollection() {
        this.reportFields = MIRObjectCollections.get(this.reportFields, MIRSdkCollection.Type.OBJECT);
        return this.reportFields;
    }

    public SortedSet<MIRReportField> getReportFields() {
        return MIRObjectCollections.sortedSet(this.reportFields);
    }

    public final void addReportField(MIRReportField mIRReportField) {
        if (mIRReportField == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Feature", "ReportField"));
        }
        if (mIRReportField._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Feature", "ReportField"));
        }
        if (mIRReportField.hasFeature != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ReportField", "Feature"));
        }
        if (this.reportFields != null && this.reportFields.contains(mIRReportField)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Feature", "ReportField"));
        }
        this.getReportFieldCollection().add(mIRReportField);
        mIRReportField.hasFeature = this;
    }

    public final int getReportFieldCount() {
        if (this.reportFields != null) {
            return this.reportFields.size();
        }
        return 0;
    }

    public final boolean containsReportField(MIRReportField mIRReportField) {
        if (mIRReportField != null && this.reportFields != null) {
            return this.reportFields.contains(mIRReportField);
        }
        return false;
    }

    public final MIRReportField getReportField(String string) {
        if (this.reportFields != null) {
            return this.reportFields.get(string);
        }
        return null;
    }

    public final Iterator<MIRReportField> getReportFieldIterator() {
        if (this.reportFields != null) {
            return this.reportFields.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeReportField(MIRReportField mIRReportField) {
        if (mIRReportField != null && this.reportFields != null && this.reportFields.remove(mIRReportField)) {
            mIRReportField.hasFeature = null;
            if (this.reportFields.isEmpty()) {
                this.reportFields = null;
            }
            return true;
        }
        return false;
    }

    public final void removeReportFields() {
        if (this.reportFields != null) {
            for (MIRReportField mIRReportField : this.reportFields) {
                mIRReportField.hasFeature = null;
            }
            this.reportFields = null;
        }
    }

    protected MIRObjectCollection<MIRJoinCondition> getRightOfJoinConditionCollection() {
        this.rightOfJoinConditions = MIRObjectCollections.get(this.rightOfJoinConditions, MIRSdkCollection.Type.OBJECT);
        return this.rightOfJoinConditions;
    }

    public SortedSet<MIRJoinCondition> getRightOfJoinConditions() {
        return MIRObjectCollections.sortedSet(this.rightOfJoinConditions);
    }

    public final void addRightOfJoinCondition(MIRJoinCondition mIRJoinCondition) {
        if (mIRJoinCondition == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Feature", "RightOfJoinCondition"));
        }
        if (mIRJoinCondition._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Feature", "RightOfJoinCondition"));
        }
        if (mIRJoinCondition.hasRightFeature != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("JoinCondition", "RightFeature"));
        }
        if (this.rightOfJoinConditions != null && this.rightOfJoinConditions.contains(mIRJoinCondition)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Feature", "RightOfJoinCondition"));
        }
        this.getRightOfJoinConditionCollection().add(mIRJoinCondition);
        mIRJoinCondition.hasRightFeature = this;
    }

    public final int getRightOfJoinConditionCount() {
        if (this.rightOfJoinConditions != null) {
            return this.rightOfJoinConditions.size();
        }
        return 0;
    }

    public final boolean containsRightOfJoinCondition(MIRJoinCondition mIRJoinCondition) {
        if (mIRJoinCondition != null && this.rightOfJoinConditions != null) {
            return this.rightOfJoinConditions.contains(mIRJoinCondition);
        }
        return false;
    }

    public final MIRJoinCondition getRightOfJoinCondition(String string) {
        if (this.rightOfJoinConditions != null) {
            return this.rightOfJoinConditions.get(string);
        }
        return null;
    }

    public final Iterator<MIRJoinCondition> getRightOfJoinConditionIterator() {
        if (this.rightOfJoinConditions != null) {
            return this.rightOfJoinConditions.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeRightOfJoinCondition(MIRJoinCondition mIRJoinCondition) {
        if (mIRJoinCondition != null && this.rightOfJoinConditions != null && this.rightOfJoinConditions.remove(mIRJoinCondition)) {
            mIRJoinCondition.hasRightFeature = null;
            if (this.rightOfJoinConditions.isEmpty()) {
                this.rightOfJoinConditions = null;
            }
            return true;
        }
        return false;
    }

    public final void removeRightOfJoinConditions() {
        if (this.rightOfJoinConditions != null) {
            for (MIRJoinCondition mIRJoinCondition : this.rightOfJoinConditions) {
                mIRJoinCondition.hasRightFeature = null;
            }
            this.rightOfJoinConditions = null;
        }
    }

    protected MIRObjectCollection<MIRFeatureMap> getSourceOfFeatureMapCollection() {
        this.sourceOfFeatureMaps = MIRObjectCollections.get(this.sourceOfFeatureMaps, MIRSdkCollection.Type.OBJECT);
        return this.sourceOfFeatureMaps;
    }

    public SortedSet<MIRFeatureMap> getSourceOfFeatureMaps() {
        return MIRObjectCollections.sortedSet(this.sourceOfFeatureMaps);
    }

    public final void addSourceOfFeatureMap(MIRFeatureMap mIRFeatureMap) {
        if (mIRFeatureMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Feature", "SourceOfFeatureMap"));
        }
        if (mIRFeatureMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Feature", "SourceOfFeatureMap"));
        }
        if (this.sourceOfFeatureMaps != null && this.sourceOfFeatureMaps.contains(mIRFeatureMap)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Feature", "SourceOfFeatureMap"));
        }
        this.getSourceOfFeatureMapCollection().add(mIRFeatureMap);
        mIRFeatureMap.getSourceFeatureCollection().add(this);
    }

    public final int getSourceOfFeatureMapCount() {
        if (this.sourceOfFeatureMaps != null) {
            return this.sourceOfFeatureMaps.size();
        }
        return 0;
    }

    public final boolean containsSourceOfFeatureMap(MIRFeatureMap mIRFeatureMap) {
        if (mIRFeatureMap != null && this.sourceOfFeatureMaps != null) {
            return this.sourceOfFeatureMaps.contains(mIRFeatureMap);
        }
        return false;
    }

    public final MIRFeatureMap getSourceOfFeatureMap(String string) {
        if (this.sourceOfFeatureMaps != null) {
            return this.sourceOfFeatureMaps.get(string);
        }
        return null;
    }

    public final Iterator<MIRFeatureMap> getSourceOfFeatureMapIterator() {
        if (this.sourceOfFeatureMaps != null) {
            return this.sourceOfFeatureMaps.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSourceOfFeatureMap(MIRFeatureMap mIRFeatureMap) {
        if (mIRFeatureMap != null && this.sourceOfFeatureMaps != null && this.sourceOfFeatureMaps.remove(mIRFeatureMap)) {
            mIRFeatureMap.sourceFeatures.remove(this);
            if (mIRFeatureMap.sourceFeatures.isEmpty()) {
                mIRFeatureMap.sourceFeatures = null;
            }
            if (this.sourceOfFeatureMaps.isEmpty()) {
                this.sourceOfFeatureMaps = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSourceOfFeatureMaps() {
        if (this.sourceOfFeatureMaps != null) {
            for (MIRFeatureMap mIRFeatureMap : this.sourceOfFeatureMaps) {
                mIRFeatureMap.sourceFeatures.remove(this);
                if (!mIRFeatureMap.sourceFeatures.isEmpty()) continue;
                mIRFeatureMap.sourceFeatures = null;
            }
            this.sourceOfFeatureMaps = null;
        }
    }

    protected MIRObjectCollection<MIRSQLViewAttribute> getSourceOfSQLViewAttributeCollection() {
        this.sourceOfSQLViewAttributes = MIRObjectCollections.get(this.sourceOfSQLViewAttributes, MIRSdkCollection.Type.OBJECT);
        return this.sourceOfSQLViewAttributes;
    }

    public SortedSet<MIRSQLViewAttribute> getSourceOfSQLViewAttributes() {
        return MIRObjectCollections.sortedSet(this.sourceOfSQLViewAttributes);
    }

    public final void addSourceOfSQLViewAttribute(MIRSQLViewAttribute mIRSQLViewAttribute) {
        if (mIRSQLViewAttribute == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Feature", "SourceOfSQLViewAttribute"));
        }
        if (mIRSQLViewAttribute._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Feature", "SourceOfSQLViewAttribute"));
        }
        if (mIRSQLViewAttribute.hasSourceFeature != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("SQLViewAttribute", "SourceFeature"));
        }
        if (this.sourceOfSQLViewAttributes != null && this.sourceOfSQLViewAttributes.contains(mIRSQLViewAttribute)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Feature", "SourceOfSQLViewAttribute"));
        }
        this.getSourceOfSQLViewAttributeCollection().add(mIRSQLViewAttribute);
        mIRSQLViewAttribute.hasSourceFeature = this;
    }

    public final int getSourceOfSQLViewAttributeCount() {
        if (this.sourceOfSQLViewAttributes != null) {
            return this.sourceOfSQLViewAttributes.size();
        }
        return 0;
    }

    public final boolean containsSourceOfSQLViewAttribute(MIRSQLViewAttribute mIRSQLViewAttribute) {
        if (mIRSQLViewAttribute != null && this.sourceOfSQLViewAttributes != null) {
            return this.sourceOfSQLViewAttributes.contains(mIRSQLViewAttribute);
        }
        return false;
    }

    public final MIRSQLViewAttribute getSourceOfSQLViewAttribute(String string) {
        if (this.sourceOfSQLViewAttributes != null) {
            return this.sourceOfSQLViewAttributes.get(string);
        }
        return null;
    }

    public final Iterator<MIRSQLViewAttribute> getSourceOfSQLViewAttributeIterator() {
        if (this.sourceOfSQLViewAttributes != null) {
            return this.sourceOfSQLViewAttributes.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSourceOfSQLViewAttribute(MIRSQLViewAttribute mIRSQLViewAttribute) {
        if (mIRSQLViewAttribute != null && this.sourceOfSQLViewAttributes != null && this.sourceOfSQLViewAttributes.remove(mIRSQLViewAttribute)) {
            mIRSQLViewAttribute.hasSourceFeature = null;
            if (this.sourceOfSQLViewAttributes.isEmpty()) {
                this.sourceOfSQLViewAttributes = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSourceOfSQLViewAttributes() {
        if (this.sourceOfSQLViewAttributes != null) {
            for (MIRSQLViewAttribute mIRSQLViewAttribute : this.sourceOfSQLViewAttributes) {
                mIRSQLViewAttribute.hasSourceFeature = null;
            }
            this.sourceOfSQLViewAttributes = null;
        }
    }

    protected MIRObjectCollection<MIRSummaryMap> getSourceOfSummaryMapCollection() {
        this.sourceOfSummaryMaps = MIRObjectCollections.get(this.sourceOfSummaryMaps, MIRSdkCollection.Type.OBJECT);
        return this.sourceOfSummaryMaps;
    }

    public SortedSet<MIRSummaryMap> getSourceOfSummaryMaps() {
        return MIRObjectCollections.sortedSet(this.sourceOfSummaryMaps);
    }

    public final void addSourceOfSummaryMap(MIRSummaryMap mIRSummaryMap) {
        if (mIRSummaryMap == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Feature", "SourceOfSummaryMap"));
        }
        if (mIRSummaryMap._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Feature", "SourceOfSummaryMap"));
        }
        if (this.sourceOfSummaryMaps != null && this.sourceOfSummaryMaps.contains(mIRSummaryMap)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Feature", "SourceOfSummaryMap"));
        }
        this.getSourceOfSummaryMapCollection().add(mIRSummaryMap);
        mIRSummaryMap.getSourceFeatureCollection().add(this);
    }

    public final int getSourceOfSummaryMapCount() {
        if (this.sourceOfSummaryMaps != null) {
            return this.sourceOfSummaryMaps.size();
        }
        return 0;
    }

    public final boolean containsSourceOfSummaryMap(MIRSummaryMap mIRSummaryMap) {
        if (mIRSummaryMap != null && this.sourceOfSummaryMaps != null) {
            return this.sourceOfSummaryMaps.contains(mIRSummaryMap);
        }
        return false;
    }

    public final MIRSummaryMap getSourceOfSummaryMap(String string) {
        if (this.sourceOfSummaryMaps != null) {
            return this.sourceOfSummaryMaps.get(string);
        }
        return null;
    }

    public final Iterator<MIRSummaryMap> getSourceOfSummaryMapIterator() {
        if (this.sourceOfSummaryMaps != null) {
            return this.sourceOfSummaryMaps.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSourceOfSummaryMap(MIRSummaryMap mIRSummaryMap) {
        if (mIRSummaryMap != null && this.sourceOfSummaryMaps != null && this.sourceOfSummaryMaps.remove(mIRSummaryMap)) {
            mIRSummaryMap.sourceFeatures.remove(this);
            if (mIRSummaryMap.sourceFeatures.isEmpty()) {
                mIRSummaryMap.sourceFeatures = null;
            }
            if (this.sourceOfSummaryMaps.isEmpty()) {
                this.sourceOfSummaryMaps = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSourceOfSummaryMaps() {
        if (this.sourceOfSummaryMaps != null) {
            for (MIRSummaryMap mIRSummaryMap : this.sourceOfSummaryMaps) {
                mIRSummaryMap.sourceFeatures.remove(this);
                if (!mIRSummaryMap.sourceFeatures.isEmpty()) continue;
                mIRSummaryMap.sourceFeatures = null;
            }
            this.sourceOfSummaryMaps = null;
        }
    }

    public final void addType(MIRType mIRType) {
        if (mIRType == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("Feature", "Type"));
        }
        if (mIRType._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("Feature", "Type"));
        }
        if (this.hasType != null) {
            if (this.hasType._equals(mIRType)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("Feature", "Type"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("Feature", "Type"));
        }
        this.hasType = mIRType;
        mIRType.getFeatureCollection().add(this);
    }

    public final MIRType getType() {
        return this.hasType;
    }

    public final boolean removeType() {
        if (this.hasType != null) {
            this.hasType.features.remove(this);
            if (this.hasType.features.isEmpty()) {
                this.hasType.features = null;
            }
            this.hasType = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRModelObject.staticGetMetaClass(), 77, "Feature", true);
            new MIRMetaAttribute(metaClass, 66, "Position", "java.lang.Short", null, new Short(0));
            new MIRMetaAttribute(metaClass, 504, "LineageOptions", "java.lang.Integer", null, new Integer(0));
            new MIRMetaLink(metaClass, 115, "Classifier", true, 2, 75, 65);
            new MIRMetaLink(metaClass, 548, "ControlOfFeatureMap", false, 1, 78, 547);
            new MIRMetaLink(metaClass, 574, "ControlOfSummaryMap", false, 1, 262, 573);
            new MIRMetaLink(metaClass, 1016, "DataControlOfSummaryMap", false, 1, 262, 1017);
            new MIRMetaLink(metaClass, 113, "DestinationOfFeatureMap", false, 1, 78, 119);
            new MIRMetaLink(metaClass, 683, "DestinationOfSummaryMap", false, 3, 262, 684);
            new MIRMetaLink(metaClass, 1041, "DomainConnectionElement", true, 1, 317, 1040);
            new MIRMetaLink(metaClass, 1122, "LeftOfJoinCondition", false, 0, 355, 1125);
            new MIRMetaLink(metaClass, 1144, "MaskedOfSummaryMap", false, 0, 262, 1145);
            new MIRMetaLink(metaClass, 317, "ReportField", false, 0, 123, 319);
            new MIRMetaLink(metaClass, 1123, "RightOfJoinCondition", false, 0, 355, 1126);
            new MIRMetaLink(metaClass, 112, "SourceOfFeatureMap", false, 1, 78, 118);
            new MIRMetaLink(metaClass, 116, "SourceOfSQLViewAttribute", false, 1, 26, 228);
            new MIRMetaLink(metaClass, 679, "SourceOfSummaryMap", false, 1, 262, 680);
            new MIRMetaLink(metaClass, 114, "Type", true, 0, 3, 252);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRFeature.staticGetMetaClass();
    }

    public MIRFeatureMap getDestinationOfFeatureMap() {
        return this.getDestinationOfFeatureMap(null);
    }

    public void setLineageOption(int n) {
        this.aLineageOptions |= n;
    }

    public void unsetLineageOption(int n) {
        this.aLineageOptions &= ~n;
    }

    public boolean hasLineageOption(int n) {
        return (this.aLineageOptions & n) != 0;
    }

    @Override
    protected boolean _isValidName() {
        if (this.hasClassifier != null && !this.hasClassifier._allowName(this.hasClassifier.features, this)) {
            return false;
        }
        return super._isValidName();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasClassifier != null) {
            this.hasClassifier.features.rename(this, string);
        }
        if (this.controlOfFeatureMaps != null) {
            for (MIRFeatureMap mIRElement : this.controlOfFeatureMaps) {
                mIRElement.controlFeatures.rename(this, string);
            }
        }
        if (this.controlOfSummaryMaps != null) {
            for (MIRSummaryMap mIRSummaryMap : this.controlOfSummaryMaps) {
                mIRSummaryMap.controlFeatures.rename(this, string);
            }
        }
        if (this.dataControlOfSummaryMaps != null) {
            for (MIRSummaryMap mIRSummaryMap : this.dataControlOfSummaryMaps) {
                mIRSummaryMap.dataControlFeatures.rename(this, string);
            }
        }
        if (this.hasDomainConnectionElement != null) {
            this.hasDomainConnectionElement.domainOfFeatures.rename(this, string);
        }
        if (this.maskedOfSummaryMaps != null) {
            for (MIRSummaryMap mIRSummaryMap : this.maskedOfSummaryMaps) {
                mIRSummaryMap.maskedFeatures.rename(this, string);
            }
        }
        if (this.sourceOfFeatureMaps != null) {
            for (MIRFeatureMap mIRFeatureMap : this.sourceOfFeatureMaps) {
                mIRFeatureMap.sourceFeatures.rename(this, string);
            }
        }
        if (this.sourceOfSummaryMaps != null) {
            for (MIRSummaryMap mIRSummaryMap : this.sourceOfSummaryMaps) {
                mIRSummaryMap.sourceFeatures.rename(this, string);
            }
        }
        if (this.hasType != null) {
            this.hasType.features.rename(this, string);
        }
        super._rename(string);
    }
}

