/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRExternalServerType;
import MITI.sdk.MIRHarvestableContent;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIRRepository;
import MITI.sdk.MIRRepositoryObject;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRExternalServer
extends MIRRepositoryObject {
    protected transient String aConfiguration = "";
    protected transient boolean aDefault = false;
    protected transient String aPassword = "";
    protected transient byte aType = (byte)2;
    protected transient String aUrl = "";
    protected transient String aUsername = "";
    protected transient MIRObjectCollection<MIRHarvestableContent> harvestableContents = null;
    protected transient MIRObjectCollection<MIRHarvestableContent> identityOfHarvestableContents = null;
    protected transient MIRRepository hasRepository = null;
    private static MIRMetaClass metaClass = MIRExternalServer.staticGetMetaClass();

    public MIRExternalServer() {
    }

    public MIRExternalServer(MIRExternalServer mIRExternalServer) {
        this.setFrom(mIRExternalServer);
    }

    @Override
    public Object clone() {
        return new MIRExternalServer(this);
    }

    @Override
    public short getElementType() {
        return 179;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)179)) {
            this.setConfiguration(((MIRExternalServer)mIR_Object).getConfiguration());
            this.setDefault(((MIRExternalServer)mIR_Object).getDefault());
            this.setPassword(((MIRExternalServer)mIR_Object).getPassword());
            this.setType(((MIRExternalServer)mIR_Object).getType());
            this.setUrl(((MIRExternalServer)mIR_Object).getUrl());
            this.setUsername(((MIRExternalServer)mIR_Object).getUsername());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasRepository != null) {
            return this.hasRepository;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasRepository != null ? 1 : 0) + super.getParentCount();
    }

    public final void setConfiguration(String string) {
        this.aConfiguration = string == null ? "" : string;
    }

    public final String getConfiguration() {
        return this.aConfiguration;
    }

    public final void setDefault(boolean bl) {
        this.aDefault = bl;
    }

    public final boolean getDefault() {
        return this.aDefault;
    }

    public final void setPassword(String string) {
        this.aPassword = string == null ? "" : string;
    }

    public final String getPassword() {
        return this.aPassword;
    }

    public final void setType(byte by) {
        this.aType = by;
    }

    public final byte getType() {
        return this.aType;
    }

    public final void setUrl(String string) {
        this.aUrl = string == null ? "" : string;
    }

    public final String getUrl() {
        return this.aUrl;
    }

    public final void setUsername(String string) {
        this.aUsername = string == null ? "" : string;
    }

    public final String getUsername() {
        return this.aUsername;
    }

    protected MIRObjectCollection<MIRHarvestableContent> getHarvestableContentCollection() {
        this.harvestableContents = MIRObjectCollections.get(this.harvestableContents, MIRSdkCollection.Type.OBJECT);
        return this.harvestableContents;
    }

    public SortedSet<MIRHarvestableContent> getHarvestableContents() {
        return MIRObjectCollections.sortedSet(this.harvestableContents);
    }

    public final void addHarvestableContent(MIRHarvestableContent mIRHarvestableContent) {
        if (mIRHarvestableContent == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ExternalServer", "HarvestableContent"));
        }
        if (mIRHarvestableContent._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ExternalServer", "HarvestableContent"));
        }
        if (mIRHarvestableContent.hasExternalServer != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("HarvestableContent", "ExternalServer"));
        }
        if (this.harvestableContents != null && this.harvestableContents.contains(mIRHarvestableContent)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ExternalServer", "HarvestableContent"));
        }
        this.getHarvestableContentCollection().add(mIRHarvestableContent);
        mIRHarvestableContent.hasExternalServer = this;
    }

    public final int getHarvestableContentCount() {
        if (this.harvestableContents != null) {
            return this.harvestableContents.size();
        }
        return 0;
    }

    public final boolean containsHarvestableContent(MIRHarvestableContent mIRHarvestableContent) {
        if (mIRHarvestableContent != null && this.harvestableContents != null) {
            return this.harvestableContents.contains(mIRHarvestableContent);
        }
        return false;
    }

    public final MIRHarvestableContent getHarvestableContent(String string) {
        if (this.harvestableContents != null) {
            return this.harvestableContents.get(string);
        }
        return null;
    }

    public final Iterator<MIRHarvestableContent> getHarvestableContentIterator() {
        if (this.harvestableContents != null) {
            return this.harvestableContents.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeHarvestableContent(MIRHarvestableContent mIRHarvestableContent) {
        if (mIRHarvestableContent != null && this.harvestableContents != null && this.harvestableContents.remove(mIRHarvestableContent)) {
            mIRHarvestableContent.hasExternalServer = null;
            if (this.harvestableContents.isEmpty()) {
                this.harvestableContents = null;
            }
            return true;
        }
        return false;
    }

    public final void removeHarvestableContents() {
        if (this.harvestableContents != null) {
            for (MIRHarvestableContent mIRHarvestableContent : this.harvestableContents) {
                mIRHarvestableContent.hasExternalServer = null;
            }
            this.harvestableContents = null;
        }
    }

    protected MIRObjectCollection<MIRHarvestableContent> getIdentityOfHarvestableContentCollection() {
        this.identityOfHarvestableContents = MIRObjectCollections.get(this.identityOfHarvestableContents, MIRSdkCollection.Type.OBJECT);
        return this.identityOfHarvestableContents;
    }

    public SortedSet<MIRHarvestableContent> getIdentityOfHarvestableContents() {
        return MIRObjectCollections.sortedSet(this.identityOfHarvestableContents);
    }

    public final void addIdentityOfHarvestableContent(MIRHarvestableContent mIRHarvestableContent) {
        if (mIRHarvestableContent == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ExternalServer", "IdentityOfHarvestableContent"));
        }
        if (mIRHarvestableContent._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ExternalServer", "IdentityOfHarvestableContent"));
        }
        if (mIRHarvestableContent.hasIdentityExternalServer != null) {
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("HarvestableContent", "IdentityExternalServer"));
        }
        if (this.identityOfHarvestableContents != null && this.identityOfHarvestableContents.contains(mIRHarvestableContent)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ExternalServer", "IdentityOfHarvestableContent"));
        }
        this.getIdentityOfHarvestableContentCollection().add(mIRHarvestableContent);
        mIRHarvestableContent.hasIdentityExternalServer = this;
    }

    public final int getIdentityOfHarvestableContentCount() {
        if (this.identityOfHarvestableContents != null) {
            return this.identityOfHarvestableContents.size();
        }
        return 0;
    }

    public final boolean containsIdentityOfHarvestableContent(MIRHarvestableContent mIRHarvestableContent) {
        if (mIRHarvestableContent != null && this.identityOfHarvestableContents != null) {
            return this.identityOfHarvestableContents.contains(mIRHarvestableContent);
        }
        return false;
    }

    public final MIRHarvestableContent getIdentityOfHarvestableContent(String string) {
        if (this.identityOfHarvestableContents != null) {
            return this.identityOfHarvestableContents.get(string);
        }
        return null;
    }

    public final Iterator<MIRHarvestableContent> getIdentityOfHarvestableContentIterator() {
        if (this.identityOfHarvestableContents != null) {
            return this.identityOfHarvestableContents.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeIdentityOfHarvestableContent(MIRHarvestableContent mIRHarvestableContent) {
        if (mIRHarvestableContent != null && this.identityOfHarvestableContents != null && this.identityOfHarvestableContents.remove(mIRHarvestableContent)) {
            mIRHarvestableContent.hasIdentityExternalServer = null;
            if (this.identityOfHarvestableContents.isEmpty()) {
                this.identityOfHarvestableContents = null;
            }
            return true;
        }
        return false;
    }

    public final void removeIdentityOfHarvestableContents() {
        if (this.identityOfHarvestableContents != null) {
            for (MIRHarvestableContent mIRHarvestableContent : this.identityOfHarvestableContents) {
                mIRHarvestableContent.hasIdentityExternalServer = null;
            }
            this.identityOfHarvestableContents = null;
        }
    }

    public final void addRepository(MIRRepository mIRRepository) {
        if (mIRRepository == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ExternalServer", "Repository"));
        }
        if (mIRRepository._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ExternalServer", "Repository"));
        }
        if (this.hasRepository != null) {
            if (this.hasRepository._equals(mIRRepository)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ExternalServer", "Repository"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ExternalServer", "Repository"));
        }
        this.hasRepository = mIRRepository;
        mIRRepository.getExternalServerCollection().add(this);
    }

    public final MIRRepository getRepository() {
        return this.hasRepository;
    }

    public final boolean removeRepository() {
        if (this.hasRepository != null) {
            this.hasRepository.externalServers.remove(this);
            if (this.hasRepository.externalServers.isEmpty()) {
                this.hasRepository.externalServers = null;
            }
            this.hasRepository = null;
            return true;
        }
        return false;
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRRepositoryObject.staticGetMetaClass(), 179, "ExternalServer", false);
            new MIRMetaAttribute(metaClass, 286, "Url", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 510, "Username", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 511, "Password", "java.lang.String", null, "");
            new MIRMetaAttribute(metaClass, 512, "Type", "java.lang.Byte", MIRExternalServerType.class, new Byte(2));
            new MIRMetaAttribute(metaClass, 513, "Default", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaAttribute(metaClass, 514, "Configuration", "java.lang.String", null, "");
            new MIRMetaLink(metaClass, 901, "HarvestableContent", false, 1, 351, 899);
            new MIRMetaLink(metaClass, 1146, "IdentityOfHarvestableContent", false, 0, 351, 1147);
            new MIRMetaLink(metaClass, 484, "Repository", true, 2, 156, 483);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRExternalServer.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasRepository != null) {
            this.hasRepository.externalServers.rename(this, string);
        }
        super._rename(string);
    }
}

