/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRMetaAttribute;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIR_Object;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRElementNamePart
extends MIRObject {
    protected transient short aPosition = 0;
    protected transient boolean aQuoted = false;
    protected transient short aSourceElementType = 0;
    protected transient MIRElementNode hasElementNode = null;
    protected transient MIROperationNode hasOperationNode = null;
    protected transient MIRObjectCollection<MIRElement> referencedElements = null;
    private static MIRMetaClass metaClass = MIRElementNamePart.staticGetMetaClass();
    protected static final Comparator<MIRElementNamePart> ByPosition = new Comparator<MIRElementNamePart>(){

        @Override
        public int compare(MIRElementNamePart mIRElementNamePart, MIRElementNamePart mIRElementNamePart2) {
            return mIRElementNamePart.getPosition() - mIRElementNamePart2.getPosition();
        }
    };

    public MIRElementNamePart() {
    }

    public MIRElementNamePart(MIRElementNamePart mIRElementNamePart) {
        this.setFrom(mIRElementNamePart);
    }

    @Override
    public Object clone() {
        return new MIRElementNamePart(this);
    }

    @Override
    public short getElementType() {
        return 110;
    }

    @Override
    public void setFrom(MIR_Object mIR_Object) {
        super.setFrom(mIR_Object);
        if (mIR_Object.isInstanceOf((short)110)) {
            this.setPosition(((MIRElementNamePart)mIR_Object).getPosition());
            this.setQuoted(((MIRElementNamePart)mIR_Object).getQuoted());
            this.setSourceElementType(((MIRElementNamePart)mIR_Object).getSourceElementType());
        }
    }

    @Override
    public MIRObject getParent() {
        if (this.hasElementNode != null) {
            return this.hasElementNode;
        }
        if (this.hasOperationNode != null) {
            return this.hasOperationNode;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasElementNode != null ? 1 : 0) + (this.hasOperationNode != null ? 1 : 0) + super.getParentCount();
    }

    public final void setPosition(short s) {
        this.aPosition = s;
    }

    public final short getPosition() {
        return this.aPosition;
    }

    public final void setQuoted(boolean bl) {
        this.aQuoted = bl;
    }

    public final boolean getQuoted() {
        return this.aQuoted;
    }

    public final void setSourceElementType(short s) {
        this.aSourceElementType = s;
    }

    public final short getSourceElementType() {
        return this.aSourceElementType;
    }

    public final void addElementNode(MIRElementNode mIRElementNode) {
        if (mIRElementNode == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ElementNamePart", "ElementNode"));
        }
        if (mIRElementNode._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ElementNamePart", "ElementNode"));
        }
        if (this.hasElementNode != null) {
            if (this.hasElementNode._equals(mIRElementNode)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ElementNamePart", "ElementNode"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ElementNamePart", "ElementNode"));
        }
        this.hasElementNode = mIRElementNode;
        mIRElementNode.getElementNamePartCollection().add(this);
    }

    public final MIRElementNode getElementNode() {
        return this.hasElementNode;
    }

    public final boolean removeElementNode() {
        if (this.hasElementNode != null) {
            this.hasElementNode.elementNameParts.remove(this);
            if (this.hasElementNode.elementNameParts.isEmpty()) {
                this.hasElementNode.elementNameParts = null;
            }
            this.hasElementNode = null;
            return true;
        }
        return false;
    }

    public final void addOperationNode(MIROperationNode mIROperationNode) {
        if (mIROperationNode == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ElementNamePart", "OperationNode"));
        }
        if (mIROperationNode._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ElementNamePart", "OperationNode"));
        }
        if (this.hasOperationNode != null) {
            if (this.hasOperationNode._equals(mIROperationNode)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ElementNamePart", "OperationNode"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ElementNamePart", "OperationNode"));
        }
        this.hasOperationNode = mIROperationNode;
        mIROperationNode.getElementNamePartCollection().add(this);
    }

    public final MIROperationNode getOperationNode() {
        return this.hasOperationNode;
    }

    public final boolean removeOperationNode() {
        if (this.hasOperationNode != null) {
            this.hasOperationNode.elementNameParts.remove(this);
            if (this.hasOperationNode.elementNameParts.isEmpty()) {
                this.hasOperationNode.elementNameParts = null;
            }
            this.hasOperationNode = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRElement> getReferencedElementCollection() {
        this.referencedElements = MIRObjectCollections.get(this.referencedElements, MIRSdkCollection.Type.OBJECT);
        return this.referencedElements;
    }

    public SortedSet<MIRElement> getReferencedElements() {
        return MIRObjectCollections.sortedSet(this.referencedElements);
    }

    public final void addReferencedElement(MIRElement mIRElement) {
        if (mIRElement == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ElementNamePart", "ReferencedElement"));
        }
        if (mIRElement._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ElementNamePart", "ReferencedElement"));
        }
        if (this.referencedElements != null && this.referencedElements.contains(mIRElement)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ElementNamePart", "ReferencedElement"));
        }
        this.getReferencedElementCollection().add(mIRElement);
        mIRElement.getReferencedByElementNamePartCollection().add(this);
    }

    public final int getReferencedElementCount() {
        if (this.referencedElements != null) {
            return this.referencedElements.size();
        }
        return 0;
    }

    public final boolean containsReferencedElement(MIRElement mIRElement) {
        if (mIRElement != null && this.referencedElements != null) {
            return this.referencedElements.contains(mIRElement);
        }
        return false;
    }

    public final MIRElement getReferencedElement(String string) {
        if (this.referencedElements != null) {
            return this.referencedElements.get(string);
        }
        return null;
    }

    public final Iterator<MIRElement> getReferencedElementIterator() {
        if (this.referencedElements != null) {
            return this.referencedElements.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeReferencedElement(MIRElement mIRElement) {
        if (mIRElement != null && this.referencedElements != null && this.referencedElements.remove(mIRElement)) {
            mIRElement.referencedByElementNameParts.remove(this);
            if (mIRElement.referencedByElementNameParts.isEmpty()) {
                mIRElement.referencedByElementNameParts = null;
            }
            if (this.referencedElements.isEmpty()) {
                this.referencedElements = null;
            }
            return true;
        }
        return false;
    }

    public final void removeReferencedElements() {
        if (this.referencedElements != null) {
            for (MIRElement mIRElement : this.referencedElements) {
                mIRElement.referencedByElementNameParts.remove(this);
                if (!mIRElement.referencedByElementNameParts.isEmpty()) continue;
                mIRElement.referencedByElementNameParts = null;
            }
            this.referencedElements = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRObject.staticGetMetaClass(), 110, "ElementNamePart", false);
            new MIRMetaAttribute(metaClass, 181, "Position", "java.lang.Short", null, new Short(0));
            new MIRMetaAttribute(metaClass, 180, "SourceElementType", "java.lang.Short", MIRElementType.class, new Short(0));
            new MIRMetaAttribute(metaClass, 508, "Quoted", "java.lang.Boolean", null, new Boolean(false));
            new MIRMetaLink(metaClass, 282, "ElementNode", true, 2, 111, 285);
            new MIRMetaLink(metaClass, 1114, "OperationNode", true, 2, 114, 1115);
            new MIRMetaLink(metaClass, 283, "ReferencedElement", false, 1, 0, 281);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRElementNamePart.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasElementNode != null) {
            this.hasElementNode.elementNameParts.rename(this, string);
        }
        if (this.hasOperationNode != null) {
            this.hasOperationNode.elementNameParts.rename(this, string);
        }
        if (this.referencedElements != null) {
            for (MIRElement mIRElement : this.referencedElements) {
                mIRElement.referencedByElementNameParts.rename(this, string);
            }
        }
        super._rename(string);
    }
}

