/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk;

import MITI.messages.MIR.MIRSDK;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRMetaClass;
import MITI.sdk.MIRMetaLink;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.collections.MIRObjectCollection;
import MITI.sdk.collections.MIRSdkCollection;
import java.util.Iterator;
import java.util.SortedSet;

public class MIRElementMap
extends MIRElement {
    protected transient MIRElement hasClientElement = null;
    protected transient MIRObjectCollection<MIRElement> supplierElements = null;
    private static MIRMetaClass metaClass = MIRElementMap.staticGetMetaClass();

    public MIRElementMap() {
    }

    public MIRElementMap(MIRElementMap mIRElementMap) {
        this.setFrom(mIRElementMap);
    }

    @Override
    public Object clone() {
        return new MIRElementMap(this);
    }

    @Override
    public short getElementType() {
        return 197;
    }

    @Override
    public MIRObject getParent() {
        if (this.hasClientElement != null) {
            return this.hasClientElement;
        }
        return super.getParent();
    }

    @Override
    public int getParentCount() {
        return (this.hasClientElement != null ? 1 : 0) + super.getParentCount();
    }

    public final void addClientElement(MIRElement mIRElement) {
        if (mIRElement == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ElementMap", "ClientElement"));
        }
        if (mIRElement._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ElementMap", "ClientElement"));
        }
        if (this.hasClientElement != null) {
            if (this.hasClientElement._equals(mIRElement)) {
                throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ElementMap", "ClientElement"));
            }
            throw new IllegalArgumentException(MIRSDK.ALREADY_LINKED.getMessage("ElementMap", "ClientElement"));
        }
        this.hasClientElement = mIRElement;
        mIRElement.getClientOfElementMapCollection().add(this);
    }

    public final MIRElement getClientElement() {
        return this.hasClientElement;
    }

    public final boolean removeClientElement() {
        if (this.hasClientElement != null) {
            this.hasClientElement.clientOfElementMaps.remove(this);
            if (this.hasClientElement.clientOfElementMaps.isEmpty()) {
                this.hasClientElement.clientOfElementMaps = null;
            }
            this.hasClientElement = null;
            return true;
        }
        return false;
    }

    protected MIRObjectCollection<MIRElement> getSupplierElementCollection() {
        this.supplierElements = MIRObjectCollections.get(this.supplierElements, MIRSdkCollection.Type.OBJECT);
        return this.supplierElements;
    }

    public SortedSet<MIRElement> getSupplierElements() {
        return MIRObjectCollections.sortedSet(this.supplierElements);
    }

    public final void addSupplierElement(MIRElement mIRElement) {
        if (mIRElement == null) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_NULL.getMessage("ElementMap", "SupplierElement"));
        }
        if (mIRElement._equals(this)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_SELF.getMessage("ElementMap", "SupplierElement"));
        }
        if (this.supplierElements != null && this.supplierElements.contains(mIRElement)) {
            throw new IllegalArgumentException(MIRSDK.CANNOT_ADD_TWICE.getMessage("ElementMap", "SupplierElement"));
        }
        this.getSupplierElementCollection().add(mIRElement);
        mIRElement.getSupplierOfElementMapCollection().add(this);
    }

    public final int getSupplierElementCount() {
        if (this.supplierElements != null) {
            return this.supplierElements.size();
        }
        return 0;
    }

    public final boolean containsSupplierElement(MIRElement mIRElement) {
        if (mIRElement != null && this.supplierElements != null) {
            return this.supplierElements.contains(mIRElement);
        }
        return false;
    }

    public final MIRElement getSupplierElement(String string) {
        if (this.supplierElements != null) {
            return this.supplierElements.get(string);
        }
        return null;
    }

    public final Iterator<MIRElement> getSupplierElementIterator() {
        if (this.supplierElements != null) {
            return this.supplierElements.iterator();
        }
        return MIRObjectCollections.emptySet().iterator();
    }

    public final boolean removeSupplierElement(MIRElement mIRElement) {
        if (mIRElement != null && this.supplierElements != null && this.supplierElements.remove(mIRElement)) {
            mIRElement.supplierOfElementMaps.remove(this);
            if (mIRElement.supplierOfElementMaps.isEmpty()) {
                mIRElement.supplierOfElementMaps = null;
            }
            if (this.supplierElements.isEmpty()) {
                this.supplierElements = null;
            }
            return true;
        }
        return false;
    }

    public final void removeSupplierElements() {
        if (this.supplierElements != null) {
            for (MIRElement mIRElement : this.supplierElements) {
                mIRElement.supplierOfElementMaps.remove(this);
                if (!mIRElement.supplierOfElementMaps.isEmpty()) continue;
                mIRElement.supplierOfElementMaps = null;
            }
            this.supplierElements = null;
        }
    }

    public static MIRMetaClass staticGetMetaClass() {
        if (metaClass == null) {
            metaClass = new MIRMetaClass(MIRElement.staticGetMetaClass(), 197, "ElementMap", false);
            new MIRMetaLink(metaClass, 577, "ClientElement", true, 2, 0, 578);
            new MIRMetaLink(metaClass, 575, "SupplierElement", false, 0, 0, 576);
        }
        return metaClass;
    }

    @Override
    public MIRMetaClass getMetaClass() {
        return MIRElementMap.staticGetMetaClass();
    }

    @Override
    protected void _rename(String string) {
        if (this.hasClientElement != null) {
            this.hasClientElement.clientOfElementMaps.rename(this, string);
        }
        if (this.supplierElements != null) {
            for (MIRElement mIRElement : this.supplierElements) {
                mIRElement.supplierOfElementMaps.rename(this, string);
            }
        }
        super._rename(string);
    }
}

